/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SharedAcctCollection;
import com.kingdee.eas.basedata.assistant.SharedAcctFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.DownLoadBankParam;
import com.kingdee.eas.fi.cas.client.AbstractDownLoadBankStatementUI;
import com.kingdee.eas.fi.cas.client.CashClientHelper;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DownLoadBankStatementUI
extends AbstractDownLoadBankStatementUI {
    private static final String resourcePath = "com.kingdee.eas.fi.cas.BankStatementResource";
    private static final String PARAM_COMPANY = "company";
    private static final String PERM_CAS_BANKSTATEMENT_DOWNLOADBE = "cas_bankstatement_08downloadBE";
    private DownLoadBankParam rstValue;
    private CompanyOrgUnitInfo companyInfo;
    private Set<String> authOrgCompanyId;

    private void initAuthOrgCompanyId() throws EASBizException, BOSException {
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        FullOrgUnitCollection collection = PermissionFactory.getRemoteInstance().getAuthorizedOrg((IObjectPK)new ObjectUuidPK(userId), OrgType.Company, null, PERM_CAS_BANKSTATEMENT_DOWNLOADBE);
        this.authOrgCompanyId = new HashSet<String>();
        if (EmptyUtil.isEmpty((AbstractObjectCollection)collection)) {
            this.authOrgCompanyId.add("000000");
        } else {
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                this.authOrgCompanyId.add(collection.get(i).getId().toString());
            }
        }
    }

    private Date getFirstDayStart() throws EASBizException, BOSException {
        Object[] companys = AccessHelper.getF7Data((KDBizPromptBox)this.prmtCompany);
        if (companys == null || !(companys[0] instanceof CompanyOrgUnitInfo)) {
            return DateUtil.getDayBegin();
        }
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)companys[0];
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        Date firstDayStart = startPeriod.getBeginDate();
        return firstDayStart;
    }

    private void initBeginAndEndDate() throws BOSException, EASBizException {
        this.dpkFrom.setValue((Object)this.getFirstDayStart());
        this.dpkTo.setValue((Object)new Date());
    }

    private void initPrmtCompany() throws EASBizException, BOSException {
        this.prmtCompany.setValue((Object)this.companyInfo);
        boolean isSharedOrg = CashClientHelper.hasSharedOrgUIParam((CoreUIObject)this);
        this.prmtCompany.setEnabled(isSharedOrg);
        if (isSharedOrg) {
            NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(OrgType.Company);
            this.prmtCompany.setFilterInfoProducer((IFilterInfoProducer)iProducer);
            NewOrgViewF7PromptDialog model = iProducer.getModel();
            if (model != null) {
                this.prmtCompany.setSelector((KDPromptSelector)model);
                model.setMultiSelect(true);
                model.setPermissionItem(PERM_CAS_BANKSTATEMENT_DOWNLOADBE);
            }
            this.prmtCompany.setCommitFormat("$number$;$name$");
        }
    }

    private void initUI() throws BOSException, EASBizException {
        this.initPrmtCompany();
        this.initBeginAndEndDate();
        this.chkConTransDownUp.setSelected(true);
    }

    public void onLoad() throws Exception {
        this.companyInfo = (CompanyOrgUnitInfo)this.getUIContext().get(PARAM_COMPANY);
        this.initAuthOrgCompanyId();
        super.onLoad();
        this.initUI();
    }

    private Set<String> getShareAccountIdSet(Set<String> companyIdSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("shareBalanceOfAcctCompany.id", companyIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("bankAccount.id");
        view.setSelector(selector);
        SharedAcctCollection coll = SharedAcctFactory.getRemoteInstance().getSharedAcctCollection(view);
        HashSet<String> sharedAcctSet = new HashSet<String>();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            sharedAcctSet.add(coll.get(i).getBankAccount().getId().toString());
        }
        return sharedAcctSet;
    }

    private void initPrmtBankAccount() throws BOSException, EASBizException {
        EntityViewInfo entityViewInfo = this.getBankAccountFilter();
        this.prmtBankAccount.setCommitFormat("$number$;$name$");
        this.prmtBankAccount.setEntityViewInfo(entityViewInfo);
        this.prmtBankAccount.getQueryAgent().resetRuntimeEntityView();
    }

    private EntityViewInfo getBankAccountFilter() throws BOSException {
        Set<String> companyIdSet;
        String[] companyIds = AccessHelper.getF7Ids((KDBizPromptBox)this.prmtCompany);
        if (companyIds == null || companyIds.length == 0) {
            companyIdSet = this.authOrgCompanyId;
        } else {
            companyIdSet = new HashSet<String>();
            int length = companyIds.length;
            for (int i = 0; i < length; ++i) {
                companyIdSet.add(companyIds[i]);
            }
        }
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        if (companyIdSet.size() > 0) {
            filterItems.add(new FilterItemInfo("company.id", companyIdSet, CompareType.INCLUDE));
            filterItems.add(new FilterItemInfo("isBank", (Object)Boolean.TRUE));
            filterItems.add(new FilterItemInfo("shareType", (Object)new Integer(0)));
            filterItems.add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
            filterItems.add(new FilterItemInfo("bank.ingroup", (Object)Boolean.FALSE));
            Set<String> sharedAcctSet = this.getShareAccountIdSet(companyIdSet);
            if (!EmptyUtil.isEmpty(sharedAcctSet)) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", sharedAcctSet, CompareType.INCLUDE));
                filterInfo.mergeFilter(filter, "OR");
            }
        } else {
            filterItems.add(new FilterItemInfo("company.id", (Object)"000000"));
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        return entityViewInfo;
    }

    @Override
    protected void prmtBankAccount_willShow(SelectorEvent e) throws Exception {
        this.initPrmtBankAccount();
    }

    @Override
    protected void prmtBankAccount_willCommit(CommitEvent e) throws Exception {
        this.initPrmtBankAccount();
    }

    @Override
    protected void prmtCompany_dataChanged(DataChangeEvent e) throws Exception {
        Object newValue = e.getNewValue();
        if (newValue == null) {
            return;
        }
        this.prmtBankAccount.setDataNoNotify(null);
        this.kdBankName.setText(null);
        this.dpkFrom.setValue((Object)this.getFirstDayStart());
    }

    @Override
    public void actionCancelDown_actionPerformed(ActionEvent e) throws Exception {
        this.rstValue = null;
        this.destroyWindow();
    }

    @Override
    public void actionConfirmDown_actionPerformed(ActionEvent e) throws Exception {
        this.verify();
        this.rstValue = this.getDownLoadBankParam();
        this.destroyWindow();
    }

    private DownLoadBankParam getDownLoadBankParam() throws BOSException {
        DownLoadBankParam rstValue = new DownLoadBankParam();
        HashSet<Object> accountBankIdSet = null;
        Object[] accountBankIds = AccessHelper.getF7Ids((KDBizPromptBox)this.prmtBankAccount);
        if (EmptyUtil.isEmpty((Object[])accountBankIds)) {
            EntityViewInfo view = this.getBankAccountFilter();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            view.setSelector(selector);
            AccountBankCollection accountBanks = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
            accountBankIdSet = new HashSet();
            if (accountBanks.size() == 0) {
                accountBankIdSet.add("000000");
            } else {
                int size = accountBanks.size();
                for (int i = 0; i < size; ++i) {
                    accountBankIdSet.add(accountBanks.get(i).getId().toString());
                }
            }
        } else {
            accountBankIdSet = new HashSet<Object>(Arrays.asList(accountBankIds));
        }
        rstValue.setBankAccountIdSet(accountBankIdSet);
        rstValue.setBeginDate(this.dpkFrom.getSqlDate());
        rstValue.setEndDate(this.dpkTo.getSqlDate());
        rstValue.setIsconTransDownUp(this.chkConTransDownUp.isSelected());
        rstValue.setIsconDetailReced(this.chkConDetailReced.isSelected());
        return rstValue;
    }

    @Override
    protected void prmtBankAccount_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBankAccount_dataChanged(e);
        Object[] bankAccounts = AccessHelper.getF7Data((KDBizPromptBox)this.prmtBankAccount);
        if (bankAccounts != null && bankAccounts.length == 1) {
            AccountBankInfo acctBank = (AccountBankInfo)bankAccounts[0];
            BankInfo bank = acctBank.getBank();
            if (bank != null) {
                bank = BankFactory.getRemoteInstance().getBankInfo((IObjectPK)new ObjectUuidPK(bank.getId()));
                this.kdBankName.setText(bank.getName());
            }
        } else {
            this.kdBankName.setText(null);
        }
    }

    private void verifyDateRange() throws EASBizException, BOSException {
        Date beginDate = (Date)this.dpkFrom.getValue();
        Date endDate = (Date)this.dpkTo.getValue();
        Date firstDayStart = this.getFirstDayStart();
        Date today = new Date();
        boolean isuse = ContextHelperFactory.getRemoteInstance().getBooleanParam("CS046", (IObjectPK)new ObjectUuidPK(this.companyInfo.getId()));
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.companyInfo);
        if (beginDate.before(startPeriod.getBeginDate())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"CheckBeginDate"));
            SysUtil.abort();
            return;
        }
        if ((beginDate.before(firstDayStart) || beginDate.after(today)) && (!isuse || beginDate.after(today))) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"BeginDateError"));
            SysUtil.abort();
            return;
        }
        if (endDate.after(today) || endDate.before(beginDate)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"EndDateError"));
            SysUtil.abort();
            return;
        }
    }

    private void verify() throws EASBizException, BOSException {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtCompany);
        this.verifyDateRange();
    }

    public static DownLoadBankParam showDialogWindows(IUIObject ui, CompanyOrgUnitInfo companyInfo, boolean isSharedOrg) throws Exception {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)PARAM_COMPANY, (Object)companyInfo);
        if (isSharedOrg) {
            uiContext.put((Object)"UIClassParam", (Object)"sharedorg=1");
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DownLoadBankStatementUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        return ((DownLoadBankStatementUI)uiWindow.getUIObject()).rstValue;
    }
}

