/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.ElecBookOnLineTypeEnum;
import com.kingdee.eas.fi.cas.client.AbstractElecBookFilerUI;
import com.kingdee.eas.fi.cas.client.ElecBookFilerParam;
import com.kingdee.eas.fi.cas.client.PeriodHelper;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.be.BankInterface;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class ElecBookFilerUI
extends AbstractElecBookFilerUI {
    private static final long serialVersionUID = 7156289351571319178L;
    private static final Logger logger = CoreUIObject.getLogger(ElecBookFilerUI.class);
    private static final String RESOURCEPATH = "com.kingdee.eas.fm.be.beResourse";
    private static final String F7_ACCOUNT_BANK_QUERY = "com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery";
    private Map bankInterMap = new HashMap();

    protected void init() throws Exception {
        super.init();
        this.initBankInterface();
        PeriodHelper.initPeriodSpinner(this.spBeginYear, this.spBeginMonth, this.spEndYear, this.spEndMonth);
        FMClientHelper.initCurrency((KDComboBox)this.cmbxCurrency);
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        FMClientHelper.setSelectObject((KDComboBox)this.cmbxCurrency, (Object)ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(company));
        this.reSetF7BankAccountQuery();
        this.rdOffline.setSelected(true);
        this.initOnLineType();
    }

    private void initOnLineType() {
        this.cmbxOnLineType.removeAllItems();
        if (this.rdOffline.isSelected()) {
            this.cmbxOnLineType.setEnabled(false);
        } else {
            this.cmbxOnLineType.setEnabled(true);
            this.cmbxOnLineType.addItem((Object)ElecBookOnLineTypeEnum.ONLINE_SINGLE);
            this.cmbxOnLineType.addItem((Object)ElecBookOnLineTypeEnum.ONLINE_ALL);
        }
    }

    @Override
    protected void f7BankAccounts_willShow(SelectorEvent e) throws Exception {
        this.initAccountBankEvi();
    }

    @Override
    protected void f7BankAccounts_willCommit(CommitEvent e) throws Exception {
        this.initAccountBankEvi();
    }

    private void initAccountBankEvi() {
        BankInterface bankInterface;
        if (!this.rdOffline.isSelected() && ElecBookOnLineTypeEnum.ONLINE_SINGLE.equals(this.cmbxOnLineType.getSelectedItem())) {
            this.f7BankAccount.setEnabledMultiSelection(false);
        } else {
            this.f7BankAccount.setEnabledMultiSelection(true);
        }
        FilterInfo filterInfo = new FilterInfo();
        FilterInfo companyFilter = new FilterInfo();
        FilterInfo agencyCompanyFilter = new FilterInfo();
        Object[] companyId = this.getCompanyIds();
        if (!FMHelper.isEmpty((Object[])companyId)) {
            HashSet<Object> list = new HashSet<Object>(companyId.length);
            for (int i = 0; i < companyId.length; ++i) {
                list.add(companyId[i]);
            }
            companyFilter.getFilterItems().add(new FilterItemInfo("company.id", list, CompareType.INCLUDE));
            agencyCompanyFilter.getFilterItems().add(new FilterItemInfo("agencyCompany.id", list, CompareType.INCLUDE));
        }
        if (this.cmbxBankInterface.getSelectedItem() instanceof BankInterface && !FMHelper.isEmpty((String)(bankInterface = (BankInterface)this.cmbxBankInterface.getSelectedItem()).getNumber())) {
            filterInfo.getFilterItems().add(new FilterItemInfo("bankInterFaceID", (Object)bankInterface.getNumber()));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)new Integer(1)));
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("shareType", (Object)2, CompareType.NOTEQUALS));
        }
        FilterInfo currencyFilter = new FilterInfo();
        CurrencyInfo selectedCurrency = (CurrencyInfo)this.cmbxCurrency.getSelectedItem();
        if (selectedCurrency != null) {
            currencyFilter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)selectedCurrency.getId()));
            currencyFilter.getFilterItems().add(new FilterItemInfo("isByCurrency", (Object)new Boolean(false)));
            currencyFilter.setMaskString("#0 or #1");
        }
        try {
            companyFilter.mergeFilter(agencyCompanyFilter, "or");
            filterInfo.mergeFilter(companyFilter, "and");
            filterInfo.mergeFilter(currencyFilter, "and");
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        this.f7BankAccount.setEntityViewInfo(evi);
        this.f7BankAccount.getQueryAgent().resetRuntimeEntityView();
    }

    private void initBankInterface() throws BOSException {
        this.cmbxBankInterface.removeAllItems();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setSelector(this.getSelectors());
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)new Integer(1)));
        try {
            ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            ObjectUuidPK orgPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentFIUnit().getId().toString());
            String sql = PermissionFactory.getRemoteInstance().getQueryPermissionSQL((IObjectPK)userPK, (IObjectPK)orgPK, "bd_assistant_accountBank_view");
            if (!EmptyUtil.isEmpty((String)sql.trim())) {
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
                filter.mergeFilter(fi, "AND");
            }
        }
        catch (Exception e) {
            logger.info((Object)e);
        }
        view.setFilter(filter);
        AccountBankCollection colls = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
        int k = 0;
        this.bankInterMap.clear();
        for (int i = 0; i < colls.size(); ++i) {
            AccountBankInfo info = colls.get(i);
            BankInterface bankAcct = new BankInterface();
            if (FMHelper.isEmpty((String)info.getBankInterFaceID())) continue;
            bankAcct.setNumber(info.getBankInterFaceID());
            bankAcct.setName(info.getBankInterFace());
            if (this.bankInterMap.containsKey(bankAcct.getNumber())) continue;
            this.cmbxBankInterface.addItem((Object)bankAcct);
            this.bankInterMap.put(bankAcct.getNumber(), new Integer(k));
            ++k;
        }
        if (!this.bankInterMap.containsKey(null)) {
            BankInterface bankAcct = new BankInterface();
            bankAcct.setNumber(null);
            bankAcct.setName(EASResource.getString((String)"com.kingdee.eas.fm.be.FmbeResource", (String)"Select_All"));
            this.cmbxBankInterface.addItem((Object)bankAcct);
            this.bankInterMap.put(null, new Integer(this.bankInterMap.size() + 1));
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void cmbxBankInterfaces_itemStateChanged(ItemEvent e) throws Exception {
        this.f7BankAccount.setData(null);
    }

    @Override
    protected void rdOfflines_stateChanged(ChangeEvent e) throws Exception {
        if (this.rdOffline.isSelected()) {
            this.f7BankAccount.setEnabled(true);
            this.cmbxOnLineType.setEnabled(false);
            this.initOnLineType();
            if (!this.bankInterMap.containsKey(null)) {
                BankInterface bankAcct = new BankInterface();
                bankAcct.setNumber(null);
                bankAcct.setName(EASResource.getString((String)"com.kingdee.eas.fm.be.FmbeResource", (String)"Select_All"));
                this.cmbxBankInterface.addItem((Object)bankAcct);
                this.bankInterMap.put(null, new Integer(this.bankInterMap.size() + 1));
            }
        } else {
            this.cmbxOnLineType.setEnabled(true);
            this.cmbxOnLineType.addItem((Object)ElecBookOnLineTypeEnum.ONLINE_SINGLE);
            this.cmbxOnLineType.addItem((Object)ElecBookOnLineTypeEnum.ONLINE_ALL);
            if (this.bankInterMap.containsKey(null)) {
                this.cmbxBankInterface.removeItemAt(this.bankInterMap.size() - 1);
                this.bankInterMap.remove(null);
            }
        }
    }

    @Override
    protected void cmbxOnLineTypes_itemStateChanged(ItemEvent e) throws Exception {
        if (!this.rdOffline.isSelected() && ElecBookOnLineTypeEnum.ONLINE_SINGLE.equals(this.cmbxOnLineType.getSelectedItem())) {
            this.f7BankAccount.setEnabledMultiSelection(false);
            this.f7BankAccount.setEnabled(true);
            if (!EmptyUtil.isEmpty((Object)this.f7BankAccount) && !EmptyUtil.isEmpty((Object)this.f7BankAccount.getData())) {
                Object[] accountBankColl;
                if (this.f7BankAccount.getData() instanceof AccountBankInfo) {
                    return;
                }
                if (this.f7BankAccount.getData() instanceof Object[] && (accountBankColl = (Object[])this.f7BankAccount.getData()).length != 0) {
                    this.f7BankAccount.setData((Object)new Object[]{accountBankColl[0]});
                }
            }
        } else if (!this.rdOffline.isSelected()) {
            this.f7BankAccount.setEnabledMultiSelection(true);
            this.f7BankAccount.setData(null);
            this.f7BankAccount.setEnabled(false);
        }
    }

    @Override
    protected void spBeginMonth_stateChanged(ChangeEvent e) throws Exception {
    }

    @Override
    protected void spBeginYear_stateChanged(ChangeEvent e) throws Exception {
        try {
            CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            PeriodHelper.setPeriodNum(companyInfo, this.spBeginMonth, (Integer)this.spBeginYear.getValue());
        }
        catch (Exception ex) {
            SysUtil.abort((Throwable)ex);
        }
    }

    @Override
    protected void spEndMonth_stateChanged(ChangeEvent e) throws Exception {
    }

    @Override
    protected void spEndYear_stateChanged(ChangeEvent e) throws Exception {
        try {
            CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            PeriodHelper.setPeriodNum(companyInfo, this.spEndMonth, (Integer)this.spEndYear.getValue());
        }
        catch (Exception ex) {
            SysUtil.abort((Throwable)ex);
        }
    }

    public void clear() {
        super.clear();
        try {
            this.init();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public Object getParam() {
        ElecBookFilerParam param = new ElecBookFilerParam();
        param.setBeginPeriodYear(Integer.parseInt(this.spBeginYear.getValue().toString()));
        param.setEndPeriodYear(Integer.parseInt(this.spEndYear.getValue().toString()));
        param.setBeginPeriodMonth(Integer.parseInt(this.spBeginMonth.getValue().toString()));
        param.setEndPeriodMonth(Integer.parseInt(this.spEndMonth.getValue().toString()));
        String currencyId = ((CurrencyInfo)this.cmbxCurrency.getSelectedItem()).getId().toString();
        param.setCurrencyId(currencyId);
        param.setCompanyId(this.companyIds);
        if (this.f7BankAccount.getData() instanceof AccountBankInfo) {
            param.setBankAcctIds(new String[]{((AccountBankInfo)this.f7BankAccount.getData()).getId().toString()});
        } else if (this.f7BankAccount.getData() instanceof Object[] && !FMHelper.isEmpty((Object[])((Object[])this.f7BankAccount.getData()))) {
            param.setBankAcctIds(AccessHelper.getF7Ids((KDBizPromptBox)this.f7BankAccount));
        }
        param.setOnLine(this.rdOnline.isSelected());
        if (!EmptyUtil.isEmpty((Object)this.cmbxOnLineType.getSelectedItem())) {
            param.setOnLineType(((ElecBookOnLineTypeEnum)((Object)this.cmbxOnLineType.getSelectedItem())).getValue());
        }
        if (this.cmbxBankInterface.getSelectedItem() instanceof BankInterface) {
            BankInterface bankInterface = (BankInterface)this.cmbxBankInterface.getSelectedItem();
            param.setBankInterFace(bankInterface.getName());
            param.setBankInterFaceID(bankInterface.getNumber());
        } else {
            param.setBankInterFace(null);
            param.setBankInterFaceID(null);
        }
        return param;
    }

    public void setParam(Object param) {
        ElecBookFilerParam paramInfo = (ElecBookFilerParam)param;
        this.spBeginYear.setValue((Object)new Integer(paramInfo.getBeginPeriodYear()));
        this.spEndYear.setValue((Object)new Integer(paramInfo.getEndPeriodYear()));
        this.spBeginMonth.setValue((Object)new Integer(paramInfo.getBeginPeriodMonth()));
        this.spEndMonth.setValue((Object)new Integer(paramInfo.getEndPeriodMonth()));
        if (EmptyUtil.isEmpty((String)paramInfo.getBankInterFaceID())) {
            this.cmbxBankInterface.setSelectedItem(this.cmbxBankInterface.getItemAt(this.cmbxBankInterface.getItemCount() - 1));
        } else {
            int index = (Integer)this.bankInterMap.get(paramInfo.getBankInterFaceID());
            FMClientHelper.setSelectObject((KDComboBox)this.cmbxBankInterface, (Object)this.cmbxBankInterface.getItemAt(index));
        }
        if (!EmptyUtil.isEmpty((String)paramInfo.getOnLineType())) {
            this.cmbxOnLineType.setSelectedItem((Object)paramInfo.getOnLineType());
        }
        String currencyId = paramInfo.getCurrencyId();
        CurrencyInfo currencyInfo = null;
        try {
            if (currencyId != null) {
                ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
                currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
                FMClientHelper.setSelectObject((KDComboBox)this.cmbxCurrency, (Object)currencyInfo);
            }
        }
        catch (Exception e1) {
            SysUtil.abort((Throwable)e1);
        }
        String[] companyIds = paramInfo.getCompanyId();
        try {
            this.setCompanyIds(companyIds);
        }
        catch (Exception e) {
            SysUtil.abort((Throwable)e);
        }
        if (paramInfo.isOnLine()) {
            this.rdOnline.setSelected(true);
        } else {
            this.rdOffline.setSelected(true);
        }
        try {
            if (paramInfo.getBankAcctIds() != null) {
                Set set = FMHelper.asSet((String[])paramInfo.getBankAcctIds());
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
                ev.setFilter(filter);
                AccountBankCollection coll = null;
                IAccountBank bankAcct = AccountBankFactory.getRemoteInstance();
                coll = bankAcct.getAccountBankCollection(ev);
                this.f7BankAccount.setData((Object)coll.toArray());
            } else {
                this.f7BankAccount.setData(null);
            }
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
    }

    protected void initCompanyState() {
        if (this.currentCompany == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"341_ElecBookFilerUI"));
            SysUtil.abort();
        }
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            this.btnCompanySelect.setEnabled(true);
            this.btnCompanySelect.setVisible(true);
        } else {
            this.btnCompanySelect.setEnabled(false);
            this.btnCompanySelect.setVisible(false);
        }
    }

    protected void companyValueChange(Object object) throws Exception {
        Object[] array = (Object[])object;
        Object[] result = FMClientHelper.removeVirtualCompany((Object[])array);
        super.companyValueChange((Object)result);
        this.reSetF7BankAccountQuery();
    }

    private void reSetF7BankAccountQuery() {
        this.f7BankAccount.setData(null);
        FilterInfo filterInfo = new FilterInfo();
        FilterInfo companyFilter = new FilterInfo();
        FilterInfo agencyCompanyFilter = new FilterInfo();
        Object[] companyId = this.getCompanyIds();
        if (!FMHelper.isEmpty((Object[])companyId)) {
            HashSet<Object> list = new HashSet<Object>(companyId.length);
            for (int i = 0; i < companyId.length; ++i) {
                list.add(companyId[i]);
            }
            companyFilter.getFilterItems().add(new FilterItemInfo("company.id", list, CompareType.INCLUDE));
            agencyCompanyFilter.getFilterItems().add(new FilterItemInfo("agencyCompany.id", list, CompareType.INCLUDE));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        filterInfo.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)new Integer(1)));
        try {
            companyFilter.mergeFilter(agencyCompanyFilter, "or");
            filterInfo.mergeFilter(companyFilter, "and");
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        this.f7BankAccount.setDisplayFormat("$number$ $name$");
        this.f7BankAccount.setCommitFormat("$number$");
        this.f7BankAccount.setEditFormat("$number$");
        this.f7BankAccount.setEnabledMultiSelection(true);
        this.f7BankAccount.setQueryInfo(F7_ACCOUNT_BANK_QUERY);
        this.f7BankAccount.setEntityViewInfo(evi);
    }

    public boolean verify() {
        if (this.rdOnline.isSelected() && this.spBeginYear.getIntegerVlaue().intValue() != this.spEndYear.getIntegerVlaue().intValue()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"342_ElecBookFilerUI"));
            SysUtil.abort();
        }
        if (this.spBeginYear.getIntegerVlaue() > this.spEndYear.getIntegerVlaue()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"343_ElecBookFilerUI"));
            SysUtil.abort();
        } else if (this.spBeginYear.getIntegerVlaue().intValue() == this.spEndYear.getIntegerVlaue().intValue() && this.spBeginMonth.getIntegerVlaue() > this.spEndMonth.getIntegerVlaue()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"343_ElecBookFilerUI"));
            SysUtil.abort();
        }
        if (ElecBookOnLineTypeEnum.ONLINE_SINGLE.equals((Object)((ElecBookOnLineTypeEnum)((Object)this.cmbxOnLineType.getSelectedItem()))) && this.f7BankAccount.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCEPATH, (String)"CheckAccountBank"));
            SysUtil.abort();
        }
        return true;
    }

    protected Class getParamClass() {
        return ElecBookFilerParam.class;
    }
}

