/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.fi.cas.BSSourceEnum;
import com.kingdee.eas.fi.cas.BankStatementCollection;
import com.kingdee.eas.fi.cas.BankStatementFactory;
import com.kingdee.eas.fi.cas.BankStatementInfo;
import com.kingdee.eas.fi.cas.CashMgtInitFacadeFactory;
import com.kingdee.eas.fi.cas.client.AbstractCashMgtInitJournalHandler;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.util.TypeConversionUtils;
import java.util.Date;
import java.util.Iterator;

public class EnterpriseUnreachedInitBankStmtHandler
extends AbstractCashMgtInitJournalHandler {
    @Override
    public void initTable(String currencyId) throws Exception {
        super.initTable(currencyId);
        this.table.checkParsed();
        this.table.getColumn("assisDate").getStyleAttributes().setHided(true);
        this.table.getColumn("voucherType").getStyleAttributes().setHided(true);
        this.table.getColumn("voucherNumber").getStyleAttributes().setHided(true);
        this.table.getColumn("billType").getStyleAttributes().setHided(true);
        this.table.getColumn("billNumber").getStyleAttributes().setHided(true);
    }

    private BankStatementCollection getBankStatementCollection() throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(this.getFilterInfo());
        viewInfo.getSelector().addObjectCollection((IObjectCollection)this.getSelectors());
        BankStatementCollection bankStatements = BankStatementFactory.getRemoteInstance().getBankStatementCollection(viewInfo);
        return bankStatements;
    }

    @Override
    public void loadFields() throws Exception {
        super.loadFields();
        BankStatementCollection bankStatements = this.getBankStatementCollection();
        IRow row = null;
        Iterator iter = bankStatements.iterator();
        while (iter.hasNext()) {
            BankStatementInfo bankStatementInfo = (BankStatementInfo)iter.next();
            row = this.table.addRow();
            row.getCell("createDate").setValue((Object)bankStatementInfo.getCreateDate());
            row.getCell("description").setValue((Object)bankStatementInfo.getDescription());
            row.getCell("settlementType").setValue((Object)bankStatementInfo.getSettleType());
            row.getCell("settlementNumber").setValue((Object)bankStatementInfo.getSettleNumber());
            row.getCell("debitAmt").setValue((Object)bankStatementInfo.getDebitAmount());
            row.getCell("creditAmt").setValue((Object)bankStatementInfo.getCreditAmount());
            row.setUserObject((Object)bankStatementInfo);
            if (bankStatementInfo == null || !bankStatementInfo.getVerifyStatus().equals((Object)VerifyScopeEnum.WHOLE)) continue;
            row.getStyleAttributes().setLocked(true);
        }
    }

    @Override
    public void storeFields() throws Exception {
        super.storeFields();
        BankStatementCollection bankStatements = new BankStatementCollection();
        int rowCount = this.table.getRowCount();
        IRow row = null;
        BankStatementInfo bankStatementInfo = null;
        for (int i = 0; i < rowCount; ++i) {
            row = this.table.getRow(i);
            bankStatementInfo = (BankStatementInfo)row.getUserObject();
            if (bankStatementInfo == null) {
                bankStatementInfo = new BankStatementInfo();
            }
            bankStatementInfo.setCreateDate((Date)row.getCell("createDate").getValue());
            bankStatementInfo.setDescription((String)row.getCell("description").getValue());
            bankStatementInfo.setSettleType((SettlementTypeInfo)row.getCell("settlementType").getValue());
            bankStatementInfo.setSettleNumber((String)row.getCell("settlementNumber").getValue());
            bankStatementInfo.setDebitAmount(TypeConversionUtils.objToBigDecimal((Object)row.getCell("debitAmt").getValue()));
            bankStatementInfo.setCreditAmount(TypeConversionUtils.objToBigDecimal((Object)row.getCell("creditAmt").getValue()));
            if (bankStatementInfo.getDebitAmount() != null && bankStatementInfo.getDebitAmount().signum() > 0) {
                bankStatementInfo.setIsDebit(true);
            } else {
                bankStatementInfo.setIsDebit(false);
            }
            bankStatementInfo.setAccountBank(this.accountBank);
            bankStatementInfo.setAccountView(this.accountView);
            bankStatementInfo.setCurrency(this.currency);
            bankStatementInfo.setCompany(ContextHelperFactory.getRemoteInstance().getCurrentCompany());
            if (bankStatementInfo.get("verifyStatus") == null) {
                bankStatementInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
            }
            bankStatementInfo.setSource(BSSourceEnum.MANUAL);
            bankStatements.add(bankStatementInfo);
        }
        CashMgtInitFacadeFactory.getRemoteInstance().saveEntUnreachInit(this.getFilterInfo(), bankStatements);
    }
}

