/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.uiframe.client.LicenseHelper;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.fi.cas.FinalCheckoutFactory;
import com.kingdee.eas.fi.cas.IFinalCheckout;
import com.kingdee.eas.fi.cas.client.AbstractFinalCheckOutBatchUI;
import com.kingdee.eas.fi.cas.client.CashClientHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class FinalCheckOutBatchUI
extends AbstractFinalCheckOutBatchUI {
    private static final Logger logger = CoreUIObject.getLogger(FinalCheckOutBatchUI.class);
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String resourcePath = "com.kingdee.eas.fi.cas.CheckoutResource";
    private static final String SELECT = "select";
    private static final String PERIOD_ID = "period.id";
    private static final String PERIOD = "period";
    private static final String COMPANY_ID = "company.id";
    private static final String COMPANY_NUMBER = "companyNumber";
    private static final String COMPANY_NAME = "companyName";
    private static final String CLOSE_INIT = "closeInit";
    private static final String VOUCHER_BOOK = "voucherBook";
    private static final String BALACE_EQUAL = "balaceEqual";
    private static final String INSIDE_NOT_VOUCHER = "insideNotVoucher";
    private static final String OUTSIDE_NOT_VOUCHER = "outsideNotVoucher";
    private List initData = null;
    private boolean isSharedOrg = false;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionSelectAll.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_selectall"));
        this.actionRefresh.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_refresh"));
        this.actionClearAll.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.actionCheckOut.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_closeinitialize"));
    }

    public boolean destroyWindow() {
        if (this.isSharedOrg) {
            CashClientHelper.releaseSharedOrgLicense();
        }
        return super.destroyWindow();
    }

    public void onLoad() throws Exception {
        this.isSharedOrg = CashClientHelper.hasSharedOrgUIParam((CoreUIObject)this);
        if (this.isSharedOrg) {
            CashClientHelper.processSharedOrgLicense(this);
        }
        super.onLoad();
        this.initData = this.getFacade().getInitData(null);
        List processData = this.processData(this.initData);
        this.loadDataToTable(processData);
        this.lockColumnsExceptSelect();
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
    }

    private List processData(List initData) {
        ArrayList processData = new ArrayList();
        if (initData != null) {
            for (int i = 0; i < initData.size(); ++i) {
                HashMap<String, Object> processMap = new HashMap<String, Object>();
                Map info = (Map)initData.get(i);
                Map checkMsg = (Map)info.get("checkMsg");
                processMap.put("checkMsg", checkMsg);
                processMap.put("company", info.get("company"));
                processMap.put("curPeriod", info.get("curPeriod"));
                processMap.put("CS001", info.get("CS001"));
                processMap.put("CS002", info.get("CS002"));
                processMap.put("CS055", info.get("CS055"));
                processMap.put("CS056", info.get("CS056"));
                boolean isStart = (Boolean)info.get("isStart");
                processMap.put("isStart", isStart);
                if (!isStart) {
                    String isStartMsg = "";
                    isStartMsg = EASResource.getString((String)resourcePath, (String)"StartPeriod_NullMsg");
                    processMap.put("isStart_msg", isStartMsg);
                    processMap.put("needAllBook", false);
                    processMap.put(INSIDE_NOT_VOUCHER, false);
                    processMap.put(OUTSIDE_NOT_VOUCHER, false);
                    processData.add(processMap);
                    continue;
                }
                boolean needAllBook = Boolean.valueOf((String)info.get("CS002"));
                int bookType = Integer.valueOf((String)info.get("CS001"));
                if (bookType == 1 && needAllBook) {
                    String needAllBookMsg = this.checkNotBookBill(needAllBook, bookType, checkMsg);
                    if (!FMHelper.isEmpty((String)needAllBookMsg)) {
                        processMap.put("needAllBook_Msg", needAllBookMsg);
                        needAllBook = false;
                    } else {
                        needAllBook = true;
                    }
                } else {
                    needAllBook = true;
                }
                processMap.put("needAllBook", needAllBook);
                boolean insideNotVoucher = Boolean.valueOf((String)info.get("CS055"));
                if (insideNotVoucher) {
                    String checkInsideMsg = this.checkInsideNotVoucherBill(checkMsg);
                    if (!FMHelper.isEmpty((String)checkInsideMsg)) {
                        processMap.put("checkInsideNotVoucher_Msg", checkInsideMsg);
                        insideNotVoucher = false;
                    } else {
                        insideNotVoucher = true;
                    }
                } else {
                    insideNotVoucher = !insideNotVoucher;
                }
                processMap.put(INSIDE_NOT_VOUCHER, insideNotVoucher);
                boolean outsideNotVoucher = Boolean.valueOf((String)info.get("CS056"));
                if (outsideNotVoucher) {
                    String checkOutsideMsg = this.checkOutsideNotVoucherBill(checkMsg);
                    if (!FMHelper.isEmpty((String)checkOutsideMsg)) {
                        processMap.put("checkOutsideNotVoucher_Msg", checkOutsideMsg);
                        outsideNotVoucher = false;
                    } else {
                        outsideNotVoucher = true;
                    }
                } else {
                    outsideNotVoucher = !outsideNotVoucher;
                }
                processMap.put(OUTSIDE_NOT_VOUCHER, outsideNotVoucher);
                processData.add(processMap);
            }
        }
        return processData;
    }

    private void loadDataToTable(List initData) throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getColumn(BALACE_EQUAL).getStyleAttributes().setHided(true);
        String result = "";
        if (initData != null) {
            for (int i = 0; i < initData.size(); ++i) {
                IRow rowAss = this.tblMain.addRow();
                Map info = (Map)initData.get(i);
                rowAss.setUserObject((Object)info);
                FullOrgUnitInfo curCompany = (FullOrgUnitInfo)info.get("company");
                PeriodInfo curPeriodInfo = (PeriodInfo)info.get("curPeriod");
                Object[] args = new String[]{String.valueOf(curPeriodInfo.getPeriodYear()), String.valueOf(curPeriodInfo.getPeriodNumber())};
                result = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"LBL_Period"), args);
                rowAss.getCell(SELECT).setValue((Object)Boolean.FALSE);
                rowAss.getCell(COMPANY_ID).setValue((Object)curCompany.getId().toString());
                rowAss.getCell(COMPANY_NAME).setValue((Object)curCompany.getName());
                rowAss.getCell(COMPANY_NUMBER).setValue((Object)curCompany.getNumber());
                rowAss.getCell(PERIOD_ID).setValue((Object)curPeriodInfo.getId().toString());
                rowAss.getCell(PERIOD).setValue((Object)result);
                rowAss.getCell(CLOSE_INIT).setValue(info.get("isStart"));
                rowAss.getCell(VOUCHER_BOOK).setValue(info.get("needAllBook"));
                rowAss.getCell(INSIDE_NOT_VOUCHER).setValue(info.get(INSIDE_NOT_VOUCHER));
                rowAss.getCell(OUTSIDE_NOT_VOUCHER).setValue(info.get(OUTSIDE_NOT_VOUCHER));
                rowAss.getCell("msg").setValue(info.get("isStart_msg"));
            }
        }
    }

    private void lockColumnsExceptSelect() {
        KDTColumns cols = this.tblMain.getColumns();
        int length = cols.size();
        for (int i = 0; i < length; ++i) {
            KDTColumn column = cols.getColumn(i);
            if (column.getKey().equals(SELECT)) continue;
            this.tblMain.getColumn(i).getStyleAttributes().setLocked(true);
        }
    }

    public final IFinalCheckout getFacade() throws Exception {
        return FinalCheckoutFactory.getRemoteInstance();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.tblMain.removeRows();
        this.initData = this.getFacade().getInitData(null);
        List processData = this.processData(this.initData);
        this.loadDataToTable(processData);
        this.actionCheckOut.setEnabled(true);
        this.actionClearAll.setEnabled(true);
        this.actionSelectAll.setEnabled(true);
        this.tblMain.getColumn(SELECT).getStyleAttributes().setLocked(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionCheckOut_actionPerformed(ActionEvent e) throws Exception {
        PeriodInfo period;
        super.actionCheckOut_actionPerformed(e);
        Map initCompanyData = this.getInitDataCompanyMap();
        boolean hasSelect = false;
        ArrayList<String> validComList = new ArrayList<String>();
        ArrayList<String> invalidComList = new ArrayList<String>();
        HashMap<String, String> notCheckOutMsgMap = new HashMap<String, String>();
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow rowAss = this.tblMain.getRow(i);
            Map info = (Map)rowAss.getUserObject();
            FullOrgUnitInfo company = (FullOrgUnitInfo)info.get("company");
            boolean isSelected = (Boolean)rowAss.getCell(SELECT).getValue();
            if (!isSelected) continue;
            boolean isStart = (Boolean)rowAss.getCell(CLOSE_INIT).getValue();
            boolean needAllBook = (Boolean)rowAss.getCell(VOUCHER_BOOK).getValue();
            boolean forbitInsideNotVoucherBill = (Boolean)rowAss.getCell(INSIDE_NOT_VOUCHER).getValue();
            boolean forbitOutsideNotVoucherBill = (Boolean)rowAss.getCell(OUTSIDE_NOT_VOUCHER).getValue();
            IParamControl pc = ParamControlFactory.getRemoteInstance();
            if (isStart && needAllBook && forbitInsideNotVoucherBill && forbitOutsideNotVoucherBill) {
                validComList.add(company.getId().toString());
            } else {
                invalidComList.add(company.getId().toString());
                StringBuffer msg = new StringBuffer();
                msg.append(info.get("isStart_msg") != null ? info.get("isStart_msg") : "").append(info.get("gl_balance_msg") != null ? info.get("gl_balance_msg") : "").append(info.get("needAllBook_Msg") != null ? info.get("needAllBook_Msg") : "").append(info.get("checkInsideNotVoucher_Msg") != null ? info.get("checkInsideNotVoucher_Msg") : "").append(info.get("checkOutsideNotVoucher_Msg") != null ? info.get("checkOutsideNotVoucher_Msg") : "");
                notCheckOutMsgMap.put(company.getId().toString(), msg.toString());
            }
            hasSelect = true;
        }
        if (!hasSelect) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"selectCheckOutCompany"));
            SysUtil.abort();
        }
        ArrayList<String> comfirmCheckCompanyList = new ArrayList<String>();
        HashMap<String, String> comfirmCheckOutMsgMap = new HashMap<String, String>();
        for (int i = 0; i < rowCount; ++i) {
            String checkNotBookMsg;
            boolean result;
            PeriodInfo periodInfo;
            IRow rowAss = this.tblMain.getRow(i);
            Map info = (Map)rowAss.getUserObject();
            FullOrgUnitInfo company = (FullOrgUnitInfo)info.get("company");
            boolean isSelected = (Boolean)rowAss.getCell(SELECT).getValue();
            if (!isSelected || invalidComList.contains(company.getId().toString())) continue;
            if (EmptyUtil.isEmpty(info.get("curPeriod"))) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"MSG_periodError"));
                SysUtil.abort();
            }
            if (!EmptyUtil.isEmpty((CoreBaseInfo)(periodInfo = (PeriodInfo)info.get("curPeriod"))) && periodInfo.getEndDate().getMonth() == 9 && !(result = LicenseHelper.keyPointLicenseCheck())) {
                SysUtil.abort();
            }
            boolean needAllBook = Boolean.valueOf((String)info.get("CS002"));
            int bookType = Integer.valueOf((String)info.get("CS001"));
            if (needAllBook && bookType == 1 || FMHelper.isEmpty((String)(checkNotBookMsg = this.checkNotBookBill(needAllBook, bookType, (Map)info.get("checkMsg"))).toString())) continue;
            comfirmCheckCompanyList.add(company.getId().toString());
            comfirmCheckOutMsgMap.put(company.getId().toString(), checkNotBookMsg + LINE_SEPARATOR);
        }
        if (comfirmCheckCompanyList.size() != 0) {
            StringBuffer comfirmMsg = new StringBuffer();
            for (String key : comfirmCheckOutMsgMap.keySet()) {
                String msg = (String)comfirmCheckOutMsgMap.get(key);
                FullOrgUnitInfo company = (FullOrgUnitInfo)initCompanyData.get(key);
                comfirmMsg.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"344_FinalCheckOutBatchUI", (Object[])new Object[]{company.getNumber(), company.getName(), LINE_SEPARATOR, msg, LINE_SEPARATOR}));
            }
            int option = MsgBox.showConfirm3a((String)EASResource.getString((String)resourcePath, (String)"havaNotBookBill"), (String)comfirmMsg.toString());
            if (option == 2) {
                validComList.removeAll(comfirmCheckCompanyList);
                invalidComList.addAll(comfirmCheckCompanyList);
            }
        }
        Map checkOutMap = new HashMap();
        if (validComList.size() > 0) {
            ArrayList appliedList = new ArrayList();
            IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
            try {
                int i;
                Map resultRequest = iMutex.batchRequestObjIDForUpdate(validComList);
                for (i = 0; i < validComList.size(); ++i) {
                    Boolean boolResult = (Boolean)resultRequest.get(validComList.get(i));
                    if (!boolResult.booleanValue()) continue;
                    appliedList.add(validComList.get(i));
                }
                for (i = 0; i < validComList.size(); ++i) {
                    Boolean boolResult = (Boolean)resultRequest.get(validComList.get(i));
                    if (boolResult.booleanValue()) continue;
                    FullOrgUnitInfo company = (FullOrgUnitInfo)initCompanyData.get(validComList.get(i));
                    String msg1 = EASResource.getString((String)resourcePath, (String)"77_FinalCheckOutUI", (Object[])new Object[]{company.getNumber(), company.getName()});
                    MsgBox.showInfo((String)msg1);
                    return;
                }
                checkOutMap = this.getFacade().finalCheckOutBatch(validComList);
            }
            finally {
                if (appliedList.size() > 0) {
                    iMutex.batchReleaseObjIDForUpdate(validComList);
                }
            }
        }
        StringBuffer totalMsg = new StringBuffer();
        for (String key : invalidComList) {
            FullOrgUnitInfo company = (FullOrgUnitInfo)initCompanyData.get(key);
            totalMsg.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"346_FinalCheckOutBatchUI", (Object[])new Object[]{company.getNumber(), company.getName(), LINE_SEPARATOR}));
            String validMsg = (String)notCheckOutMsgMap.get(key);
            String comfirmMsg = (String)comfirmCheckOutMsgMap.get(key);
            if (!FMHelper.isEmpty((String)validMsg)) {
                totalMsg.append(validMsg + LINE_SEPARATOR);
            }
            if (FMHelper.isEmpty((String)comfirmMsg)) continue;
            totalMsg.append(comfirmMsg + LINE_SEPARATOR);
        }
        StringBuffer checkOutSuccMsg = new StringBuffer();
        if (checkOutMap.keySet().size() > 0) {
            for (String key : checkOutMap.keySet()) {
                FullOrgUnitInfo company = (FullOrgUnitInfo)initCompanyData.get(key);
                Object object = checkOutMap.get(key);
                if (object instanceof String) {
                    invalidComList.add(key);
                    String error = (String)object;
                    checkOutSuccMsg.append(company.getNumber()).append(" ").append(company.getName()).append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"454_FinalCheckOutBatchUI")).append(error).append(LINE_SEPARATOR);
                    continue;
                }
                period = (PeriodInfo)object;
                String[] args = new String[]{String.valueOf(period.getPeriodYear()), String.valueOf(period.getPeriodNumber())};
                MessageFormat mf = new MessageFormat(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"LBL_Period"));
                String result = mf.format(args);
                checkOutSuccMsg.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"347_FinalCheckOutBatchUI", (Object[])new Object[]{company.getNumber(), company.getName(), result, LINE_SEPARATOR}));
            }
            checkOutSuccMsg.append(LINE_SEPARATOR);
        }
        if (invalidComList.size() > 0) {
            String detailMsg = totalMsg.toString();
            if (checkOutMap.keySet().size() > 0) {
                detailMsg = checkOutSuccMsg.toString() + detailMsg;
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"haveError"), (String)detailMsg, (int)2);
        } else if (checkOutMap.keySet().size() > 0 && invalidComList.size() == 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"348_FinalCheckOutBatchUI"), (String)checkOutSuccMsg.toString(), (int)2);
        }
        for (int i = 0; i < rowCount; ++i) {
            IRow rowAss = this.tblMain.getRow(i);
            String id = (String)rowAss.getCell(COMPANY_ID).getValue();
            if (!checkOutMap.containsKey(id)) continue;
            Object object = checkOutMap.get(id);
            if (object instanceof String) {
                rowAss.getCell("msg").setValue(object);
                continue;
            }
            period = (PeriodInfo)checkOutMap.get(id);
            String msgStr = MessageFormat.format(EASResource.getString((String)resourcePath, (String)"73_FinalCheckOutBatchUI"), period.getPeriodYear(), period.getPeriodNumber());
            msgStr = msgStr.replace(",", "");
            rowAss.getCell("msg").setValue((Object)msgStr);
        }
        this.actionCheckOut.setEnabled(false);
        this.actionClearAll.setEnabled(false);
        this.actionSelectAll.setEnabled(false);
        this.tblMain.getColumn(SELECT).getStyleAttributes().setLocked(true);
    }

    private Map getInitDataCompanyMap() {
        HashMap<String, FullOrgUnitInfo> initCompanyMap = new HashMap<String, FullOrgUnitInfo>();
        if (this.initData != null) {
            for (int i = 0; i < this.initData.size(); ++i) {
                Map info = (Map)this.initData.get(i);
                FullOrgUnitInfo company = (FullOrgUnitInfo)info.get("company");
                initCompanyMap.put(company.getId().toString(), company);
            }
        }
        return initCompanyMap;
    }

    private String checkNotBookBill(boolean needAllBook, int bookType, Map checkMsg) {
        StringBuffer singleMsg = new StringBuffer();
        Vector tmpVec = null;
        String strInfo = null;
        if (bookType == 0) {
            if (checkMsg.get("RECEIVINGBOOK") != null) {
                tmpVec = (Vector)checkMsg.get("RECEIVINGBOOK");
                if (!tmpVec.isEmpty()) {
                    strInfo = tmpVec.toString();
                    singleMsg.append(EASResource.getString((String)resourcePath, (String)"ExistNoBookRecMsg")).append(strInfo.subSequence(1, strInfo.length() - 1));
                }
                singleMsg.append(LINE_SEPARATOR);
            }
            if (checkMsg.get("PAYMENTBOOK") != null) {
                tmpVec = (Vector)checkMsg.get("PAYMENTBOOK");
                if (!tmpVec.isEmpty()) {
                    strInfo = tmpVec.toString();
                    singleMsg.append(EASResource.getString((String)resourcePath, (String)"ExistNoBookPayMsg")).append(strInfo.subSequence(1, strInfo.length() - 1));
                }
                singleMsg.append(LINE_SEPARATOR);
            }
        }
        if (needAllBook && bookType == 1 && checkMsg.get("VOUCHERBOOK") != null) {
            tmpVec = (Vector)checkMsg.get("VOUCHERBOOK");
            if (!tmpVec.isEmpty()) {
                strInfo = tmpVec.toString();
                singleMsg.append(EASResource.getString((String)resourcePath, (String)"ExistNoBookVoucherMsg")).append(strInfo.subSequence(1, strInfo.length() - 1));
            }
            singleMsg.append(LINE_SEPARATOR);
        }
        return singleMsg.toString();
    }

    private String checkInsideNotVoucherBill(Map checkMsg) {
        StringBuffer singleMsg = new StringBuffer();
        Vector tmpVec = null;
        String strInfo = "";
        if (checkMsg.get("PAYINNOTVOUCHER") != null) {
            tmpVec = (Vector)checkMsg.get("PAYINNOTVOUCHER");
            if (!tmpVec.isEmpty()) {
                strInfo = tmpVec.toString();
                singleMsg.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"hasInSideNotVouPay")).append(strInfo.subSequence(1, strInfo.length() - 1));
            }
            singleMsg.append(LINE_SEPARATOR);
        }
        if (checkMsg.get("RECINNOTVOUCHER") != null) {
            tmpVec = (Vector)checkMsg.get("RECINNOTVOUCHER");
            if (!tmpVec.isEmpty()) {
                strInfo = tmpVec.toString();
                singleMsg.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"hasInSideNotVouRec")).append(strInfo.subSequence(1, strInfo.length() - 1));
            }
            singleMsg.append(LINE_SEPARATOR);
        }
        return singleMsg.toString();
    }

    private String checkOutsideNotVoucherBill(Map checkMsg) {
        String strInfo;
        Vector tmpVec;
        StringBuffer singleMsg = new StringBuffer();
        if (checkMsg.get("PAYOUTNOTVOUCHER") != null) {
            tmpVec = (Vector)checkMsg.get("PAYOUTNOTVOUCHER");
            if (!tmpVec.isEmpty()) {
                strInfo = tmpVec.toString();
                singleMsg.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"hasOutSideNotVouPay")).append(strInfo.subSequence(1, strInfo.length() - 1));
            }
            singleMsg.append(LINE_SEPARATOR);
        }
        if (checkMsg.get("RECOUTNOTVOUCHER") != null) {
            tmpVec = (Vector)checkMsg.get("RECOUTNOTVOUCHER");
            if (!tmpVec.isEmpty()) {
                strInfo = tmpVec.toString();
                singleMsg.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"hasOutSideNotVouRec")).append(strInfo.subSequence(1, strInfo.length() - 1));
            }
            singleMsg.append(LINE_SEPARATOR);
        }
        return singleMsg.toString();
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionClearAll_actionPerformed(e);
        this.doSelect(false);
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAll_actionPerformed(e);
        this.doSelect(true);
    }

    private void doSelect(boolean select) {
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow rowAss = this.tblMain.getRow(i);
            rowAss.getCell(SELECT).setValue((Object)select);
        }
    }
}

