/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.CasGLItemCheckRptInfo;
import com.kingdee.eas.fi.cas.CashMgtInitFacadeFactory;
import com.kingdee.eas.fi.cas.ICashMgtInitFacade;
import com.kingdee.eas.fi.cas.client.AbstractFinalCheckOutFailureReportUI;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Vector;

public class FinalCheckOutFailureReportUI
extends AbstractFinalCheckOutFailureReportUI {
    private static final String CUR_COL = "currency";
    private static final String CAS_COL = "casStartAmt";
    private static final String GL_COL = "glStartAmt";
    private static final String DIFF_COL = "startDifferenceAmt";
    private int fcPrecision = 4;
    private int scPrecision = 4;
    private Vector vec;

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.removeRows();
        this.tblMain.getStyleAttributes().setLocked(true);
        int columnCount = this.tblMain.getColumnCount();
        for (int i = 3; i < columnCount; ++i) {
            this.tblMain.getColumn(i).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
        Vector vec = (Vector)this.getUIContext().get("vec");
        this.showFailureReport(vec);
        this.initTable();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionCloseWindow_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }

    public String getUITitle() {
        return EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"cm40");
    }

    public void showFailureReport(Vector vec) {
        int size = vec.size();
        CasGLItemCheckRptInfo casMgtInitFailureRptInfo = null;
        for (int i = 0; i < size; ++i) {
            casMgtInitFailureRptInfo = (CasGLItemCheckRptInfo)vec.get(i);
            this.addLine(casMgtInitFailureRptInfo);
        }
    }

    public void showDialogWindows(IUIObject ui, String strCompanyId, String strPeriodId) throws EASBizException, BOSException {
        ICashMgtInitFacade init = CashMgtInitFacadeFactory.getRemoteInstance();
        this.vec = init.getContrastWithGL(strCompanyId, strPeriodId);
        if (this.vec != null) {
            UIContext uiContext = new UIContext((Object)this);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.cas.client.CashMgtInitFailureReportUI", (Map)uiContext, null, OprtState.VIEW);
            ((FinalCheckOutFailureReportUI)uiWindow.getUIObject()).showFailureReport(this.vec);
            uiWindow.show();
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"cm37"));
            SysUtil.abort();
        }
    }

    private void addLine(CasGLItemCheckRptInfo cashMgtInitFailureReportInfo) {
        if (cashMgtInitFailureReportInfo != null) {
            IRow row = this.tblMain.addRow();
            this.loadLineFields(row, cashMgtInitFailureReportInfo);
        }
    }

    private void loadLineFields(IRow row, CasGLItemCheckRptInfo rptInfo) {
        BigDecimal amt = null;
        if (rptInfo.getCurrencyInfo() != null) {
            this.fcPrecision = rptInfo.getCurrencyInfo().getPrecision();
        }
        row.getCell("bank").setValue((Object)rptInfo.getBankInfo());
        row.getCell("bankAccount").setValue((Object)rptInfo.getAccountBankInfo());
        row.getCell("account").setValue((Object)rptInfo.getAccountViewInfo());
        row.getCell(CUR_COL).setValue((Object)rptInfo.getCurrencyInfo());
        if (rptInfo.getCasStartAmt() != null) {
            amt = rptInfo.getCasStartAmt().setScale(this.fcPrecision, 4);
            row.getCell(CAS_COL).setValue((Object)amt);
        }
        if (rptInfo.getGlStartAmt() != null) {
            amt = rptInfo.getGlStartAmt().setScale(this.fcPrecision, 4);
            row.getCell(GL_COL).setValue((Object)amt);
        }
        if (rptInfo.getStartDifferenceAmt() != null) {
            amt = rptInfo.getStartDifferenceAmt().setScale(this.fcPrecision, 4);
            row.getCell(DIFF_COL).setValue((Object)amt);
        }
    }

    private void initTable() {
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            IRow row = this.tblMain.getRow(i);
            CurrencyInfo curInfo = (CurrencyInfo)row.getCell(CUR_COL).getValue();
            if (curInfo == null) continue;
            String strCurrencyId = curInfo.getId().toString();
            FMClientHelper.setNumberFormat((IRow)row, (String)CAS_COL, (String)strCurrencyId);
            FMClientHelper.setNumberFormat((IRow)row, (String)GL_COL, (String)strCurrencyId);
            FMClientHelper.setNumberFormat((IRow)row, (String)DIFF_COL, (String)strCurrencyId);
        }
        this.tblMain.getColumn(CAS_COL).setWidth(110);
        this.tblMain.getColumn(GL_COL).setWidth(110);
        this.tblMain.getColumn(DIFF_COL).setWidth(110);
    }
}

