/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.base.uiframe.client.LicenseHelper;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.common.perf.CreateJobFacadeFactory;
import com.kingdee.eas.basedata.common.perf.ICreateJobFacade;
import com.kingdee.eas.basedata.common.perf.JobConfig;
import com.kingdee.eas.basedata.master.account.AccountRefContrastCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.FinalCheckoutFactory;
import com.kingdee.eas.fi.cas.IFinalCheckout;
import com.kingdee.eas.fi.cas.client.AbstractFinalCheckOutUI;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fi.cas.client.PeriodHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.MutexUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.Uuid;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class FinalCheckOutUI
extends AbstractFinalCheckOutUI {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String resourcePath = "com.kingdee.eas.fi.cas.CheckoutResource";
    public static final String RESOURCE_PATH = "com.kingdee.eas.fi.cas.CASPeriodEndResource";
    private static final Logger logger = CoreUIObject.getLogger(FinalCheckOutUI.class);
    private CompanyOrgUnitInfo company;
    private PeriodInfo periodInfo = null;
    private PeriodInfo nextPeriodInfo = null;
    private PeriodInfo startPeriod = null;
    private PeriodInfo prevPeriodInfo = null;
    private StringBuffer buff = null;
    private StringBuffer buff1 = null;
    private StringBuffer buff2 = null;
    private StringBuffer strBuff = null;
    private Uuid mutexUuid = null;
    public static final String ACTIONKEY_MODIFY = "MODIFY";
    protected BalanceModifyListener modifyeBalance = new BalanceModifyListener("MODIFY");

    public void onLoad() throws Exception {
        if (this.mutexUuid == null) {
            this.mutexUuid = Uuid.create();
        }
        MutexUtils.setMutex((Uuid)this.mutexUuid, (String)("CashMgtInit_Final" + ContextHelperFactory.getRemoteInstance().getCurrentCompany().getNumber()), (String)"ActionOnLoad");
        super.onLoad();
        this.initUI();
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        this.initTableStyle();
        this.attachListeners();
    }

    private void initUI() throws Exception {
        CompanyOrgUnitInfo companyInfo = ClientUtils.getCurrLoginCompany();
        ClientUtils.checkCompany((Component)((Object)this), companyInfo);
        this.company = companyInfo;
        boolean flag = SystemStatusCtrolUtils.isStart(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        if (!flag) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CheckOut_Msg"));
            MutexUtils.releaseMutex((Uuid)this.mutexUuid);
            SysUtil.abort();
        }
        this.periodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.company);
        this.nextPeriodInfo = PeriodUtils.getNextPeriodInfo((PeriodInfo)this.periodInfo);
        this.grpCheck.add((AbstractButton)this.btnCheckout);
        this.grpCheck.add((AbstractButton)this.btnCheckoutOpp);
        this.setImage();
        this.contCompany.setVisible(false);
        this.prmtCompany.setVisible(false);
        this.btnCheckout.setEnabled(true);
        this.btnCheckout.setSelected(true);
        this.btnCheckoutOpp.setEnabled(true);
        if (this.nextPeriodInfo != null) {
            this.setCheckText();
        } else {
            this.setCommonText();
            StringBuffer buffCheck = new StringBuffer();
            buffCheck.append(EASResource.getString((String)resourcePath, (String)"CHECKOUT_after"));
            buffCheck.append(EASResource.getString((String)resourcePath, (String)"CHECKOUT_alter"));
            buffCheck.append(EASResource.getString((String)resourcePath, (String)"CHECKOUT_all"));
            StringBuffer la = new StringBuffer();
            la.append(this.buff);
            la.append(LINE_SEPARATOR);
            la.append("");
            la.append(LINE_SEPARATOR);
            this.txtHint.setText(la + buffCheck.toString());
        }
    }

    protected void initTableStyle() {
        InputMap imEntry = this.getInputMap(2);
        KeyStroke ctrl_shift_f9 = KeyStroke.getKeyStroke(120, 3);
        imEntry.put(ctrl_shift_f9, ACTIONKEY_MODIFY);
    }

    protected void attachListeners() {
        ActionMap am = this.getActionMap();
        am.put(ACTIONKEY_MODIFY, this.modifyeBalance);
    }

    public void modifyBalance() {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.cas.client.CasBalanceModifyUI", (Map)uiContext, null, OprtState.EDIT);
            this.destroyWindow();
            uiWindow.show();
        }
        catch (UIException e) {
            this.handUIException(e);
        }
    }

    public void setSelectedRadio(boolean bln) {
        this.btnCheckout.setSelected(bln);
        this.btnCheckoutOpp.setEnabled(!bln);
    }

    private void setImage() {
        Icon guide = null;
        guide = EASResource.getIcon((String)"imgGuide_pic260");
        KDLabel backlabel = new KDLabel(guide);
        backlabel.setBounds(0, 0, guide.getIconWidth(), guide.getIconHeight());
        this.pnlPicture.add((Component)backlabel, (Object)"Center");
        this.pnlPicture.setSize(guide.getIconWidth(), guide.getIconHeight());
        this.pnlPicture.setBackground(Color.blue);
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.uiWindow.close();
    }

    @Override
    protected void btnCheckout_actionPerformed(ActionEvent e) throws Exception {
        super.btnCheckout_actionPerformed(e);
        this.setCheckText();
        this.btnCheckout.setSelected(true);
        this.btnCheckoutOpp.setEnabled(true);
    }

    @Override
    protected void btnCheckoutOpp_actionPerformed(ActionEvent e) throws Exception {
        super.btnCheckoutOpp_actionPerformed(e);
        this.setUnCheckText();
        this.btnCheckoutOpp.setSelected(true);
        this.btnCheckoutOpp.setEnabled(true);
    }

    public void setCommonText() {
        try {
            this.periodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.company);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (this.periodInfo == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"MSG_periodError"));
            SysUtil.abort();
            return;
        }
        this.buff = new StringBuffer();
        this.buff.append(EASResource.getString((String)resourcePath, (String)"CHECKOUT_current"));
        Object[] args = new String[]{String.valueOf(this.periodInfo.getPeriodYear()), String.valueOf(this.periodInfo.getPeriodNumber())};
        String result = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"LBL_Period"), args);
        this.buff.append(result);
        this.buff.append(LINE_SEPARATOR);
    }

    public boolean destroyWindow() {
        MutexUtils.releaseMutex((Uuid)this.mutexUuid);
        return super.destroyWindow();
    }

    public void setCheckText() {
        try {
            this.nextPeriodInfo = PeriodUtils.getNextPeriodInfo((PeriodInfo)this.periodInfo);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (this.nextPeriodInfo == null) {
            this.destroyWindow();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"MSG_periodError"));
            SysUtil.abort();
            return;
        }
        this.setCommonText();
        this.buff1 = new StringBuffer();
        this.buff1.append(this.buff);
        this.buff1.append(EASResource.getString((String)resourcePath, (String)"CHECKOUT_next"));
        Object[] args = new String[]{String.valueOf(this.nextPeriodInfo.getPeriodYear()), String.valueOf(this.nextPeriodInfo.getPeriodNumber())};
        String result = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"LBL_Period"), args);
        this.buff1.append(result);
        this.buff1.append(LINE_SEPARATOR);
        this.buff1.append("");
        this.buff1.append(LINE_SEPARATOR);
        StringBuffer buffCheck = new StringBuffer();
        buffCheck.append(EASResource.getString((String)resourcePath, (String)"CHECKOUT_after"));
        buffCheck.append(EASResource.getString((String)resourcePath, (String)"CHECKOUT_alter"));
        buffCheck.append(EASResource.getString((String)resourcePath, (String)"CHECKOUT_all"));
        this.txtHint.setText(this.buff1.toString() + buffCheck.toString());
        this.lblInfo.setText(EASResource.getString((String)resourcePath, (String)"CheckOut_labelpropmt"));
    }

    public void setUnCheckText() throws EASBizException, BOSException {
        this.startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.company);
        this.periodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.company);
        if (this.startPeriod != null && PeriodHelper.isAfterStartPeriod(this.startPeriod, this.periodInfo)) {
            this.prevPeriodInfo = PeriodUtils.getPrePeriodInfo((PeriodInfo)this.periodInfo);
            if (this.prevPeriodInfo != null && PeriodHelper.isAfterStartPeriod(this.startPeriod, this.prevPeriodInfo)) {
                this.setCommonText();
                this.buff2 = new StringBuffer();
                this.buff2.append(this.buff);
                this.buff2.append(EASResource.getString((String)resourcePath, (String)"PrevPeriod_Msg"));
                Object[] args = new String[]{String.valueOf(this.prevPeriodInfo.getPeriodYear()), String.valueOf(this.prevPeriodInfo.getPeriodNumber())};
                String result = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"LBL_Period"), args);
                this.buff2.append(result);
                this.buff2.append(LINE_SEPARATOR);
                this.buff2.append("");
                this.buff2.append(LINE_SEPARATOR);
            }
        } else {
            this.destroyWindow();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"MSG_periodError"));
            SysUtil.abort();
            return;
        }
        StringBuffer buffCheck = new StringBuffer();
        buffCheck.append(EASResource.getString((String)resourcePath, (String)"UnCheckOut_hint"));
        if (this.buff2 != null) {
            this.txtHint.setText(this.buff2.toString() + buffCheck.toString());
        }
        this.lblInfo.setText(EASResource.getString((String)resourcePath, (String)"UnCheckOut_labelpropmt"));
    }

    @Override
    protected void btnHelp_actionPerformed(ActionEvent e) throws Exception {
        super.btnHelp_actionPerformed(e);
    }

    @Override
    protected void btnSure_actionPerformed(ActionEvent e) throws Exception {
        super.btnSure_actionPerformed(e);
    }

    private void beforeCheckOut() throws Exception {
        if (this.company == null) {
            return;
        }
        boolean flag = SystemStatusCtrolUtils.isStart(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.company);
        if (!flag) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"StartPeriod_NullMsg"));
            SysUtil.abort();
        } else {
            boolean result;
            this.periodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.company);
            if (this.periodInfo == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"MSG_periodError"));
                SysUtil.abort();
            }
            if (this.btnCheckout.isSelected() && this.periodInfo.getEndDate().getMonth() == 9 && !(result = LicenseHelper.keyPointLicenseCheck())) {
                SysUtil.abort();
            }
            this.btnCheckout.setVisible(false);
            this.btnCheckoutOpp.setVisible(false);
            this.btnCancel.setText(EASResource.getString((String)resourcePath, (String)"Close"));
            this.lblInfo.setVisible(false);
            this.btnSure.setVisible(false);
            this.prmtCompany.setEnabled(false);
        }
    }

    private void antiCheckOut() {
        if (this.periodInfo.isIsAdjustPeriod()) {
            String companyid = this.company.getId().toString();
            try {
                AccountRefContrastCollection coll = FMClientHelper.getEnabledAcctRefContrastColl((String)companyid, (Date)DateTimeUtils.truncateDate((Date)this.periodInfo.getBeginDate()), (Date)DateTimeUtils.truncateDate((Date)this.periodInfo.getEndDate()));
                if (coll != null && !coll.isEmpty()) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"periodIsAdjust"));
                    SysUtil.abort();
                }
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        try {
            String companyId;
            SystemStatusCtrolUtils sscUtils;
            if (this.periodInfo.equals((Object)this.startPeriod)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"MSG_unCheckout"));
                SysUtil.abort();
            }
            if (!PeriodHelper.isAfterStartPeriod(this.startPeriod, this.prevPeriodInfo)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"AntiCheckOut_PeriodMsg"));
                SysUtil.abort();
            }
            if ((sscUtils = new SystemStatusCtrolUtils()).isRelatedAccount4Client(companyId = this.company.getId().toString(), SystemEnum.CASHMANAGEMENT)) {
                PeriodInfo glCurPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)this.company);
                if (glCurPeriod != null && this.periodInfo != null && this.periodInfo.getPeriodYear() == glCurPeriod.getPeriodYear() && this.periodInfo.getPeriodNumber() == glCurPeriod.getPeriodNumber()) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"349_FinalCheckOutUI"));
                    SysUtil.abort();
                }
                if (sscUtils.isEqualsCurPeriodAndRelPeriod4Client(companyId, SystemEnum.CASHMANAGEMENT)) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"CancelCASAndGL"));
                    SysUtil.abort();
                }
            }
            IFinalCheckout checkout = FinalCheckoutFactory.getRemoteInstance();
            PeriodInfo tempPeriodInfo = checkout.deleteCheckAccount(companyId);
            this.txtHint.setText(null);
            this.txtHint.setText(this.getOverReorptText(tempPeriodInfo));
        }
        catch (Exception exp) {
            this.handUIException(exp);
        }
    }

    private void CheckOut() {
        try {
            IFinalCheckout checkout = FinalCheckoutFactory.getRemoteInstance();
            int param = -1;
            Date beginDate = this.periodInfo.getBeginDate();
            Timestamp endDate = this.periodInfo.getEndDate();
            String companyId = this.company.getId().toString();
            Map hashMap = checkout.checkBeforeCheckAccount(companyId, beginDate, endDate, param);
            this.showCheckMessage((Map)hashMap.get(companyId));
            List list = checkout.checkBalanceAdjustAudit(companyId);
            if (list.size() > 0) {
                StringBuffer message = new StringBuffer();
                message.append(this.company.getName() + " \uff1a");
                for (AccountBankInfo acctBank : list) {
                    message.append(acctBank.getName() + ", ");
                }
                MsgBox.showConfirm3a((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"372_FinalCheckOutUI"), (String)message.toString());
                SysUtil.abort();
            }
            logger.error((Object)" ******************** \u671f\u672b\u7ed3\u8d26  ******************* ");
            if (!this.endingPeriod()) {
                this.destroyWindow();
                return;
            }
            this.periodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.company);
            this.nextPeriodInfo = PeriodUtils.getNextPeriodInfo(null, (PeriodInfo)this.periodInfo);
            this.txtHint.setText(null);
            this.txtHint.setText(this.getReorptText(this.periodInfo));
            if (!hashMap.isEmpty() && this.strBuff != null) {
                this.strBuff.append(LINE_SEPARATOR);
                this.strBuff.append("");
                this.strBuff.append(LINE_SEPARATOR);
                this.txtHint.setText(this.txtHint.getText() + this.strBuff.toString());
            }
        }
        catch (Exception exp) {
            this.handUIException(exp);
        }
    }

    private void showCheckMessage(Map hashMap) {
        if (!EmptyUtil.isEmpty((Object)hashMap) && !hashMap.isEmpty()) {
            Vector vec;
            Set keySet = hashMap.keySet();
            this.strBuff = new StringBuffer();
            Vector tmpVec = null;
            String strInfo = null;
            if (hashMap.get("RECEIVINGBOOK") != null) {
                tmpVec = (Vector)hashMap.get("RECEIVINGBOOK");
                if (!tmpVec.isEmpty()) {
                    strInfo = tmpVec.toString();
                    this.strBuff.append(EASResource.getString((String)resourcePath, (String)"ExistNoBookRecMsg")).append(strInfo.subSequence(1, strInfo.length() - 1));
                }
                this.strBuff.append(LINE_SEPARATOR);
            }
            if (hashMap.get("PAYMENTBOOK") != null) {
                tmpVec = (Vector)hashMap.get("PAYMENTBOOK");
                if (!tmpVec.isEmpty()) {
                    strInfo = tmpVec.toString();
                    this.strBuff.append(EASResource.getString((String)resourcePath, (String)"ExistNoBookPayMsg")).append(strInfo.subSequence(1, strInfo.length() - 1));
                }
                this.strBuff.append(LINE_SEPARATOR);
            }
            if (hashMap.get("VOUCHERBOOK") != null) {
                tmpVec = (Vector)hashMap.get("VOUCHERBOOK");
                if (!tmpVec.isEmpty()) {
                    strInfo = tmpVec.toString();
                    this.strBuff.append(EASResource.getString((String)resourcePath, (String)"ExistNoBookVoucherMsg")).append(strInfo.subSequence(1, strInfo.length() - 1));
                }
                this.strBuff.append(LINE_SEPARATOR);
            }
            if (hashMap.get("PAYOUTNOTVOUCHER") != null) {
                tmpVec = (Vector)hashMap.get("PAYOUTNOTVOUCHER");
                if (!tmpVec.isEmpty()) {
                    strInfo = tmpVec.toString();
                    this.strBuff.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"hasOutSideNotVouPay")).append(strInfo.subSequence(1, strInfo.length() - 1));
                }
                this.strBuff.append(LINE_SEPARATOR);
            }
            if (hashMap.get("RECOUTNOTVOUCHER") != null) {
                tmpVec = (Vector)hashMap.get("RECOUTNOTVOUCHER");
                if (!tmpVec.isEmpty()) {
                    strInfo = tmpVec.toString();
                    this.strBuff.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"hasOutSideNotVouRec")).append(strInfo.subSequence(1, strInfo.length() - 1));
                }
                this.strBuff.append(LINE_SEPARATOR);
            }
            if (hashMap.get("PAYINNOTVOUCHER") != null) {
                tmpVec = (Vector)hashMap.get("PAYINNOTVOUCHER");
                if (!tmpVec.isEmpty()) {
                    strInfo = tmpVec.toString();
                    this.strBuff.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"hasInSideNotVouPay")).append(strInfo.subSequence(1, strInfo.length() - 1));
                }
                this.strBuff.append(LINE_SEPARATOR);
            }
            if (hashMap.get("RECINNOTVOUCHER") != null) {
                tmpVec = (Vector)hashMap.get("RECINNOTVOUCHER");
                if (!tmpVec.isEmpty()) {
                    strInfo = tmpVec.toString();
                    this.strBuff.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"hasInSideNotVouRec")).append(strInfo.subSequence(1, strInfo.length() - 1));
                }
                this.strBuff.append(LINE_SEPARATOR);
            }
            Iterator iter = keySet.iterator();
            while (iter.hasNext()) {
                String strKey = iter.next().toString();
                Vector vec2 = (Vector)hashMap.get(strKey);
                if (!vec2.isEmpty() && ("PAYOUTNOTVOUCHER".equals(strKey) || "RECOUTNOTVOUCHER".equals(strKey))) {
                    MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"hasOutSideNotVoucherBill"));
                    this.txtHint.setText(this.strBuff.toString());
                    SysUtil.abort();
                    continue;
                }
                if (!vec2.isEmpty() && ("PAYINNOTVOUCHER".equals(strKey) || "RECINNOTVOUCHER".equals(strKey))) {
                    MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"hasInsideNotVoucherBill"));
                    this.txtHint.setText(this.strBuff.toString());
                    SysUtil.abort();
                    continue;
                }
                if (vec2.isEmpty() || "gl_balance".equals(strKey)) continue;
                IContextHelper remoteInstance = ContextHelperFactory.getRemoteInstance();
                boolean needallbook = remoteInstance.getBooleanParam("CS002", (IObjectPK)new ObjectUuidPK(remoteInstance.getCurrentCompany().getId()));
                int booktype = remoteInstance.getIntParam("CS001", (IObjectPK)new ObjectUuidPK(remoteInstance.getCurrentCompany().getId()));
                if (needallbook && booktype == 1) {
                    MsgBox.showError((Component)((Object)this), (String)this.strBuff.toString());
                    this.txtHint.setText(this.strBuff.toString());
                    SysUtil.abort();
                    continue;
                }
                int i = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)strKey));
                if (i == 0) continue;
                this.txtHint.setText(this.strBuff.toString());
                SysUtil.abort();
                return;
            }
            if (hashMap.get("gl_balance") != null && (vec = (Vector)hashMap.get("gl_balance")) != null && vec.size() > 0) {
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"vec", (Object)vec);
                try {
                    IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.cas.client.FinalCheckOutFailureReportUI", (Map)uiContext, null, OprtState.VIEW);
                    uiWindow.show();
                    SysUtil.abort();
                }
                catch (UIException e) {
                    this.handUIException(e);
                }
            }
        }
    }

    private String getReorptText(PeriodInfo periodInfo) {
        StringBuffer buff = new StringBuffer(EASResource.getString((String)resourcePath, (String)"CHECKOUT_success"));
        buff.append("");
        buff.append(LINE_SEPARATOR);
        if (periodInfo != null && periodInfo.getId() != null) {
            buff.append(EASResource.getString((String)resourcePath, (String)"CHECKOUT_current"));
            Object[] args = new String[]{String.valueOf(periodInfo.getPeriodYear()), String.valueOf(periodInfo.getPeriodNumber())};
            String result = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"LBL_Period"), args);
            buff.append(result);
        } else {
            buff.append(EASResource.getString((String)resourcePath, (String)"HasNotNextPeriod"));
        }
        buff.append("");
        buff.append(LINE_SEPARATOR);
        return buff.toString();
    }

    private String getOverReorptText(PeriodInfo periodInfo) {
        StringBuffer buff = new StringBuffer(EASResource.getString((String)resourcePath, (String)"CHECKOUT_turnover"));
        buff.append("");
        buff.append(LINE_SEPARATOR);
        buff.append(EASResource.getString((String)resourcePath, (String)"CHECKOUT_current"));
        if (periodInfo != null) {
            Object[] args = new String[]{String.valueOf(periodInfo.getPeriodYear()), String.valueOf(periodInfo.getPeriodNumber())};
            String result = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"LBL_Period"), args);
            buff.append(result);
        }
        buff.append("");
        buff.append(LINE_SEPARATOR);
        return buff.toString();
    }

    @Override
    public void actionCheckOut_actionPerformed(ActionEvent e) throws Exception {
        super.actionCheckOut_actionPerformed(e);
    }

    @Override
    public void actionUnCheckOut_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnCheckOut_actionPerformed(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionStart_actionPerformed(ActionEvent e) throws Exception {
        if (this.btnCheckout.isSelected()) {
            PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)this.getOrgPK(this.ActionCheckOut), (IMetaDataPK)this.getMetaDataPK(), (ItemAction)this.ActionCheckOut);
            this.actionCheckOut_actionPerformed(null);
        } else {
            PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)this.getOrgPK(this.ActionUnCheckOut), (IMetaDataPK)this.getMetaDataPK(), (ItemAction)this.ActionUnCheckOut);
        }
        super.actionStart_actionPerformed(e);
        Date now = new Date();
        Date invalidDate = this.company.getInvalidDate();
        if (invalidDate != null && !invalidDate.after(now)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"NotCheckoutByCompany"));
            return;
        }
        ArrayList<String> appliedList = new ArrayList<String>();
        String companyId = this.company.getId().toString();
        IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
        try {
            boolean boolResult = iMutex.requestObjIDForUpdate(companyId);
            if (!boolResult) {
                String msg1 = EASResource.getString((String)resourcePath, (String)"77_FinalCheckOutUI", (Object[])new Object[]{this.company.getNumber(), this.company.getName()});
                MsgBox.showInfo((String)msg1);
                return;
            }
            appliedList.add(companyId);
            if (this.btnCheckout.isSelected()) {
                this.beforeCheckOut();
                this.CheckOut();
            } else if (this.btnCheckoutOpp.isSelected()) {
                this.beforeCheckOut();
                this.antiCheckOut();
            }
        }
        finally {
            if (appliedList.size() > 0) {
                iMutex.releaseObjIDForUpdate(companyId);
            }
        }
    }

    private boolean endingPeriod() {
        try {
            ICreateJobFacade createJobFacade = CreateJobFacadeFactory.getRemoteInstance();
            JobConfig jobCfg = this.creteJobCfg();
            if (createJobFacade.checkDuplicateTask(jobCfg.getTaskType())) {
                String message = EASResource.getString((String)RESOURCE_PATH, (String)"CASPeriodEndIsInQueue");
                MsgBox.showWarning((String)message);
                return false;
            }
            Object[] params = new Object[]{this.company, SysContext.getSysContext().getLocale(), SysContext.getSysContext().getCurrentUserInfo(), this.periodInfo};
            Object ret = createJobFacade.executeJob(jobCfg, (Object)params);
            logger.error((Object)("******************** \u6267\u884c\u5b8c\u6027\u80fd\u9694\u79bb\u4efb\u52a1  ret.get(result) =  " + ((Map)ret).get("result") + " *******************"));
            if (ret instanceof Map && ((Map)ret).get("result") != null) {
                logger.error((Object)"******************** \u8fd4\u56de\u7ed3\u679c\u4e0d\u4e3anull\uff0c\u8bf4\u660e\u662f\u540c\u6b65\u6267\u884c\u7684 ********************");
                return true;
            }
            logger.error((Object)"******************** \u8fd4\u56de\u7ed3\u679c\u4e3anull\uff0c\u8bf4\u660e\u662f\u540e\u53f0\u5f02\u6b65\u6267\u884c ********************");
            String message = EASResource.getString((String)RESOURCE_PATH, (String)"CASPeriodEndInQueue");
            MsgBox.showWarning((String)message);
            this.destroyWindow();
            return false;
        }
        catch (Exception e) {
            this.handUIException(e);
            return false;
        }
    }

    private JobConfig creteJobCfg() {
        StringBuffer sb = new StringBuffer(this.periodInfo.toString());
        sb.append(" \u3010").append(this.company.getName()).append("(").append(this.company.getNumber()).append(")\u3011");
        sb.append(EASResource.getString((String)RESOURCE_PATH, (String)"CASPeriodEnd"));
        String title = sb.toString();
        JobConfig jobCfg = new JobConfig();
        jobCfg.setTitle(title);
        jobCfg.setSyn(true);
        jobCfg.setTaskType("FI_CAS_001" + this.company.getNumber());
        jobCfg.setDescription(title);
        jobCfg.setNeedCheckTaskType(true);
        jobCfg.setNumber("FI_CAS_001");
        return jobCfg;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected boolean checkBeforeWindowClosing() {
        MutexUtils.releaseMutex((Uuid)this.mutexUuid);
        return super.checkBeforeWindowClosing();
    }

    class BalanceModifyListener
    extends AbstractAction {
        String s;

        BalanceModifyListener(String sc) {
            this.s = sc;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (FinalCheckOutUI.ACTIONKEY_MODIFY.equals(this.s)) {
                FinalCheckOutUI.this.modifyBalance();
            }
        }
    }
}

