/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.BookNotifyFacadeFactory;
import com.kingdee.eas.fi.cas.FundsMoveBillBookNotifyBuilder;
import com.kingdee.eas.fi.cas.FundsMoveBillStateEnum;
import com.kingdee.eas.fi.cas.IBookNotifyFacade;
import com.kingdee.eas.fi.cas.PaymentBillBookNotifyBuilder;
import com.kingdee.eas.fi.cas.ReceivingBillBookNotifyBuilder;
import com.kingdee.eas.fi.cas.SettlementStatusEnum;
import com.kingdee.eas.fi.cas.client.AbstractFixRecPayJournalListUI;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMIsqlFacadeFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import org.apache.log4j.Logger;

public class FixRecPayJournalListUI
extends AbstractFixRecPayJournalListUI {
    private static final Logger logger = CoreUIObject.getLogger(FixRecPayJournalListUI.class);
    private static final String yes = EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"Yes");
    private static final String no = EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"No");

    public void onLoad() throws Exception {
        super.onLoad();
        this.execQuery();
        this.tblMain.setVisible(false);
        this.actionFix.setEnabled(true);
        this.actionQuery.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionFix.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_maintenance"));
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    protected void execQuery() {
        try {
            IRowSet rs = this.getRowSet();
            this.fillTable(rs);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    private void fillTable(IRowSet rs) throws SQLException {
        this.kDTable1.removeRows();
        while (rs.next()) {
            IRow row = this.kDTable1.addRow();
            row.setUserObject((Object)rs.getString("ID"));
            row.getCell("id").setValue((Object)rs.getString("ID"));
            row.getCell("company").setValue((Object)rs.getString("COMPANYNAME"));
            row.getCell("number").setValue((Object)rs.getString("NUMBER"));
            row.getCell("type").setValue((Object)rs.getString("TYPE"));
            row.getCell("bizDate").setValue((Object)rs.getString("BIZDATE"));
            row.getCell("sourceType").setValue((Object)rs.getString("SOURCETYPE"));
            if (rs.getString("TYPE").equals(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"350_FixRecPayJournalListUI"))) {
                row.getCell("billStatus").setValue((Object)FundsMoveBillStateEnum.getEnum(rs.getInt("BILLSTATUS")).getAlias());
            } else {
                row.getCell("billStatus").setValue((Object)BillStatusEnum.getEnum(rs.getInt("BILLSTATUS")).getAlias());
            }
            if (rs.getString("SETTLEMENTSTATUS") != null) {
                row.getCell("settlementStatus").setValue((Object)SettlementStatusEnum.getEnum(rs.getInt("SETTLEMENTSTATUS")).getAlias());
            }
            row.getCell("isVouchered").setValue((Object)rs.getBoolean("FIVOUCHERED"));
            row.getCell("currency.id").setValue((Object)rs.getString("CURRENCYID"));
            row.getCell("currency.name").setValue((Object)rs.getString("CURRENCYNAME"));
            row.getCell("bizType").setValue((Object)rs.getString("BIZTYPENAME"));
            row.getCell("exchangeRate").setValue((Object)rs.getString("EXCHANGERATE"));
            row.getCell("actLocAmt").setValue((Object)rs.getString("ACTPAYLOCAMT"));
            row.getCell("actAmt").setValue((Object)rs.getString("ACTPAYAMT"));
            CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            String currencyId = (String)row.getCell("currency.id").getValue();
            if (currencyId != null) {
                FMClientHelper.setNumberFormat((IRow)row, (String)"actAmt", (String)currencyId);
                FMClientHelper.setNumberFormat((IRow)row, (String)"exchangeRate", (String)currencyId);
            }
            if (companyInfo == null || companyInfo.getBaseCurrency() == null) continue;
            String baseCurrency = companyInfo.getBaseCurrency().getId().toString();
            FMClientHelper.setNumberFormat((IRow)row, (String)"actLocAmt", (String)baseCurrency);
        }
    }

    public IRowSet getRowSet() throws BOSException {
        StringBuffer sb = new StringBuffer();
        String loc = LocaleUtils.getLocaleString((Locale)SysContext.getSysContext().getLocale());
        sb.append("SELECT ");
        sb.append("ISNULL(PAYMENTBILL.FActualPayAmount,0) AS ACTPAYAMT, ");
        sb.append("ISNULL(PAYMENTBILL.FActPayLocAmt,0) AS ACTPAYLOCAMT, ");
        sb.append("PAYMENTBILL.FSourceType AS SOURCETYPE, ");
        sb.append("PAYMENTBILL.FExchangeRate AS EXCHANGERATE, ");
        sb.append("PAYMENTBILL.FFiVouchered AS FIVOUCHERED, ");
        sb.append("PAYMENTBILL.FBillStatus AS BILLSTATUS, ");
        sb.append("PAYMENTBILL.FSettlementStatus AS SETTLEMENTSTATUS, ");
        sb.append("PAYMENTBILL.FNumber AS NUMBER, ");
        sb.append("PAYMENTBILL.FBizDate AS BIZDATE, ");
        sb.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"351_FixRecPayJournalListUI"));
        sb.append("PAYMENTBILL.FID AS ID, ");
        sb.append("CURRENCY.FName_").append(loc).append("  AS CURRENCYNAME, ");
        sb.append("PAYMENTBILL.FCurrencyID AS CURRENCYID, ");
        sb.append("COMPANY.FName_").append(loc).append("  AS COMPANYNAME, ");
        sb.append("BIZTYPE.FName_").append(loc).append("  AS BIZTYPENAME ");
        sb.append("FROM T_CAS_PaymentBill AS PAYMENTBILL ");
        sb.append("LEFT OUTER JOIN T_BD_Currency AS CURRENCY ");
        sb.append("ON PAYMENTBILL.FCurrencyID = CURRENCY.FID ");
        sb.append("LEFT OUTER JOIN T_FS_SettBizType AS BIZTYPE ");
        sb.append("ON PAYMENTBILL.FBizTypeID = BIZTYPE.FID ");
        sb.append("LEFT OUTER JOIN T_ORG_Company AS COMPANY ");
        sb.append("ON PAYMENTBILL.FCompanyID = COMPANY.FID ");
        sb.append("UNION SELECT ISNULL(RECEIVINGBILL.FActRecAmt,0) AS ACTPAYAMT,");
        sb.append("ISNULL(RECEIVINGBILL.FActRecLocAmt,0) AS ACTPAYLOCAMT, ");
        sb.append("RECEIVINGBILL.FSourceType AS SOURCETYPE,");
        sb.append("RECEIVINGBILL.FExchangeRate AS EXCHANGERATE, ");
        sb.append("RECEIVINGBILL.FFiVouchered AS FIVOUCHERED, ");
        sb.append("RECEIVINGBILL.FBillStatus AS BILLSTATUS, ");
        sb.append("RECEIVINGBILL.FSettlementStatus AS SETTLEMENTSTATUS, ");
        sb.append("RECEIVINGBILL.FNumber AS NUMBER, ");
        sb.append("RECEIVINGBILL.FBizDate AS BIZDATE, ");
        sb.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"352_FixRecPayJournalListUI"));
        sb.append("RECEIVINGBILL.FID AS ID, ");
        sb.append("CURRENCY.FName_").append(loc).append("  AS CURRENCYNAME, ");
        sb.append("RECEIVINGBILL.FCurrencyID AS CURRENCYID, ");
        sb.append("COMPANY.FName_").append(loc).append("  AS COMPANYNAME, ");
        sb.append("BIZTYPE.FName_").append(loc).append("  AS BIZTYPENAME ");
        sb.append("FROM T_CAS_ReceivingBill AS RECEIVINGBILL ");
        sb.append("LEFT OUTER JOIN T_ORG_Company AS COMPANY ");
        sb.append("ON RECEIVINGBILL.FCompanyID = COMPANY.FID ");
        sb.append("LEFT OUTER JOIN T_BD_Currency AS CURRENCY ");
        sb.append("ON RECEIVINGBILL.FCurrencyID = CURRENCY.FID ");
        sb.append("LEFT OUTER JOIN T_FS_SettBizType AS BIZTYPE ");
        sb.append("ON RECEIVINGBILL.FBizTypeID = BIZTYPE.FID ");
        sb.append("UNION SELECT ISNULL(FundsMoveBill.FSellAmount,0) AS ACTPAYAMT, ");
        sb.append("ISNULL(FundsMoveBill.FMoveOutLocAmt,0) AS ACTPAYLOCAMT, ");
        sb.append("null AS SOURCETYPE, ");
        sb.append("FundsMoveBill.FMoveOutLocRate AS EXCHANGERATE, ");
        sb.append("FundsMoveBill.FFIVouchered AS FIVOUCHERED, ");
        sb.append("FundsMoveBill.FBillState AS BILLSTATUS, ");
        sb.append("null AS SETTLEMENTSTATUS, ");
        sb.append("FundsMoveBill.FNumber AS NUMBER, ");
        sb.append("FundsMoveBill.FBizDate AS BIZDATE, ");
        sb.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"353_FixRecPayJournalListUI"));
        sb.append("FundsMoveBill.FID AS ID, ");
        sb.append("CURRENCY.FName_").append(loc).append("  AS CURRENCYNAME, ");
        sb.append("FundsMoveBill.FSellCurrencyID AS CURRENCYID, ");
        sb.append("COMPANY.FName_").append(loc).append("  AS COMPANYNAME, ");
        sb.append("null AS BIZTYPENAME ");
        sb.append("FROM T_cas_FundsMoveBill FundsMoveBill ");
        sb.append("LEFT OUTER JOIN T_BD_Currency AS CURRENCY ");
        sb.append("ON FundsMoveBill.FSellCurrencyID = CURRENCY.FID ");
        sb.append("LEFT OUTER JOIN T_ORG_Company AS COMPANY ");
        sb.append("ON FundsMoveBill.FCompanyID = COMPANY.FID");
        sb.append(" WHERE (BILLSTATUS = 14 OR BILLSTATUS = 15 ");
        sb.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"354_FixRecPayJournalListUI"));
        sb.append("AND NOT EXISTS (SELECT FBILLID FROM T_CAS_JOURNAL JOURNAL WHERE ID = JOURNAL.FBILLID) ");
        sb.append("ORDER BY TYPE ASC,COMPANYNAME ASC,BIZDATE ASC ");
        try {
            return FMIsqlFacadeFactory.getRemoteInstance().executeQuery(sb.toString(), null);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
            return null;
        }
    }

    @Override
    public void actionFix_actionPerformed(ActionEvent e) throws Exception {
        HashSet idRecSet = new HashSet();
        HashSet idPaySet = new HashSet();
        HashSet fmPaySet = new HashSet();
        IBookNotifyFacade facade = BookNotifyFacadeFactory.getRemoteInstance();
        ArrayList arrayList = this.kDTable1.getSelectManager().getBlocks();
        for (int i = 0; i < arrayList.size(); ++i) {
            IBlock selectBlock = KDTSelectBlock.change((KDTable)this.kDTable1, (IBlock)this.kDTable1.getSelectManager().get(i));
            for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                IRow row = this.kDTable1.getRow(j);
                String id = (String)row.getCell("id").getValue();
                String number = (String)row.getCell("number").getValue();
                String type = (String)row.getCell("type").getValue();
                HashMap<String, String> billMap = new HashMap<String, String>();
                billMap.put("id", id);
                billMap.put("number", number);
                billMap.put("type", type);
                if (type.equals(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"295_CasPaymentBillListUI"))) {
                    idPaySet.add(billMap);
                    continue;
                }
                if (type.equals(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"330_CasReceivingBillListUI"))) {
                    idRecSet.add(billMap);
                    continue;
                }
                fmPaySet.add(billMap);
            }
        }
        facade.clientBook(PaymentBillBookNotifyBuilder.class.getName(), idPaySet);
        facade.clientBook(ReceivingBillBookNotifyBuilder.class.getName(), idRecSet);
        facade.clientBook(FundsMoveBillBookNotifyBuilder.class.getName(), fmPaySet);
        this.execQuery();
    }
}

