/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.basedata.assistant.client.CashFlowItemF7Selector;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.cas.FlowItemPropertyEnum;
import com.kingdee.eas.fi.cas.FlowItemStateEnum;
import com.kingdee.eas.fi.cas.FundFlowDirection;
import com.kingdee.eas.fi.cas.FundFlowException;
import com.kingdee.eas.fi.cas.FundFlowItemFactory;
import com.kingdee.eas.fi.cas.FundFlowItemInfo;
import com.kingdee.eas.fi.cas.client.AbstractFundFlowItemEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.util.enums.EnumUtils;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class FundFlowItemEditUI
extends AbstractFundFlowItemEditUI {
    private static final Logger logger = CoreUIObject.getLogger(FundFlowItemEditUI.class);
    private boolean isCancelCommit = false;

    public FundFlowItemEditUI() throws Exception {
        this.comboProperty.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.fi.cas.FlowItemPropertyEnum").toArray());
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setRemarks(this.txtRemarks.getText().toString());
    }

    protected void updateButtonStatus() {
        super.updateButtonStatus();
        this.chkMenuItemSubmitAndAddNew.setSelected(true);
        this.chkMenuItemSubmitAndAddNew.setVisible(true);
    }

    protected IObjectValue createNewData() {
        FundFlowItemInfo info = new FundFlowItemInfo();
        if (this.getUIContext().get("ParentNode") != null && this.getUIContext().get("ParentNode") instanceof FundFlowItemInfo) {
            FundFlowItemInfo parentInfo = (FundFlowItemInfo)this.getUIContext().get("ParentNode");
            info.setParent(parentInfo);
            info.setDirection(parentInfo.getDirection());
            info.setProperty(parentInfo.getProperty());
        } else {
            info.setParent(null);
            info.setDirection(FundFlowDirection.IN_OUT);
            info.setProperty(FlowItemPropertyEnum.BUSSINESS);
        }
        info.setState(FlowItemStateEnum.ENABLE);
        info.setIsRptCalc(true);
        info.setIsRptEliminate(true);
        return info;
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.txtRemarks.setText(this.editData.getRemarks());
        if (this.getOprtState().equals(OprtState.EDIT) && this.editData.isIsSystem()) {
            this.txtNumber.setEnabled(false);
            ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
            try {
                boolean isReference = FundFlowItemFactory.getRemoteInstance().referenceVerfiy((IObjectPK)pk);
                if (isReference) {
                    this.comboDirection.setEnabled(false);
                    this.comboProperty.setEnabled(false);
                }
            }
            catch (Exception e) {
                this.handUIExceptionAndAbort(e);
            }
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("*");
        return sic;
    }

    protected KDTable getDetailTable() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FundFlowItemFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.txtRemarks.setMaxLength(200);
        this.txtNumber.setMaxLength(40);
        this.initCashFlowItem();
    }

    private void initCashFlowItem() {
        KDBizPromptBox cashFlowF7 = new KDBizPromptBox();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        cashFlowF7.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CashFlowQuery");
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)0));
        filter.getFilterItems().add(new FilterItemInfo("isProfit", (Object)false));
        filter.getFilterItems().add(new FilterItemInfo("isFreeze", (Object)false));
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)true));
        filter.getFilterItems().add(new FilterItemInfo("level", (Object)3, CompareType.GREATER_EQUALS));
        ev.setFilter(filter);
        cashFlowF7.setEntityViewInfo(ev);
        CashFlowItemF7Selector selector = new CashFlowItemF7Selector((IUIObject)this, cashFlowF7, "com.kingdee.eas.basedata.assistant.client.F7CashFlowItemMainUI");
        selector.setMulti(false);
        this.prmtPrimaryItem.setSelector((KDPromptSelector)selector);
        KDBizPromptBox sCashFlowF7 = new KDBizPromptBox();
        sCashFlowF7.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CashFlowQuery");
        EntityViewInfo sev = new EntityViewInfo();
        FilterInfo sfilter = new FilterInfo();
        sfilter.getFilterItems().add(new FilterItemInfo("type", (Object)1));
        sfilter.getFilterItems().add(new FilterItemInfo("isProfit", (Object)false));
        sfilter.getFilterItems().add(new FilterItemInfo("isFreeze", (Object)false));
        sfilter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)true));
        sfilter.getFilterItems().add(new FilterItemInfo("level", (Object)3, CompareType.GREATER_EQUALS));
        sev.setFilter(sfilter);
        sCashFlowF7.setEntityViewInfo(sev);
        CashFlowItemF7Selector sSelector = new CashFlowItemF7Selector((IUIObject)this, sCashFlowF7, "com.kingdee.eas.basedata.assistant.client.F7CashFlowItemMainUI");
        sSelector.setMulti(false);
        this.prmtSupplementaryItem.setSelector((KDPromptSelector)sSelector);
    }

    protected void prmtPrimaryItem_willCommit(CommitEvent e) {
        if (this.isCancelCommit) {
            e.setCanceled(true);
        }
        try {
            int type = 0;
            this.setCashFlowEvi(this.prmtPrimaryItem, type);
        }
        catch (Exception e1) {
            logger.error((Object)e1);
            this.handUIException(e1);
        }
    }

    public boolean destroyWindow() {
        this.isCancelCommit = true;
        boolean flag = super.destroyWindow();
        this.isCancelCommit = false;
        return flag;
    }

    @Override
    protected void prmtSupplementaryItem_willCommit(CommitEvent e) {
        if (this.isCancelCommit) {
            e.setCanceled(true);
        }
        try {
            int type = 1;
            this.setCashFlowEvi(this.prmtSupplementaryItem, type);
        }
        catch (Exception e1) {
            logger.error((Object)e1);
            this.handUIException(e1);
        }
    }

    private void setCashFlowEvi(KDBizPromptBox promptBox, int type) throws EASBizException, BOSException, ParserException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)type));
        filter.getFilterItems().add(new FilterItemInfo("isProfit", (Object)false));
        filter.getFilterItems().add(new FilterItemInfo("isProfit", (Object)false));
        filter.getFilterItems().add(new FilterItemInfo("isFreeze", (Object)false));
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)true));
        filter.getFilterItems().add(new FilterItemInfo("level", (Object)3, CompareType.GREATER_EQUALS));
        ev.setFilter(filter);
        promptBox.setEntityViewInfo(ev);
        promptBox.getQueryAgent().resetRuntimeEntityView();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        ClientVerifyHelper.verifyUIControlEmpty((CoreUI)this);
        if (this.prmtParent.getValue() != null) {
            FundFlowItemInfo parent = (FundFlowItemInfo)this.prmtParent.getValue();
            if (parent.getDirection().equals((Object)FundFlowDirection.IN) && !parent.getDirection().equals(this.comboDirection.getSelectedItem())) {
                throw new FundFlowException(FundFlowException.DIRECTIONIN);
            }
            if (parent.getDirection().equals((Object)FundFlowDirection.OUT) && !parent.getDirection().equals(this.comboDirection.getSelectedItem())) {
                throw new FundFlowException(FundFlowException.DIRECTIONOUT);
            }
        }
    }

    protected boolean isContinueAddNew() {
        return false;
    }
}

