/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.AccountMgrStrategyInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCostCenterF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.FundsMoveBillFactory;
import com.kingdee.eas.fi.cas.FundsMoveBillInfo;
import com.kingdee.eas.fi.cas.FundsMoveBillStateEnum;
import com.kingdee.eas.fi.cas.FundsMoveException;
import com.kingdee.eas.fi.cas.FundsMoveTypeFactory;
import com.kingdee.eas.fi.cas.FundsMoveTypeInfo;
import com.kingdee.eas.fi.cas.IFundsMoveBill;
import com.kingdee.eas.fi.cas.RecPayAcctBankStratageCtrl;
import com.kingdee.eas.fi.cas.RecPayHelper;
import com.kingdee.eas.fi.cas.client.AbstractFundsMoveBillEditUI;
import com.kingdee.eas.fi.cas.client.CasPeriodHelper;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fi.cas.client.FundsMoveBillHandler;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMBgItemProp;
import com.kingdee.eas.fm.common.FMBudgetFacadeFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.util.CommonDataProvider;
import com.kingdee.eas.ma.budget.FpCashDirectionEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import javax.swing.KeyStroke;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class FundsMoveBillEditUI
extends AbstractFundsMoveBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(FundsMoveBillEditUI.class);
    private static final String FundsMoveBillResource = "com.kingdee.eas.fi.cas.FundsMoveBillResource";
    private IContextHelper context = ContextHelperFactory.getRemoteInstance();
    private CompanyOrgUnitInfo company = this.context.getCurrentCompany();
    boolean isIndirectExRateIn = false;
    private CasRecPayHandler handler = new CasRecPayHandler();
    boolean isIndirectExRateOut = false;
    boolean isIndirectExRateFee = false;
    int basePrecsion = FMClientHelper.getPrecOfCurrency((BOSUuid)this.currentCompany.getBaseCurrency().getId());
    IObjectPK pk1;

    @Override
    public void loadFields() {
        Map liseteners = null;
        try {
            liseteners = FMClientHelper.removeCompListeners((CoreUI)this);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            logger.error((Object)e);
        }
        super.loadFields();
        FMClientHelper.loadFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        FMClientHelper.loadFieldsBgItem((KDBizPromptBox)this.prmtOppBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[1]);
        FMClientHelper.loadFieldsBgItem((KDBizPromptBox)this.prmtFeeBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[2]);
        FMClientHelper.loadFieldsBgItem((KDBizPromptBox)this.prmtIncomeBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[3]);
        this.prmtMoveInAcctView.setValue((Object)this.editData.getMoveInAccountView());
        this.prmtMoveInBankAcct.setValue((Object)this.editData.getMoveInBankAccount());
        UIUtil.setSelectObject((KDComboBox)this.cmbMoveInCurrency, (Object)this.editData.getMoveInCurrency());
        UIUtil.setSelectObject((KDComboBox)this.cmbMoveOutCurrency, (Object)this.editData.getMoveOutCurrency());
        UIUtil.setSelectObject((KDComboBox)this.cmbFeeCurrency, (Object)this.editData.getFeeCurrency());
        this.setCostCenterF7();
        try {
            this.setCompPrecision();
            FMClientHelper.addCompListeners((CoreUI)this, (Map)liseteners);
            Map map = this.getUIContext();
            String actionCopy = (String)map.get("COPY");
            if (actionCopy != null && actionCopy.equals("COPY")) {
                this.cmbMoveOutCurrency_itemStateChanged(null);
                this.txtExchangeRate_dataChanged(null);
                this.cmbMoveInCurrency_itemStateChanged(null);
                this.cmbFeeCurrency_itemStateChanged(null);
                map.remove("COPY");
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            logger.error((Object)e);
        }
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.actionTDPrint.setEnabled(false);
            this.actionTDPrintPreview.setEnabled(false);
        } else {
            this.actionTDPrint.setEnabled(true);
            this.actionTDPrintPreview.setEnabled(true);
        }
        this.resetTxtIncomeValue();
    }

    protected void setCostCenterF7() {
        NewCostCenterF7 costCenterF7 = new NewCostCenterF7((IUIObject)this);
        costCenterF7.setNeedAddOrgRange(false);
        costCenterF7.setIsCUFilter(true);
        costCenterF7.setMultiSelect(false);
        costCenterF7.setContainSealUp(false);
        costCenterF7.setCurrentCUID(this.currentCompany.getCU().getId().toString());
        try {
            String param = this.getSysParam("CS082");
            if (null != param && param.equals("0")) {
                costCenterF7.showCheckBoxOfShowingAllOUs();
                costCenterF7.setIsCUFilter(false);
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        this.prmtCostCenter.setSelector((KDPromptSelector)costCenterF7);
    }

    public String getSysParam(String number) throws EASBizException, BOSException {
        IParamControl iParamControl = ParamControlFactory.getRemoteInstance();
        String param = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentFIUnit().getId().toString()), number);
        if (null != param) {
            return param;
        }
        return "0";
    }

    private void setCompPrecision() throws Exception {
        int precsion;
        int exPrecsion;
        FundsMoveBillInfo info = (FundsMoveBillInfo)this.getDataObject();
        if (info.getMoveInCurrency() != null) {
            int curPrecsion = FMClientHelper.getPrecOfCurrency((BOSUuid)info.getMoveInCurrency().getId());
            this.txtMoveInAmount.setPrecision(curPrecsion);
            this.txtMoveInLocAmt.setPrecision(this.basePrecsion);
            this.txtMoveInBalance.setPrecision(curPrecsion);
            exPrecsion = FMClientHelper.getPrecOfExRate((String)this.currentCompany.getId().toString(), (String)info.getMoveInCurrency().getId().toString(), (String)this.baseCurrency.getId().toString(), (Date)new Date());
            this.txtMoveInLocRate.setPrecision(exPrecsion);
        }
        if (info.getMoveOutCurrency() != null) {
            precsion = FMClientHelper.getPrecOfCurrency((BOSUuid)info.getMoveOutCurrency().getId());
            this.txtMoveOutAmount.setPrecision(precsion);
            this.txtMoveOutLocAmt.setPrecision(this.basePrecsion);
            this.txtMoveOutBalance.setPrecision(precsion);
            exPrecsion = FMClientHelper.getPrecOfExRate((String)this.currentCompany.getId().toString(), (String)info.getMoveOutCurrency().getId().toString(), (String)this.baseCurrency.getId().toString(), (Date)new Date());
            this.txtMoveOutLocRate.setPrecision(exPrecsion);
        }
        if (info.getFeeCurrency() != null) {
            precsion = FMClientHelper.getPrecOfCurrency((BOSUuid)info.getFeeCurrency().getId());
            this.txtIncome.setPrecision(this.basePrecsion);
            this.txtFeeAmount.setPrecision(precsion);
            this.txtFeeLocAmt.setPrecision(this.basePrecsion);
            exPrecsion = FMClientHelper.getPrecOfExRate((String)this.currentCompany.getId().toString(), (String)info.getFeeCurrency().getId().toString(), (String)this.baseCurrency.getId().toString(), (Date)new Date());
            this.txtFeeLocRate.setPrecision(exPrecsion);
        }
        if (info.getMoveInCurrency() != null && info.getMoveOutCurrency() != null) {
            int exPrecsion2 = FMClientHelper.getPrecOfExRate((String)this.currentCompany.getId().toString(), (String)info.getMoveOutCurrency().getId().toString(), (String)info.getMoveInCurrency().getId().toString(), (Date)new Date());
            this.txtExchangeRate.setPrecision(exPrecsion2);
        }
    }

    @Override
    public void storeFields() {
        FMClientHelper.storeFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        FMClientHelper.storeFieldsBgItem((KDBizPromptBox)this.prmtOppBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[1]);
        FMClientHelper.storeFieldsBgItem((KDBizPromptBox)this.prmtFeeBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[2]);
        FMClientHelper.storeFieldsBgItem((KDBizPromptBox)this.prmtIncomeBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[3]);
        super.storeFields();
        this.editData.setBaseCurrency(this.baseCurrency);
    }

    @Override
    public void actionViewBgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        FundsMoveBillInfo info = this.editData;
        if (info.getCompany().getBaseCurrency() == null || EmptyUtil.isEmpty((String)info.getCompany().getBaseCurrency().getNumber())) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("baseCurrency.*");
            ObjectUuidPK pk = new ObjectUuidPK(info.getCompany().getId());
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)pk, sic);
            info.setCompany(company);
        }
        String boName = "com.kingdee.eas.fi.cas.app.FundsMoveBill";
        FMClientHelper.viewBgBalance((Component)((Object)this), (String)boName, null, (IObjectValue)info);
    }

    public void onLoad() throws Exception {
        if (!"FINDVIEW".equalsIgnoreCase(this.getOprtState())) {
            ClientUtils.checkCompany((Component)((Object)this), this.currentCompany);
        }
        if (!"FINDVIEW".equalsIgnoreCase(this.getOprtState()) && !OprtState.VIEW.equalsIgnoreCase(this.getOprtState())) {
            FMClientHelper.checkIsAdjustPeriod((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompany);
        }
        FMClientHelper.setCompontDisplayFormat((CoreUIObject)this, (CurrencyInfo)this.getSelectCurrency());
        this.prmtAdminOrgUnit.setQueryInfo("com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery");
        this.prmtAdminOrgUnit.setVisible(true);
        this.prmtAdminOrgUnit.setEditable(true);
        this.prmtAdminOrgUnit.setDisplayFormat("$name$");
        this.prmtAdminOrgUnit.setEditFormat("$number$");
        this.prmtAdminOrgUnit.setCommitFormat("$number$");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("isFreeze", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("isSealUp", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
        fic.add(new FilterItemInfo("isCostOrgUnit", (Object)Constants.TRUE));
        view.setFilter(filter);
        this.prmtAdminOrgUnit.setEntityViewInfo(view);
        super.onLoad();
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        this.menuItemAudit.setAccelerator(KeyStroke.getKeyStroke("ctrl alt A"));
        this.menuItemAntiAudit.setAccelerator(KeyStroke.getKeyStroke("alt shift A"));
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        HashSet<String> idSet = new HashSet<String>();
        if (this.editData.getId() == null) {
            return;
        }
        idSet.add(this.editData.getId().toString());
        if (idSet == null || idSet.size() == 0) {
            return;
        }
        CommonDataProvider data = new CommonDataProvider(idSet, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.cas.FundsMoveBillTDQuery"));
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            return;
        }
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(this.editData.getId().toString());
        if (idSet == null || idSet.size() == 0 || this.getTDQueryPK() == null || this.getTDFileName() == null) {
            return;
        }
        CommonDataProvider data = new CommonDataProvider(idSet, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.fi.cas.FundsMoveBillTDQuery");
    }

    protected String getTDFileName() {
        return "/FI/CAS/FUNDSMOVEBILL";
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_dysz"));
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_audit"));
        this.actionAntiAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.actionSettle.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_dengzsetting"));
    }

    protected void initUIProp() throws Exception {
        super.initUIProp();
        FMClientHelper.initComboCurrency((KDComboBox)this.cmbMoveOutCurrency, (boolean)false);
        FMClientHelper.initComboCurrency((KDComboBox)this.cmbMoveInCurrency, (boolean)false);
        FMClientHelper.initComboCurrency((KDComboBox)this.cmbFeeCurrency, (boolean)false);
        SpinnerNumberModel count = new SpinnerNumberModel(0, 0, 9999, 1);
        this.spAppendix.setModel((SpinnerModel)count);
        F7SelectorFactory.initPerson((IUIObject)this, (KDBizPromptBox)this.prmtAuditor);
        F7SelectorFactory.initPerson((IUIObject)this, (KDBizPromptBox)this.prmtHandler);
        F7SelectorFactory.initAccountBank((IUIObject)this, (KDBizPromptBox)this.prmtMoveInBankAcct);
        this.prmtMoveInBankAcct.setSelectorCollection(this.getAccountBankSIC());
        F7SelectorFactory.initAccountBank((IUIObject)this, (KDBizPromptBox)this.prmtMoveOutBankAcct);
        this.prmtMoveOutBankAcct.setSelectorCollection(this.getAccountBankSIC());
        F7SelectorFactory.initAccountBank((IUIObject)this, (KDBizPromptBox)this.prmtFeeBankAcct);
        this.prmtFeeBankAcct.setSelectorCollection(this.getAccountBankSIC());
        FMClientHelper.initBgItemF7((KDBizPromptBox)this.prmtBgItem, (FpCashDirectionEnum[])new FpCashDirectionEnum[]{FpCashDirectionEnum.output, FpCashDirectionEnum.other}, (boolean)true, (boolean)true);
        FMClientHelper.initBgItemF7((KDBizPromptBox)this.prmtOppBgItem, (FpCashDirectionEnum[])new FpCashDirectionEnum[]{FpCashDirectionEnum.input, FpCashDirectionEnum.other}, (boolean)true, (boolean)true);
        FMClientHelper.initBgItemF7((KDBizPromptBox)this.prmtFeeBgItem, (FpCashDirectionEnum[])new FpCashDirectionEnum[]{FpCashDirectionEnum.output, FpCashDirectionEnum.other}, (boolean)true, (boolean)true);
        FMClientHelper.initBgItemF7((KDBizPromptBox)this.prmtIncomeBgItem, (FpCashDirectionEnum[])new FpCashDirectionEnum[]{FpCashDirectionEnum.output, FpCashDirectionEnum.other}, (boolean)true, (boolean)true);
        this.txtMoveInBalance.setRemoveingZeroInDispaly(false);
        this.txtMoveOutBalance.setRemoveingZeroInDispaly(false);
        this.txtDigest.setMaxLength(255);
        this.addBalanceListener();
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    protected void initPropEvi() throws Exception {
        super.initPropEvi();
    }

    protected void initDataStatus() {
        AccountViewInfo acctView;
        AccountBankInfo acctBank;
        super.initDataStatus();
        FundsMoveBillInfo info = (FundsMoveBillInfo)this.getDataObject();
        FMClientHelper.initNumber((CoreBaseInfo)info, (KDTextField)this.txtNumber, (String)info.getCompany().getId().toString());
        if (info.getMoveOutBankAccount() != null && info.getMoveOutAccountView() != null) {
            this.prmtMoveOutAcctView.setEnabled(false);
        } else {
            this.prmtMoveOutAcctView.setEnabled(true);
        }
        if (info.getMoveInBankAccount() != null && info.getMoveInAccountView() != null) {
            this.prmtMoveInAcctView.setEnabled(false);
        } else {
            this.prmtMoveInAcctView.setEnabled(true);
        }
        if (info.getFeeBankAccount() != null && info.getPayoutAcctView() != null) {
            this.prmtPayOutAcctView.setEnabled(false);
        } else {
            this.prmtPayOutAcctView.setEnabled(true);
        }
        FundsMoveTypeInfo moveType = info.getMoveType();
        if (moveType != null && moveType.isCashOutBank()) {
            this.prmtMoveInBankAcct.setValue(null);
            this.prmtMoveInBankAcct.setEnabled(false);
        } else {
            this.prmtMoveInBankAcct.setEnabled(true);
        }
        if (moveType != null && moveType.isCashInBank()) {
            this.prmtMoveOutBankAcct.setValue(null);
            this.prmtMoveOutBankAcct.setEnabled(false);
        } else {
            this.prmtMoveOutBankAcct.setEnabled(true);
        }
        if (this.getOprtState().equals(OprtState.ADDNEW) || this.getOprtState().equals(OprtState.EDIT)) {
            this.txtMoveOutLocRate.setEnabled(!info.getMoveOutCurrency().getId().equals((Object)this.baseCurrency.getId()));
            this.txtMoveInLocRate.setEnabled(!info.getMoveInCurrency().getId().equals((Object)this.baseCurrency.getId()));
            this.txtFeeLocRate.setEnabled(!info.getFeeCurrency().getId().equals((Object)this.baseCurrency.getId()));
            this.txtExchangeRate.setEnabled(!info.getMoveOutCurrency().getId().equals((Object)info.getMoveInCurrency().getId()));
        }
        if (info.getBillState() != null && info.getBillState() != FundsMoveBillStateEnum.saved) {
            this.actionSave.setEnabled(false);
        }
        boolean billStateCtolEdit = info.getBillState() != null && (info.getBillState() == FundsMoveBillStateEnum.audited || info.getBillState() == FundsMoveBillStateEnum.settled);
        boolean isAddNew = OprtState.ADDNEW.equals(this.getOprtState());
        if (billStateCtolEdit || isAddNew) {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        } else {
            this.actionEdit.setEnabled(true);
            this.actionRemove.setEnabled(true);
        }
        if (isAddNew) {
            this.actionAudit.setVisible(false);
            this.actionAntiAudit.setVisible(false);
            this.actionSettle.setVisible(false);
            this.actionAntiSettle.setVisible(false);
            this.actionVoucher.setVisible(false);
            this.actionDelVoucher.setVisible(false);
        }
        if (info.getId() != null) {
            ObjectUuidPK pk = new ObjectUuidPK(info.getId());
            FundsMoveBillInfo newInfo = null;
            try {
                newInfo = FundsMoveBillFactory.getRemoteInstance().getFundsMoveBillInfo((IObjectPK)pk);
            }
            catch (Exception e) {
                newInfo = info;
            }
            boolean isSaveState = newInfo.getBillState().equals((Object)FundsMoveBillStateEnum.saved);
            boolean isSubmitState = newInfo.getBillState().equals((Object)FundsMoveBillStateEnum.submited);
            boolean isAuditState = newInfo.getBillState().equals((Object)FundsMoveBillStateEnum.audited);
            boolean isSettleState = newInfo.getBillState().equals((Object)FundsMoveBillStateEnum.settled);
            boolean isVoucher = newInfo.isFiVouchered();
            if (this.getOprtState().equals(OprtState.VIEW) || this.getOprtState().equals(OprtState.EDIT)) {
                if (isSaveState) {
                    this.actionAudit.setVisible(false);
                    this.actionAntiAudit.setVisible(false);
                    this.actionSettle.setVisible(false);
                    this.actionAntiSettle.setVisible(false);
                    this.actionVoucher.setVisible(false);
                    this.actionDelVoucher.setVisible(false);
                }
                if (isSubmitState) {
                    this.actionAudit.setVisible(true);
                    this.actionAntiAudit.setVisible(false);
                    this.actionSettle.setVisible(false);
                    this.actionAntiSettle.setVisible(false);
                    this.actionVoucher.setVisible(false);
                    this.actionDelVoucher.setVisible(false);
                }
                if (isAuditState && !isSettleState && !isVoucher) {
                    this.actionAudit.setVisible(false);
                    this.actionAntiAudit.setVisible(true);
                    this.actionSettle.setVisible(true);
                    this.actionAntiSettle.setVisible(false);
                    this.actionVoucher.setVisible(true);
                    this.actionDelVoucher.setVisible(false);
                }
                if (isAuditState && !isSettleState && isVoucher) {
                    this.actionAudit.setVisible(false);
                    this.actionAntiAudit.setVisible(false);
                    this.actionSettle.setVisible(true);
                    this.actionAntiSettle.setVisible(false);
                    this.actionVoucher.setVisible(false);
                    this.actionDelVoucher.setVisible(true);
                }
                if (isSettleState && !isVoucher) {
                    this.actionAudit.setVisible(false);
                    this.actionAntiAudit.setVisible(false);
                    this.actionSettle.setVisible(false);
                    this.actionAntiSettle.setVisible(true);
                    this.actionVoucher.setVisible(true);
                    this.actionDelVoucher.setVisible(false);
                }
                if (isSettleState && isVoucher) {
                    this.actionAudit.setVisible(false);
                    this.actionAntiAudit.setVisible(false);
                    this.actionSettle.setVisible(false);
                    this.actionAntiSettle.setVisible(false);
                    this.actionVoucher.setVisible(false);
                    this.actionDelVoucher.setVisible(true);
                }
            }
        }
        if (this.getOprtState().equals(OprtState.EDIT)) {
            this.actionAudit.setVisible(false);
        }
        if (this.getOprtState().equals(OprtState.EDIT) && this.prmtMoveOutBankAcct.getValue() != null && this.prmtMoveOutAcctView.getValue() != null) {
            acctBank = (AccountBankInfo)this.prmtMoveOutBankAcct.getValue();
            acctView = (AccountViewInfo)this.prmtMoveOutAcctView.getValue();
            CurrencyInfo currency = (CurrencyInfo)this.cmbMoveOutCurrency.getSelectedItem();
            try {
                this.setBalanceValue(this.txtMoveOutBalance, acctView, acctBank, currency);
            }
            catch (Exception e) {
                this.handUIExceptionAndAbort(e);
            }
        }
        if (this.getOprtState().equals(OprtState.EDIT) && this.prmtMoveInBankAcct.getValue() != null && this.prmtMoveInAcctView.getValue() != null) {
            acctBank = (AccountBankInfo)this.prmtMoveInBankAcct.getValue();
            acctView = (AccountViewInfo)this.prmtMoveInAcctView.getValue();
            CurrencyInfo currency = (CurrencyInfo)this.cmbMoveInCurrency.getSelectedItem();
            try {
                this.setBalanceValue(this.txtMoveInBalance, acctView, acctBank, currency);
            }
            catch (Exception e) {
                this.handUIExceptionAndAbort(e);
            }
        }
    }

    protected IObjectValue createNewData() {
        FundsMoveBillInfo info = null;
        Map map = this.getUIContext();
        String actionCopy = (String)map.get("COPY");
        String id = null;
        if (map.get("ID") != null) {
            id = map.get("ID").toString();
        }
        if (actionCopy != null && id != null && actionCopy.equals("COPY")) {
            try {
                FundsMoveBillInfo oldInfo = (FundsMoveBillInfo)this.getValue((IObjectPK)new ObjectUuidPK(id));
                info = oldInfo.copy();
                info.setBizDate(DateHelper.getDayBegin());
                info.setCompany(oldInfo.getCompany());
                info.setCreator(this.userinfo);
                info.setCreateTime(new Timestamp(System.currentTimeMillis()));
            }
            catch (Exception e) {
                logger.error((Object)e);
                this.handUIExceptionAndAbort(e);
            }
        } else {
            info = new FundsMoveBillInfo();
            info.setCompany(this.currentCompany);
            FMClientHelper.initNumber((CoreBaseInfo)info, (KDTextField)this.txtNumber, (String)info.getCompany().getId().toString());
            info.setCreator(this.userinfo);
            info.setMoveOutAmount(Constants.ZERO);
            info.setMoveOutLocRate(Constants.ONE);
            info.setMoveOutLocAmt(Constants.ZERO);
            info.setMoveOutCurrency(this.baseCurrency);
            info.setMoveInAmount(Constants.ZERO);
            info.setMoveInLocRate(Constants.ONE);
            info.setMoveInLocAmt(Constants.ZERO);
            info.setMoveInCurrency(this.baseCurrency);
            info.setExchangeRate(Constants.ONE);
            info.setFeeLocRate(Constants.ONE);
            info.setFeeAmount(Constants.ZERO);
            info.setFeeLocAmt(Constants.ZERO);
            info.setFeeCurrency(this.baseCurrency);
            info.setIncome(Constants.ZERO);
            info.setBizDate(DateTimeUtils.truncateDate((Date)new Date()));
            try {
                FundsMoveTypeInfo transBill = FundsMoveTypeFactory.getRemoteInstance().getFundsMoveTypeInfo((IObjectPK)new ObjectUuidPK("iemfFwEWEADgAAitwKgSCCtZzW0="));
                info.setMoveType(transBill);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return info;
    }

    @Override
    protected void prmtMoveInAcctView_willCommit(CommitEvent e) throws Exception {
        FundsMoveTypeInfo moveType;
        super.prmtMoveInAcctView_willCommit(e);
        if (this.prmtMoveType.getValue() != null && (moveType = (FundsMoveTypeInfo)this.prmtMoveType.getValue()).isCashOutBank()) {
            this.setAccountViewEvi(this.prmtMoveInAcctView, this.cmbMoveInCurrency, true);
            return;
        }
        this.setAccountViewEvi(this.prmtMoveInAcctView, this.cmbMoveInCurrency);
    }

    @Override
    protected void prmtMoveInAcctView_willShow(SelectorEvent e) throws Exception {
        FundsMoveTypeInfo moveType;
        super.prmtMoveInAcctView_willShow(e);
        if (this.prmtMoveType.getValue() != null && (moveType = (FundsMoveTypeInfo)this.prmtMoveType.getValue()).isCashOutBank()) {
            this.setAccountViewEvi(this.prmtMoveInAcctView, this.cmbMoveInCurrency, true);
            return;
        }
        this.setAccountViewEvi(this.prmtMoveInAcctView, this.cmbMoveInCurrency);
    }

    @Override
    protected void prmtMoveOutAcctView_willCommit(CommitEvent e) throws Exception {
        FundsMoveTypeInfo moveType;
        super.prmtMoveOutAcctView_willCommit(e);
        if (this.prmtMoveType.getValue() != null && (moveType = (FundsMoveTypeInfo)this.prmtMoveType.getValue()).isCashInBank()) {
            this.setAccountViewEvi(this.prmtMoveOutAcctView, this.cmbMoveOutCurrency, true);
            return;
        }
        this.setAccountViewEvi(this.prmtMoveOutAcctView, this.cmbMoveOutCurrency);
    }

    @Override
    protected void prmtMoveOutAcctView_willShow(SelectorEvent e) throws Exception {
        FundsMoveTypeInfo moveType;
        super.prmtMoveOutAcctView_willShow(e);
        if (this.prmtMoveType.getValue() != null && (moveType = (FundsMoveTypeInfo)this.prmtMoveType.getValue()).isCashInBank()) {
            this.setAccountViewEvi(this.prmtMoveOutAcctView, this.cmbMoveOutCurrency, true);
            return;
        }
        this.setAccountViewEvi(this.prmtMoveOutAcctView, this.cmbMoveOutCurrency);
    }

    @Override
    protected void prmtIncomeAcctView_willCommit(CommitEvent e) throws Exception {
        super.prmtIncomeAcctView_willCommit(e);
        this.setAccountViewEvi(this.prmtIncomeAcctView, null);
    }

    @Override
    protected void prmtIncomeAcctView_willShow(SelectorEvent e) throws Exception {
        super.prmtIncomeAcctView_willShow(e);
        this.setAccountViewEvi(this.prmtIncomeAcctView, null);
    }

    @Override
    protected void prmtFeeAcctView_willCommit(CommitEvent e) throws Exception {
        super.prmtFeeAcctView_willCommit(e);
        this.setAccountViewEvi(this.prmtFeeAcctView, this.cmbFeeCurrency);
    }

    @Override
    protected void prmtFeeAcctView_willShow(SelectorEvent e) throws Exception {
        super.prmtFeeAcctView_willShow(e);
        this.setAccountViewEvi(this.prmtFeeAcctView, this.cmbFeeCurrency);
    }

    @Override
    protected void prmtPayOutAcctView_willCommit(CommitEvent e) throws Exception {
        super.prmtPayOutAcctView_willCommit(e);
        this.setAccountViewEvi(this.prmtPayOutAcctView, this.cmbFeeCurrency);
    }

    @Override
    protected void prmtPayOutAcctView_willShow(SelectorEvent e) throws Exception {
        super.prmtPayOutAcctView_willShow(e);
        this.setAccountViewEvi(this.prmtPayOutAcctView, this.cmbFeeCurrency);
    }

    @Override
    protected void prmtFeeBankAcct_willCommit(CommitEvent e) throws Exception {
        super.prmtFeeBankAcct_willCommit(e);
        if (this.cmbFeeCurrency.getSelectedItem() == null) {
            FundsMoveBillHandler.initAccountBank((IUIObject)this, this.prmtFeeBankAcct);
        } else {
            CurrencyInfo currency = (CurrencyInfo)this.cmbFeeCurrency.getSelectedItem();
            FundsMoveBillHandler.initAccountBank((IUIObject)this, this.prmtFeeBankAcct, currency.getId().toString());
        }
    }

    @Override
    protected void prmtFeeBankAcct_willShow(SelectorEvent e) throws Exception {
        super.prmtFeeBankAcct_willShow(e);
        if (this.cmbFeeCurrency.getSelectedItem() == null) {
            FundsMoveBillHandler.initAccountBank((IUIObject)this, this.prmtFeeBankAcct);
        } else {
            CurrencyInfo currency = (CurrencyInfo)this.cmbFeeCurrency.getSelectedItem();
            FundsMoveBillHandler.initAccountBank((IUIObject)this, this.prmtFeeBankAcct, currency.getId().toString());
        }
    }

    @Override
    protected void prmtMoveInBankAcct_willCommit(CommitEvent e) throws Exception {
        super.prmtMoveInBankAcct_willCommit(e);
        if (this.cmbMoveInCurrency.getSelectedItem() == null) {
            FundsMoveBillHandler.initAccountBank((IUIObject)this, this.prmtMoveInBankAcct);
        } else {
            CurrencyInfo currency = (CurrencyInfo)this.cmbMoveInCurrency.getSelectedItem();
            FundsMoveBillHandler.initAccountBank((IUIObject)this, this.prmtMoveInBankAcct, currency.getId().toString());
        }
    }

    @Override
    protected void prmtMoveInBankAcct_willShow(SelectorEvent e) throws Exception {
        super.prmtMoveInBankAcct_willShow(e);
        if (this.cmbMoveInCurrency.getSelectedItem() == null) {
            FundsMoveBillHandler.initAccountBank((IUIObject)this, this.prmtMoveInBankAcct);
        } else {
            CurrencyInfo currency = (CurrencyInfo)this.cmbMoveInCurrency.getSelectedItem();
            FundsMoveBillHandler.initAccountBank((IUIObject)this, this.prmtMoveInBankAcct, currency.getId().toString());
        }
    }

    @Override
    protected void prmtMoveOutBankAcct_willCommit(CommitEvent e) throws Exception {
        super.prmtMoveOutBankAcct_willCommit(e);
        if (this.cmbMoveOutCurrency.getSelectedItem() == null) {
            FundsMoveBillHandler.initAccountBank((IUIObject)this, this.prmtMoveOutBankAcct);
        } else {
            CurrencyInfo currency = (CurrencyInfo)this.cmbMoveOutCurrency.getSelectedItem();
            FundsMoveBillHandler.initAccountBank((IUIObject)this, this.prmtMoveOutBankAcct, currency.getId().toString());
        }
    }

    @Override
    protected void prmtMoveOutBankAcct_willShow(SelectorEvent e) throws Exception {
        super.prmtMoveOutBankAcct_willShow(e);
        if (this.cmbMoveOutCurrency.getSelectedItem() == null) {
            FundsMoveBillHandler.initAccountBank((IUIObject)this, this.prmtMoveOutBankAcct);
        } else {
            CurrencyInfo currency = (CurrencyInfo)this.cmbMoveOutCurrency.getSelectedItem();
            FundsMoveBillHandler.initAccountBank((IUIObject)this, this.prmtMoveOutBankAcct, currency.getId().toString());
        }
    }

    @Override
    protected void prmtMoveType_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtMoveType_dataChanged(e);
        if (e.getNewValue() == null) {
            return;
        }
        FundsMoveTypeInfo moveType = (FundsMoveTypeInfo)e.getNewValue();
        if (moveType.isCashOutBank()) {
            this.prmtMoveInBankAcct.setValue(null);
            this.prmtMoveInBankAcct.setEnabled(false);
        } else {
            this.prmtMoveInBankAcct.setEnabled(true);
        }
        if (moveType.isCashInBank()) {
            this.prmtMoveOutBankAcct.setValue(null);
            this.prmtMoveOutBankAcct.setEnabled(false);
        } else {
            this.prmtMoveOutBankAcct.setEnabled(true);
        }
    }

    public BigDecimal getLocAmout(KDFormattedTextField txtForeignAmout, KDFormattedTextField txtChangeRate, boolean isIndirectExRate) {
        if (txtForeignAmout.getBigDecimalValue() == null || txtChangeRate.getBigDecimalValue() == null) {
            return Constants.ZERO;
        }
        BigDecimal foreignAmout = txtForeignAmout.getBigDecimalValue();
        BigDecimal exchageRate = txtChangeRate.getBigDecimalValue();
        BigDecimal locAmount = new BigDecimal(0);
        locAmount = isIndirectExRate ? foreignAmout.divide(exchageRate, 20, 4) : foreignAmout.multiply(exchageRate);
        return locAmount;
    }

    private void setAccountViewEvi(KDBizPromptBox f7, KDComboBox cmbCurrency, boolean isCash) throws EASBizException, BOSException {
        String currencyId = null;
        if (cmbCurrency != null && cmbCurrency.getSelectedItem() != null) {
            CurrencyInfo currency = (CurrencyInfo)cmbCurrency.getSelectedItem();
            currencyId = currency.getId().toString();
        }
        String companyId = this.currentCompany.getId().toString();
        f7.getQueryAgent().resetRuntimeEntityView();
        EntityViewInfo treeevi = FundsMoveBillHandler.getAccountViewEvi(companyId, currencyId, false, isCash);
        AccountPromptBox opseelect = new AccountPromptBox((IUIObject)this, this.currentCompany, treeevi.getFilter(), false, true);
        f7.setSelector((KDPromptSelector)opseelect);
        EntityViewInfo evi = FundsMoveBillHandler.getAccountViewEvi(companyId, currencyId, true, isCash);
        f7.setEntityViewInfo(evi);
    }

    private void setAccountViewEvi(KDBizPromptBox f7, KDComboBox cmbCurrency) throws EASBizException, BOSException {
        this.setAccountViewEvi(f7, cmbCurrency, false);
    }

    @Override
    protected void cmbMoveInCurrency_itemStateChanged(ItemEvent e) throws Exception {
        super.cmbMoveInCurrency_itemStateChanged(e);
        if (this.cmbMoveInCurrency.getSelectedItem() == null) {
            return;
        }
        CurrencyInfo desCurrency = (CurrencyInfo)this.cmbMoveInCurrency.getSelectedItem();
        this.txtMoveInAmount.setPrecision(desCurrency.getPrecision());
        if (!desCurrency.getId().equals((Object)this.currentCompany.getBaseCurrency().getId())) {
            ExchangeRateInfo exRateInfo = CasRecPayHandler.getExRateInfo(desCurrency.getId().toString(), null, null, (Date)this.pkBizDate.getValue());
            this.isIndirectExRateIn = CasRecPayHandler.isIndirectExRate(exRateInfo);
        } else {
            this.isIndirectExRateIn = false;
        }
        Object srcCurrency = this.cmbMoveOutCurrency.getSelectedItem();
        this.initExchangeRate(desCurrency, srcCurrency, this.txtMoveInLocRate);
        AccountBankInfo acctMoveInBank = (AccountBankInfo)this.prmtMoveInBankAcct.getValue();
        AccountViewInfo acctMoveInView = (AccountViewInfo)this.prmtMoveInAcctView.getValue();
        CurrencyInfo MoveIncurrency = (CurrencyInfo)this.cmbMoveInCurrency.getSelectedItem();
        this.setBalanceValue(this.txtMoveInBalance, acctMoveInView, acctMoveInBank, MoveIncurrency);
        if (e != null) {
            this.prmtMoveInBankAcct.setValue(null);
            this.prmtMoveInAcctView.setValue(null);
        }
    }

    @Override
    protected void cmbMoveOutCurrency_itemStateChanged(ItemEvent e) throws Exception {
        ExchangeRateInfo locRate;
        super.cmbMoveOutCurrency_itemStateChanged(e);
        if (this.cmbMoveOutCurrency.getSelectedItem() == null) {
            return;
        }
        CurrencyInfo srcCurrency = (CurrencyInfo)this.cmbMoveOutCurrency.getSelectedItem();
        this.txtMoveOutAmount.setPrecision(srcCurrency.getPrecision());
        if (!srcCurrency.getId().equals((Object)this.currentCompany.getBaseCurrency().getId())) {
            ExchangeRateInfo exRateInfo = CasRecPayHandler.getExRateInfo(srcCurrency.getId().toString(), null, null, (Date)this.pkBizDate.getValue());
            this.isIndirectExRateOut = CasRecPayHandler.isIndirectExRate(exRateInfo);
        } else {
            this.isIndirectExRateOut = false;
        }
        if (this.cmbMoveInCurrency.getSelectedItem() != null) {
            CurrencyInfo desCurrency = (CurrencyInfo)this.cmbMoveInCurrency.getSelectedItem();
            ExchangeRateInfo rate = CasRecPayHandler.getExRateInfo(srcCurrency.getId().toString(), desCurrency.getId().toString(), this.currentCompany, (Date)this.pkBizDate.getValue());
            if (rate != null) {
                this.txtExchangeRate.setValue((Object)rate.getConvertRate());
                this.txtExchangeRate.setPrecision(rate.getPrecision());
            } else {
                this.txtExchangeRate.setValue((Object)Constants.ZERO);
                this.txtExchangeRate.setPrecision(5);
            }
            if (srcCurrency.getId().equals((Object)desCurrency.getId())) {
                this.txtExchangeRate.setEnabled(false);
                this.txtExchangeRate.setValue((Object)Constants.ONE);
                int precsion = FMClientHelper.getPrecOfCurrency((BOSUuid)srcCurrency.getId());
                this.txtExchangeRate.setPrecision(precsion);
            } else {
                this.txtExchangeRate.setEnabled(true);
            }
        }
        if ((locRate = CasRecPayHandler.getExRateInfo(srcCurrency.getId().toString(), this.baseCurrency.getId().toString(), this.currentCompany, (Date)this.pkBizDate.getValue())) != null) {
            this.txtMoveOutLocRate.setValue((Object)locRate.getConvertRate());
            this.txtMoveOutLocRate.setPrecision(locRate.getPrecision());
        } else {
            this.txtMoveOutLocRate.setValue((Object)Constants.ZERO);
            this.txtMoveOutLocRate.setPrecision(5);
        }
        if (srcCurrency.getId().equals((Object)this.baseCurrency.getId())) {
            this.txtMoveOutLocRate.setEnabled(false);
            this.txtMoveOutLocRate.setValue((Object)Constants.ONE);
            int precsion = FMClientHelper.getPrecOfCurrency((BOSUuid)this.baseCurrency.getId());
            this.txtMoveOutLocRate.setPrecision(precsion);
        } else {
            this.txtMoveOutLocRate.setEnabled(true);
        }
        AccountBankInfo acctBank = (AccountBankInfo)this.prmtMoveOutBankAcct.getValue();
        AccountViewInfo acctView = (AccountViewInfo)this.prmtMoveOutAcctView.getValue();
        CurrencyInfo currency = (CurrencyInfo)this.cmbMoveOutCurrency.getSelectedItem();
        this.setBalanceValue(this.txtMoveOutBalance, acctView, acctBank, currency);
        if (e != null) {
            this.prmtMoveOutBankAcct.setValue(null);
            this.prmtMoveOutAcctView.setValue(null);
        }
    }

    @Override
    protected void cmbFeeCurrency_itemStateChanged(ItemEvent e) throws Exception {
        super.cmbFeeCurrency_itemStateChanged(e);
        if (this.cmbFeeCurrency.getSelectedItem() == null) {
            return;
        }
        CurrencyInfo feeCurrency = (CurrencyInfo)this.cmbFeeCurrency.getSelectedItem();
        this.txtFeeAmount.setPrecision(feeCurrency.getPrecision());
        if (!feeCurrency.getId().equals((Object)this.currentCompany.getBaseCurrency().getId())) {
            ExchangeRateInfo exRateInfo = CasRecPayHandler.getExRateInfo(feeCurrency.getId().toString(), null, null, (Date)this.pkBizDate.getValue());
            this.isIndirectExRateFee = CasRecPayHandler.isIndirectExRate(exRateInfo);
        } else {
            this.isIndirectExRateFee = false;
        }
        ExchangeRateInfo locRate = CasRecPayHandler.getExRateInfo(feeCurrency.getId().toString(), this.baseCurrency.getId().toString(), this.currentCompany, (Date)this.pkBizDate.getValue());
        if (locRate != null) {
            this.txtFeeLocRate.setValue((Object)locRate.getConvertRate());
            this.txtFeeLocRate.setPrecision(locRate.getPrecision());
        } else {
            this.txtFeeLocRate.setValue((Object)Constants.ZERO);
            this.txtFeeLocRate.setPrecision(5);
        }
        if (feeCurrency.getId().equals((Object)this.baseCurrency.getId())) {
            this.txtFeeLocRate.setEnabled(false);
            this.txtFeeLocRate.setValue((Object)Constants.ONE);
            int precsion = FMClientHelper.getPrecOfCurrency((BOSUuid)this.baseCurrency.getId());
            this.txtFeeLocRate.setPrecision(precsion);
        } else {
            this.txtFeeLocRate.setEnabled(true);
        }
        if (e != null) {
            this.prmtFeeBankAcct.setValue(null);
            this.prmtPayOutAcctView.setValue(null);
            this.prmtFeeAcctView.setValue(null);
        }
    }

    @Override
    protected void txtExchangeRate_dataChanged(DataChangeEvent e) throws Exception {
        super.txtExchangeRate_dataChanged(e);
    }

    @Override
    protected void txtFeeAmount_dataChanged(DataChangeEvent e) throws Exception {
        super.txtFeeAmount_dataChanged(e);
        BigDecimal locAmt = this.getLocAmout(this.txtFeeAmount, this.txtFeeLocRate, this.isIndirectExRateFee);
        this.txtFeeLocAmt.setValue((Object)locAmt.setScale(this.txtFeeLocAmt.getPrecision(), 4));
    }

    @Override
    protected void txtFeeLocRate_dataChanged(DataChangeEvent e) throws Exception {
        super.txtFeeLocRate_dataChanged(e);
        BigDecimal locAmt = this.getLocAmout(this.txtFeeAmount, this.txtFeeLocRate, this.isIndirectExRateFee);
        this.txtFeeLocAmt.setValue((Object)locAmt);
        this.txtFeeLocAmt.setValue((Object)locAmt.setScale(this.txtFeeLocAmt.getPrecision(), 4));
    }

    @Override
    protected void txtMoveInAmount_dataChanged(DataChangeEvent e) throws Exception {
        super.txtMoveInAmount_dataChanged(e);
        BigDecimal locAmt = this.getLocAmout(this.txtMoveInAmount, this.txtMoveInLocRate, this.isIndirectExRateIn);
        this.txtMoveInLocAmt.setValue((Object)locAmt);
        this.txtMoveInLocAmt.setValue((Object)locAmt.setScale(this.txtMoveInLocAmt.getPrecision(), 4));
    }

    @Override
    protected void txtMoveInLocRate_dataChanged(DataChangeEvent e) throws Exception {
        super.txtMoveInLocRate_dataChanged(e);
        BigDecimal locAmt = this.getLocAmout(this.txtMoveInAmount, this.txtMoveInLocRate, this.isIndirectExRateIn);
        this.txtMoveInLocAmt.setValue((Object)locAmt);
        this.txtMoveInLocAmt.setValue((Object)locAmt.setScale(this.txtMoveInLocAmt.getPrecision(), 4));
    }

    @Override
    protected void txtMoveOutLocRate_dataChanged(DataChangeEvent e) throws Exception {
        super.txtMoveOutLocRate_dataChanged(e);
        BigDecimal locAmt = this.getLocAmout(this.txtMoveOutAmount, this.txtMoveOutLocRate, this.isIndirectExRateOut);
        this.txtMoveOutLocAmt.setValue((Object)locAmt);
        this.txtMoveOutLocAmt.setValue((Object)locAmt.setScale(this.txtMoveOutLocAmt.getPrecision(), 4));
    }

    @Override
    protected void txtMoveOutAmount_dataChanged(DataChangeEvent e) throws Exception {
        super.txtMoveOutAmount_dataChanged(e);
        BigDecimal locAmt = this.getLocAmout(this.txtMoveOutAmount, this.txtMoveOutLocRate, this.isIndirectExRateOut);
        this.txtMoveOutLocAmt.setValue((Object)locAmt);
        this.txtMoveOutLocAmt.setValue((Object)locAmt.setScale(this.txtMoveOutLocAmt.getPrecision(), 4));
    }

    @Override
    protected void txtMoveInLocAmt_dataChanged(DataChangeEvent e) throws Exception {
        super.txtMoveInLocAmt_dataChanged(e);
        this.resetTxtIncomeValue();
    }

    @Override
    protected void txtMoveOutLocAmt_dataChanged(DataChangeEvent e) throws Exception {
        super.txtMoveOutLocAmt_dataChanged(e);
        this.resetTxtIncomeValue();
    }

    private void resetTxtIncomeValue() {
        if (this.txtMoveInLocAmt.getBigDecimalValue() == null || this.txtMoveOutLocAmt.getBigDecimalValue() == null) {
            return;
        }
        BigDecimal locInAmount = this.txtMoveInLocAmt.getBigDecimalValue();
        BigDecimal locOutAmount = this.txtMoveOutLocAmt.getBigDecimalValue();
        BigDecimal locInAmountAfter = locInAmount.setScale(this.basePrecsion, 4);
        BigDecimal locOutAmountAfter = locOutAmount.setScale(this.basePrecsion, 4);
        BigDecimal income = locInAmountAfter.subtract(locOutAmountAfter);
        this.txtIncome.setValue((Object)income);
    }

    @Override
    protected void prmtMoveInBankAcct_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtMoveInBankAcct_dataChanged(e);
        if (e.getNewValue() == null) {
            this.prmtMoveInAcctView.setEnabled(true);
            return;
        }
        AccountBankInfo accountBank = (AccountBankInfo)e.getNewValue();
        AccountViewInfo accountView = accountBank.getAccount();
        if (accountView != null) {
            this.prmtMoveInAcctView.setValue((Object)accountView);
            this.prmtMoveInAcctView.setEnabled(false);
        } else {
            this.prmtMoveInAcctView.setEnabled(true);
        }
    }

    @Override
    protected void prmtMoveOutBankAcct_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtMoveOutBankAcct_dataChanged(e);
        if (e.getNewValue() == null) {
            this.prmtMoveOutAcctView.setEnabled(true);
            return;
        }
        AccountBankInfo accountBank = (AccountBankInfo)e.getNewValue();
        AccountViewInfo accountView = accountBank.getAccount();
        if (accountView != null) {
            this.prmtMoveOutAcctView.setValue((Object)accountView);
            this.prmtMoveOutAcctView.setEnabled(false);
        } else {
            this.prmtMoveOutAcctView.setEnabled(true);
        }
    }

    @Override
    protected void prmtFeeBankAcct_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtFeeBankAcct_dataChanged(e);
        if (e.getNewValue() == null) {
            this.prmtPayOutAcctView.setEnabled(true);
            return;
        }
        AccountBankInfo accountBank = (AccountBankInfo)e.getNewValue();
        AccountViewInfo accountView = accountBank.getAccount();
        if (accountView != null) {
            this.prmtPayOutAcctView.setValue((Object)accountView);
            this.prmtPayOutAcctView.setEnabled(false);
        } else {
            this.prmtPayOutAcctView.setEnabled(true);
        }
    }

    @Override
    protected void prmtPayOutAcctView_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtPayOutAcctView_dataChanged(e);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        AccountBankInfo moveAcctBank;
        BigDecimal income;
        super.verifyInput(e);
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtCompany);
        if (this.txtNumber.isRequired()) {
            ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
        }
        ClientVerifyHelper.verifyRequire((CoreUIObject)this);
        ClientVerifyHelper.verifyEmptyAndNoZero((CoreUIObject)this, (KDFormattedTextField)this.txtMoveInAmount);
        ClientVerifyHelper.verifyEmptyAndNoZero((CoreUIObject)this, (KDFormattedTextField)this.txtMoveOutAmount);
        FundsMoveBillHandler.verifyDirectionMatch((CoreUIObject)this, this.txtMoveInAmount, this.txtMoveOutAmount);
        FMClientVerifyHelper.verifyGreaterThan((CoreUIObject)this, (KDFormattedTextField)this.txtExchangeRate, (BigDecimal)Constants.ZERO);
        FMClientVerifyHelper.verifyGreaterThan((CoreUIObject)this, (KDFormattedTextField)this.txtMoveInLocRate, (BigDecimal)Constants.ZERO);
        FMClientVerifyHelper.verifyGreaterThan((CoreUIObject)this, (KDFormattedTextField)this.txtMoveOutLocRate, (BigDecimal)Constants.ZERO);
        FMClientVerifyHelper.verifyGreaterThan((CoreUIObject)this, (KDFormattedTextField)this.txtFeeLocRate, (BigDecimal)Constants.ZERO);
        this.verifyAcctAndCurrencyMatch(this.prmtMoveInBankAcct, this.cmbMoveInCurrency);
        this.verifyAcctAndCurrencyMatch(this.prmtMoveOutBankAcct, this.cmbMoveOutCurrency);
        this.verifyAcctAndCurrencyMatch(this.prmtFeeBankAcct, this.cmbFeeCurrency);
        BigDecimal feeAmount = this.txtFeeAmount.getBigDecimalValue();
        if (feeAmount != null && feeAmount.compareTo(Constants.ZERO) != 0) {
            ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtFeeAcctView);
            ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtPayOutAcctView);
        }
        if ((income = this.txtIncome.getBigDecimalValue().setScale(this.basePrecsion, 4)) != null && income.compareTo(Constants.ZERO) != 0) {
            ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtIncomeAcctView);
        }
        if ((moveAcctBank = (AccountBankInfo)this.prmtMoveOutBankAcct.getValue()) != null && moveAcctBank.getCtrlStrategy() != null) {
            AccountMgrStrategyInfo strategy = moveAcctBank.getCtrlStrategy();
            BigDecimal balance = this.txtMoveOutBalance.getBigDecimalValue();
            this.verifyOverDraft(strategy, balance, this.editData);
        }
        if (this.editData.getId() != null) {
            ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId().toString());
            FundsMoveBillInfo info = FundsMoveBillFactory.getRemoteInstance().getFundsMoveBillInfo((IObjectPK)pk);
            if (info.getBillState() == FundsMoveBillStateEnum.audited || info.getBillState() == FundsMoveBillStateEnum.settled) {
                MsgBox.showInfo((String)EASResource.getString((String)FundsMoveBillResource, (String)"billStateChanged"));
                SysUtil.abort();
            }
        }
    }

    private void verifyAcctAndCurrencyMatch(KDBizPromptBox acctF7, KDComboBox cmbCurrency) {
        boolean isMoveInAcctSigleCurrency;
        boolean bl = isMoveInAcctSigleCurrency = acctF7.getValue() != null && ((AccountBankInfo)acctF7.getValue()).getCurrency() != null;
        if (isMoveInAcctSigleCurrency) {
            BOSUuid cmbCurID = ((CurrencyInfo)cmbCurrency.getSelectedItem()).getId();
            BOSUuid accLinkID = ((AccountBankInfo)acctF7.getValue()).getCurrency().getId();
            if (!accLinkID.equals((Object)cmbCurID)) {
                MsgBox.showInfo((String)EASResource.getString((String)FundsMoveBillResource, (String)"currencyNotMatchAccNum"));
                cmbCurrency.requestFocus();
                SysUtil.abort();
            }
        }
    }

    public void verifyAcctAndCurrencyMatch(AccountBankInfo acct, CurrencyInfo currencyInfo) {
        boolean isMoveInAcctSigleCurrency;
        boolean bl = isMoveInAcctSigleCurrency = acct.getCurrency() != null;
        if (isMoveInAcctSigleCurrency && !acct.getCurrency().getId().equals((Object)currencyInfo.getId())) {
            MsgBox.showInfo((String)EASResource.getString((String)FundsMoveBillResource, (String)"currencyNotMatchAccNum"));
            this.cmbMoveInCurrency.requestFocus();
            SysUtil.abort();
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        FMClientHelper.checkIsAdjustPeriod((Component)((Object)this), (CompanyOrgUnitInfo)this.company);
        super.actionAddNew_actionPerformed(e);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.actionTDPrint.setEnabled(false);
            this.actionTDPrintPreview.setEnabled(false);
        }
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.checkIsAdjustPeriod();
        this.checkModified();
        if (this.editData != null) {
            IPermission iPermission = PermissionFactory.getRemoteInstance();
            iPermission.checkFunctionPermission(this.getUserPk(), (IObjectPK)new ObjectUuidPK(this.editData.getCompany().getId().toString()), "fi_cas_fundsmove_03AddNew");
            FundsMoveBillInfo newEditData = this.editData.copy();
            newEditData.setId(null);
            newEditData.setNumber(null);
            newEditData.setBizDate(DateHelper.getDayBegin());
            newEditData.setCompany(newEditData.getCompany());
            newEditData.setCreator(this.userinfo);
            newEditData.setCreateTime(new Timestamp(System.currentTimeMillis()));
            this.unLockUI();
            this.setOprtState("ADDNEW");
            super.setMakeRelations(null);
            this.setDataObject((IObjectValue)newEditData);
            this.getUIContext().put("COPY", "COPY");
            this.loadFields();
            this.showCopyAddNew();
            this.actionCopy.setEnabled(false);
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        if (!OprtState.ADDNEW.equals(this.getOprtState())) {
            this.actionTDPrint.setEnabled(true);
            this.actionTDPrintPreview.setEnabled(true);
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.pk1 = null;
        super.actionSubmit_actionPerformed(e);
        if (!OprtState.ADDNEW.equals(this.getOprtState())) {
            this.actionTDPrint.setEnabled(true);
            this.actionTDPrintPreview.setEnabled(true);
        }
        if (this.pk1 != null) {
            String billId = this.pk1.toString();
            String Msg = FMBudgetFacadeFactory.getRemoteInstance().getMsgFromID(billId);
            if (Msg != null && !"".equals(Msg)) {
                MsgBox.showConfirm2((String)Msg);
            }
        }
    }

    public IObjectPK runSubmit() throws Exception {
        this.pk1 = super.runSubmit();
        return this.pk1;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FundsMoveBillFactory.getRemoteInstance();
    }

    private SelectorItemCollection getAccountBankSIC() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("bankAccountNumber");
        sic.add("bank.id");
        sic.add("bank.name");
        sic.add("bank.number");
        sic.add("account.id");
        sic.add("account.number");
        sic.add("account.name");
        return sic;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("moveOutAmount"));
        sic.add(new SelectorItemInfo("moveInAmount"));
        sic.add(new SelectorItemInfo("moveOutLocRate"));
        sic.add(new SelectorItemInfo("digest"));
        sic.add(new SelectorItemInfo("moveOutBankAccount.id"));
        sic.add(new SelectorItemInfo("moveOutBankAccount.name"));
        sic.add(new SelectorItemInfo("moveOutBankAccount.number"));
        sic.add(new SelectorItemInfo("moveOutBankAccount.bankAccountNumber"));
        sic.add(new SelectorItemInfo("moveInBankAccount.id"));
        sic.add(new SelectorItemInfo("moveInBankAccount.name"));
        sic.add(new SelectorItemInfo("moveInBankAccount.number"));
        sic.add(new SelectorItemInfo("moveInBankAccount.bankAccountNumber"));
        sic.add(new SelectorItemInfo("moveOutAccountView.id"));
        sic.add(new SelectorItemInfo("moveOutAccountView.name"));
        sic.add(new SelectorItemInfo("moveOutAccountView.number"));
        sic.add(new SelectorItemInfo("moveOutAccountView.isBank"));
        sic.add(new SelectorItemInfo("moveOutAccountView.isCash"));
        sic.add(new SelectorItemInfo("moveInAccountView.id"));
        sic.add(new SelectorItemInfo("moveInAccountView.name"));
        sic.add(new SelectorItemInfo("moveInAccountView.number"));
        sic.add(new SelectorItemInfo("moveInAccountView.isBank"));
        sic.add(new SelectorItemInfo("moveInAccountView.isCash"));
        sic.add(new SelectorItemInfo("appendix"));
        sic.add(new SelectorItemInfo("myHandler.name"));
        sic.add(new SelectorItemInfo("myHandler.number"));
        sic.add(new SelectorItemInfo("cashier.id"));
        sic.add(new SelectorItemInfo("cashier.name"));
        sic.add(new SelectorItemInfo("accountant.id"));
        sic.add(new SelectorItemInfo("accountant.name"));
        sic.add(new SelectorItemInfo("moveOutCurrency.id"));
        sic.add(new SelectorItemInfo("moveOutCurrency.name"));
        sic.add(new SelectorItemInfo("moveInCurrency.id"));
        sic.add(new SelectorItemInfo("moveInCurrency.name"));
        sic.add(new SelectorItemInfo("moveType.*"));
        sic.add(new SelectorItemInfo("moveOutLocAmt"));
        sic.add(new SelectorItemInfo("exchangeRate"));
        sic.add(new SelectorItemInfo("moveInLocRate"));
        sic.add(new SelectorItemInfo("moveInLocAmt"));
        sic.add(new SelectorItemInfo("feeCurrency"));
        sic.add(new SelectorItemInfo("feeBankAccount.id"));
        sic.add(new SelectorItemInfo("feeBankAccount.name"));
        sic.add(new SelectorItemInfo("feeBankAccount.number"));
        sic.add(new SelectorItemInfo("feeBankAccount.bankAccountNumber"));
        sic.add(new SelectorItemInfo("payoutAcctView.id"));
        sic.add(new SelectorItemInfo("payoutAcctView.name"));
        sic.add(new SelectorItemInfo("payoutAcctView.number"));
        sic.add(new SelectorItemInfo("payoutAcctView.isBank"));
        sic.add(new SelectorItemInfo("payoutAcctView.isCash"));
        sic.add(new SelectorItemInfo("feeAmount"));
        sic.add(new SelectorItemInfo("feeLocRate"));
        sic.add(new SelectorItemInfo("feeLocAmt"));
        sic.add(new SelectorItemInfo("feeAcctView.id"));
        sic.add(new SelectorItemInfo("feeAcctView.name"));
        sic.add(new SelectorItemInfo("feeAcctView.number"));
        sic.add(new SelectorItemInfo("feeAcctView.isBank"));
        sic.add(new SelectorItemInfo("feeAcctView.isCash"));
        sic.add(new SelectorItemInfo("income"));
        sic.add(new SelectorItemInfo("incomeAcctView.id"));
        sic.add(new SelectorItemInfo("incomeAcctView.name"));
        sic.add(new SelectorItemInfo("incomeAcctView.number"));
        sic.add(new SelectorItemInfo("incomeAcctView.isBank"));
        sic.add(new SelectorItemInfo("incomeAcctView.isCash"));
        sic.add("billState");
        sic.add("outBgItemId");
        sic.add("outBgItemNumber");
        sic.add("outBgItemName");
        sic.add("oppBgItemId");
        sic.add("oppBgItemNumber");
        sic.add("oppBgItemName");
        sic.add("feeBgItemId");
        sic.add("feeBgItemNumber");
        sic.add("feeBgItemName");
        sic.add("incomeBgItemId");
        sic.add("incomeBgItemNumber");
        sic.add("incomeBgItemName");
        sic.add("costCenter.id");
        sic.add("costCenter.name");
        sic.add("costCenter.number");
        return sic;
    }

    private void addBalanceListener() {
        FocusAdapter moveOutBalanceListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                try {
                    AccountBankInfo acctBank = (AccountBankInfo)FundsMoveBillEditUI.this.prmtMoveOutBankAcct.getValue();
                    AccountViewInfo acctView = (AccountViewInfo)FundsMoveBillEditUI.this.prmtMoveOutAcctView.getValue();
                    CurrencyInfo currency = (CurrencyInfo)FundsMoveBillEditUI.this.cmbMoveOutCurrency.getSelectedItem();
                    FundsMoveBillEditUI.this.setBalanceValue(FundsMoveBillEditUI.this.txtMoveOutBalance, acctView, acctBank, currency);
                }
                catch (EASBizException e1) {
                    logger.error((Object)e1);
                    SysUtil.abort();
                }
                catch (BOSException e1) {
                    logger.error((Object)e1);
                    SysUtil.abort();
                }
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                try {
                    AccountBankInfo acctBank = (AccountBankInfo)FundsMoveBillEditUI.this.prmtMoveOutBankAcct.getValue();
                    AccountViewInfo acctView = (AccountViewInfo)FundsMoveBillEditUI.this.prmtMoveOutAcctView.getValue();
                    CurrencyInfo currency = (CurrencyInfo)FundsMoveBillEditUI.this.cmbMoveOutCurrency.getSelectedItem();
                    FundsMoveBillEditUI.this.setBalanceValue(FundsMoveBillEditUI.this.txtMoveOutBalance, acctView, acctBank, currency);
                }
                catch (EASBizException e1) {
                    logger.error((Object)e1);
                    SysUtil.abort();
                }
                catch (BOSException e1) {
                    logger.error((Object)e1);
                    SysUtil.abort();
                }
            }
        };
        this.prmtMoveOutBankAcct.getEditor().addFocusListener(moveOutBalanceListener);
        FocusAdapter moveInBalanceListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                try {
                    AccountBankInfo acctBank = (AccountBankInfo)FundsMoveBillEditUI.this.prmtMoveInBankAcct.getValue();
                    AccountViewInfo acctView = (AccountViewInfo)FundsMoveBillEditUI.this.prmtMoveInAcctView.getValue();
                    CurrencyInfo currency = (CurrencyInfo)FundsMoveBillEditUI.this.cmbMoveInCurrency.getSelectedItem();
                    FundsMoveBillEditUI.this.setBalanceValue(FundsMoveBillEditUI.this.txtMoveInBalance, acctView, acctBank, currency);
                }
                catch (EASBizException e1) {
                    logger.error((Object)e1);
                    SysUtil.abort();
                }
                catch (BOSException e1) {
                    logger.error((Object)e1);
                    SysUtil.abort();
                }
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                try {
                    AccountBankInfo acctBank = (AccountBankInfo)FundsMoveBillEditUI.this.prmtMoveInBankAcct.getValue();
                    AccountViewInfo acctView = (AccountViewInfo)FundsMoveBillEditUI.this.prmtMoveInAcctView.getValue();
                    CurrencyInfo currency = (CurrencyInfo)FundsMoveBillEditUI.this.cmbMoveInCurrency.getSelectedItem();
                    FundsMoveBillEditUI.this.setBalanceValue(FundsMoveBillEditUI.this.txtMoveInBalance, acctView, acctBank, currency);
                }
                catch (EASBizException e1) {
                    logger.error((Object)e1);
                    SysUtil.abort();
                }
                catch (BOSException e1) {
                    logger.error((Object)e1);
                    SysUtil.abort();
                }
            }
        };
        this.prmtMoveInBankAcct.getEditor().addFocusListener(moveInBalanceListener);
    }

    private void setBalanceValue(KDFormattedTextField txtBalance, AccountViewInfo acctView, AccountBankInfo acctBank, CurrencyInfo currency) throws EASBizException, BOSException {
        if ("FINDVIEW".equals(this.getOprtState()) || "VIEW".equals(this.getOprtState())) {
            txtBalance.setText("");
            return;
        }
        BigDecimal totalBalance = RecPayHelper.getTotalBalance(this.currentCompany, acctView, acctBank, currency);
        if (!EmptyUtil.isEmpty((Object)totalBalance)) {
            FMClientHelper.setCutValue((KDFormattedTextField)txtBalance, (Number)totalBalance);
        }
    }

    private void showMsg(ActionEvent e) {
        Component component = (Component)e.getSource();
        FMClientHelper.showSuccessMessage((CoreUI)this, (Component)component);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(this.editData.getId().toString());
        boolean idsInProcess = FMHelper.hasWFInstance(null, (String)this.editData.getId().toString());
        if (idsInProcess) {
            this.actionMultiapprove_actionPerformed(e);
        } else {
            ((IFundsMoveBill)this.getBizInterface()).audit(idSet);
        }
        this.showMsg(e);
        this.setDataObject(this.getValue((IObjectPK)new ObjectUuidPK(this.editData.getId())));
        this.loadFields();
        this.setSave(true);
        this.setSaved(true);
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(this.editData.getId().toString());
        ((IFundsMoveBill)this.getBizInterface()).antiAudit(idSet);
        this.showMsg(e);
        this.setDataObject(this.getValue((IObjectPK)new ObjectUuidPK(this.editData.getId())));
        this.loadFields();
        this.setSave(true);
        this.setSaved(true);
    }

    @Override
    public void actionSettle_actionPerformed(ActionEvent e) throws Exception {
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(this.editData.getId().toString());
        ((IFundsMoveBill)this.getBizInterface()).settle(idSet);
        boolean flagItemVoucher = this.MenuItemVoucher.isVisible();
        boolean flagItemDelVoucher = this.menuItemDelVoucher.isVisible();
        Component component = (Component)e.getSource();
        FMClientHelper.showSuccessInfo((Component)((Object)this), (Component)component);
        this.setDataObject(this.getValue((IObjectPK)new ObjectUuidPK(this.editData.getId())));
        this.loadFields();
        this.setSave(true);
        this.setSaved(true);
        if (flagItemVoucher) {
            this.MenuItemVoucher.setVisible(true);
            this.MenuItemVoucher.setEnabled(true);
            this.btnVoucher.setVisible(true);
            this.btnVoucher.setEnabled(true);
        }
        if (flagItemDelVoucher) {
            this.menuItemDelVoucher.setVisible(true);
            this.menuItemDelVoucher.setEnabled(true);
            this.btnDelVoucher.setVisible(true);
            this.btnDelVoucher.setEnabled(true);
        }
        this.btnAntiAudit.setVisible(false);
        this.menuItemAntiAudit.setVisible(false);
        this.menuItemAntiSettle.setVisible(true);
        this.btnAntiSettle.setVisible(true);
    }

    @Override
    public void actionAntiSettle_actionPerformed(ActionEvent e) throws Exception {
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(this.editData.getId().toString());
        ((IFundsMoveBill)this.getBizInterface()).antiSettle(idSet);
        boolean flagItemVoucher = this.MenuItemVoucher.isVisible();
        boolean flagItemDelVoucher = this.menuItemDelVoucher.isVisible();
        Component component = (Component)e.getSource();
        FMClientHelper.showSuccessInfo((Component)((Object)this), (Component)component);
        this.setDataObject(this.getValue((IObjectPK)new ObjectUuidPK(this.editData.getId())));
        this.loadFields();
        this.setSave(true);
        this.setSaved(true);
        if (flagItemVoucher) {
            this.MenuItemVoucher.setVisible(true);
            this.MenuItemVoucher.setEnabled(true);
            this.btnVoucher.setVisible(true);
            this.btnVoucher.setEnabled(true);
        }
        if (flagItemDelVoucher) {
            this.menuItemDelVoucher.setVisible(true);
            this.menuItemDelVoucher.setEnabled(true);
            this.btnDelVoucher.setVisible(true);
            this.btnDelVoucher.setEnabled(true);
        }
        if (this.MenuItemVoucher.isVisible()) {
            this.btnAntiAudit.setVisible(true);
            this.menuItemAntiAudit.setVisible(true);
        }
        this.menuItemSettle.setVisible(true);
        this.btnSettle.setVisible(true);
        this.menuItemAntiSettle.setVisible(false);
        this.btnAntiSettle.setVisible(false);
    }

    @Override
    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getBillState() == FundsMoveBillStateEnum.saved || this.editData.getBillState() == FundsMoveBillStateEnum.submited) {
            throw new FundsMoveException(FundsMoveException.NOT_AUDITED_CANT_VOURCHER);
        }
        super.actionVoucher_actionPerformed(e);
        boolean flagItemSettle = this.menuItemSettle.isVisible();
        boolean flagItemAntiSettle = this.menuItemAntiSettle.isVisible();
        this.setDataObject(this.getValue((IObjectPK)new ObjectUuidPK(this.editData.getId())));
        this.loadFields();
        this.setSave(true);
        this.setSaved(true);
        if (flagItemSettle) {
            this.menuItemSettle.setVisible(true);
            this.menuItemSettle.setEnabled(true);
            this.btnSettle.setVisible(true);
            this.btnSettle.setEnabled(true);
        }
        if (flagItemAntiSettle) {
            this.menuItemAntiSettle.setVisible(true);
            this.menuItemAntiSettle.setEnabled(true);
            this.btnAntiSettle.setVisible(true);
            this.btnAntiSettle.setEnabled(true);
        }
        this.btnVoucher.setVisible(false);
        this.MenuItemVoucher.setVisible(false);
        this.menuItemDelVoucher.setVisible(true);
        this.btnDelVoucher.setVisible(true);
    }

    @Override
    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelVoucher_actionPerformed(e);
        boolean flagItemSettle = this.menuItemSettle.isVisible();
        boolean flagItemAntiSettle = this.menuItemAntiSettle.isVisible();
        this.setDataObject(this.getValue((IObjectPK)new ObjectUuidPK(this.editData.getId())));
        this.loadFields();
        this.setSave(true);
        this.setSaved(true);
        if (flagItemSettle) {
            this.menuItemSettle.setVisible(true);
            this.menuItemSettle.setEnabled(true);
            this.btnSettle.setVisible(true);
            this.btnSettle.setEnabled(true);
        }
        if (flagItemAntiSettle) {
            this.menuItemAntiSettle.setVisible(true);
            this.menuItemAntiSettle.setEnabled(true);
            this.btnAntiSettle.setVisible(true);
            this.btnAntiSettle.setEnabled(true);
        }
        this.btnVoucher.setVisible(true);
        this.btnVoucher.setEnabled(true);
        this.MenuItemVoucher.setVisible(true);
        this.MenuItemVoucher.setEnabled(true);
        this.menuItemDelVoucher.setVisible(false);
        this.btnDelVoucher.setVisible(false);
    }

    protected void initDapButtons() throws Exception {
        FundsMoveBillInfo info = (FundsMoveBillInfo)this.getDataObject();
        if (info == null) {
            return;
        }
        String oprtS = this.getOprtState();
        String listOprtState = (String)this.getUIContext().get("listOprtState");
        if (listOprtState != null && listOprtState.equals("FINDVIEW")) {
            oprtS = "FINDVIEW";
        }
        FundsMoveBillStateEnum billStatus = FundsMoveBillStateEnum.saved;
        if (info.getBillState() != null) {
            billStatus = info.getBillState();
        }
        boolean canVoucher = !info.isFiVouchered() && billStatus.equals((Object)FundsMoveBillStateEnum.audited) && !"FINDVIEW".equals(oprtS);
        this.actionVoucher.setVisible(canVoucher);
        this.actionVoucher.setEnabled(canVoucher);
        boolean canAntiVoucher = info.isFiVouchered() && !"FINDVIEW".equals(this.getOprtState());
        this.actionDelVoucher.setVisible(canAntiVoucher);
        this.actionDelVoucher.setEnabled(canAntiVoucher);
    }

    public boolean isNeedShowBOTPRule() {
        return true;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        FMClientHelper.checkIsAdjustPeriod((Component)((Object)this), (CompanyOrgUnitInfo)this.company);
        super.actionEdit_actionPerformed(e);
    }

    private void verifyOverDraft(AccountMgrStrategyInfo strategy, BigDecimal balance, FundsMoveBillInfo editData) throws Exception {
        RecPayAcctBankStratageCtrl.verifyOverDraft(this.handler.getInstanceBean(), strategy, balance, (CoreBillBaseInfo)editData);
    }

    @Override
    protected void pkBizDate_dataChanged(DataChangeEvent e) throws Exception {
        CurrencyInfo desCurrency = (CurrencyInfo)this.cmbMoveInCurrency.getSelectedItem();
        Object srcCurrency = this.cmbMoveOutCurrency.getSelectedItem();
        this.initExchangeRate(desCurrency, srcCurrency, this.txtMoveInLocRate);
        this.cmbMoveOutCurrency_itemStateChanged(null);
        this.cmbFeeCurrency_itemStateChanged(null);
    }

    public void checkIsAdjustPeriod() {
        try {
            CasPeriodHelper.checkAdjustPeriod(null, this.editData, "company");
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
    }

    private void initExchangeRate(CurrencyInfo desCurrency, Object srcCurrency, KDFormattedTextField txtLocRate) {
        ExchangeRateInfo locRate;
        int pre;
        if (this.cmbMoveOutCurrency.getSelectedItem() != null) {
            ExchangeRateInfo exchageRate = CasRecPayHandler.getExRateInfo(((CurrencyInfo)srcCurrency).getId().toString(), desCurrency.getId().toString(), this.currentCompany, (Date)this.pkBizDate.getValue());
            if (exchageRate != null) {
                this.txtExchangeRate.setValue((Object)exchageRate.getConvertRate());
                this.txtExchangeRate.setPrecision(exchageRate.getPrecision());
            } else {
                this.txtExchangeRate.setValue((Object)Constants.ZERO);
                this.txtExchangeRate.setPrecision(5);
            }
            if (((CurrencyInfo)srcCurrency).getId().equals((Object)desCurrency.getId())) {
                this.txtExchangeRate.setEnabled(false);
                this.txtExchangeRate.setValue((Object)Constants.ONE);
                pre = FMClientHelper.getPrecOfCurrency((BOSUuid)((CurrencyInfo)srcCurrency).getId());
                this.txtExchangeRate.setPrecision(pre);
            } else {
                this.txtExchangeRate.setEnabled(true);
            }
        }
        if ((locRate = CasRecPayHandler.getExRateInfo(desCurrency.getId().toString(), this.baseCurrency.getId().toString(), this.currentCompany, (Date)this.pkBizDate.getValue())) != null) {
            txtLocRate.setValue((Object)locRate.getConvertRate());
            txtLocRate.setPrecision(locRate.getPrecision());
        } else {
            txtLocRate.setValue((Object)Constants.ZERO);
            txtLocRate.setPrecision(5);
        }
        if (desCurrency.getId().equals((Object)this.baseCurrency.getId())) {
            txtLocRate.setEnabled(false);
            txtLocRate.setValue((Object)Constants.ONE);
            pre = FMClientHelper.getPrecOfCurrency((BOSUuid)this.baseCurrency.getId());
            txtLocRate.setPrecision(pre);
        } else {
            txtLocRate.setEnabled(true);
        }
    }

    public String getAfterSubmitOprtState() {
        return OprtState.VIEW;
    }
}

