/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

public class FundsMoveBillHandler {
    private static final Map AcctViewEviMap = new HashMap(32);

    public static EntityViewInfo getAccountViewEvi(String companyID, String currencyId, boolean isLeaf, boolean isCash) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)companyID));
        if (isLeaf) {
            filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)"1"));
        }
        filter.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)Boolean.FALSE));
        if (isCash) {
            filter.getFilterItems().add(new FilterItemInfo("isCash", (Object)Boolean.TRUE));
        }
        EntityViewInfo customEvi = new EntityViewInfo();
        customEvi.setFilter(filter);
        EntityViewInfo evi = null;
        String key = companyID + "_" + currencyId + "_" + isLeaf + "_" + isCash;
        if (AcctViewEviMap.get(key) != null) {
            evi = (EntityViewInfo)AcctViewEviMap.get(key);
        }
        if (evi == null) {
            evi = FMHelper.getAccountViewEvi((String)companyID, (String)currencyId, (EntityViewInfo)customEvi);
            AcctViewEviMap.put(key, evi);
        }
        SorterItemCollection sorter = evi.getSorter();
        sorter.add(new SorterItemInfo("number"));
        return evi;
    }

    public static EntityViewInfo getAccountViewEvi(String companyID, String currencyId, boolean isLeaf) throws EASBizException, BOSException {
        return FundsMoveBillHandler.getAccountViewEvi(companyID, currencyId, isLeaf, false);
    }

    public static void initAccountBank(IUIObject coreui, KDBizPromptBox prmtAcct) {
        prmtAcct.getQueryAgent().resetRuntimeEntityView();
        EntityViewInfo entryViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0), CompareType.EQUALS));
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString(), CompareType.EQUALS));
        entryViewInfo.setFilter(filter);
        prmtAcct.setEntityViewInfo(entryViewInfo);
        prmtAcct.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
        prmtAcct.setDisplayFormat("$number$ $name$");
        prmtAcct.setEditFormat("$number$");
        prmtAcct.setCommitFormat("$number$;$name$");
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("bank.*");
        selectors.add("account.*");
        selectors.add("ctrlStrategy.*");
        prmtAcct.setSelectorCollection(selectors);
    }

    public static void initAccountBank(IUIObject coreui, KDBizPromptBox prmtAcct, String currencyID) {
        prmtAcct.getQueryAgent().resetRuntimeEntityView();
        EntityViewInfo entryViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0), CompareType.EQUALS));
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", null, CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and (#2 or #3)");
        entryViewInfo.setFilter(filter);
        prmtAcct.setEntityViewInfo(entryViewInfo);
        prmtAcct.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
        prmtAcct.setDisplayFormat("$number$ $name$");
        prmtAcct.setEditFormat("$number$");
        prmtAcct.setCommitFormat("$number$;$name$");
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("bank.*");
        selectors.add("account.*");
        selectors.add("ctrlStrategy.*");
        prmtAcct.setSelectorCollection(selectors);
    }

    public static void main(String[] args) {
    }

    public static void verifyDirectionMatch(CoreUIObject ui, KDFormattedTextField txt1, KDFormattedTextField txt2) {
        BigDecimal value2;
        String path = "com.kingdee.eas.fm.common.FMResource";
        if (txt1.getBigDecimalValue() == null || txt2.getBigDecimalValue() == null) {
            return;
        }
        BigDecimal value1 = txt1.getBigDecimalValue();
        if (FMConstants.ZERO.compareTo(value1.multiply(value2 = txt2.getBigDecimalValue())) > 0) {
            txt1.requestFocus(true);
            String aText = FundsMoveBillHandler.getCompLabelText((Component)txt1);
            String bText = FundsMoveBillHandler.getCompLabelText((Component)txt2);
            String msg = MessageFormat.format(EASResource.getString((String)path, (String)"dirctSame"), aText, bText);
            MsgBox.showWarning((Component)ui, (String)msg);
            SysUtil.abort();
        }
    }

    private static String getCompLabelText(Component component) {
        Container cont2;
        Container cont;
        String text = "";
        if (component.getParent() instanceof KDLabelContainer) {
            text = ((KDLabelContainer)component.getParent()).getBoundLabelText();
        } else if (component instanceof KDTextArea && (cont = component.getParent()) != null && (cont2 = cont.getParent()) instanceof KDScrollPane && cont2.getParent() instanceof KDLabelContainer) {
            text = ((KDLabelContainer)cont2.getParent()).getBoundLabelText();
        }
        return text;
    }
}

