/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.FundsMoveBillCollection;
import com.kingdee.eas.fi.cas.FundsMoveBillFactory;
import com.kingdee.eas.fi.cas.FundsMoveBillInfo;
import com.kingdee.eas.fi.cas.FundsMoveBillProcess;
import com.kingdee.eas.fi.cas.FundsMoveBillStateEnum;
import com.kingdee.eas.fi.cas.FundsMoveException;
import com.kingdee.eas.fi.cas.IFundsMoveBill;
import com.kingdee.eas.fi.cas.client.AbstractFundsMoveBillListUI;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fi.cas.client.FundsMoveBillEditUI;
import com.kingdee.eas.fi.cas.client.FundsMoveBillFilterUI;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fee.FeeBillInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.util.CommonDataProvider;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class FundsMoveBillListUI
extends AbstractFundsMoveBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(FundsMoveBillListUI.class);
    private static final String MOVEOUT_LOCRATE = "moveOutLocRate";
    private static final String MOVEOUT_LOCAMT = "moveOutLocAmt";
    private static final String MOVEOUT_AMOUNT = "moveOutAmount";
    private static final String EXCHANGERATE = "exchangeRate";
    private static final String MOVEIN_AMOUNT = "moveInAmount";
    private static final String MOVEIN_LOCRATE = "moveInLocRate";
    private static final String MOVEIN_LOCAMT = "moveInLocAmt";
    private static final String FEE_AMOUNT = "feeAmount";
    private static final String FEE_LOCAMT = "feeLocAmount";
    private static final String INCOME = "income";
    private static final String MOVEOUT_CURRENCY_ID = "moveOutCurrency.id";
    private static final String MOVEIN_CURRENCY_ID = "MoveInCurrency.id";
    private static final String FEE_CURRENCY_ID = "feeCurrency.id";
    private static final String FundsMoveBillResource = "com.kingdee.eas.fi.cas.FundsMoveBillResource";
    private FundsMoveBillFilterUI filterUI = null;
    protected CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    String baseNumberFormat = FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)this.currentCompany.getBaseCurrency().getId().toString()));

    public FundsMoveBillListUI() throws Exception {
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)new FillListener());
    }

    public void onLoad() throws Exception {
        ClientUtils.checkCompany((Component)((Object)this), this.currentCompany);
        super.onLoad();
        this.tblMain.getColumn("id").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("moveInBankAcct.bankAcctNum").getStyleAttributes().setNumberFormat("@");
        this.tblMain.getColumn("moveOutBankAcct.bankAcctNum").getStyleAttributes().setNumberFormat("@");
        this.tblMain.getColumn("feeBankAcct.bankAcctNum").getStyleAttributes().setNumberFormat("@");
        this.onshows();
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        this.menuItemSaveBatch.setAccelerator(KeyStroke.getKeyStroke("ctrl S"));
        this.menuItemAudit.setAccelerator(KeyStroke.getKeyStroke("ctrl alt A"));
        this.menuItemAntiAudit.setAccelerator(KeyStroke.getKeyStroke("alt shift A"));
    }

    protected void execQuery() {
        if (this.getUIContext().get("DapMultiBillListUIFlag") != null) {
            FilterInfo filter = new FilterInfo();
            HashSet<String> companyIdSet = new HashSet<String>();
            try {
                IPermission iPermission = PermissionFactory.getRemoteInstance();
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("unit.isOUSealUp", (Object)"0"));
                viewInfo.setFilter(filterInfo);
                FullOrgUnitCollection mainOrgs = iPermission.getAuthorizedOrg(this.getUserPk(), OrgType.Company, null, "fi_cas_fundsmove_01view", viewInfo);
                for (int i = 0; i < mainOrgs.size(); ++i) {
                    companyIdSet.add(mainOrgs.get(i).getId().toString());
                }
                filter.getFilterItems().add(new FilterItemInfo("company.id", companyIdSet, CompareType.INCLUDE));
                this.mainQuery.getFilter().mergeFilter(filter, "AND");
            }
            catch (BOSException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
            catch (EASBizException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
        }
        super.execQuery();
        this.onshows();
    }

    public void onshows() {
        this.tblMain.getColumn(FEE_LOCAMT).getStyleAttributes().setNumberFormat(this.baseNumberFormat);
        this.tblMain.getColumn(MOVEOUT_LOCAMT).getStyleAttributes().setNumberFormat(this.baseNumberFormat);
        this.tblMain.getColumn(MOVEIN_LOCAMT).getStyleAttributes().setNumberFormat(this.baseNumberFormat);
        this.tblMain.getColumn(INCOME).getStyleAttributes().setNumberFormat(this.baseNumberFormat);
    }

    public void actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.onshows();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new FundsMoveBillFilterUI();
        }
        return this.filterUI;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_audit"));
        this.actionAntiAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.actionSettle.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_dengzsetting"));
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_dysz"));
        this.actionSaveBatch.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_submit"));
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        this.checkSelected();
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue()));
        FundsMoveBillInfo info = FundsMoveBillFactory.getRemoteInstance().getFundsMoveBillInfo((IObjectPK)pk);
        this.setActionEnabled(info);
    }

    private void setActionEnabled(FundsMoveBillInfo info) {
        boolean isSaveState = info.getBillState().equals((Object)FundsMoveBillStateEnum.saved);
        boolean isSubmitState = info.getBillState().equals((Object)FundsMoveBillStateEnum.submited);
        boolean isAuditState = info.getBillState().equals((Object)FundsMoveBillStateEnum.audited);
        boolean isSettleState = info.getBillState().equals((Object)FundsMoveBillStateEnum.settled);
        boolean isVoucher = info.isFiVouchered();
        this.actionVoucher.setEnabled(true);
        this.actionRemove.setEnabled(isSaveState || isSubmitState);
        this.actionEdit.setEnabled(isSaveState || isSubmitState);
        this.actionAudit.setEnabled(isSubmitState && !isAuditState);
        this.actionAntiAudit.setEnabled(isAuditState && !isVoucher);
        this.actionSettle.setEnabled(isAuditState && !isSettleState);
        this.actionAntiSettle.setEnabled(isSettleState);
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0 || this.getTDQueryPK() == null || this.getTDFileName() == null) {
            return;
        }
        if (idList == null || idList.size() == 0) {
            return;
        }
        CommonDataProvider data = new CommonDataProvider((List)idList, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.cas.FundsMoveBillTDQuery"));
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0 || this.getTDQueryPK() == null || this.getTDFileName() == null) {
            return;
        }
        if (idList == null || idList.size() == 0) {
            return;
        }
        CommonDataProvider data = new CommonDataProvider((List)idList, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.cas.FundsMoveBillTDQuery"));
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.fi.cas.FundsMoveBillTDQuery");
    }

    protected String getTDFileName() {
        return "/FI/CAS/FUNDSMOVEBILL";
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAudit_actionPerformed(e);
        this.checkSelected();
        ArrayList pks = this.getSelectedIdValues();
        Set set = FMHelper.list2Set((List)pks);
        boolean hasWfInstance = FMHelper.hasWFInstance(null, (List)pks);
        if (hasWfInstance) {
            this.actionMultiapprove_actionPerformed(e);
            return;
        }
        FundsMoveBillFactory.getRemoteInstance().audit(set);
        this.setMessageText(EASResource.getString((String)FundsMoveBillResource, (String)"OprtSucc"));
        this.showMessage();
        this.refresh(e);
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAntiAudit_actionPerformed(e);
        this.checkSelected();
        ArrayList pks = this.getSelectedIdValues();
        Set set = FMHelper.list2Set((List)pks);
        FundsMoveBillFactory.getRemoteInstance().antiAudit(set);
        this.setMessageText(EASResource.getString((String)FundsMoveBillResource, (String)"OprtSucc"));
        this.showMessage();
        this.refresh(e);
    }

    @Override
    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        FMClientHelper.checkIsAdjustPeriod((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompany);
        String id = this.getSelectedKeyValue();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        FundsMoveBillInfo info = ((IFundsMoveBill)this.getBillInterface()).getFundsMoveBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        iPermission.checkFunctionPermission(this.getUserPk(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()), "fi_cas_fundsmove_03AddNew");
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"COPY", (Object)"COPY");
        this.prepareUIContext(uiContext, e);
        uiContext.put((Object)"IDList", null);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    @Override
    public void actionAntiSettle_actionPerformed(ActionEvent e) throws Exception {
        super.actionAntiSettle_actionPerformed(e);
        this.checkSelected();
        ArrayList pks = this.getSelectedIdValues();
        Set set = FMHelper.list2Set((List)pks);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("fiVouchered");
        view.setSelector(sic);
        FundsMoveBillCollection fundsMoveBills = FundsMoveBillFactory.getRemoteInstance().getFundsMoveBillCollection(view);
        ArrayList<String> antiSettles = new ArrayList<String>();
        String fail = EASResource.getString((String)FundsMoveBillResource, (String)"8_billnum");
        for (int i = 0; i < fundsMoveBills.size(); ++i) {
            FundsMoveBillInfo fundsMoveBill = fundsMoveBills.get(i);
            if (fundsMoveBill.isFiVouchered()) {
                fail = fail + fundsMoveBill.getNumber() + "\u3001";
                continue;
            }
            antiSettles.add(fundsMoveBill.getId().toString());
        }
        if (fundsMoveBills.size() != antiSettles.size()) {
            String msg = EASResource.getString((String)FundsMoveBillResource, (String)"9_FundsMoveBillListUI");
            MsgBox.showInfo((String)(fail.substring(0, fail.length() - 1) + msg));
        }
        if (antiSettles.size() > 0) {
            FundsMoveBillFactory.getRemoteInstance().antiSettle(FMHelper.list2Set(antiSettles));
        }
        this.setMessageText(EASResource.getString((String)FundsMoveBillResource, (String)"OprtSucc"));
        this.showMessage();
        this.refresh(e);
    }

    @Override
    public void actionSettle_actionPerformed(ActionEvent e) throws Exception {
        super.actionSettle_actionPerformed(e);
        this.checkSelected();
        ArrayList pks = this.getSelectedIdValues();
        Set set = FMHelper.list2Set((List)pks);
        FundsMoveBillFactory.getRemoteInstance().settle(set);
        this.setMessageText(EASResource.getString((String)FundsMoveBillResource, (String)"OprtSucc"));
        this.showMessage();
        this.refresh(e);
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue()));
        FundsMoveBillInfo info = FundsMoveBillFactory.getRemoteInstance().getFundsMoveBillInfo((IObjectPK)pk);
        if (info.getBillState() == FundsMoveBillStateEnum.saved || info.getBillState() == FundsMoveBillStateEnum.submited) {
            throw new FundsMoveException(FundsMoveException.NOT_AUDITED_CANT_VOURCHER);
        }
        super.actionVoucher_actionPerformed(e);
        this.refresh(e);
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue()));
        FundsMoveBillInfo info = FundsMoveBillFactory.getRemoteInstance().getFundsMoveBillInfo((IObjectPK)pk);
        if (info.getBillState() != FundsMoveBillStateEnum.audited && info.getBillState() != FundsMoveBillStateEnum.settled) {
            throw new FundsMoveException(FundsMoveException.NOT_AUDIT_CANT_CREATETO);
        }
        if (info.getFeeAmount() != null && info.getFeeAmount().compareTo(Constants.ZERO) != 0) {
            throw new FundsMoveException(FundsMoveException.FEEAMOUNT_NOT_ZERO);
        }
        FMClientHelper.generateDestBill((CoreBillListUI)this, (String)new FundsMoveBillInfo().getBOSType().toString(), (String)new FeeBillInfo().getBOSType().toString(), (String)pk.toString());
    }

    public boolean isNeedShowBOTPRule() {
        return true;
    }

    protected String getEditUIName() {
        return FundsMoveBillEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FundsMoveBillFactory.getRemoteInstance();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        FMClientHelper.checkIsAdjustPeriod((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompany);
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue()));
        FundsMoveBillInfo info = FundsMoveBillFactory.getRemoteInstance().getFundsMoveBillInfo((IObjectPK)pk);
        if (info.getBillState() == FundsMoveBillStateEnum.audited || info.getBillState() == FundsMoveBillStateEnum.settled) {
            throw new FundsMoveException(FundsMoveException.AUDITED_BILL_CANT_UPDATE);
        }
        super.actionEdit_actionPerformed(e);
    }

    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = super.getBOTPSelectors();
        sic.add("moveOutBankAccount.id");
        sic.add("moveOutBankAccount.name");
        sic.add("moveOutBankAccount.number");
        sic.add("moveOutBankAccount.bankAccountNumber");
        sic.add("moveOutAccountView.id");
        sic.add("moveOutAccountView.name");
        sic.add("moveOutAccountView.number");
        sic.add("company.id");
        return sic;
    }

    protected CommonQueryProcessor getQueryProcessor() {
        return new FundsMoveBillProcess();
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = super.getFilterInfo();
        if (this.getUIContext().get("BTPEDITPARAMETER") != null) {
            if (((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("filterInfo") != null) {
                return (FilterInfo)((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("filterInfo");
            }
            if (((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("DefaultQueryFilter") != null) {
                return (FilterInfo)((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("DefaultQueryFilter");
            }
        }
        return filter;
    }

    @Override
    public void actionSaveBatch_actionPerformed(ActionEvent e) throws Exception {
        this.batchSaveServer(e);
    }

    private void batchSaveServer(ActionEvent e) throws Exception {
        this.checkSelected();
        try {
            ((IFundsMoveBill)this.getBillInterface()).saveBatch(this.getSelectedIdValues());
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            MsgBox.showInfo((Component)((Object)this), (String)ex.getMessage());
            SysUtil.abort();
        }
        this.execQuery();
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"238_AgentPayBillListUI"));
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        FMClientHelper.checkIsAdjustPeriod((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompany);
        super.actionAddNew_actionPerformed(e);
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            if (e == null) {
                return;
            }
            IRow currentRow = null;
            String moveOutCurrencyID = null;
            String moveInCurrencyID = null;
            String feeCurrencyID = null;
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                currentRow = FundsMoveBillListUI.this.tblMain.getRow(i);
                moveOutCurrencyID = (String)currentRow.getCell(FundsMoveBillListUI.MOVEOUT_CURRENCY_ID).getValue();
                moveInCurrencyID = (String)currentRow.getCell(FundsMoveBillListUI.MOVEIN_CURRENCY_ID).getValue();
                feeCurrencyID = (String)currentRow.getCell(FundsMoveBillListUI.FEE_CURRENCY_ID).getValue();
                if (moveOutCurrencyID != null) {
                    FMClientHelper.setNumberFormat((IRow)currentRow, (String)FundsMoveBillListUI.MOVEOUT_AMOUNT, (String)moveOutCurrencyID);
                }
                if (moveInCurrencyID != null) {
                    FMClientHelper.setNumberFormat((IRow)currentRow, (String)FundsMoveBillListUI.MOVEIN_AMOUNT, (String)moveInCurrencyID);
                }
                if (feeCurrencyID != null) {
                    FMClientHelper.setNumberFormat((IRow)currentRow, (String)FundsMoveBillListUI.FEE_AMOUNT, (String)feeCurrencyID);
                }
                FMClientHelper.setActualDigitNumberFormat((ICell)currentRow.getCell(FundsMoveBillListUI.EXCHANGERATE));
                FMClientHelper.setActualDigitNumberFormat((ICell)currentRow.getCell(FundsMoveBillListUI.MOVEOUT_LOCRATE));
                FMClientHelper.setActualDigitNumberFormat((ICell)currentRow.getCell(FundsMoveBillListUI.MOVEIN_LOCRATE));
            }
        }
    }
}

