/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.CasForArApUtil;
import com.kingdee.eas.fi.cas.CasMutexUtils;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.client.AbstractInitPaymentBillListUI;
import com.kingdee.eas.fi.cas.client.ArApRecPayHelper;
import com.kingdee.eas.fi.cas.client.ArApRecPayLogic;
import com.kingdee.eas.fi.cas.client.ArApRecPayQueryProcessor;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fi.cas.client.PaymentBillUI;
import com.kingdee.eas.fi.cas.client.PaymentFilterUI;
import com.kingdee.eas.fi.cas.client.PaymentHandler;
import com.kingdee.eas.fi.cas.client.RecPayHandler;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.ExportHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.util.CommonDataProvider;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.Uuid;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class InitPaymentBillListUI
extends AbstractInitPaymentBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(InitPaymentBillListUI.class);
    private CompanyOrgUnitInfo companyInfo;
    private PaymentFilterUI filterUI;
    private RecPayHandler handler = new PaymentHandler();
    private ArApRecPayLogic arapLogic = new ArApRecPayLogic();
    private boolean isStart = false;
    private final BOSObjectType billBosType = BOSObjectType.create((String)"40284E81");
    private CommonQueryDialog queryDlg = null;
    private String[] amountFields = new String[]{"actAmt", "actLocAmt", "entries.payAmt", "entries.rebate", "entries.actPayAmt", "entries.actPayAmtVc", "verifiedAmt", "unVerifiedAmt", "entries.recAmtVc", "entries.payAmtVc", "entries.payAmtUnVc", "entries.recAmtUnVc"};
    protected ArApRecPayHelper arapHelper = new ArApRecPayHelper();
    public static final String PAYMENTBILL_FILENAME = "/FI/CAS/PAYMENTBILL";
    FillListener fillListener = new FillListener();

    private String[] getVisibleFields() {
        return new String[]{"companyName", "number", "billStatus", "bizDate", "payeeType", "payeeName", "currency.name", "payType", "settleTypeName", "settleNumber", "payerAccountBank", "payerBank", "actAmt", "entries.payAmt", "entries.rebate", "entries.actPayAmt"};
    }

    public FilterParam getDefalutQueryParam() {
        return null;
    }

    public void onLoad() throws Exception {
        if (this.companyInfo == null) {
            this.companyInfo = ClientUtils.getCurrLoginCompany();
        }
        this.initUIMainOrgContext(this.companyInfo.getId().toString());
        this.isStart = SystemStatusCtrolUtils.isStart(null, (SystemEnum)SystemEnum.ACCOUNTSPAYABLE, (CompanyOrgUnitInfo)this.companyInfo);
        super.onLoad();
        this.setWorkButtonStatus();
        this.arapLogic.freeze(this.tblMain);
        this.setDateDisplay();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        uiContext.put((Object)"UIClassParam", (Object)"isInitBill");
        super.prepareUIContext(uiContext, e);
    }

    private void setWorkButtonStatus() {
        this.actionAddNew.setEnabled(!this.isStart);
        this.actionCopy.setEnabled(!this.isStart);
        this.actionEdit.setEnabled(!this.isStart);
        this.actionRemove.setEnabled(!this.isStart);
        this.btnAddNew.setEnabled(!this.isStart);
        this.btnEdit.setEnabled(!this.isStart);
        this.btnRemove.setEnabled(!this.isStart);
        this.actionCreateTo.setVisible(false);
        this.actionCopyTo.setVisible(false);
        this.actionAudit.setVisible(false);
        this.actionAntiAudit.setVisible(false);
        this.actionCommitSettle.setVisible(false);
        this.actionPay.setVisible(false);
        this.actionCancelPay.setVisible(false);
        this.actionVoucher.setVisible(false);
        this.actionDelVoucher.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.actionWorkFlowG.setVisible(false);
        this.menuWorkFlow.setVisible(false);
        this.menuBiz.setVisible(false);
        this.separatorFW1.setVisible(false);
        this.separatorFW2.setVisible(false);
        this.separatorFW3.setVisible(false);
        this.separatorFW4.setVisible(false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnCopy.setIcon(EASResource.getIcon((String)"imgTbtn_copy"));
        this.menuItemCopy.setIcon(EASResource.getIcon((String)"imgTbtn_copy"));
        this.setButtonDefaultStyl(this.btnCopy);
        this.menuItemMultiPrint.setIcon(EASResource.getIcon((String)"imgTbtn_printcontinue"));
        this.menuItemMultiPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_printpreview"));
        this.menuItemBatchSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_referbatch"));
        this.btnBatchSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_referbatch"));
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new PaymentFilterUI(true, SourceTypeEnum.AP);
        }
        return this.filterUI;
    }

    protected CommonQueryDialog getQueryDlg() throws Exception {
        CommonQueryDialog queryDlg = super.getQueryDlg();
        queryDlg.setWidth(424);
        queryDlg.setHeight(310);
        queryDlg.setVisibleTableCols(this.getVisibleFields());
        return queryDlg;
    }

    protected CommonQueryProcessor getQueryProcessor() {
        return new ArApRecPayQueryProcessor((IUIObject)this, this.companyInfo, SourceTypeEnum.AP, true);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PaymentBillFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return PaymentBillUI.class.getName();
    }

    private void setListUITablePrecision(int start, int end) {
        for (int i = start; i <= end; ++i) {
            IRow row = this.tblMain.getRow(i);
            int precision = 2;
            ICell cell = row.getCell("currency.precision");
            if (cell != null && cell.getValue() != null) {
                precision = Integer.parseInt(cell.getValue().toString());
            }
            for (int j = 0; j < this.amountFields.length; ++j) {
                CasForArApUtil.setPrecision(row.getCell(this.amountFields[j]), precision);
            }
        }
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    protected void execQuery() {
        CompanyOrgUnitInfo company = this.filterUI.getCompanyInfo();
        if (company != null) {
            this.initUIMainOrgContext(company.getId().toString());
        }
        if (!this.isHaveFilterItem("IsInitializeBill")) {
            this.mainQuery.getFilter().getFilterItems().add(new FilterItemInfo("IsInitializeBill", (Object)true));
            int size = this.mainQuery.getFilter().getFilterItems().size();
            String maskString = this.mainQuery.getFilter().getMaskString();
            if (size > 1 && maskString != null) {
                StringBuffer newMaskString = new StringBuffer();
                newMaskString.append("(").append(maskString).append(" AND #").append(size - 1).append(")");
                this.mainQuery.getFilter().setMaskString(newMaskString.toString());
            }
        }
        super.execQuery();
        this.setWorkButtonStatus();
    }

    private boolean isHaveFilterItem(String item) {
        FilterItemCollection filterCol = this.mainQuery.getFilter().getFilterItems();
        if (filterCol == null) {
            return false;
        }
        int size = filterCol.size();
        for (int i = 0; i < size; ++i) {
            FilterItemInfo filterItem = filterCol.get(i);
            if (!filterItem.getPropertyName().equalsIgnoreCase(item)) continue;
            return true;
        }
        return false;
    }

    public String[] getMergeColumnKeys() {
        return this.handler.getMergeColumnKeys("pay");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        Uuid mutexID = Uuid.create();
        MutexParameter mutext = CasMutexUtils.getAPInitShareMutextPara(null, null, mutexID, SysContext.getSysContext().getCurrentFIUnit().getId(), SysContext.getSysContext().getCurrentUserInfo().getId());
        if (CasMutexUtils.requestMutex(null, mutext)) {
            try {
                super.actionAddNew_actionPerformed(e);
            }
            finally {
                CasMutexUtils.releaseMutex(null, mutexID);
            }
        } else {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"mutexErr_AP_Init"));
        }
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
        String boID = this.getSelectedKeyValue();
        if (boID == null) {
            return;
        }
        boolean isEdit = true;
        int rowNumber = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(rowNumber);
        int billStatus = ((BizEnumValueInfo)row.getCell("billStatus").getValue()).getInt();
        if (billStatus >= 12) {
            isEdit = false;
        }
        acm.showAttachmentListUIByBoID(boID, (Object)this, isEdit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        ((IPaymentBill)this.getBizInterface()).checkIsCanEditInit(id);
        Uuid mutexID = Uuid.create();
        MutexParameter mutext = CasMutexUtils.getAPInitShareMutextPara(null, null, mutexID, SysContext.getSysContext().getCurrentFIUnit().getId(), SysContext.getSysContext().getCurrentUserInfo().getId());
        if (CasMutexUtils.requestMutex(null, mutext)) {
            try {
                super.actionEdit_actionPerformed(e);
            }
            finally {
                CasMutexUtils.releaseMutex(null, mutexID);
            }
        } else {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"mutexErr_AP_Init"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        ArApRecPayHelper.requestPureMutex(idList);
        Uuid mutexID = Uuid.create();
        MutexParameter mutext = CasMutexUtils.getAPInitShareMutextPara(null, null, mutexID, SysContext.getSysContext().getCurrentFIUnit().getId(), SysContext.getSysContext().getCurrentUserInfo().getId());
        if (CasMutexUtils.requestMutex(null, mutext)) {
            try {
                super.actionRemove_actionPerformed(e);
            }
            finally {
                CasMutexUtils.releaseMutex(null, mutexID);
            }
        } else {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"mutexErr_AP_Init"));
        }
        ArApRecPayHelper.releasePureMutex(idList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionBatchSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionBatchSubmit_actionPerformed(e);
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        Set idSet = FMHelper.list2Set((List)idList);
        ArApRecPayHelper.requestPureMutex(idList);
        Uuid mutexID = Uuid.create();
        MutexParameter mutext = CasMutexUtils.getAPInitShareMutextPara(null, null, mutexID, SysContext.getSysContext().getCurrentFIUnit().getId(), SysContext.getSysContext().getCurrentUserInfo().getId());
        if (CasMutexUtils.requestMutex(null, mutext)) {
            try {
                Class[] clz = new Class[]{Set.class};
                ArApRecPayHelper.batchOperaction((ListUI)this, idSet, this.getBizInterface(), this.getBOSEntity().getAlias(), this.btnBatchSubmit.getToolTipText(), "submit", clz);
            }
            finally {
                CasMutexUtils.releaseMutex(null, mutexID);
            }
        } else {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"mutexErr_AP_Init"));
        }
        ArApRecPayHelper.releasePureMutex(idList);
        this.execQuery();
    }

    public EntityObjectInfo getBOSEntity() throws Exception {
        return MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(this.getBizType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkObjectExists();
        Uuid mutexID = Uuid.create();
        MutexParameter mutext = CasMutexUtils.getAPInitShareMutextPara(null, null, mutexID, SysContext.getSysContext().getCurrentFIUnit().getId(), SysContext.getSysContext().getCurrentUserInfo().getId());
        if (CasMutexUtils.requestMutex(null, mutext)) {
            try {
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
                uiContext.put((Object)"COPY", (Object)"COPY");
                this.prepareUIContext(uiContext, e);
                uiContext.put((Object)"IDList", null);
                IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW);
                uiWindow.show();
            }
            finally {
                CasMutexUtils.releaseMutex(null, mutexID);
            }
        } else {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"mutexErr_AP_Init"));
        }
    }

    private void checkObjectExists() throws Exception {
        if (this.getSelectedKeyValue() == null) {
            return;
        }
        if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())))) {
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        CompanyOrgUnitInfo currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        CasForArApUtil.checkCompany((Component)((Object)this), currentCompany);
        IObjectPK pkOut = LogUtil.beginLog(null, (String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ArApBillResource", (String)"log_import"), (BOSObjectType)this.billBosType, null, (String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ArApBillResource", (String)"log_import"));
        super.actionImportData_actionPerformed(e);
        LogUtil.afterLog(null, (IObjectPK)pkOut);
    }

    protected ArrayList getImportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "InitPaymentBill";
        param.alias = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"357_InitPaymentBillListUI");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        ExportHelper.export((Component)((Object)this), (KDTable)this.tblMain);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.actionVoucher.setVisible(false);
        this.actionDelVoucher.setVisible(false);
        this.separatorFW4.setVisible(false);
        this.isStart = SystemStatusCtrolUtils.isStart(null, (SystemEnum)SystemEnum.ACCOUNTSPAYABLE, (CompanyOrgUnitInfo)this.companyInfo);
        this.setWorkButtonStatus();
    }

    protected boolean isVoucherVisible() {
        return false;
    }

    @Override
    public void actionMultiPrint_actionPerformed(ActionEvent e) throws Exception {
        this.invokeMultiPrintFunction(true);
    }

    @Override
    public void actionMultiPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.invokeMultiPrintFunction(false);
    }

    private void checkBillIsAudited(ArrayList idList) throws Exception {
        String id = null;
        int billStatus = 0;
        IPaymentBill iPaymentBill = PaymentBillFactory.getRemoteInstance();
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            id = idList.get(i).toString();
            billStatus = iPaymentBill.getBillStatus(id);
            if (billStatus >= 15) continue;
            MsgBox.showInfo((Component)((Object)this), (String)InitPaymentBillListUI.getStrResource("bill_not_audited"));
            SysUtil.abort();
        }
    }

    private static String getStrResource(String resKey) {
        return EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)resKey);
    }

    protected void invokeMultiPrintFunction(boolean isPrint) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() == 0 || this.getTDQueryPK() == null || this.getTDFileName() == null) {
            return;
        }
        CommonDataProvider data = new CommonDataProvider((List)idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        if (isPrint) {
            appHlp.print(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.printPreview(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    protected String getTDFileName() {
        return PAYMENTBILL_FILENAME;
    }

    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.fi.cas.PaymentBillTDQuery");
    }

    protected boolean isFootVisible() {
        return true;
    }

    private void setDateDisplay() {
        String fmt = CtrlFormatUtilities.getDateFormatString();
        String dateTimeFmt = CtrlFormatUtilities.getDateTimeFormatString();
        this.tblMain.getColumn("createDate").getStyleAttributes().setNumberFormat(dateTimeFmt);
        this.tblMain.getColumn("updateDate").getStyleAttributes().setNumberFormat(fmt);
        this.tblMain.getColumn("auditDate").getStyleAttributes().setNumberFormat(fmt);
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            InitPaymentBillListUI.this.setListUITablePrecision(e.getFirstRow(), e.getLastRow());
        }
    }
}

