/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.noteprint.util.NotePrtRecordUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.CasForArApUtil;
import com.kingdee.eas.fi.cas.CasMutexUtils;
import com.kingdee.eas.fi.cas.IReceivingBill;
import com.kingdee.eas.fi.cas.ReceivingBillEntryCollection;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.client.AbstractInitReceivingBillListUI;
import com.kingdee.eas.fi.cas.client.ArApRecPayHelper;
import com.kingdee.eas.fi.cas.client.ArApRecPayLogic;
import com.kingdee.eas.fi.cas.client.ArApRecPayQueryProcessor;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fi.cas.client.RecPayHandler;
import com.kingdee.eas.fi.cas.client.ReceivingBillUI;
import com.kingdee.eas.fi.cas.client.ReceivingFilterUI;
import com.kingdee.eas.fi.cas.client.ReceivingHandler;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.ExportHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreBillEditUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.util.CommonDataProvider;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.Uuid;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class InitReceivingBillListUI
extends AbstractInitReceivingBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(InitReceivingBillListUI.class);
    private CompanyOrgUnitInfo companyInfo;
    private ReceivingFilterUI filterUI;
    private RecPayHandler handler = new ReceivingHandler();
    private ArApRecPayLogic arapLogic = new ArApRecPayLogic();
    protected UserInfo currentUser = null;
    protected boolean isInitBill = false;
    private boolean isStart = false;
    private static final String Arap_RecPayResource = "com.kingdee.eas.fi.ar.ARRecPayResource";
    protected ArApRecPayHelper arapHelper = new ArApRecPayHelper();
    private CommonQueryDialog queryDlg = null;
    private String[] amountFields = new String[]{"actAmt", "actLocAmt", "entries.recAmt", "entries.rebate", "entries.actRecAmt", "entries.actRecAmtVc", "verifiedAmt", "unVerifiedAmt", "entries.recAmtVc", "entries.recAmtUnVc"};
    FillListener fillListener = new FillListener();
    public static final String RECEIVINGBILL_FILENAME = "/FI/CAS/RECEIVINGBILL";
    public static final String templatePath = "/FI/CAS/RECEIVINGBILL";
    private final BOSObjectType billBosType = BOSObjectType.create((String)"FA44FD5B");

    private String[] getVisibleFields() {
        return new String[]{"companyName", "number", "billStatus", "bizDate", "payerType", "payerName", "currency.name", "recType", "settleTypeName", "settleNumber", "payeeAccountBank", "payeeBank", "actAmt", "entryRecBillType", "entries.recAmt", "entries.rebate", "entries.actRecAmt"};
    }

    public FilterParam getDefalutQueryParam() {
        return null;
    }

    public void onLoad() throws Exception {
        if (this.companyInfo == null) {
            this.companyInfo = ClientUtils.getCurrLoginCompany();
        }
        this.initUIMainOrgContext(this.companyInfo.getId().toString());
        if (this.currentUser == null) {
            this.currentUser = SysContext.getSysContext().getCurrentUserInfo();
        }
        this.isStart = SystemStatusCtrolUtils.isStart(null, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (CompanyOrgUnitInfo)this.companyInfo);
        super.onLoad();
        this.setWorkButtonStatus();
        this.arapLogic.freeze(this.tblMain);
        this.setDateDisplay();
    }

    private void setWorkButtonStatus() {
        this.actionAddNew.setEnabled(!this.isStart);
        this.actionEdit.setEnabled(!this.isStart);
        this.actionCopy.setEnabled(!this.isStart);
        this.actionRemove.setEnabled(!this.isStart);
        this.btnAddNew.setEnabled(!this.isStart);
        this.btnEdit.setEnabled(!this.isStart);
        this.btnRemove.setEnabled(!this.isStart);
        this.actionCreateTo.setVisible(false);
        this.actionCopyTo.setVisible(false);
        this.actionAudit.setVisible(false);
        this.actionAntiAudit.setVisible(false);
        this.actionCommitSettle.setVisible(false);
        this.actionRec.setVisible(false);
        this.actionCancelRec.setVisible(false);
        this.actionVoucher.setVisible(false);
        this.actionDelVoucher.setVisible(false);
        this.actionWorkFlowG.setVisible(false);
        this.menuWorkFlow.setVisible(false);
        this.separatorFW1.setVisible(false);
        this.separatorFW2.setVisible(false);
        this.separatorFW3.setVisible(false);
        this.separatorFW4.setVisible(false);
        this.separatorView1.setVisible(false);
        this.separatorWF1.setVisible(false);
        this.separatorFile1.setVisible(false);
        this.separator1.setVisible(false);
        this.actionAuditResult.setVisible(false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnCopy.setIcon(EASResource.getIcon((String)"imgTbtn_copy"));
        this.setButtonDefaultStyl(this.btnCopy);
        this.menuItemCopy.setIcon(EASResource.getIcon((String)"imgTbtn_copy"));
        this.btnTrans.setIcon(EASResource.getIcon((String)"imgTbtn_conversionsave"));
        this.menuItemTrans.setIcon(EASResource.getIcon((String)"imgTbtn_conversionsave"));
        this.menuItemMultiPrint.setIcon(EASResource.getIcon((String)"imgTbtn_printcontinue"));
        this.menuItemMultiPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_printpreview"));
        this.menuItemBatchSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_referbatch"));
        this.btnBatchSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_referbatch"));
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        uiContext.put((Object)"UIClassParam", (Object)"isInitBill");
        super.prepareUIContext(uiContext, e);
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new ReceivingFilterUI(true, SourceTypeEnum.AR);
        }
        return this.filterUI;
    }

    protected CommonQueryDialog getQueryDlg() throws Exception {
        this.queryDlg = super.getQueryDlg();
        this.queryDlg.setWidth(424);
        this.queryDlg.setHeight(310);
        this.queryDlg.setVisibleTableCols(this.getVisibleFields());
        return this.queryDlg;
    }

    protected CommonQueryProcessor getQueryProcessor() {
        return new ArApRecPayQueryProcessor((IUIObject)this, this.companyInfo, SourceTypeEnum.AR, true);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ReceivingBillFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return ReceivingBillUI.class.getName();
    }

    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("sourceType"));
        sic.add(new SelectorItemInfo("actPayAmt"));
        sic.add(new SelectorItemInfo("actPayLocAmt"));
        sic.add(new SelectorItemInfo("payeeID"));
        sic.add(new SelectorItemInfo("payeeNumber"));
        sic.add(new SelectorItemInfo("payeeName"));
        sic.add(new SelectorItemInfo("payeeBank"));
        sic.add(new SelectorItemInfo("payeeAccountBank"));
        sic.add(new SelectorItemInfo("payeeAccountBank.bankAccountNumber"));
        sic.add(new SelectorItemInfo("exchangeRate"));
        sic.add(new SelectorItemInfo("payerType.*"));
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("settlementStatus"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("payerAccount.name"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("cashier.name"));
        sic.add(new SelectorItemInfo("accountant.name"));
        sic.add(new SelectorItemInfo("handler.name"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("payeeType.name"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.amount"));
        sic.add(new SelectorItemInfo("entries.rebate"));
        sic.add(new SelectorItemInfo("entries.actualAmt"));
        sic.add(new SelectorItemInfo("entries.actualAmtVc"));
        sic.add(new SelectorItemInfo("entries.sourceBillId"));
        sic.add(new SelectorItemInfo("entries.sourceBillEntryId"));
        sic.add(new SelectorItemInfo("entries.vcStatus"));
        sic.add(new SelectorItemInfo("entries.unLockAmt"));
        sic.add(new SelectorItemInfo("entries.unLockLocAmt"));
        sic.add(new SelectorItemInfo("settlementType.id"));
        sic.add(new SelectorItemInfo("settlementNumber"));
        sic.add(new SelectorItemInfo("oppAccount.id"));
        sic.add(new SelectorItemInfo("settleBizType"));
        sic.add(new SelectorItemInfo("isImport"));
        sic.add(new SelectorItemInfo("person.name"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("recBillType.id"));
        sic.add(new SelectorItemInfo("recBillType.number"));
        sic.add(new SelectorItemInfo("recBillType.name"));
        sic.add(new SelectorItemInfo("recBillType.sourceSysType"));
        sic.add(new SelectorItemInfo("payeeAccount.id"));
        sic.add(new SelectorItemInfo("payeeAccount.number"));
        sic.add(new SelectorItemInfo("payeeAccount.name"));
        sic.add(new SelectorItemInfo("settlementType.id"));
        sic.add(new SelectorItemInfo("settlementType.number"));
        sic.add(new SelectorItemInfo("settlementType.name"));
        sic.add(new SelectorItemInfo("settlementType.capitalType"));
        sic.add(new SelectorItemInfo("isTransBill"));
        return sic;
    }

    private void setListUITablePrecision(int start, int end) {
        for (int i = start; i <= end; ++i) {
            IRow row = this.tblMain.getRow(i);
            int precision = 2;
            ICell cell = row.getCell("currency.precision");
            if (cell != null && cell.getValue() != null) {
                precision = Integer.parseInt(cell.getValue().toString());
            }
            for (int j = 0; j < this.amountFields.length; ++j) {
                CasForArApUtil.setPrecision(row.getCell(this.amountFields[j]), precision);
            }
        }
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    protected void execQuery() {
        CompanyOrgUnitInfo company = this.filterUI.getCompanyInfo();
        if (company != null) {
            this.initUIMainOrgContext(company.getId().toString());
        }
        if (!this.isHaveFilterItem("IsInitializeBill")) {
            this.mainQuery.getFilter().getFilterItems().add(new FilterItemInfo("IsInitializeBill", (Object)true));
            int size = this.mainQuery.getFilter().getFilterItems().size();
            String maskString = this.mainQuery.getFilter().getMaskString();
            if (size > 1 && maskString != null) {
                StringBuffer newMaskString = new StringBuffer();
                newMaskString.append("(").append(maskString).append(" AND #").append(size - 1).append(")");
                this.mainQuery.getFilter().setMaskString(newMaskString.toString());
            }
        }
        super.execQuery();
        this.setWorkButtonStatus();
    }

    private boolean isHaveFilterItem(String item) {
        FilterItemCollection filterCol = this.mainQuery.getFilter().getFilterItems();
        if (filterCol == null) {
            return false;
        }
        int size = filterCol.size();
        for (int i = 0; i < size; ++i) {
            FilterItemInfo filterItem = filterCol.get(i);
            if (!filterItem.getPropertyName().equalsIgnoreCase(item)) continue;
            return true;
        }
        return false;
    }

    public String[] getMergeColumnKeys() {
        return this.handler.getMergeColumnKeys("rec");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        Uuid mutexID = Uuid.create();
        MutexParameter mutext = CasMutexUtils.getARInitShareMutextPara(null, null, mutexID, SysContext.getSysContext().getCurrentFIUnit().getId(), SysContext.getSysContext().getCurrentUserInfo().getId());
        if (CasMutexUtils.requestMutex(null, mutext)) {
            try {
                super.actionAddNew_actionPerformed(e);
            }
            finally {
                CasMutexUtils.releaseMutex(null, mutexID);
            }
        } else {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"mutexErr_AR_Init"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        ((IReceivingBill)this.getBizInterface()).checkIsCanEditInit(id);
        Uuid mutexID = Uuid.create();
        MutexParameter mutext = CasMutexUtils.getARInitShareMutextPara(null, null, mutexID, SysContext.getSysContext().getCurrentFIUnit().getId(), SysContext.getSysContext().getCurrentUserInfo().getId());
        if (CasMutexUtils.requestMutex(null, mutext)) {
            try {
                super.actionEdit_actionPerformed(e);
            }
            finally {
                CasMutexUtils.releaseMutex(null, mutexID);
            }
        } else {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"mutexErr_AR_Init"));
        }
    }

    @Override
    public void actionTrans_actionPerformed(ActionEvent e) throws Exception {
        super.actionTrans_actionPerformed(e);
        this.checkSelected();
        this.checkObjectExists();
        if (!this.checkTrans()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)Arap_RecPayResource, (String)"canNotTrans"));
            SysUtil.abort();
        }
        IReceivingBill iReceivingBill = (IReceivingBill)this.getBizInterface();
        ObjectUuidPK pk = new ObjectUuidPK(this.getSelectedKeyValue());
        ReceivingBillInfo receivingBillInfo = iReceivingBill.getReceivingBillInfo((IObjectPK)pk, this.getBOTPSelectors());
        this.makeReceivingBill(receivingBillInfo);
    }

    protected BOTMappingCollection getRulesByDestBill(String aDestBosType, ReceivingBillInfo srcInfo) throws BOTPException, BOSException, Exception {
        IBOTMapping botMapping = BOTMappingFactory.getRemoteInstance();
        BOTMappingCollection botMappingCollection = botMapping.getMappingCollectionForSelect(this.getBillList(), aDestBosType, DefineSysEnum.BTP);
        return botMappingCollection;
    }

    private void makeReceivingBill(ReceivingBillInfo srcBillInfo) throws BOTPException, Exception {
        ReceivingBillEntryInfo destEntryInfo;
        String srcBosType = srcBillInfo.getBOSType().toString();
        String destBillBosType = srcBosType;
        BOTMappingCollection mapBotpRules = this.getRulesByDestBill(destBillBosType, srcBillInfo);
        if (mapBotpRules.size() == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.base.btp.btpResource.mappingInfoNull"));
            SysUtil.abort();
        }
        BOTMappingInfo btpMappingInfo = mapBotpRules.get(0);
        IBTPManager iBTPManager = BTPManagerFactory.getRemoteInstance();
        CoreBillBaseCollection billCollection = new CoreBillBaseCollection();
        billCollection.add((CoreBillBaseInfo)srcBillInfo);
        BTPTransformResult btpResult = iBTPManager.transformWithMutex(billCollection, destBillBosType, (IObjectPK)new ObjectUuidPK(btpMappingInfo.getId().toString()), true);
        ReceivingBillInfo destBillInfo = (ReceivingBillInfo)btpResult.getBills().getObject(0);
        destBillInfo.setCompany(this.companyInfo);
        destBillInfo.setAuditor(this.currentUser);
        destBillInfo.setCreator(this.currentUser);
        destBillInfo.setCashier(this.currentUser);
        destBillInfo.setAuditDate(new Date());
        destBillInfo.setBillStatus(BillStatusEnum.SAVE);
        destBillInfo.setBizDate(DateTimeUtils.truncateDate((Date)new Date()));
        destBillInfo.setCreateTime(new Timestamp(new Date().getTime()));
        destBillInfo.setSourceBillId(srcBillInfo.getId().toString());
        destBillInfo.setRecBillType(srcBillInfo.getRecBillType());
        destBillInfo.setIsTransBill(true);
        ReceivingBillEntryCollection destCol = destBillInfo.getEntries();
        ReceivingBillEntryCollection srcCol = srcBillInfo.getEntries();
        BigDecimal unLockAmtSum = new BigDecimal("0.00");
        for (int i = 0; i < destCol.size(); ++i) {
            destEntryInfo = destCol.get(i);
            ReceivingBillEntryInfo srcEntryInfo = srcCol.get(i);
            destEntryInfo.setSourceBillEntryId(srcEntryInfo.getId().toString());
            destEntryInfo.setSourceBillAsstActID(srcBillInfo.getPayerID());
            if (srcEntryInfo.getUnLockAmt() == null) continue;
            unLockAmtSum = srcEntryInfo.getUnLockAmt().abs().add(unLockAmtSum);
        }
        for (int j = 0; j < destCol.size(); ++j) {
            destEntryInfo = destCol.get(j);
            if (destEntryInfo.getAmount() != null) {
                if (destEntryInfo.getAmount().compareTo(ArApRecPayLogic.ZERO) != 0) continue;
            }
            destCol.removeObject(j);
        }
        if (ArApRecPayLogic.ZERO.compareTo(unLockAmtSum) == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)Arap_RecPayResource, (String)"canNotTrans"));
            SysUtil.abort();
        }
        UIContext map = new UIContext((Object)this);
        map.put("srcBillID", srcBillInfo.getId().toString());
        map.put("InitDataObject", destBillInfo);
        map.put("Owner", this);
        map.put("BOTPViewStatus", new Integer(1));
        map.put("srcBillBOSTypeString", destBillInfo.getBOSType());
        map.put("canResize", "true");
        String destBillEditUIClassName = iBTPManager.getEntityObjectInfoExtendPro(destBillBosType, "editUI");
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(destBillEditUIClassName, (Map)map, null, OprtState.ADDNEW);
        ((CoreBillEditUI)uiWindow.getUIObject()).setMakeRelations(btpResult.getBOTRelationCollection());
        uiWindow.show();
    }

    private boolean checkTrans() {
        String[] keyFieldNames = new String[]{"sourceBillId", "billStatus"};
        Object[] sourceEntryId = this.getCurrentRowValue(keyFieldNames);
        if (sourceEntryId[0] != null && "FC910EF3".equals(BOSUuid.read((String)sourceEntryId[0].toString()).getType())) {
            return false;
        }
        return sourceEntryId[1] == null || ((BizEnumValueInfo)sourceEntryId[1]).getInt() >= 14;
    }

    private Object[] getCurrentRowValue(String[] keyFieldNames) {
        Object[] values = new Object[keyFieldNames.length];
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length > 0) {
            int rowIndex = selectRows[0];
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            for (int i = 0; i < keyFieldNames.length; ++i) {
                Object keyValue;
                ICell cell = row.getCell(keyFieldNames[i]);
                if (cell == null) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                    SysUtil.abort();
                }
                if ((keyValue = cell.getValue()) == null) continue;
                values[i] = keyValue;
            }
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        ArrayList idList = this.getSelectedIdValues();
        ArApRecPayHelper.requestPureMutex(idList);
        Uuid mutexID = Uuid.create();
        MutexParameter mutext = CasMutexUtils.getARInitShareMutextPara(null, null, mutexID, SysContext.getSysContext().getCurrentFIUnit().getId(), SysContext.getSysContext().getCurrentUserInfo().getId());
        if (CasMutexUtils.requestMutex(null, mutext)) {
            try {
                super.actionRemove_actionPerformed(e);
            }
            finally {
                CasMutexUtils.releaseMutex(null, mutexID);
            }
        } else {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"mutexErr_AR_Init"));
        }
        ArApRecPayHelper.releasePureMutex(idList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionBatchSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionBatchSubmit_actionPerformed(e);
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        Set idSet = FMHelper.list2Set((List)idList);
        ArApRecPayHelper.requestPureMutex(idList);
        Uuid mutexID = Uuid.create();
        MutexParameter mutext = CasMutexUtils.getARInitShareMutextPara(null, null, mutexID, SysContext.getSysContext().getCurrentFIUnit().getId(), SysContext.getSysContext().getCurrentUserInfo().getId());
        if (CasMutexUtils.requestMutex(null, mutext)) {
            try {
                Class[] clz = new Class[]{Set.class};
                ArApRecPayHelper.batchOperaction((ListUI)this, idSet, this.getBizInterface(), this.getBOSEntity().getAlias(), this.btnBatchSubmit.getToolTipText(), "submit", clz);
            }
            finally {
                CasMutexUtils.releaseMutex(null, mutexID);
            }
        } else {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"mutexErr_AR_Init"));
        }
        ArApRecPayHelper.releasePureMutex(idList);
        this.execQuery();
    }

    public EntityObjectInfo getBOSEntity() throws Exception {
        return MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(this.getBizType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        Uuid mutexID = Uuid.create();
        MutexParameter mutext = CasMutexUtils.getARInitShareMutextPara(null, null, mutexID, SysContext.getSysContext().getCurrentFIUnit().getId(), SysContext.getSysContext().getCurrentUserInfo().getId());
        if (CasMutexUtils.requestMutex(null, mutext)) {
            try {
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
                uiContext.put((Object)"UIClassParam", (Object)"isInitBill");
                uiContext.put((Object)"COPY", (Object)"COPY");
                this.prepareUIContext(uiContext, e);
                uiContext.put((Object)"IDList", null);
                IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW);
                uiWindow.show();
            }
            finally {
                CasMutexUtils.releaseMutex(null, mutexID);
            }
        } else {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"mutexErr_AR_Init"));
        }
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
        String boID = this.getSelectedKeyValue();
        if (boID == null) {
            return;
        }
        boolean isEdit = true;
        int rowNumber = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(rowNumber);
        int billStatus = ((BizEnumValueInfo)row.getCell("billStatus").getValue()).getInt();
        if (billStatus >= 12) {
            isEdit = false;
        }
        acm.showAttachmentListUIByBoID(boID, (Object)this, isEdit);
    }

    private int PrintBackControl(boolean noPreview) throws Exception {
        int prtControl = 3;
        ArrayList blocks = this.tblMain.getSelectManager().getBlocks();
        for (KDTSelectBlock block : blocks) {
            int top = block.getTop();
            int bottom = block.getBottom();
            for (int rowIndex = top; rowIndex <= bottom; ++rowIndex) {
                IRow row = this.tblMain.getRow(rowIndex);
                int billStatus = ((BizEnumValueInfo)row.getCell("billStatus").getValue()).getInt();
                if (noPreview && (11 == billStatus || 10 == billStatus)) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ArApBillResource", (String)"unAuditedBillNoPrint"));
                    SysUtil.abort();
                }
                ObjectUuidPK pk = new ObjectUuidPK(row.getCell("id").getValue().toString());
                NotePrtRecordUtil.setQueryPK((String)"com.kingdee.eas.base.noteprint.app.PrtRecordQuery");
                if (!NotePrtRecordUtil.isPrintControlEnabled((String)"/FI/CAS/RECEIVINGBILL", (IObjectPK)pk)) continue;
                prtControl = 0;
            }
        }
        return prtControl;
    }

    private void checkObjectExists() throws Exception {
        if (this.getSelectedKeyValue() == null) {
            return;
        }
        if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())))) {
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        CompanyOrgUnitInfo currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        CasForArApUtil.checkCompany((Component)((Object)this), currentCompany);
        IObjectPK pkIn = LogUtil.beginLog(null, (String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ArApBillResource", (String)"log_import"), (BOSObjectType)this.billBosType, null, (String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ArApBillResource", (String)"log_import"));
        super.actionImportData_actionPerformed(e);
        LogUtil.afterLog(null, (IObjectPK)pkIn);
    }

    protected ArrayList getImportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "InitReceivingBill";
        param.alias = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"359_InitReceivingBillListUI");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        ExportHelper.export((Component)((Object)this), (KDTable)this.tblMain);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.actionVoucher.setVisible(false);
        this.actionDelVoucher.setVisible(false);
        this.separatorFW4.setVisible(false);
        this.isStart = SystemStatusCtrolUtils.isStart(null, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (CompanyOrgUnitInfo)this.companyInfo);
        this.setWorkButtonStatus();
    }

    protected boolean isVoucherVisible() {
        return false;
    }

    @Override
    public void actionMultiPrint_actionPerformed(ActionEvent e) throws Exception {
        this.invokeMultiPrintFunction(true);
    }

    @Override
    public void actionMultiPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.invokeMultiPrintFunction(false);
    }

    private void checkBillIsAudited(ArrayList idList) throws Exception {
        String id = null;
        int billStatus = 0;
        IReceivingBill iReceivingBill = ReceivingBillFactory.getRemoteInstance();
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            id = idList.get(i).toString();
            billStatus = iReceivingBill.getBillStatus(id);
            if (billStatus >= 14) continue;
            MsgBox.showInfo((Component)((Object)this), (String)InitReceivingBillListUI.getStrResource("bill_not_audited"));
            SysUtil.abort();
        }
    }

    private static String getStrResource(String resKey) {
        return EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)resKey);
    }

    protected void invokeMultiPrintFunction(boolean isPrint) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() == 0 || this.getTDQueryPK() == null || this.getTDFileName() == null) {
            return;
        }
        CommonDataProvider data = new CommonDataProvider((List)idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        if (isPrint) {
            appHlp.print(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.printPreview(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    protected String getTDFileName() {
        return "/FI/CAS/RECEIVINGBILL";
    }

    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.fi.cas.ReceivingBillTDQuery");
    }

    public void actionTraceUp_actionPerformed(ActionEvent e) throws Exception {
        this.getUIContext().put("UI_System", SourceTypeEnum.AR);
        super.actionTraceUp_actionPerformed(e);
    }

    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        this.getUIContext().put("UI_System", SourceTypeEnum.AR);
        super.actionTraceDown_actionPerformed(e);
    }

    protected boolean isFootVisible() {
        return true;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    private void setDateDisplay() {
        String fmt = CtrlFormatUtilities.getDateFormatString();
        String dateTimeFmt = CtrlFormatUtilities.getDateTimeFormatString();
        this.tblMain.getColumn("createDate").getStyleAttributes().setNumberFormat(dateTimeFmt);
        this.tblMain.getColumn("updateDate").getStyleAttributes().setNumberFormat(fmt);
        this.tblMain.getColumn("auditDate").getStyleAttributes().setNumberFormat(fmt);
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            InitReceivingBillListUI.this.setListUITablePrecision(e.getFirstRow(), e.getLastRow());
        }
    }
}

