/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fi.cas.client.IRowSetAddBf;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.util.TDUtils;
import com.kingdee.eas.fm.common.util.UserDefineColumnCollection;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.awt.Component;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class JournalDataProvider
implements BOSQueryDelegate {
    private static Logger logger = Logger.getLogger((String)JournalDataProvider.class.getName());
    private IRowSetAddBf addBf = null;
    private Set ids = null;
    private SettlementBillInfo infoBill = null;
    private IMetaDataPK qpk = new MetaDataPK("com.kingdee.eas.fi.cas.JournalQuery");
    private KDTable tblMain;
    private UserDefineColumnCollection udcc;
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();

    public JournalDataProvider(Set id) {
        this.ids = id;
    }

    public JournalDataProvider(List id) {
        this.ids = new HashSet(id);
    }

    public JournalDataProvider(KDTable tblMain, UserDefineColumnCollection udcc) {
        this.tblMain = tblMain;
        this.udcc = udcc;
    }

    public JournalDataProvider(KDTable tblMain, UserDefineColumnCollection udcc, IRowSetAddBf addBf) {
        this.tblMain = tblMain;
        this.udcc = udcc;
        this.addBf = addBf;
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        IRowSet iRowSet = null;
        if (this.tblMain == null) {
            try {
                IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)this.qpk);
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.ids, CompareType.INCLUDE));
                ev.setFilter(filter);
                exec.setObjectView(ev);
                iRowSet = exec.executeQuery();
                DynamicRowSet drs = this.initDrowSet();
                while (iRowSet.next()) {
                    drs.beforeFirst();
                    drs.moveToInsertRow();
                    int n = drs.getRowSetMetaData().getColumnCount();
                    for (int i = 1; i <= n; ++i) {
                        drs.updateString(i, null);
                    }
                    drs.updateString("voucherType", iRowSet.getString("voucherType"));
                    drs.updateString("voucherNumber", iRowSet.getString("voucherNumber"));
                    drs.updateString("oppAccountNumber", iRowSet.getString("oppAccountViewNumber"));
                    drs.updateString("billType", iRowSet.getString("billType"));
                    drs.updateString("billNumber", iRowSet.getString("billNumber"));
                    drs.updateString("description", iRowSet.getString("description"));
                    drs.updateString("settType", iRowSet.getString("settlementType"));
                    drs.updateString("settNumber", iRowSet.getString("settlementNumber"));
                    drs.updateString("createDate", iRowSet.getString("createDate"));
                    drs.updateString("cash", iRowSet.getString("cashier"));
                    drs.updateString("verify", iRowSet.getString("verifyStatus"));
                    drs.updateString("source", iRowSet.getString("source"));
                    drs.updateString("oppUnit", iRowSet.getString("oppUnit"));
                    drs.updateString("oppAcctNumber", iRowSet.getString("oppAcctNumber"));
                    drs.updateString("oppBank", iRowSet.getString("oppBank"));
                    drs.updateString("currency", iRowSet.getString("currency.name"));
                    drs.updateString("bankAccountView", iRowSet.getString("accountNumber"));
                    drs.updateString("description", iRowSet.getString("description"));
                    this.fillAccount(iRowSet, drs);
                    this.fillAmount(iRowSet, drs);
                    this.fillPeriod(iRowSet, drs);
                }
                iRowSet = drs;
            }
            catch (Exception e1) {
                ExceptionHandler.handle((Component)((CoreUI)null), (Throwable)e1);
            }
        } else {
            TDUtils td = new TDUtils();
            try {
                boolean val_sumtd = ContextHelperFactory.getRemoteInstance().getBooleanParam("CS098", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
                KDTable tblMainEx = new KDTable();
                tblMainEx = this.tblMain;
                if (!val_sumtd) {
                    int i = 0;
                    while (i < tblMainEx.getRowCount3()) {
                        if (!(tblMainEx.getCell(i, "description").getValue() != null && (tblMainEx.getCell(i, "description").getValue().equals(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"360_JournalDataProvider")) || tblMainEx.getCell(i, "description").getValue().equals(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"361_JournalDataProvider")) || tblMainEx.getCell(i, "description").getValue().equals(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"362_JournalDataProvider")) || tblMainEx.getCell(i, "description").getValue().equals(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"363_JournalDataProvider")) || tblMainEx.getCell(i, "description").getValue().equals(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"364_JournalDataProvider")) || tblMainEx.getCell(i, "description").getValue().equals(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"365_JournalDataProvider"))))) {
                            tblMainEx.removeRow(i);
                            if (i <= 0) continue;
                            --i;
                            continue;
                        }
                        ++i;
                    }
                }
                iRowSet = td.kdTable2RowSet(tblMainEx, this.udcc);
            }
            catch (Exception e) {
                logger.error((Object)e);
                SysUtil.abort((Throwable)e);
            }
        }
        if (this.addBf != null) {
            int rowLineCount = 10;
            if (ds.getID().indexOf(".bos-query") > 0) {
                try {
                    rowLineCount = Integer.parseInt(ds.getID().substring(0, ds.getID().lastIndexOf(".bos-query")));
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            } else {
                try {
                    rowLineCount = Integer.parseInt(ds.getID().substring(2));
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
                for (int i = 4; i <= 30; ++i) {
                    if (!("ds" + i).equalsIgnoreCase(ds.getID())) continue;
                    rowLineCount = i;
                    break;
                }
            }
            this.addBf.addBf(iRowSet, rowLineCount);
        }
        return iRowSet;
    }

    private DynamicRowSet initDrowSet() throws SQLException {
        String[] keys = new String[]{"id", "company", "createDate", "bizDate", "voucherType", "voucherNumber", "oppAccountNumber", "billType", "billNumber", "description", "settType", "settNumber", "exchange", "debit", "localDebit", "credit", "localCredit", "dc", "balance", "localBalance", "cash", "verify", "source", "oppUnit", "oppAcctNumber", "oppBank", "bankAccount", "currency", "bankAccountView", "intTerm", "startPeriod", "endPeriod"};
        DynamicRowSet drs = new DynamicRowSet(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            ColInfo ciId = new ColInfo();
            ciId.colType = 12;
            ciId.columnName = keys[i];
            drs.setColInfo(i + 1, ciId);
        }
        return drs;
    }

    private void fillAccount(IRowSet iRowSet, DynamicRowSet drs) throws SQLException, BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)iRowSet.getString("accountBankNumber"), CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        AccountBankCollection coll = AccountBankFactory.getRemoteInstance().getAccountBankCollection(viewInfo);
        if (coll.size() > 0 && coll.get(0) != null && coll.get(0).getName() != null) {
            drs.updateString("bankAccount", coll.get(0).getName());
        }
    }

    private void fillAmount(IRowSet iRowSet, DynamicRowSet drs) throws ParseException, SQLException {
        SimpleDateFormat format1 = new SimpleDateFormat("yyyy-MM-dd");
        Date date = format1.parse(iRowSet.getString("bizDate"));
        BigDecimal localCredit = BigDecimal.ZERO;
        BigDecimal localDebit = BigDecimal.ZERO;
        BigDecimal rate = null;
        boolean isIndirectExRate = false;
        if (!iRowSet.getString("currency.id").equals(this.currentCompany.getId().toString())) {
            ExchangeRateInfo exchangeRateInfo = CasRecPayHandler.getExRateInfo(iRowSet.getString("currency.id"), null, this.currentCompany, date);
            if (exchangeRateInfo != null) {
                rate = exchangeRateInfo.getConvertRate();
            }
            isIndirectExRate = CasRecPayHandler.isIndirectExRate(exchangeRateInfo);
        }
        if (iRowSet.getString("creditAmount") != null && !iRowSet.getString("creditAmount").equals("0")) {
            drs.updateString("dc", EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"377_JournalDataProvider"));
            drs.updateString("credit", iRowSet.getString("creditAmount"));
            BigDecimal credit = new BigDecimal(iRowSet.getString("creditAmount"));
            if (rate != null) {
                localCredit = !isIndirectExRate ? credit.multiply(rate.setScale(9)) : credit.divide(rate.setScale(9));
            }
            drs.updateString("localCredit", localCredit.toString());
        }
        if (iRowSet.getString("debitAmount") != null && !iRowSet.getString("debitAmount").equals("0")) {
            drs.updateString("dc", EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"378_JournalDataProvider"));
            drs.updateString("debit", iRowSet.getString("debitAmount"));
            BigDecimal debit = new BigDecimal(iRowSet.getString("debitAmount"));
            if (rate != null) {
                localDebit = !isIndirectExRate ? debit.multiply(rate.setScale(9)) : debit.divide(rate.setScale(9));
            }
            drs.updateString("localdebit", localDebit.toString());
        }
        drs.updateString("exchange", rate.setScale(9).toString());
    }

    private void fillPeriod(IRowSet iRowSet, DynamicRowSet drs) throws SQLException {
        String period = iRowSet.getString("periodYear") + EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"379_JournalDataProvider") + iRowSet.getString("periodNumber") + EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"380_JournalDataProvider");
        drs.updateString("intTerm", period);
        drs.updateString("startPeriod", period);
        drs.updateString("endPeriod", period);
        drs.insertRow();
    }
}

