/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeCollection;
import com.kingdee.eas.basedata.assistant.VoucherTypeFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.master.account.IAccountRefContrast;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgSelect;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.OrgUnitTreePromptBox;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fi.cas.CashDataSourceEnum;
import com.kingdee.eas.fi.cas.CashDataTypeEnum;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.CashManagementFactory;
import com.kingdee.eas.fi.cas.DirectionEnum;
import com.kingdee.eas.fi.cas.ICashManagement;
import com.kingdee.eas.fi.cas.IInnerCashFacade;
import com.kingdee.eas.fi.cas.InnerCashFacadeFactory;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fi.cas.client.CashClientHelper;
import com.kingdee.eas.fi.cas.client.PeriodHelper;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;

public class JournalHandler {
    private static Logger logger = Logger.getLogger((String)JournalHandler.class.getName());
    private static final String resourcePath = "com.kingdee.eas.fi.cas.JournalResource";
    protected static final String DAY_TOTAL = EASResource.getString((String)"com.kingdee.eas.fi.cas.JournalResource", (String)"DayTotal");
    protected static final String YEAR_TOTAL = EASResource.getString((String)"com.kingdee.eas.fi.cas.JournalResource", (String)"YearTotal");
    protected static final String PERIOD_TOTAL = EASResource.getString((String)"com.kingdee.eas.fi.cas.JournalResource", (String)"MonthTotal");
    protected static final String DAY_BALANCE = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"BankStmt_DayStart");
    protected static final String resourcePath1 = "com.kingdee.eas.fi.cas.client.CashMgtResource";
    protected static final String YEAR_BALANCE = EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"YearBalance");
    protected static final String BEGIN_BALANCE = EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"BeginBalance");
    protected static final String COL_DC = "dc";
    protected static final String COL_PERIOD = "period";
    protected static final String COL_YEAR = "year";
    protected static final String COL_SOURCE = "source";
    protected static final String COL_BALANCE = "balance";
    protected static final String COL_CREDIT = "credit";
    protected static final String COL_DEBIT = "debit";
    protected static final String COL_DESCRIPTION = "description";
    protected static final String COL_CASHIER = "cashier";
    protected static final String COL_BILLNUMBER = "billNumber";
    protected static final String COL_BILLTYPE = "billType";
    protected static final String COL_OPPACCOUNTNUMBER = "oppAccountNumber";
    protected static final String COL_VOUCHERNUMBER = "voucherNumber";
    protected static final String COL_VOUCHERTYPE = "voucherType";
    protected static final String COL_BIZDATE = "bizDate";
    protected static final String COL_ID = "id";
    protected static final String COL_COMPANY = "company";
    protected static final String CREDIT_AMOUNT = "creditAmount";
    protected static final String DEBIT_AMOUNT = "debitAmount";
    protected static final String PERIOD_NUMBER = "periodnumber";
    protected static final String PERIOD_YEAR = "periodyear";
    protected static final String COL_CREATE_DATE = "createDate";
    protected static final String COL_LOCAL_BALANCE = "localBalance";
    protected static final String COL_LOCAL_CREDIT = "localCredit";
    protected static final String COL_LOCAL_DEBIT = "localDebit";
    protected static final String COL_EXCHANGE = "exchange";
    protected static final String COL_TDCONTROL = "r1-print.non-statistic";
    private boolean glDc;

    public void verifyJournal(CoreUIObject ui, JournalInfo journal, PeriodInfo curPeriod) throws EASBizException, BOSException {
        ExchangeRateInfo rate;
        CompanyOrgUnitInfo company = journal.getCompany();
        SelectorItemCollection sict = new SelectorItemCollection();
        sict.add(new SelectorItemInfo(COL_ID));
        sict.add(new SelectorItemInfo("currency.id"));
        sict.add(new SelectorItemInfo("currency.number"));
        sict.add(new SelectorItemInfo("baseExchangeTable.id"));
        sict.add(new SelectorItemInfo("baseCurrency.id"));
        sict.add(new SelectorItemInfo("baseCurrency.number"));
        company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()), sict);
        String srcCurrency = journal.getCurrency().getId().toString();
        String destCurrency = company.getBaseCurrency().getId().toString();
        String companyid = company.getId().toString();
        if (!srcCurrency.equals(destCurrency) && EmptyUtil.isEmpty((CoreBaseInfo)(rate = FMClientHelper.getExRateInfo((String)companyid, (String)srcCurrency, (String)destCurrency, (Date)journal.getBizDate())))) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"NoExchange"));
            SysUtil.abort();
        }
        ClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (Object)journal.getType(), (String)"JournalTypeIsNUll");
        if (journal.getType().equals((Object)JournalTypeEnum.BANK)) {
            ClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (Object)journal.getAccountBank(), (String)"AcctBankIsNUll");
        }
        ClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (Object)journal.getAccountView(), (String)"AccountViewIsNUll");
        ClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (Object)journal.getCreateDate(), (String)"CreateDateIsNUll");
        if (journal.getPeriod() == null) {
            DateFormat df = DateFormat.getDateInstance(1);
            String date = df.format(journal.getCreateDate());
            MsgBox.showWarning((Component)ui, (String)(date + EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"366_JournalHandler")));
            SysUtil.abort();
        }
        if (DateTimeUtils.truncateDate((Date)journal.getBizDate()).after(DateTimeUtils.truncateDate((Date)journal.getCreateDate()))) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"367_JournalHandler"));
            SysUtil.abort();
        }
        ClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (Object)journal.getPeriod(), (String)"PeriodIsNUll");
        ClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (String)resourcePath, (Object)journal.getCurrency(), (String)"CurrencyIsNUll");
        BigDecimal creditAmt = journal.getCreditAmount();
        BigDecimal debitAmt = journal.getDebitAmount();
        if (!(creditAmt != null && creditAmt.compareTo(Constants.ZERO) != 0 || debitAmt != null && debitAmt.compareTo(Constants.ZERO) != 0)) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"AmountIsNull"));
            SysUtil.abort();
        }
        if (journal.getCreateDate().before(curPeriod.getBeginDate())) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"BeforeCurrentPeriod"));
            SysUtil.abort();
        }
        if (!EmptyUtil.isEmpty((String)journal.getVoucherNumber())) {
            int result;
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)journal.getPeriod().getId().toString()));
            if (journal.getVoucherType() != null) {
                filter.getFilterItems().add(new FilterItemInfo("voucherType.id", (Object)journal.getVoucherType().getId()));
            }
            if (!EmptyUtil.isEmpty((String)journal.getVoucherNumber())) {
                filter.getFilterItems().add(new FilterItemInfo(COL_VOUCHERNUMBER, (Object)journal.getVoucherNumber()));
            }
            if (!EmptyUtil.isEmpty((Object)journal.getId())) {
                filter.getFilterItems().add(new FilterItemInfo(COL_ID, (Object)journal.getId(), CompareType.NOTEQUALS));
            }
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)journal.getCompany().getId().toString()));
            boolean isExistSameVoucher = JournalFactory.getRemoteInstance().exists(filter);
            if (isExistSameVoucher && (result = MsgBox.showConfirm2((Component)ui, (String)EASResource.getString((String)resourcePath, (String)"voucherNumSame"))) == 2) {
                SysUtil.abort();
            }
        }
    }

    public void verifyJournal(CoreUIObject ui, JournalInfo journal) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        PeriodInfo curPeriod = CashClientHelper.getCurrentPeriod(company);
        this.verifyJournal(ui, journal, curPeriod);
    }

    public void showErrer(CoreUIObject ui, String errerMsg) {
        MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)errerMsg));
        SysUtil.abort();
    }

    public void saveJournal(JournalInfo info) {
    }

    public static void setF7Company(IUIObject owner, KDBizPromptBox f7company) {
        OrgType[] CompanyType = new OrgType[]{OrgType.Company};
        f7company.setEditFormat("$number$");
        f7company.setDisplayFormat("$name$");
        OrgUnitTreePromptBox boxCompany = new OrgUnitTreePromptBox(owner, CompanyType, null, OrgSelect.OnlySelectCompanyEntity, false, false, false);
        f7company.setSelector((KDPromptSelector)boxCompany);
    }

    public void initF7Acct(IUIObject owner, KDBizPromptBox f7Acct, CompanyOrgUnitInfo company, CurrencyInfo currency) {
        if (company.getAccountTable() == null) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)new Integer(0)));
        f7Acct.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)"1"));
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)company.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)company.getAccountTable().getId().toString()));
        f7Acct.setDisplayFormat("$number$-$name$");
        f7Acct.setEditFormat("$number$");
        f7Acct.setCommitFormat("$number$");
        f7Acct.setEditable(true);
        f7Acct.setSelector((KDPromptSelector)new AccountPromptBox(owner, company, filter, false, true));
        f7Acct.setEntityViewInfo(evi);
    }

    public void initComboVoucherType(KDComboBox cboVoucherType, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        BOSUuid pk = company.getCU().getId();
        FilterInfo filter = VoucherTypeFactory.getRemoteInstance().getDatabaseDFilter((IObjectPK)new ObjectUuidPK(pk.toString()), COL_ID, "adminCU.id");
        viewInfo.setFilter(filter);
        VoucherTypeCollection types = VoucherTypeFactory.getRemoteInstance().getVoucherTypeCollection(viewInfo);
        cboVoucherType.removeAllItems();
        cboVoucherType.addItem((Object)"");
        cboVoucherType.addItems(types.toArray());
        for (int i = 0; i < types.size(); ++i) {
            VoucherTypeInfo typeInfo = types.get(i);
            if (!typeInfo.isPretermit()) continue;
            cboVoucherType.setSelectedItem((Object)typeInfo);
            break;
        }
    }

    public void initComboVoucherType(KDComboBox cboVoucherType) {
        try {
            EntityViewInfo viewInfo = new EntityViewInfo();
            BOSUuid pk = SysContext.getSysContext().getCurrentCtrlUnit().getId();
            FilterInfo filter = VoucherTypeFactory.getRemoteInstance().getDatabaseDFilter((IObjectPK)new ObjectUuidPK(pk.toString()), COL_ID, "adminCU.id");
            viewInfo.setFilter(filter);
            VoucherTypeCollection types = VoucherTypeFactory.getRemoteInstance().getVoucherTypeCollection(viewInfo);
            cboVoucherType.addItem(null);
            cboVoucherType.addItems(types.toArray());
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            SysUtil.abort();
        }
    }

    public void initComboSettlementType(KDComboBox cboSettlementType) {
        try {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            evi.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
            evi.getSorter().add(new SorterItemInfo("number"));
            SettlementTypeCollection types = SettlementTypeFactory.getRemoteInstance().getSettlementTypeCollection(evi);
            cboSettlementType.removeAllItems();
            cboSettlementType.addItem(null);
            cboSettlementType.addItems(types.toArray());
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    public void initComboBillType(KDComboBox cboBillType, boolean hasNull) {
        cboBillType.removeAllItems();
        if (hasNull) {
            cboBillType.addItem(null);
        }
        cboBillType.addItems(BillTypeEnum.getEnumList().toArray());
    }

    public void submitJournals(JournalCollection journals) {
        try {
            JournalFactory.getRemoteInstance().addBatch((IObjectCollection)journals);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
    }

    public void submitJournal(JournalInfo journal) {
        try {
            JournalFactory.getRemoteInstance().submit((CoreBaseInfo)journal);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
    }

    protected void fillLocalCurrencyDataForTotal(IRow row, BigDecimal exchange, BigDecimal debitAmt, BigDecimal creditAmt, BigDecimal balance, boolean isCurEqualsBasecur, ConvertModeEnum convertMode, BalanceDirectionEnum dc) {
        BigDecimal localBalance;
        BigDecimal localCreditAmt;
        BigDecimal localDebitAmt;
        if (isCurEqualsBasecur) {
            localDebitAmt = debitAmt;
            localCreditAmt = creditAmt;
            localBalance = balance;
        } else if (convertMode.equals((Object)ConvertModeEnum.DIRECTEXCHANGERATE)) {
            localDebitAmt = debitAmt.multiply(exchange);
            localCreditAmt = creditAmt.multiply(exchange);
            localBalance = balance.multiply(exchange);
        } else {
            localDebitAmt = debitAmt.divide(exchange, 20, 4);
            localCreditAmt = creditAmt.divide(exchange, 20, 4);
            localBalance = balance.divide(exchange, 20, 4);
        }
        DirectionEnum direction = balance.compareTo(CasConstants.ZERO) == 0 ? DirectionEnum.Balance : (balance.compareTo(CasConstants.ZERO) > 0 ? DirectionEnum.Debit : DirectionEnum.Credit);
        row.getCell(COL_DC).setValue((Object)direction);
        row.getCell(COL_LOCAL_DEBIT).setValue((Object)localDebitAmt);
        row.getCell(COL_LOCAL_CREDIT).setValue((Object)localCreditAmt);
        if (!this.glDc) {
            row.getCell(COL_LOCAL_BALANCE).setValue((Object)localBalance.abs());
            row.getCell(COL_BALANCE).setValue((Object)balance.abs());
        } else {
            if (dc != null && !dc.getAlias().equals(direction.getAlias()) && !direction.equals((Object)DirectionEnum.Balance)) {
                row.getCell(COL_DC).setValue((Object)dc);
            }
            row.getCell(COL_LOCAL_BALANCE).setValue((Object)localBalance);
            row.getCell(COL_BALANCE).setValue((Object)balance);
        }
    }

    protected void fillLocalCurrencyData(IRow row, BigDecimal exchange, BigDecimal debitAmt, BigDecimal creditAmt, BigDecimal balance, boolean isCurEqualsBasecur, ConvertModeEnum convertMode, BalanceDirectionEnum dc) {
        BigDecimal localBalance;
        BigDecimal localCreditAmt;
        BigDecimal localDebitAmt;
        if (isCurEqualsBasecur) {
            localDebitAmt = debitAmt;
            localCreditAmt = creditAmt;
            localBalance = balance;
        } else if (convertMode.equals((Object)ConvertModeEnum.DIRECTEXCHANGERATE)) {
            localDebitAmt = debitAmt.multiply(exchange);
            localCreditAmt = creditAmt.multiply(exchange);
            localBalance = balance.multiply(exchange);
        } else {
            localDebitAmt = debitAmt.divide(exchange, 20, 4);
            localCreditAmt = creditAmt.divide(exchange, 20, 4);
            localBalance = balance.divide(exchange, 20, 4);
        }
        DirectionEnum direction = balance.compareTo(CasConstants.ZERO) == 0 ? DirectionEnum.Balance : (balance.compareTo(CasConstants.ZERO) > 0 ? DirectionEnum.Debit : DirectionEnum.Credit);
        row.getCell(COL_DC).setValue((Object)direction);
        if (localDebitAmt.compareTo(CasConstants.ZERO) != 0) {
            row.getCell(COL_LOCAL_DEBIT).setValue((Object)localDebitAmt);
        }
        if (localCreditAmt.compareTo(CasConstants.ZERO) != 0) {
            row.getCell(COL_LOCAL_CREDIT).setValue((Object)localCreditAmt);
        }
        if (!this.glDc) {
            row.getCell(COL_LOCAL_BALANCE).setValue((Object)localBalance.abs());
            row.getCell(COL_BALANCE).setValue((Object)balance.abs());
        } else {
            if (dc != null && !dc.getAlias().equals(direction.getAlias()) && !direction.equals((Object)DirectionEnum.Balance)) {
                row.getCell(COL_DC).setValue((Object)dc);
            }
            row.getCell(COL_LOCAL_BALANCE).setValue((Object)localBalance);
            row.getCell(COL_BALANCE).setValue((Object)balance);
        }
    }

    public void setColumnFormat(KDTable tblMain, BOSUuid currencyId) {
        String numberFtm = FMClientHelper.getNumberFtm((BOSUuid)currencyId);
        tblMain.getColumn(COL_DEBIT).getStyleAttributes().setNumberFormat(numberFtm);
        tblMain.getColumn(COL_CREDIT).getStyleAttributes().setNumberFormat(numberFtm);
        tblMain.getColumn(COL_BALANCE).getStyleAttributes().setNumberFormat(numberFtm);
        tblMain.getColumn(COL_LOCAL_BALANCE).getStyleAttributes().setNumberFormat(numberFtm);
        tblMain.getColumn(COL_LOCAL_CREDIT).getStyleAttributes().setNumberFormat(numberFtm);
        tblMain.getColumn(COL_LOCAL_DEBIT).getStyleAttributes().setNumberFormat(numberFtm);
        tblMain.getColumn(COL_DEBIT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tblMain.getColumn(COL_CREDIT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tblMain.getColumn(COL_BALANCE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tblMain.getColumn(COL_LOCAL_BALANCE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tblMain.getColumn(COL_LOCAL_CREDIT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tblMain.getColumn(COL_LOCAL_DEBIT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    public void setNumberFormat(IRow row, BOSUuid currencyId, boolean isShowDate) {
        String numberFtm = FMClientHelper.getNumberFtm((BOSUuid)currencyId);
        row.getCell(COL_DEBIT).getStyleAttributes().setNumberFormat(numberFtm);
        row.getCell(COL_CREDIT).getStyleAttributes().setNumberFormat(numberFtm);
        row.getCell(COL_BALANCE).getStyleAttributes().setNumberFormat(numberFtm);
        row.getCell(COL_LOCAL_DEBIT).getStyleAttributes().setNumberFormat(numberFtm);
        row.getCell(COL_LOCAL_CREDIT).getStyleAttributes().setNumberFormat(numberFtm);
        row.getCell(COL_LOCAL_BALANCE).getStyleAttributes().setNumberFormat(numberFtm);
        row.getCell(COL_DEBIT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell(COL_CREDIT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell(COL_BALANCE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell(COL_LOCAL_DEBIT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell(COL_LOCAL_CREDIT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell(COL_LOCAL_BALANCE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    protected void fillBalance(CompanyOrgUnitInfo companyInfo, int year, int periodNumber, IRow row, BigDecimal exchange, BigDecimal balance, boolean isCurEqualsBasecur, String description, ConvertModeEnum convertMode, BalanceDirectionEnum dc) throws EASBizException, BOSException {
        PeriodInfo period = PeriodHelper.getPeriodInfo(year, periodNumber, companyInfo);
        Date beginDate = null;
        if (period != null) {
            beginDate = period.getBeginDate();
        }
        this.fillBalance(row, exchange, balance, isCurEqualsBasecur, description, beginDate, convertMode, dc);
    }

    protected void fillBalance(IRow row, BigDecimal exchange, BigDecimal balance, boolean isCurEqualsBasecur, String description, Date beginDate, ConvertModeEnum convertMode, BalanceDirectionEnum dc) {
        BigDecimal localBalance = isCurEqualsBasecur ? balance : (convertMode.equals((Object)ConvertModeEnum.DIRECTEXCHANGERATE) ? balance.multiply(exchange) : balance.divide(exchange, 4));
        DirectionEnum direction = balance.compareTo(CasConstants.ZERO) == 0 ? DirectionEnum.Balance : (balance.compareTo(CasConstants.ZERO) > 0 ? DirectionEnum.Debit : DirectionEnum.Credit);
        row.getStyleAttributes().setBackground(CasConstants.PERIOD_TOTAL_COLOR);
        row.getCell(COL_DC).setValue((Object)direction);
        row.getCell(COL_DESCRIPTION).setValue((Object)description);
        if (!this.glDc) {
            row.getCell(COL_LOCAL_BALANCE).setValue((Object)localBalance.abs());
            row.getCell(COL_BALANCE).setValue((Object)balance.abs());
        } else {
            if (dc != null && !dc.getAlias().equals(direction.getAlias()) && !direction.equals((Object)DirectionEnum.Balance)) {
                row.getCell(COL_DC).setValue((Object)dc);
            }
            row.getCell(COL_LOCAL_BALANCE).setValue((Object)localBalance);
            row.getCell(COL_BALANCE).setValue((Object)balance);
        }
        row.getCell(COL_CREATE_DATE).setValue((Object)Constants.FORMAT_DAY.format(beginDate));
    }

    public boolean isGlDc() {
        return this.glDc;
    }

    public void setGlDc(boolean glDc) {
        this.glDc = glDc;
    }

    protected void fillDayTotal(Date date, IRow row, BigDecimal exchange, BigDecimal debitAmt, BigDecimal creditAmt, BigDecimal balance, boolean isCurEqualsBasecur, ConvertModeEnum convertMode, BalanceDirectionEnum dc) {
        row.getStyleAttributes().setBackground(CasConstants.PERIOD_TOTAL_COLOR);
        row.getCell(COL_DESCRIPTION).setValue((Object)DAY_TOTAL);
        if (debitAmt.compareTo(CasConstants.ZERO) != 0) {
            row.getCell(COL_DEBIT).setValue((Object)debitAmt);
        }
        if (creditAmt.compareTo(CasConstants.ZERO) != 0) {
            row.getCell(COL_CREDIT).setValue((Object)creditAmt);
        }
        row.getCell(COL_CREATE_DATE).setValue((Object)Constants.FORMAT_DAY.format(date));
        this.fillLocalCurrencyDataForTotal(row, exchange, debitAmt, creditAmt, balance, isCurEqualsBasecur, convertMode, dc);
    }

    protected void fillTotal(CompanyOrgUnitInfo companyInfo, int year, int periodNumber, Date date, IRow row, BigDecimal exchange, BigDecimal debitAmt, BigDecimal creditAmt, BigDecimal balance, boolean isCurEqualsBasecur, String description, ConvertModeEnum convertMode, BalanceDirectionEnum dc) throws EASBizException, BOSException {
        row.getStyleAttributes().setBackground(CasConstants.PERIOD_TOTAL_COLOR);
        row.getCell(COL_DESCRIPTION).setValue((Object)description);
        row.getCell(COL_DEBIT).setValue((Object)debitAmt);
        row.getCell(COL_CREDIT).setValue((Object)creditAmt);
        row.getCell(COL_TDCONTROL).setValue((Object)"true");
        if (date == null) {
            PeriodInfo endPeriod = PeriodHelper.getPeriodInfo(year, periodNumber, companyInfo);
            row.getCell(COL_CREATE_DATE).setValue((Object)Constants.FORMAT_DAY.format(endPeriod.getEndDate()));
        } else {
            row.getCell(COL_CREATE_DATE).setValue((Object)Constants.FORMAT_DAY.format(date));
        }
        this.fillLocalCurrencyDataForTotal(row, exchange, debitAmt, creditAmt, balance, isCurEqualsBasecur, convertMode, dc);
    }

    protected BigDecimal getBeginBalance(CompanyOrgUnitInfo companyInfo, String accountTableNumber, String currencyNumber, String accountNumber, String accountBankNumber, Date beginDate, CashDataSourceEnum dateType, boolean isAdjustPeriod, boolean isMulUnionQuery) throws EASBizException, BOSException {
        String lastDayAcctTableNumber;
        Date previousDate = beginDate;
        PeriodInfo previousPeriod = PeriodUtils.getPeriodInfo((Date)previousDate, (CompanyOrgUnitInfo)companyInfo);
        if (!isAdjustPeriod) {
            previousDate = DateHelper.getBeforeDay((Date)previousDate);
            previousPeriod = PeriodUtils.getPeriodInfo((Date)previousDate, (CompanyOrgUnitInfo)companyInfo);
        }
        if (previousPeriod == null) {
            PeriodInfo period = PeriodUtils.getPeriodInfo((Date)beginDate, (CompanyOrgUnitInfo)companyInfo);
            if (accountBankNumber == null) {
                return JournalHandler.getCashMonthStartAmt(accountTableNumber, companyInfo.getId().toString(), accountNumber, currencyNumber, period.getId().toString());
            }
            return JournalHandler.getBankMonthStartAmt(accountTableNumber, companyInfo.getId().toString(), accountBankNumber, accountNumber, currencyNumber, period.getId().toString());
        }
        IInnerCashFacade innerCashFacade = InnerCashFacadeFactory.getRemoteInstance();
        String lastDayAcctTableid = innerCashFacade.getActualAcctTableIDEx(companyInfo.getId().toString(), previousDate, previousDate, isAdjustPeriod);
        if (lastDayAcctTableid != null && !(lastDayAcctTableNumber = AccountTableFactory.getRemoteInstance().getAccountTableInfo((IObjectPK)new ObjectUuidPK(lastDayAcctTableid)).getNumber()).equals(accountTableNumber)) {
            PeriodInfo period = PeriodUtils.getPeriodInfo((Date)beginDate, (CompanyOrgUnitInfo)companyInfo);
            if (accountBankNumber == null) {
                return JournalHandler.getCashMonthStartAmt(accountTableNumber, companyInfo.getId().toString(), accountNumber, currencyNumber, period.getId().toString());
            }
            return JournalHandler.getBankMonthStartAmt(accountTableNumber, companyInfo.getId().toString(), accountBankNumber, accountNumber, currencyNumber, period.getId().toString());
        }
        ICashManagement cashInacct = CashManagementFactory.getRemoteInstance();
        BigDecimal balance = null;
        balance = cashInacct.cash(companyInfo.getNumber(), dateType, accountTableNumber, accountNumber, accountBankNumber, currencyNumber, beginDate, beginDate, CashDataTypeEnum.C, false, isAdjustPeriod, isMulUnionQuery);
        return balance;
    }

    protected BigDecimal getBeginBalance(CompanyOrgUnitInfo companyInfo, String accountTableNumber, String currencyNumber, String accountNumber, String accountBankNumber, PeriodInfo period, CashDataSourceEnum dateType, boolean isMulUnionQuery) throws EASBizException, BOSException {
        if (period.isIsAdjustPeriod()) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyInfo.getId()));
            filter.getFilterItems().add(new FilterItemInfo("enabledPeriod.id", (Object)period.getId()));
            filter.getFilterItems().add(new FilterItemInfo("enabledAcctTable.number", (Object)accountTableNumber));
            IAccountRefContrast acctContrast = AccountRefContrastFactory.getRemoteInstance();
            if (acctContrast.exists(filter)) {
                return new BigDecimal("0");
            }
        }
        return this.getBeginBalance(companyInfo, accountTableNumber, currencyNumber, accountNumber, accountBankNumber, period.getBeginDate(), dateType, period.isIsAdjustPeriod(), isMulUnionQuery);
    }

    public static BigDecimal getCashMonthStartAmt(String acctTableNum, String companyId, String accountNum, String currencyNum, String periodId) {
        StringBuffer sql = new StringBuffer();
        sql.append("select FMonthStartAmt SubResult from T_CAS_JournalBalance where ");
        sql.append("FIsInit =0  and ");
        sql.append("FCompanyId='").append(companyId).append("' and FCurrencyId in(").append("select fid from t_bd_currency where FNumber = '").append(currencyNum).append("') and FPeriodId='").append(periodId).append("'");
        sql.append(" and FType= 1");
        if (accountNum != null && accountNum.length() > 0) {
            sql.append(" and FAccountViewId in (").append("select fid from t_bd_accountview where FIsLeaf = 1 and FIsCash = 1 and FCompanyID='").append(companyId).append("' and FNumber = '").append(accountNum.trim()).append("' and FAccountTableID in(select fid from t_bd_accountTable where FNumber = '").append(acctTableNum).append("'))");
        }
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
        IRowSet rs = null;
        try {
            rs = exec.executeSQL();
            if (rs != null && rs.next()) {
                return rs.getBigDecimal("SubResult");
            }
        }
        catch (BOSException e1) {
            SysUtil.abort((Throwable)e1);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return Constants.ZERO;
    }

    public static BigDecimal getBankMonthStartAmt(String acctTableNum, String companyId, String accountBankNum, String accountNum, String currencyNum, String periodId) {
        StringBuffer sql = new StringBuffer();
        sql.append("select FMonthStartAmt SubResult from T_CAS_JournalBalance where ");
        sql.append("FIsInit =0  and ");
        sql.append("FCompanyId='").append(companyId).append("' and FCurrencyId in(").append("select fid from t_bd_currency where FNumber = '").append(currencyNum).append("') and FPeriodId='").append(periodId).append("'");
        sql.append(" and FAccountBankId in(").append("select fid from t_bd_accountbanks where fnumber='").append(accountBankNum).append("'").append(" and fcompanyid='").append(companyId).append("')");
        sql.append(" and FType= 2");
        if (accountNum != null && accountNum.length() > 0) {
            sql.append(" and FAccountViewId in (").append("select fid from t_bd_accountview where FIsLeaf = 1 and FIsBank = 1 and FCompanyID='").append(companyId).append("' and FNumber = '").append(accountNum.trim()).append("' and FAccountTableID in(select fid from t_bd_accountTable where FNumber = '").append(acctTableNum).append("'))");
        }
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
        IRowSet rs = null;
        boolean result = false;
        try {
            rs = exec.executeSQL();
            if (rs != null && rs.next()) {
                return rs.getBigDecimal("SubResult");
            }
        }
        catch (BOSException e1) {
            SysUtil.abort((Throwable)e1);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return FMConstants.ZERO;
    }

    protected BigDecimal getYearTotal(CompanyOrgUnitInfo companyInfo, String accountTableNumber, String currencyNumber, String accountNumber, String accountBankNumber, int year, int periodNumber, CashDataSourceEnum dateType, CashDataTypeEnum type, boolean isMulUnionQuery) throws EASBizException, BOSException {
        ICashManagement cashInacct = CashManagementFactory.getRemoteInstance();
        BigDecimal result = null;
        GregorianCalendar begincal = new GregorianCalendar(year, 0, 1);
        PeriodInfo endPeriod = PeriodHelper.getPeriodInfo(year, periodNumber, companyInfo);
        if (endPeriod == null) {
            return CasConstants.ZERO;
        }
        if (endPeriod.isIsAdjustPeriod()) {
            AccountRefContrastInfo info;
            if (companyInfo.getAccountTable() == null) {
                companyInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId()));
            }
            if ((info = AccountRefContrastFactory.getRemoteInstance().getLastAcctInfo(companyInfo.getId().toString(), companyInfo.getAccountTable().getId().toString(), year, periodNumber)).getEnabledPeriod() != null && info.getEnabledPeriod().getId().equals((Object)endPeriod.getId()) && accountTableNumber.equals(info.getEnabledAcctTable().getNumber())) {
                return CasConstants.ZERO;
            }
        }
        if ((endPeriod = PeriodHelper.getPrePeriodInfo(companyInfo, endPeriod)) == null || endPeriod.getPeriodYear() != year) {
            return CasConstants.ZERO;
        }
        result = cashInacct.cash(companyInfo.getNumber(), dateType, accountTableNumber, accountNumber, accountBankNumber, currencyNumber, begincal.getTime(), endPeriod.getEndDate(), type, false, false, isMulUnionQuery);
        return result;
    }

    public void setSelectObject(KDComboBox cbo, Object anObject) {
        if (CoreBaseInfo.class.isInstance(anObject)) {
            CoreBaseInfo newObject = (CoreBaseInfo)anObject;
            for (int i = 0; i < cbo.getItemCount(); ++i) {
                CoreBaseInfo obj;
                if (cbo.getItemAt(i) == null || cbo.getItemAt(i).equals("") || (obj = (CoreBaseInfo)cbo.getItemAt(i)) == null || !newObject.getId().equals((Object)obj.getId())) continue;
                cbo.setSelectedIndex(i);
                break;
            }
        } else {
            cbo.setSelectedItem(anObject);
        }
    }

    protected void fillAdjustRow_New(BigDecimal monthDebitAmt, BigDecimal monthCreditAmt, BigDecimal yearDebitAmt, BigDecimal yearCreditAmt, KDTable tblMain, boolean isShowBeginBalance, boolean isShowPeriodTotal, boolean isShowYearTotal, CompanyOrgUnitInfo companyInfo, boolean isCurEqualsBasecur, BigDecimal balance, PeriodInfo beginPeriodInfo, PeriodInfo endPeriodInfo, ConvertModeEnum convertMode, CurrencyInfo sourceCurrency, BalanceDirectionEnum dc) throws BOSException, EASBizException {
        PeriodInfo temPeriodInfo = beginPeriodInfo;
        if (beginPeriodInfo == null || endPeriodInfo == null) {
            return;
        }
        while (temPeriodInfo.getPeriodYear() < endPeriodInfo.getPeriodYear() || temPeriodInfo.getPeriodYear() == endPeriodInfo.getPeriodYear() && endPeriodInfo.getPeriodNumber() >= temPeriodInfo.getPeriodNumber()) {
            PeriodInfo temNextPeriodInfo;
            BigDecimal exchange;
            Timestamp tempDate;
            BigDecimal exchange2;
            Timestamp tempDate2;
            PeriodInfo period;
            IRow row;
            if (isShowBeginBalance) {
                row = tblMain.addRow();
                period = PeriodHelper.getPeriodInfo(temPeriodInfo.getPeriodYear(), temPeriodInfo.getPeriodNumber(), companyInfo);
                tempDate2 = period.getEndDate();
                exchange2 = JournalHandler.getExchange(companyInfo, sourceCurrency, null, DateUtil.getBeforeDay((Date)tempDate2));
                this.fillBalance(companyInfo, temPeriodInfo.getPeriodYear(), temPeriodInfo.getPeriodNumber(), row, exchange2, balance, isCurEqualsBasecur, BEGIN_BALANCE, convertMode, dc);
            }
            if (isShowPeriodTotal) {
                row = tblMain.addRow();
                tempDate = temPeriodInfo.getEndDate();
                exchange = JournalHandler.getExchange(companyInfo, sourceCurrency, null, tempDate);
                this.fillTotal(companyInfo, temPeriodInfo.getPeriodYear(), temPeriodInfo.getPeriodNumber(), temPeriodInfo.getEndDate(), row, exchange, monthDebitAmt, monthCreditAmt, balance, isCurEqualsBasecur, PERIOD_TOTAL, convertMode, dc);
                monthDebitAmt = Constants.ZERO;
                monthCreditAmt = Constants.ZERO;
            }
            if (isShowYearTotal) {
                row = tblMain.addRow();
                tempDate = temPeriodInfo.getEndDate();
                exchange = JournalHandler.getExchange(companyInfo, sourceCurrency, null, tempDate);
                this.fillTotal(companyInfo, temPeriodInfo.getPeriodYear(), temPeriodInfo.getPeriodNumber(), temPeriodInfo.getEndDate(), row, exchange, yearDebitAmt, yearCreditAmt, balance, isCurEqualsBasecur, YEAR_TOTAL, convertMode, dc);
            }
            if ((temNextPeriodInfo = PeriodHelper.getNextPeriodInfo(companyInfo, temPeriodInfo)) == null) {
                return;
            }
            if ((temNextPeriodInfo.getPeriodYear() < endPeriodInfo.getPeriodYear() || temNextPeriodInfo.getPeriodYear() == endPeriodInfo.getPeriodYear() && endPeriodInfo.getPeriodNumber() >= temNextPeriodInfo.getPeriodNumber()) && temPeriodInfo.getPeriodYear() < temNextPeriodInfo.getPeriodYear()) {
                row = tblMain.addRow();
                period = PeriodHelper.getPeriodInfo(temNextPeriodInfo.getPeriodYear(), temNextPeriodInfo.getPeriodNumber(), companyInfo);
                tempDate2 = period.getEndDate();
                exchange2 = JournalHandler.getExchange(companyInfo, sourceCurrency, null, DateUtil.getBeforeDay((Date)tempDate2));
                this.fillBalance(companyInfo, temNextPeriodInfo.getPeriodYear(), temNextPeriodInfo.getPeriodNumber(), row, exchange2, balance, isCurEqualsBasecur, YEAR_BALANCE, convertMode, dc);
                yearDebitAmt = CasConstants.ZERO;
                yearCreditAmt = CasConstants.ZERO;
            }
            temPeriodInfo = temNextPeriodInfo;
        }
    }

    protected void fillAdjustRow_NewDay(BigDecimal monthDebitAmt, BigDecimal monthCreditAmt, BigDecimal yearDebitAmt, BigDecimal yearCreditAmt, KDTable tblMain, boolean isShowBeginBalance, boolean isShowPeriodTotal, boolean isShowYearTotal, CompanyOrgUnitInfo companyInfo, boolean isCurEqualsBasecur, BigDecimal balance, PeriodInfo beginPeriodInfo, PeriodInfo endPeriodInfo, ConvertModeEnum convertMode, Date beginDay, Date endDay, CurrencyInfo sourceCurrency, BalanceDirectionEnum dc) throws BOSException, EASBizException {
        PeriodInfo temPeriodInfo = beginPeriodInfo;
        if (beginPeriodInfo == null || endPeriodInfo == null) {
            return;
        }
        boolean first = true;
        while (temPeriodInfo.getPeriodYear() < endPeriodInfo.getPeriodYear() || temPeriodInfo.getPeriodYear() == endPeriodInfo.getPeriodYear() && endPeriodInfo.getPeriodNumber() >= temPeriodInfo.getPeriodNumber()) {
            PeriodInfo temNextPeriodInfo;
            BigDecimal exchange;
            Date tempDate;
            IRow row;
            if (isShowBeginBalance) {
                row = tblMain.addRow();
                PeriodInfo period = PeriodHelper.getPeriodInfo(temPeriodInfo.getPeriodYear(), temPeriodInfo.getPeriodNumber(), companyInfo);
                Timestamp tempDate2 = period.getEndDate();
                BigDecimal exchange2 = JournalHandler.getExchange(companyInfo, sourceCurrency, null, tempDate2);
                if (first) {
                    this.fillBalance(row, exchange2, balance, isCurEqualsBasecur, DAY_BALANCE, beginDay, convertMode, dc);
                } else {
                    this.fillBalance(companyInfo, temPeriodInfo.getPeriodYear(), temPeriodInfo.getPeriodNumber(), row, exchange2, balance, isCurEqualsBasecur, DAY_BALANCE, convertMode, dc);
                }
                first = false;
            }
            if (isShowPeriodTotal) {
                row = tblMain.addRow();
                tempDate = temPeriodInfo.getEndDate();
                exchange = JournalHandler.getExchange(companyInfo, sourceCurrency, null, tempDate);
                if (temPeriodInfo.getEndDate().compareTo(new Timestamp(endDay.getTime())) < 0) {
                    this.fillTotal(companyInfo, temPeriodInfo.getPeriodYear(), temPeriodInfo.getPeriodNumber(), temPeriodInfo.getEndDate(), row, exchange, monthDebitAmt, monthCreditAmt, balance, isCurEqualsBasecur, PERIOD_TOTAL, convertMode, dc);
                } else {
                    this.fillTotal(companyInfo, temPeriodInfo.getPeriodYear(), temPeriodInfo.getPeriodNumber(), endDay, row, exchange, monthDebitAmt, monthCreditAmt, balance, isCurEqualsBasecur, PERIOD_TOTAL, convertMode, dc);
                }
                monthDebitAmt = Constants.ZERO;
                monthCreditAmt = Constants.ZERO;
            }
            if (isShowYearTotal) {
                row = tblMain.addRow();
                tempDate = temPeriodInfo.getEndDate();
                exchange = JournalHandler.getExchange(companyInfo, sourceCurrency, null, tempDate);
                if (temPeriodInfo.getEndDate().compareTo(new Timestamp(endDay.getTime())) < 0) {
                    this.fillTotal(companyInfo, temPeriodInfo.getPeriodYear(), temPeriodInfo.getPeriodNumber(), temPeriodInfo.getEndDate(), row, exchange, yearDebitAmt, yearCreditAmt, balance, isCurEqualsBasecur, YEAR_TOTAL, convertMode, dc);
                } else {
                    this.fillTotal(companyInfo, temPeriodInfo.getPeriodYear(), temPeriodInfo.getPeriodNumber(), endDay, row, exchange, yearDebitAmt, yearCreditAmt, balance, isCurEqualsBasecur, YEAR_TOTAL, convertMode, dc);
                }
            }
            if ((temNextPeriodInfo = PeriodHelper.getNextPeriodInfo(companyInfo, temPeriodInfo)) == null) {
                return;
            }
            if ((temNextPeriodInfo.getPeriodYear() < endPeriodInfo.getPeriodYear() || temNextPeriodInfo.getPeriodYear() == endPeriodInfo.getPeriodYear() && endPeriodInfo.getPeriodNumber() >= temNextPeriodInfo.getPeriodNumber()) && temPeriodInfo.getPeriodYear() < temNextPeriodInfo.getPeriodYear()) {
                row = tblMain.addRow();
                tempDate = temNextPeriodInfo.getBeginDate();
                exchange = JournalHandler.getExchange(companyInfo, sourceCurrency, null, DateUtil.getBeforeDay((Date)tempDate));
                this.fillBalance(companyInfo, temNextPeriodInfo.getPeriodYear(), temNextPeriodInfo.getPeriodNumber(), row, exchange, balance, isCurEqualsBasecur, YEAR_BALANCE, convertMode, dc);
                yearDebitAmt = CasConstants.ZERO;
                yearCreditAmt = CasConstants.ZERO;
            }
            temPeriodInfo = temNextPeriodInfo;
        }
    }

    protected void setBeginBalanceRowDisc(KDTable tblMain, Date beginDate, boolean isByDay, BigDecimal exchange, boolean isCurEqualsBasecur, BigDecimal dayBalance, ConvertModeEnum convertMode, BalanceDirectionEnum dc) {
        if (isByDay) {
            String desc = null;
            int size = tblMain.getRowCount() >= 2 ? 2 : tblMain.getRowCount();
            for (int i = 0; i < size; ++i) {
                IRow row = tblMain.getRow(i);
                desc = (String)row.getCell(COL_DESCRIPTION).getValue();
                if (desc == null || !desc.equals(BEGIN_BALANCE)) continue;
                desc = DAY_BALANCE;
                this.fillBalance(row, exchange, dayBalance, isCurEqualsBasecur, desc, beginDate, convertMode, dc);
                break;
            }
        }
    }

    public void setHeadShowLocalCurrency(KDTable tblMain) {
        if (tblMain.getColumn("verify") == null) {
            tblMain.getHeadMergeManager().splitBlock(0, tblMain.getColumnIndex(COL_DEBIT), 1, tblMain.getColumnIndex(COL_LOCAL_DEBIT));
            tblMain.getHeadMergeManager().splitBlock(0, tblMain.getColumnIndex(COL_CREDIT), 1, tblMain.getColumnIndex(COL_LOCAL_CREDIT));
            tblMain.getHeadMergeManager().splitBlock(0, tblMain.getColumnIndex(COL_BALANCE), 1, tblMain.getColumnIndex(COL_LOCAL_BALANCE));
            tblMain.getHeadMergeManager().mergeBlock(0, tblMain.getColumnIndex(COL_DEBIT), 0, tblMain.getColumnIndex(COL_LOCAL_DEBIT));
            tblMain.getHeadMergeManager().mergeBlock(0, tblMain.getColumnIndex(COL_CREDIT), 0, tblMain.getColumnIndex(COL_LOCAL_CREDIT));
            tblMain.getHeadMergeManager().mergeBlock(0, tblMain.getColumnIndex(COL_BALANCE), 0, tblMain.getColumnIndex(COL_LOCAL_BALANCE));
        } else {
            tblMain.getHeadMergeManager().splitBlock(0, tblMain.getColumnIndex(COL_DEBIT), 1, tblMain.getColumnIndex(COL_LOCAL_DEBIT));
            tblMain.getHeadMergeManager().splitBlock(0, tblMain.getColumnIndex(COL_CREDIT), 1, tblMain.getColumnIndex(COL_LOCAL_CREDIT));
            tblMain.getHeadMergeManager().splitBlock(0, tblMain.getColumnIndex(COL_BALANCE), 1, tblMain.getColumnIndex(COL_LOCAL_BALANCE));
            tblMain.getHeadMergeManager().mergeBlock(0, tblMain.getColumnIndex(COL_DEBIT), 0, tblMain.getColumnIndex(COL_LOCAL_DEBIT));
            tblMain.getHeadMergeManager().mergeBlock(0, tblMain.getColumnIndex(COL_CREDIT), 0, tblMain.getColumnIndex(COL_LOCAL_CREDIT));
            tblMain.getHeadMergeManager().mergeBlock(0, tblMain.getColumnIndex(COL_BALANCE), 0, tblMain.getColumnIndex(COL_LOCAL_BALANCE));
        }
    }

    public void setHeadHideLocalCurrency(KDTable tblMain) {
        if (tblMain.getColumn("verify") == null) {
            tblMain.getHeadMergeManager().mergeBlock(0, tblMain.getColumnIndex(COL_DEBIT), 1, tblMain.getColumnIndex(COL_LOCAL_DEBIT));
            tblMain.getHeadMergeManager().mergeBlock(0, tblMain.getColumnIndex(COL_CREDIT), 1, tblMain.getColumnIndex(COL_LOCAL_CREDIT));
            tblMain.getHeadMergeManager().mergeBlock(0, tblMain.getColumnIndex(COL_BALANCE), 1, tblMain.getColumnIndex(COL_LOCAL_BALANCE));
        } else {
            tblMain.getHeadMergeManager().mergeBlock(0, tblMain.getColumnIndex(COL_DEBIT), 1, tblMain.getColumnIndex(COL_LOCAL_DEBIT));
            tblMain.getHeadMergeManager().mergeBlock(0, tblMain.getColumnIndex(COL_CREDIT), 1, tblMain.getColumnIndex(COL_LOCAL_CREDIT));
            tblMain.getHeadMergeManager().mergeBlock(0, tblMain.getColumnIndex(COL_BALANCE), 1, tblMain.getColumnIndex(COL_LOCAL_BALANCE));
        }
    }

    protected void setLocalColumnHided(KDTable tblMain, boolean isHide) {
        if (isHide) {
            this.setHeadHideLocalCurrency(tblMain);
            tblMain.getColumn(COL_EXCHANGE).getStyleAttributes().setHided(true);
            tblMain.getColumn(COL_LOCAL_DEBIT).getStyleAttributes().setHided(true);
            tblMain.getColumn(COL_LOCAL_CREDIT).getStyleAttributes().setHided(true);
            tblMain.getColumn(COL_LOCAL_BALANCE).getStyleAttributes().setHided(true);
        } else {
            this.setHeadShowLocalCurrency(tblMain);
            tblMain.getHeadRow(1).getStyleAttributes().setHided(false);
            tblMain.getColumn(COL_EXCHANGE).getStyleAttributes().setHided(false);
            tblMain.getColumn(COL_LOCAL_DEBIT).getStyleAttributes().setHided(false);
            tblMain.getColumn(COL_LOCAL_CREDIT).getStyleAttributes().setHided(false);
            tblMain.getColumn(COL_LOCAL_BALANCE).getStyleAttributes().setHided(false);
        }
    }

    protected ConvertModeEnum getExchangeConvertMode(CompanyOrgUnitInfo company, CurrencyInfo sourceCurrency, CurrencyInfo desCurrency) throws EASBizException, BOSException {
        IExchangeRate iexchangRate = null;
        ObjectUuidPK excTablepk = null;
        ObjectUuidPK sourceCurrpk = null;
        ObjectUuidPK destCurrpk = null;
        if (company == null) {
            company = SysContext.getSysContext().getCurrentFIUnit();
        } else if (company.getBaseExchangeTable() == null || company.getBaseCurrency() == null) {
            company = CashHelper.getCompanyInfo(company.getId());
        }
        if (sourceCurrency == null) {
            return ConvertModeEnum.DIRECTEXCHANGERATE;
        }
        if (desCurrency == null) {
            desCurrency = company.getBaseCurrency();
        }
        if (company.getBaseExchangeTable() == null) {
            return ConvertModeEnum.DIRECTEXCHANGERATE;
        }
        excTablepk = new ObjectUuidPK(company.getBaseExchangeTable().getId());
        if (desCurrency == null) {
            return ConvertModeEnum.DIRECTEXCHANGERATE;
        }
        if (desCurrency.getId().equals((Object)sourceCurrency.getId())) {
            return ConvertModeEnum.DIRECTEXCHANGERATE;
        }
        destCurrpk = new ObjectUuidPK(desCurrency.getId());
        iexchangRate = ExchangeRateFactory.getRemoteInstance();
        ExchangeRateInfo erInfo = iexchangRate.getExchangeRateConvertInfo((IObjectPK)excTablepk, (IObjectPK)(sourceCurrpk = new ObjectUuidPK(sourceCurrency.getId())), (IObjectPK)destCurrpk, Calendar.getInstance().getTime());
        if (erInfo == null) {
            return ConvertModeEnum.DIRECTEXCHANGERATE;
        }
        return erInfo.getConvertMode();
    }

    public static PeriodEntity requestPeriodEntity(CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        return new PeriodEntity(JournalFactory.getRemoteInstance().getPeriodRange(company));
    }

    public static BigDecimal getExchange(CompanyOrgUnitInfo company, CurrencyInfo sourceCurrency, CurrencyInfo desCurrency, Date date) throws EASBizException, BOSException {
        BigDecimal rate = CashHelper.getExchange(company, sourceCurrency, null, date);
        if (rate == null || rate.compareTo(Constants.ZERO) == 0) {
            SysUtil.abort();
        }
        return rate;
    }
}

