/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.client.CashClientHelper;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.util.DateTimeUtils;
import java.sql.Timestamp;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;

public class OutStandUnreachFilterParam
implements FilterParam {
    private static final long serialVersionUID = 4851525625976491949L;
    private String accountBankId;
    private String accountBankName;
    private String bankName;
    private String accountViewNumber;
    private String accountViewName;
    private boolean cancAccount;
    private String currencyId;
    private String currencyName;
    private int periodYear;
    private int periodNumber;
    private boolean isEntRpt;
    private int greater;
    private boolean showRecPay;
    private boolean showTotal;
    private String acctTableId;
    private CompanyOrgUnitInfo company = null;

    public CompanyOrgUnitInfo getCompany() {
        return this.company;
    }

    public void setCompany(CompanyOrgUnitInfo company) {
        this.company = company;
    }

    public String getAcctTableId() {
        return this.acctTableId;
    }

    public void setAcctTableId(String acctTableId) {
        this.acctTableId = acctTableId;
    }

    public boolean isCancAccount() {
        return this.cancAccount;
    }

    public void setCancAccount(boolean cancAccount) {
        this.cancAccount = cancAccount;
    }

    public int getGreater() {
        return this.greater;
    }

    public void setGreater(int greater) {
        this.greater = greater;
    }

    public boolean isEntRpt() {
        return this.isEntRpt;
    }

    public void setEntRpt(boolean isEntRpt) {
        this.isEntRpt = isEntRpt;
    }

    public boolean isShowRecPay() {
        return this.showRecPay;
    }

    public void setShowRecPay(boolean showRecPay) {
        this.showRecPay = showRecPay;
    }

    public boolean isShowTotal() {
        return this.showTotal;
    }

    public void setShowTotal(boolean showTotal) {
        this.showTotal = showTotal;
    }

    public FilterInfo getFilter() {
        FilterInfo filter = new FilterInfo();
        try {
            AccountBankInfo info = null;
            try {
                info = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(this.getAccountBankId()));
            }
            catch (EASBizException e1) {
                e1.printStackTrace();
            }
            catch (BOSException e1) {
                e1.printStackTrace();
            }
            CompanyOrgUnitInfo companyInfo = null;
            companyInfo = !EmptyUtil.isEmpty((CoreBaseInfo)this.company) ? this.company : ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            if (CashClientHelper.isShareBalanceOfAcctCompany(info, companyInfo.getId().toString())) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter1 = new FilterInfo();
                filter1.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)info.getBankAccountNumber(), CompareType.EQUALS));
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("id"));
                selector.add(new SelectorItemInfo("name"));
                selector.add(new SelectorItemInfo("number"));
                selector.add(new SelectorItemInfo("company.id"));
                selector.add(new SelectorItemInfo("company.name"));
                selector.add(new SelectorItemInfo("company.number"));
                view.setSelector(selector);
                view.setFilter(filter1);
                AccountBankCollection acctColl = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
                HashSet<String> bankSet = new HashSet<String>();
                HashSet<String> companySet = new HashSet<String>();
                for (int i = 0; i < acctColl.size(); ++i) {
                    AccountBankInfo tmp = acctColl.get(i);
                    bankSet.add(tmp.getId().toString());
                    companySet.add(tmp.getCompany().getId().toString());
                }
                filter.getFilterItems().add(new FilterItemInfo("accountBank.id", bankSet, CompareType.INCLUDE));
                filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)this.getCurrencyId()));
                filter.getFilterItems().add(new FilterItemInfo("company.id", companySet, CompareType.INCLUDE));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("accountBank.id", (Object)this.getAccountBankId()));
                filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)this.getCurrencyId()));
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyInfo.getId().toString()));
            }
            PeriodInfo periodInfo = PeriodUtils.getPeriodInfo((int)this.getPeriodYear(), (int)this.getPeriodNumber(), (CompanyOrgUnitInfo)companyInfo);
            Timestamp endDate = periodInfo.getEndDate();
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(endDate);
            int offsetDays = 0;
            PeriodInfo prePeriodInfo = periodInfo;
            for (int i = 0; i < this.getGreater() && prePeriodInfo != null; ++i) {
                long days = DateHelper.dateDiff((String)"d", (Date)prePeriodInfo.getBeginDate(), (Date)prePeriodInfo.getEndDate());
                offsetDays = (int)((long)offsetDays + (days + 1L));
            }
            cal.set(5, cal.get(5) - offsetDays);
            filter.getFilterItems().add(new FilterItemInfo("createDate", (Object)DateTimeUtils.truncateDate((Date)cal.getTime()), CompareType.LESS_EQUALS));
        }
        catch (EASBizException e) {
            SysUtil.abort();
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        return filter;
    }

    public SorterItemCollection getSorterItems() {
        return null;
    }

    public String getAccountBankId() {
        return this.accountBankId;
    }

    public void setAccountBankId(String accountBankId) {
        this.accountBankId = accountBankId;
    }

    public String getAccountBankName() {
        return this.accountBankName;
    }

    public void setAccountBankName(String accountBankName) {
        this.accountBankName = accountBankName;
    }

    public String getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(String currencyId) {
        this.currencyId = currencyId;
    }

    public String getCurrencyName() {
        return this.currencyName;
    }

    public void setCurrencyName(String currencyName) {
        this.currencyName = currencyName;
    }

    public int getPeriodNumber() {
        return this.periodNumber;
    }

    public void setPeriodNumber(int periodNumber) {
        this.periodNumber = periodNumber;
    }

    public int getPeriodYear() {
        return this.periodYear;
    }

    public void setPeriodYear(int periodYear) {
        this.periodYear = periodYear;
    }

    public String getBankName() {
        return this.bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public String getAccountViewName() {
        return this.accountViewName;
    }

    public void setAccountViewName(String accountViewName) {
        this.accountViewName = accountViewName;
    }

    public String getAccountViewNumber() {
        return this.accountViewNumber;
    }

    public void setAccountViewNumber(String accountViewNumber) {
        this.accountViewNumber = accountViewNumber;
    }
}

