/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasContrastGLHelper;
import com.kingdee.eas.fi.cas.CashAccountTool;
import com.kingdee.eas.fi.cas.client.AbstractOutStandingFilterUI;
import com.kingdee.eas.fi.cas.client.CashClientHelper;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fi.cas.client.ISharedOrgSupport;
import com.kingdee.eas.fi.cas.client.OutStandUnreachFilterParam;
import com.kingdee.eas.fi.cas.client.PeriodHelper;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.TypeConversionUtils;
import java.awt.Component;
import java.sql.SQLException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class OutStandingFilterUI
extends AbstractOutStandingFilterUI
implements ISharedOrgSupport {
    private static Logger logger = Logger.getLogger((String)OutStandingFilterUI.class.getName());
    private String acctTableId = null;
    private CompanyOrgUnitInfo company = null;
    private CompanyOrgUnitInfo companyInfo = null;
    private AccountBankCollection acctBankColl = null;
    private boolean isSharedOrg = false;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public Object getParam() {
        OutStandUnreachFilterParam param = new OutStandUnreachFilterParam();
        AccountBankInfo accountBankInfo = (AccountBankInfo)this.prmtBankAccount.getValue();
        param.setAccountBankId(accountBankInfo.getId().toString());
        param.setAccountBankName(accountBankInfo.getBankAccountNumber());
        param.setBankName(accountBankInfo.getBank().getName());
        param.setCancAccount(this.chkCancAccount.isSelected());
        CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        param.setCurrencyId(currencyInfo.getId().toString());
        param.setCurrencyName(currencyInfo.getName());
        param.setPeriodYear(TypeConversionUtils.objToInt((Object)this.spinPeriod.getValue()));
        param.setPeriodNumber(TypeConversionUtils.objToInt((Object)this.spinPeriodNum.getValue()));
        param.setEntRpt(this.btnEntpr.isSelected());
        param.setGreater(TypeConversionUtils.objToInt((Object)this.spinGreater.getValue()));
        param.setShowRecPay(this.chkShowRecPay.isSelected());
        param.setShowTotal(this.chkShowAmount.isSelected());
        param.setCompany((CompanyOrgUnitInfo)this.prmtCompany.getValue());
        if (this.acctTableId == null) {
            this.getAcctTableID();
        }
        param.setAcctTableId(this.acctTableId);
        try {
            accountBankInfo = FMHelper.getJouranlBalanceAcctBank(null, (AccountBankInfo)accountBankInfo, null, (String)this.acctTableId);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        param.setAccountViewNumber(accountBankInfo.getAccount().getNumber());
        param.setAccountViewName(accountBankInfo.getAccount().getName());
        return param;
    }

    public void setParam(Object arg0) {
        if (arg0 == null) {
            return;
        }
        try {
            OutStandUnreachFilterParam param = (OutStandUnreachFilterParam)arg0;
            AccountBankInfo accountBankInfo = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(param.getAccountBankId()));
            BankInfo bank = new BankInfo();
            bank.setName(param.getBankName());
            accountBankInfo.setBank(bank);
            AccountViewInfo accountView = new AccountViewInfo();
            accountView.setNumber(param.getAccountViewNumber());
            accountView.setName(param.getAccountViewName());
            accountBankInfo.setAccount(accountView);
            if (!EmptyUtil.isEmpty((CoreBaseInfo)param.getCompany())) {
                this.prmtCompany.setValue((Object)param.getCompany());
            }
            this.chkCancAccount.setSelected(param.isCancAccount());
            this.prmtBankAccount.setValue((Object)accountBankInfo);
            CurrencyInfo currencyInfo = new CurrencyInfo();
            currencyInfo.setId(BOSUuid.read((String)param.getCurrencyId()));
            currencyInfo.setName(param.getCurrencyName());
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)currencyInfo);
            this.spinPeriod.setValue((Object)new Integer(param.getPeriodYear()));
            this.spinPeriodNum.setValue((Object)new Integer(param.getPeriodNumber()));
            this.btnEntpr.setSelected(param.isEntRpt());
            this.btnBank.setSelected(!param.isEntRpt());
            this.spinGreater.setValue((Object)new Integer(param.getGreater()));
            this.chkShowRecPay.setSelected(param.isShowRecPay());
            this.chkShowAmount.setSelected(param.isShowTotal());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public void clear() {
        super.clear();
        try {
            this.company = this.companyInfo = this.getCompanyOrgUnitInfoByUserPermisson();
            this.prmtCompany.setValue((Object)this.companyInfo);
            if (this.companyInfo == null) {
                this.companyInfo = this.company;
            }
            this.initAccountBank();
            ClientUtils.setSelectedItem(this.comboCurrency, this.companyInfo.getBaseCurrency().getId().toString());
            this.chkCancAccount.setSelected(false);
            this.btnEntpr.setSelected(true);
            this.btnBank.setSelected(false);
            this.chkShowRecPay.setSelected(false);
            this.chkShowAmount.setSelected(false);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    protected void period_stateChanged(ChangeEvent e) throws Exception {
        PeriodHelper.setPeriodNum(this.company, this.spinPeriodNum, (Integer)this.spinPeriod.getValue());
    }

    protected void init() throws Exception {
        super.init();
        this.initMainOrgF7();
        this.companyInfo = this.getCompanyOrgUnitInfoByUserPermisson();
        if (EmptyUtil.isEmpty((CoreBaseInfo)this.companyInfo)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"456_OutStandingFilterUI"));
            SysUtil.abort();
        }
        this.company = this.companyInfo;
        this.prmtCompany.setValue((Object)this.companyInfo);
        if (this.companyInfo == null) {
            this.companyInfo = this.company;
        }
        CasContrastGLHelper.initComboCurrency(this.comboCurrency, true, this.companyInfo);
        this.initAccountBank();
        PeriodHelper.initPeriodSpinner(this.company, this.spinPeriod, this.spinPeriodNum);
        this.btnCompanySelect.setVisible(false);
        this.spinPeriodNum.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    OutStandingFilterUI.this.period_stateChanged(e);
                }
                catch (Exception exc) {
                    OutStandingFilterUI.this.handUIException(exc);
                }
            }
        });
    }

    private CompanyOrgUnitInfo getCompanyOrgUnitInfoByUserPermisson() throws EASBizException, BOSException, SQLException {
        CompanyOrgUnitCollection companyColl = new CompanyOrgUnitCollection();
        CompanyOrgUnitInfo tmpCompanyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (!com.kingdee.eas.fi.cas.utils.FMHelper.checkCurrentCompany(null, tmpCompanyInfo, "cas_bankbalanceagjtable_01view")) {
            companyColl = com.kingdee.eas.fi.cas.utils.FMHelper.getUserOrgRangesWithRangeWhereStartPeriod(null, "cas_bankbalanceagjtable_01view");
            tmpCompanyInfo = companyColl.get(0);
        }
        return tmpCompanyInfo;
    }

    private void initAccountBank() throws BOSException, EASBizException {
        String strCompanyId = this.companyInfo.getId().toString();
        this.acctBankColl = CashClientHelper.getSharedAcctAccountBankCollection(strCompanyId, false);
        if (this.acctBankColl != null) {
            this.prmtBankAccount.setValue((Object)this.acctBankColl.get(0));
        }
    }

    public boolean verify() {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtBankAccount);
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDComboBox)this.comboCurrency);
        this.getAcctTableID();
        return super.verify();
    }

    private void getAcctTableID() {
        int beginYear = AccessHelper.getSpiValue((KDSpinner)this.spinPeriod);
        int beginMonth = AccessHelper.getSpiValue((KDSpinner)this.spinPeriodNum);
        int endYear = AccessHelper.getSpiValue((KDSpinner)this.spinPeriod);
        int endMonth = AccessHelper.getSpiValue((KDSpinner)this.spinPeriodNum);
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
        try {
            this.acctTableId = CashAccountTool.getDisplayAcctTable(company.getId().toString(), null, beginYear, beginMonth, endYear, endMonth);
        }
        catch (EASBizException e) {
            this.handUIException(e);
            e.printStackTrace();
        }
        catch (BOSException e) {
            this.handUIException(e);
            e.printStackTrace();
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.contPeriod.setEnabled(true);
        this.contCurrency.setEnabled(true);
        this.contGreater.setEnabled(true);
        this.lblYearDesc.setEnabled(true);
    }

    @Override
    protected void prmtBankAccount_dataChanged(DataChangeEvent e) throws Exception {
        AccountBankInfo bankInfo = (AccountBankInfo)this.prmtBankAccount.getValue();
        if (bankInfo == null) {
            return;
        }
        CurrencyInfo currency = null;
        if (bankInfo.isIsByCurrency()) {
            currency = bankInfo.getCurrency();
            this.comboCurrency.setEnabled(false);
        } else {
            currency = this.companyInfo.getBaseCurrency();
            this.comboCurrency.setEnabled(true);
        }
        UIUtil.setSelectObject((KDComboBox)this.comboCurrency, (Object)currency);
    }

    @Override
    protected void prmtBankAccount_willCommit(CommitEvent e) throws Exception {
        super.prmtBankAccount_willCommit(e);
        this.bankAccountQueryInfo();
    }

    @Override
    protected void prmtBankAccount_willShow(SelectorEvent e) throws Exception {
        super.prmtBankAccount_willShow(e);
        this.bankAccountQueryInfo();
    }

    public void bankAccountQueryInfo() throws Exception {
        ClientUtils.setBankListIncludeShared(this.prmtBankAccount, this.companyInfo.getId().toString(), this.chkCancAccount.isSelected());
    }

    @Override
    protected void prmtCompany_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtCompany.getValue() != null && e.getNewValue() == e.getOldValue()) {
            return;
        }
        if (this.prmtCompany.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"432_BankBalanceAdjustmentBFilterUI"));
            this.prmtCompany.setData(e.getOldValue());
            SysUtil.abort();
        }
        this.companyInfo = (CompanyOrgUnitInfo)this.prmtCompany.getData();
        boolean a = true;
        PeriodHelper.initPeriodSpinner(this.companyInfo, this.spinPeriod, this.spinPeriodNum);
        String strCompanyId = this.companyInfo.getId().toString();
        this.acctBankColl = CashClientHelper.getAccountBankCollection(strCompanyId, true);
        CasContrastGLHelper.initComboCurrency(this.comboCurrency, true, this.companyInfo);
        if (this.acctBankColl != null) {
            this.prmtBankAccount.setValue((Object)this.acctBankColl.get(0));
        }
    }

    protected Class getParamClass() {
        return OutStandUnreachFilterParam.class;
    }

    public KDBizPromptBox getMainOrg() {
        return this.prmtCompany;
    }

    public boolean isSupportMultiOrgs() {
        this.prmtCompany.setEnabled(this.isSharedOrg());
        return false;
    }

    public String getPermissionItem() {
        return "cas_bankbalanceagjtable_01view";
    }

    @Override
    public void setIsSharedOrg(boolean value) {
        this.isSharedOrg = value;
    }

    @Override
    public boolean isSharedOrg() {
        return this.isSharedOrg;
    }
}

