/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.client.AbstractOutStandingListUI;
import com.kingdee.eas.fi.cas.client.CashClientHelper;
import com.kingdee.eas.fi.cas.client.OutStandUnreachFilterParam;
import com.kingdee.eas.fi.cas.client.OutStandUnreachUIStrategy;
import com.kingdee.eas.fi.cas.client.OutStandingFilterUI;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.KeyStroke;

public class OutStandingListUI
extends AbstractOutStandingListUI {
    private static final String RESOURCE_PATH = "com.kingdee.eas.fi.cas.CasResources";
    private OutStandUnreachUIStrategy uiStrategy;
    private OutStandingFilterUI filterUI = null;
    private boolean isSharedOrg = false;

    protected boolean isRpcCacheProcess() {
        return true;
    }

    protected String getRpcBatchImplClassName() {
        return "com.kingdee.eas.fi.cas.app.OutStandingBatchFetcher";
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new OutStandingFilterUI();
        }
        return this.filterUI;
    }

    public CommonQueryDialog getQueryDlg() throws Exception {
        CommonQueryDialog diag = super.getQueryDlg();
        diag.setWidth(380);
        diag.setShowFilter(false);
        diag.setShowSorter(false);
        return diag;
    }

    protected KDTable getMainTable() {
        return this.tblMain;
    }

    protected void execQuery() throws BOSException {
        OutStandUnreachFilterParam param = (OutStandUnreachFilterParam)this.getFilterParam();
        this.setHeaderTxt(param);
        this.uiStrategy = OutStandUnreachUIStrategy.getInstance(param.isEntRpt());
        this.uiStrategy.initTable(this.getMainTable(), param.getCurrencyId());
        IRowSet rowSet = this.uiStrategy.getRowSet(param);
        try {
            this.uiStrategy.fillData(this.getMainTable(), rowSet, param);
        }
        catch (SQLException e) {
            this.handUIExceptionAndAbort(e);
        }
    }

    private void setHeaderTxt(OutStandUnreachFilterParam param) {
        String bankTitle = param.getBankName() + "-" + param.getAccountBankName();
        this.txtBank.setText(bankTitle);
        this.txtCurrency.setText(param.getCurrencyName());
        this.txtBankAccount.setText(param.getAccountViewNumber() + " " + param.getAccountViewName());
        String periodTxt = EASResource.getString((String)RESOURCE_PATH, (String)"LBL_Period");
        Object[] args = new String[]{String.valueOf(param.getPeriodYear()), String.valueOf(param.getPeriodNumber())};
        this.txtPeriod.setText(MessageFormat.format(periodTxt, args));
        String rptTypeResName = param.isEntRpt() ? "OutstandingType_Entpr" : "OutstandingType_Bank";
        this.txtReportType.setText(EASResource.getString((String)RESOURCE_PATH, (String)rptTypeResName));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionExport.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_output"));
    }

    public boolean destroyWindow() {
        if (this.isSharedOrg) {
            CashClientHelper.releaseSharedOrgLicense();
        }
        return super.destroyWindow();
    }

    public void onLoad() throws Exception {
        this.isSharedOrg = CashClientHelper.hasSharedOrgUIParam((CoreUIObject)this);
        if (this.isSharedOrg) {
            CashClientHelper.processSharedOrgFilterUI(this.getFilterUI());
            CashClientHelper.processSharedOrgLicense((CoreUI)this);
        }
        super.onLoad();
        PeriodInfo currentPeriod = this.rpcCacheInfo.getCurPeriod();
        if (currentPeriod == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CheckoutResource", (String)"MSG_periodError"));
            SysUtil.abort();
        }
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
    }

    protected void preparePrintPageHeader(HeadFootModel headerModel) {
        String companyString = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"368_OutStandingListUI");
        String bankAcctString = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"369_OutStandingListUI");
        String currencyString = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"370_OutStandingListUI");
        String bankAcctViewString = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"371_OutStandingListUI");
        String PeriodRangeString = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"372_OutStandingListUI");
        String type = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"373_OutStandingListUI");
        StyleAttributes sb = Styles.getDefaultSA();
        String headString = bankAcctString + " &| " + currencyString;
        headerModel.addRow(headString, sb);
        headString = bankAcctViewString + " &|" + PeriodRangeString;
        headerModel.addRow(headString, sb);
        headString = type;
        headerModel.addRow(headString, sb);
        super.preparePrintPageHeader(headerModel);
    }

    protected Map preparePrintVariantMap() {
        Map hm = super.preparePrintVariantMap();
        hm.put("BankAccount", this.txtBank.getText());
        hm.put("Currency", this.txtCurrency.getText());
        hm.put("BankAccountView", this.txtBankAccount.getText());
        hm.put("PeriodRange", this.txtPeriod.getText());
        hm.put("type", this.txtReportType.getText());
        return hm;
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        OutStandUnreachFilterParam filterParam = (OutStandUnreachFilterParam)this.getFilterParam();
        ObjectUuidPK companyPK = new ObjectUuidPK(filterParam.getCompany().getId().toString());
        IPermission ipermission = PermissionFactory.getRemoteInstance();
        ipermission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)companyPK, "cas_outstanding_02print");
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPre_actionPerformed(ActionEvent e) throws Exception {
        OutStandUnreachFilterParam filterParam = (OutStandUnreachFilterParam)this.getFilterParam();
        ObjectUuidPK companyPK = new ObjectUuidPK(filterParam.getCompany().getId().toString());
        IPermission ipermission = PermissionFactory.getRemoteInstance();
        ipermission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)companyPK, "cas_outstanding_02print");
        super.actionPrintPre_actionPerformed(e);
    }
}

