/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.fi.cas.LogCategoryEnum;
import com.kingdee.eas.fi.cas.PayAdmitDestEntityEnum;
import com.kingdee.eas.fi.cas.client.AbstractPayAntiGravityLogFilterUI;
import com.kingdee.eas.fi.cas.client.PayAntiGravityLogFilterParam;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import java.awt.event.ActionEvent;
import java.sql.Date;
import java.util.Collection;
import org.apache.log4j.Logger;

public class PayAntiGravityLogFilterUI
extends AbstractPayAntiGravityLogFilterUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(PayAntiGravityLogFilterUI.class);

    public String getPermissionItem() {
        return "paymentOperateLog_view";
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void chkIA_actionPerformed(ActionEvent e) throws Exception {
        super.chkIA_actionPerformed(e);
    }

    protected void init() throws Exception {
        super.init();
        this.btnCompanySelect.setVisible(false);
        this.initBillStatus();
        this.pkDateFrom.setValue((Object)DateHelper.getDayBegin());
        this.pkDateTo.setValue((Object)DateHelper.getDayBegin());
        this.pkDateFrom.setSupportedEmpty(false);
        this.pkDateTo.setSupportedEmpty(false);
        FMClientHelper.setSelectObject((KDComboBox)this.comboOperateType, (Object)FMSysDefinedEnum.ALL_ITEMS);
        this.initOperateBill();
        FMClientHelper.setSelectObject((KDComboBox)this.comboOperateBill, (Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    protected void btnCompanySelect_actionPerformed(ActionEvent e) throws Exception {
        super.btnCompanySelect_actionPerformed(e);
    }

    private void initBillStatus() {
        this.comboOperateType.removeAllItems();
        this.comboOperateType.addItems(LogCategoryEnum.getEnumList().toArray());
        this.comboOperateType.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    private void initOperateBill() {
        this.comboOperateBill.removeAllItems();
        this.comboOperateBill.addItems(PayAdmitDestEntityEnum.getEnumList().toArray());
        this.comboOperateBill.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    public boolean verify() {
        FMClientVerifyHelper.verifyBeginEndDateRel((CoreUIObject)this, (java.util.Date)((java.util.Date)this.pkDateFrom.getValue()), (java.util.Date)((java.util.Date)this.pkDateTo.getValue()));
        Date startDate = this.pkDateFrom.getSqlDate();
        Date endDate = this.pkDateTo.getSqlDate();
        FMClientVerifyHelper.verifyBeginEndDateRel((CoreUIObject)this, (java.util.Date)startDate, (java.util.Date)endDate);
        return super.verify();
    }

    public Object getParam() {
        PayAntiGravityLogFilterParam paramInfo = new PayAntiGravityLogFilterParam();
        if (this.comboOperateType.getSelectedItem().equals(FMSysDefinedEnum.ALL_ITEMS)) {
            paramInfo.setOperateType(999);
        } else {
            paramInfo.setOperateType(((LogCategoryEnum)((Object)this.comboOperateType.getSelectedItem())).getValue());
        }
        if (this.comboOperateBill.getSelectedItem().equals(FMSysDefinedEnum.ALL_ITEMS)) {
            paramInfo.setOperateBillEnum(999);
        } else {
            paramInfo.setOperateBillEnum(((PayAdmitDestEntityEnum)((Object)this.comboOperateBill.getSelectedItem())).getValue());
        }
        paramInfo.setStartDate((java.util.Date)this.pkDateFrom.getValue());
        java.util.Date tmpDate = (java.util.Date)this.pkDateTo.getValue();
        long time = tmpDate.getTime();
        java.util.Date endDate = new java.util.Date(time + 86399000L);
        paramInfo.setEndDate(endDate);
        return paramInfo;
    }

    public void setParam(Object param) {
        PayAntiGravityLogFilterParam paramInfo = (PayAntiGravityLogFilterParam)param;
        if (paramInfo.getOperateType() == 999) {
            this.comboOperateType.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        } else {
            this.comboOperateType.setSelectedItem((Object)LogCategoryEnum.getEnum(paramInfo.getOperateType()));
        }
        if (paramInfo.getOperateBillEnum() == 999) {
            this.comboOperateBill.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        } else {
            this.comboOperateBill.setSelectedItem((Object)PayAdmitDestEntityEnum.getEnum(paramInfo.getOperateBillEnum()));
        }
        this.pkDateTo.setValue((Object)paramInfo.getEndDate());
        this.pkDateFrom.setValue((Object)paramInfo.getStartDate());
        if (!EmptyUtil.isEmpty((Collection)paramInfo.getMainOrgCollIDSet())) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)paramInfo.getMainOrgCollIDSet(), CompareType.INCLUDE));
            try {
                CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
            }
            catch (BOSException e) {
                this.handUIException(e);
                logger.error((Object)e);
            }
        }
    }
}

