/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSortItem;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.workflow.monitor.client.WfUtils;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.multiapprove.MultiApproveCollection;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.basedata.assistant.IPrintIntegration;
import com.kingdee.eas.basedata.assistant.PrintIntegrationFactory;
import com.kingdee.eas.basedata.assistant.PrintIntegrationInfo;
import com.kingdee.eas.fi.cas.AssItemsForCashPayCollection;
import com.kingdee.eas.fi.cas.AssItemsForCashPayFactory;
import com.kingdee.eas.fi.cas.AssItemsForCashPayInfo;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class PaymentBillDataProvider
implements BOSQueryDelegate {
    private static Logger logger = Logger.getLogger((String)PaymentBillDataProvider.class.getName());
    private static IMetaDataPK qpk = new MetaDataPK("com.kingdee.eas.fi.cas.PaymentBillTDQuery");
    private Set ids = null;
    private String templatePath = "/FI/CAS/PAYMENTBILL";
    private String currentPK = null;
    private boolean isPrintUnPassAuditResult = true;
    KDNoteHelper currentHelper = null;

    public PaymentBillDataProvider(Set id) {
        this.ids = id;
    }

    public PaymentBillDataProvider(List id) {
        this(new HashSet(id));
    }

    public PaymentBillDataProvider(List id, boolean isPrintUnPassAuditResult) {
        this(new HashSet(id));
        this.isPrintUnPassAuditResult = isPrintUnPassAuditResult;
    }

    public PaymentBillDataProvider(List id, KDNoteHelper currentHelper, IMetaDataPK pk) {
        this(new HashSet(id));
        this.currentHelper = currentHelper;
        qpk = pk;
    }

    public PaymentBillDataProvider(Set id, KDNoteHelper currentHelper) {
        this.ids = id;
        this.currentHelper = currentHelper;
    }

    public PaymentBillDataProvider(List id, KDNoteHelper currentHelper) {
        this(new HashSet(id));
        this.currentHelper = currentHelper;
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        IRowSet iRowSet = null;
        try {
            IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)qpk);
            exec.option().isAutoTranslateEnum = true;
            exec.option().isAutoTranslateBoolean = true;
            exec.option().isMultiLanguage = true;
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("paymentBill.id", (Object)this.ids, CompareType.INCLUDE));
            ArrayList param = ds.getParams();
            FMClientHelper.addDataFilter((FilterInfo)filter, (ArrayList)param);
            R1PrintDataSortItem[] sortItems = ds.getSortFields();
            if (sortItems != null && sortItems.length > 0) {
                for (int i = 0; i < sortItems.length; ++i) {
                    String fieldName = sortItems[i].getSortField();
                    if (EmptyUtil.isEmpty((String)fieldName)) continue;
                    SorterItemInfo sort = null;
                    sort = fieldName.indexOf("entries") > -1 ? new SorterItemInfo(fieldName) : (fieldName.indexOf("paymentBill") > -1 ? new SorterItemInfo(fieldName) : (fieldName.indexOf(".") > -1 ? new SorterItemInfo(fieldName) : new SorterItemInfo("paymentBill." + fieldName)));
                    if (0 == sortItems[i].getSortType()) {
                        sort.setSortType(SortType.ASCEND);
                    } else {
                        sort.setSortType(SortType.DESCEND);
                    }
                    ev.getSorter().add(sort);
                }
            } else {
                SorterItemInfo sort = new SorterItemInfo("paymentBill.number");
                sort.setSortType(SortType.ASCEND);
                ev.getSorter().add(sort);
            }
            ev.setFilter(filter);
            exec.setObjectView(ev);
            iRowSet = exec.executeQuery();
            while (iRowSet.next()) {
                IPrintIntegration pinfo = PrintIntegrationFactory.getRemoteInstance();
                this.currentPK = iRowSet.getString("paymentBill.id");
                if (this.currentHelper.isPrintTimesControllable2(this.templatePath)) {
                    PrintIntegrationInfo printInfo = pinfo.getBillPrintInfo("40284E81", this.currentPK);
                    int printedTimes = 0;
                    if (printInfo != null) {
                        printedTimes = printInfo.getPrintedNumber();
                    }
                    int prepareTimes = this.currentHelper.getCopies();
                    int maxPrintTimes = this.currentHelper.getMaxPrintTimes2(this.templatePath);
                    if (printedTimes < maxPrintTimes) {
                        if (printedTimes + prepareTimes <= maxPrintTimes) {
                            iRowSet.updateString("printCount", Integer.toString(printedTimes + prepareTimes));
                        } else {
                            iRowSet.updateString("printCount", Integer.toString(maxPrintTimes));
                        }
                    } else {
                        iRowSet.updateString("printCount", Integer.toString(printedTimes));
                    }
                } else {
                    iRowSet.updateString("canPrtControl", Integer.toString(3));
                }
                int precision = iRowSet.getInt("currency.precision");
                iRowSet.updateBigDecimal("actualAmt", iRowSet.getBigDecimal("actualAmt").setScale(precision, 4));
                String entryID = iRowSet.getString("PaymentBillEntry.id");
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo filteri = new FilterInfo();
                filteri.getFilterItems().add(new FilterItemInfo("entryParent", (Object)entryID));
                evi.setFilter(filteri);
                evi.getSelector().add(new SelectorItemInfo("*"));
                evi.getSelector().add(new SelectorItemInfo("asstActType.*"));
                AssItemsForCashPayCollection assColl = AssItemsForCashPayFactory.getRemoteInstance().getAssItemsForCashPayCollection(evi);
                AssItemsForCashPayInfo infoTmp = null;
                CoreBaseInfo entityInfo = null;
                StringBuffer sf_assName = new StringBuffer();
                StringBuffer sf_assType = new StringBuffer();
                for (int i = 0; i < assColl.size(); ++i) {
                    infoTmp = assColl.get(i);
                    if (infoTmp.getAsstActType() != null) {
                        sf_assType.append(infoTmp.getAsstActType().getName());
                    }
                    if (infoTmp.getFromID() != null && !infoTmp.getFromID().equals("") && (entityInfo = EJBAccessFactory.createRemoteInstance().getEntityInfo(infoTmp.getFromID())) != null && entityInfo.getString("name") != null) {
                        sf_assName.append(entityInfo.getString("name"));
                    }
                    if (i + 1 == assColl.size()) continue;
                    sf_assType.append("\uff1b");
                    sf_assName.append("\uff1b");
                }
                iRowSet.updateString("assName", sf_assName.toString());
                iRowSet.updateString("assType", sf_assType.toString());
                String currencyId = iRowSet.getString("currency.id");
                String companyId = iRowSet.getString("company.id");
                Date bizDate = iRowSet.getDate("paymentBill.bizDate");
                int exRatePrec = CasRecPayHandler.getExRatePrec(currencyId, null, companyId, (java.util.Date)bizDate);
                iRowSet.updateBigDecimal("paymentBill.exchangeRate", iRowSet.getBigDecimal("paymentBill.exchangeRate").setScale(exRatePrec, 4));
                iRowSet.updateString("paymentBillType.name", iRowSet.getString("paymentBillType.name"));
                iRowSet.updateString("settlementType.name", iRowSet.getString("settlementType.name"));
                iRowSet.updateString("person.name", iRowSet.getString("person.name"));
                iRowSet.updateString("adminOrgUnit.name", iRowSet.getString("adminOrgUnit.name"));
                iRowSet.updateString("coreBillNumber", iRowSet.getString("coreBillNumber"));
                iRowSet.updateString("coreBillType.name", iRowSet.getString("coreBillType.name"));
                iRowSet.updateString("contractNum", iRowSet.getString("contractNum"));
                iRowSet.updateString("contractEntrySeq", iRowSet.getString("contractEntrySeq"));
                iRowSet.updateString("oppAccount1.name", iRowSet.getString("oppAccount1.name"));
                iRowSet.updateString("costCenter.name", iRowSet.getString("costCenter.name"));
                iRowSet.updateString("paymentBill.recProvince", iRowSet.getString("paymentBill.recProvince"));
                iRowSet.updateString("paymentBill.recCity", iRowSet.getString("paymentBill.recCity"));
                iRowSet.updateBigDecimal("paymentBill.actPayAmt", iRowSet.getBigDecimal("paymentBill.actPayAmt").setScale(precision, 4));
                iRowSet.updateBigDecimal("paymentBill.actPayAmtVc", iRowSet.getBigDecimal("paymentBill.actPayAmtVc").setScale(precision, 4));
                iRowSet.updateBigDecimal("paymentBill.actPayLocAmt", iRowSet.getBigDecimal("paymentBill.actPayLocAmt").setScale(precision, 4));
                iRowSet.updateBigDecimal("paymentBill.actPayLocAmtVc", iRowSet.getBigDecimal("paymentBill.actPayLocAmtVc").setScale(precision, 4));
                iRowSet.updateBigDecimal("amount", iRowSet.getBigDecimal("amount").setScale(precision, 4));
                iRowSet.updateBigDecimal("amountVc", iRowSet.getBigDecimal("amountVc").setScale(precision, 4));
                iRowSet.updateBigDecimal("localAmt", iRowSet.getBigDecimal("localAmt").setScale(precision, 4));
                iRowSet.updateBigDecimal("localAmtVc", iRowSet.getBigDecimal("localAmtVc").setScale(precision, 4));
                iRowSet.updateBigDecimal("unVcAmount", iRowSet.getBigDecimal("unVcAmount").setScale(precision, 4));
                iRowSet.updateBigDecimal("unVcLocAmount", iRowSet.getBigDecimal("unVcLocAmount").setScale(precision, 4));
                if (iRowSet.getBigDecimal("rebate") != null) {
                    iRowSet.updateBigDecimal("rebate", iRowSet.getBigDecimal("rebate").setScale(precision, 4));
                }
                iRowSet.updateBigDecimal("rebateAmtVc", iRowSet.getBigDecimal("rebateAmtVc").setScale(precision, 4));
                if (iRowSet.getBigDecimal("rebateLocAmt") != null) {
                    iRowSet.updateBigDecimal("rebateLocAmt", iRowSet.getBigDecimal("rebateLocAmt").setScale(precision, 4));
                }
                if (iRowSet.getBigDecimal("rebateLocAmtVc") != null) {
                    iRowSet.updateBigDecimal("rebateLocAmtVc", iRowSet.getBigDecimal("rebateLocAmtVc").setScale(precision, 4));
                }
                if (iRowSet.getBigDecimal("actualAmtVc") != null) {
                    iRowSet.updateBigDecimal("actualAmtVc", iRowSet.getBigDecimal("actualAmtVc").setScale(precision, 4));
                }
                if (iRowSet.getBigDecimal("actualLocAmt") != null) {
                    iRowSet.updateBigDecimal("actualLocAmt", iRowSet.getBigDecimal("actualLocAmt").setScale(precision, 4));
                }
                if (iRowSet.getBigDecimal("actualLocAmtVc") != null) {
                    iRowSet.updateBigDecimal("actualLocAmtVc", iRowSet.getBigDecimal("actualLocAmtVc").setScale(precision, 4));
                }
                String billId = iRowSet.getString("id");
                MultiApproveCollection col = CashHelper.getMutiApprove(billId);
                if (this.isPrintUnPassAuditResult) {
                    for (int i = 1; i <= col.size() && i <= 5; ++i) {
                        MultiApproveInfo info = col.get(i - 1);
                        iRowSet.updateString("censor" + i, info.getCreator().getName());
                        iRowSet.updateString("auditResult" + i, info.getIsPass().toString());
                        iRowSet.updateString("auditOpinion" + i, info.getOpinion());
                    }
                } else {
                    IQueryExecutor multiExec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.cas.PaymentBillMultiApproveQuery"));
                    EntityViewInfo multiEv = new EntityViewInfo();
                    FilterInfo multiFilter = new FilterInfo();
                    multiFilter.getFilterItems().add(new FilterItemInfo("billId", (Object)billId));
                    multiFilter.getFilterItems().add(new FilterItemInfo("ProcInst.state", (Object)"closed.completed,open.running,open.not_running.suspended", CompareType.INCLUDE));
                    multiFilter.mergeFilter(WfUtils.getApproveFilter((String)billId), "and");
                    multiEv.getSelector().add(new SelectorItemInfo("creator.name"));
                    multiEv.getSelector().add(new SelectorItemInfo("isPass"));
                    multiEv.getSelector().add(new SelectorItemInfo("opinion"));
                    SorterItemInfo multiSic = new SorterItemInfo("CreateTime");
                    multiSic.setSortType(SortType.ASCEND);
                    multiEv.getSorter().add(multiSic);
                    multiEv.setFilter(multiFilter);
                    multiExec.setObjectView(multiEv);
                    IRowSet iMultiRowSet = multiExec.executeQuery();
                    int i = 1;
                    while (iMultiRowSet.next()) {
                        if ("true".equals(iMultiRowSet.getString("isPass"))) {
                            iRowSet.updateString("censor" + i, iMultiRowSet.getString("creator.name"));
                            iRowSet.updateString("auditResult" + i, iMultiRowSet.getString("isPass"));
                            iRowSet.updateString("auditOpinion" + i, iMultiRowSet.getString("opinion"));
                            ++i;
                        } else {
                            for (int j = 1; j <= i; ++j) {
                                iRowSet.updateString("censor" + j, null);
                                iRowSet.updateString("auditResult" + j, null);
                                iRowSet.updateString("auditOpinion" + j, null);
                            }
                            i = 1;
                        }
                        if (i != 6) continue;
                    }
                }
                if (iRowSet.getString("paymentBill.auditDate") != null) {
                    iRowSet.updateString("paymentBill.auditDate", iRowSet.getString("paymentBill.auditDate").substring(0, 10));
                }
                if (iRowSet.getString("payeeType.name") == null) {
                    iRowSet.updateString("payeeType.name", EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"374_PaymentBillDataProvider"));
                }
                iRowSet.updateString("sourceBillId", FMClientHelper.getBillNumber((String)iRowSet.getString("sourceBillId")));
                StringBuffer voucherNumber = new StringBuffer("");
                VoucherCollection colVoucher = null;
                if (!iRowSet.getBoolean("paymentBill.fiVouchered")) continue;
                colVoucher = FMClientHelper.getVoucherCollection((String)iRowSet.getString("paymentBill.id"));
                if (colVoucher != null && colVoucher.size() > 0) {
                    for (VoucherInfo info : colVoucher) {
                        voucherNumber.append(info.getNumber());
                        voucherNumber.append("  ");
                    }
                }
                iRowSet.updateString("voucherNumber", voucherNumber.toString());
            }
            iRowSet.beforeFirst();
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Component)((CoreUI)null), (Throwable)e1);
        }
        return iRowSet;
    }
}

