/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.client.f7.F7ContextInitializationHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.OperateBillEnum;
import com.kingdee.eas.fi.cas.PaymentOperateType;
import com.kingdee.eas.fi.cas.client.AbstractPaymentBillLogFilterUI;
import com.kingdee.eas.fi.cas.client.PaymentBillLogFilterParam;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.Date;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class PaymentBillLogFilterUI
extends AbstractPaymentBillLogFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(PaymentBillLogFilterUI.class);

    protected void init() throws Exception {
        super.init();
        this.btnCompanySelect.setVisible(false);
        this.initBillStatus(this.comboOperateType);
        this.pkDateFrom.setValue((Object)DateHelper.getDayBegin());
        this.pkDateTo.setValue((Object)DateHelper.getDayBegin());
        this.pkDateFrom.setSupportedEmpty(false);
        this.pkDateTo.setSupportedEmpty(false);
        NewCompanyF7 selector = F7ContextInitializationHelper.getSelectCompany((IUIObject)this, null, null, (boolean)false);
        selector.setMultiSelect(true);
        selector.setUIActionPK((IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.cas.client", "PaymentBillLogListUI"), (IMetaDataPK)new MetaDataPK("ActionOnLoad"));
        this.prmtCompany.setSelector((KDPromptSelector)selector);
        this.prmtCompany.setValue((Object)this.currentCompany);
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        FMClientHelper.setSelectObject((KDComboBox)this.comboOperateType, (Object)FMSysDefinedEnum.ALL_ITEMS);
        this.initOperateBill();
        FMClientHelper.setSelectObject((KDComboBox)this.comboOperateBill, (Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    private void initBillStatus(KDComboBox combo) {
        combo.removeAllItems();
        combo.addItems(PaymentOperateType.getEnumList().toArray());
        combo.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    private void initOperateBill() {
        this.comboOperateBill.removeAllItems();
        this.comboOperateBill.addItems(OperateBillEnum.getEnumList().toArray());
        this.comboOperateBill.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void clear() {
        super.clear();
        try {
            this.init();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public Object getParam() {
        PaymentBillLogFilterParam paramInfo = new PaymentBillLogFilterParam();
        if (this.comboOperateType.getSelectedItem().equals(FMSysDefinedEnum.ALL_ITEMS)) {
            paramInfo.setOperateType(999);
        } else {
            paramInfo.setOperateType(((PaymentOperateType)((Object)this.comboOperateType.getSelectedItem())).getValue());
        }
        if (this.comboOperateBill.getSelectedItem().equals(FMSysDefinedEnum.ALL_ITEMS)) {
            paramInfo.setOperateBillEnum(999);
        } else {
            paramInfo.setOperateBillEnum(((OperateBillEnum)((Object)this.comboOperateBill.getSelectedItem())).getValue());
        }
        paramInfo.setStartDate((java.util.Date)this.pkDateFrom.getValue());
        java.util.Date tmpDate = (java.util.Date)this.pkDateTo.getValue();
        long time = tmpDate.getTime();
        java.util.Date endDate = new java.util.Date(time + 86399000L);
        paramInfo.setEndDate(endDate);
        Set companyIdSet = this.getMainOrgColl();
        paramInfo.setMainOrgCollIDSet(companyIdSet);
        paramInfo.setBillNumber(this.txtBillNumber.getText());
        return paramInfo;
    }

    protected void setDefaultValue() {
        try {
            NewOrgUnitFilterInfoProducer iProducer = null;
            String permissionItem = "paymentOperateLog_view";
            iProducer = new NewOrgUnitFilterInfoProducer(OrgType.Company);
            if (iProducer != null) {
                if (permissionItem != null) {
                    iProducer.getModel().setPermissionItem(permissionItem);
                }
                this.prmtCompany.setFilterInfoProducer((IFilterInfoProducer)iProducer);
                if (iProducer.getModel() != null) {
                    this.prmtCompany.setSelector((KDPromptSelector)iProducer.getModel());
                    this.prmtCompany.setFilterInfoProducer((IFilterInfoProducer)iProducer);
                    iProducer.getModel().setMultiSelect(true);
                }
            }
            this.prmtCompany.setValue((Object)this.getCompanyOrgUnitInfoByUserPermisson());
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
    }

    private CompanyOrgUnitInfo getCompanyOrgUnitInfoByUserPermisson() throws EASBizException, BOSException {
        CompanyOrgUnitCollection coll = FMHelper.getUserOrgRangesWithRange(null, (String)"paymentOperateLog_view");
        for (int i = 0; i < coll.size(); ++i) {
            CompanyOrgUnitInfo info = coll.get(i);
            if (!this.currentCompany.getId().toString().equals(info.getId().toString())) continue;
            return info;
        }
        if (coll.size() > 0) {
            return coll.get(0);
        }
        return null;
    }

    public String getPermissionItem() {
        return "paymentOperateLog_view";
    }

    public KDBizPromptBox getMainOrg() {
        return this.prmtCompany;
    }

    public void setParam(Object param) {
        PaymentBillLogFilterParam paramInfo = (PaymentBillLogFilterParam)param;
        if (paramInfo.getOperateType() == 999) {
            this.comboOperateType.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        } else {
            this.comboOperateType.setSelectedItem((Object)BillStatusEnum.getEnum(paramInfo.getOperateType()));
        }
        if (paramInfo.getOperateBillEnum() == 999) {
            this.comboOperateBill.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        } else {
            this.comboOperateBill.setSelectedItem((Object)OperateBillEnum.getEnum(paramInfo.getOperateBillEnum()));
        }
        this.pkDateTo.setValue((Object)paramInfo.getEndDate());
        this.pkDateFrom.setValue((Object)paramInfo.getStartDate());
        if (!EmptyUtil.isEmpty((Collection)paramInfo.getMainOrgCollIDSet())) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)paramInfo.getMainOrgCollIDSet(), CompareType.INCLUDE));
            try {
                CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
                this.prmtCompany.setValue((Object)coll.toArray());
            }
            catch (BOSException e) {
                this.handUIException(e);
                logger.error((Object)e);
            }
        }
        this.txtBillNumber.setText(paramInfo.getBillNumber());
    }

    public boolean verify() {
        FMClientVerifyHelper.verifyBeginEndDateRel((CoreUIObject)this, (java.util.Date)((java.util.Date)this.pkDateFrom.getValue()), (java.util.Date)((java.util.Date)this.pkDateTo.getValue()));
        Date startDate = this.pkDateFrom.getSqlDate();
        Date endDate = this.pkDateTo.getSqlDate();
        FMClientVerifyHelper.verifyBeginEndDateRel((CoreUIObject)this, (java.util.Date)startDate, (java.util.Date)endDate);
        if (FMHelper.isEmpty((Object)this.prmtCompany.getData())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"231_AgentPayBillFilterUI"));
            SysUtil.abort();
        }
        return super.verify();
    }

    private Set getMainOrgColl() {
        HashSet<String> idSet = new HashSet<String>();
        if (this.prmtCompany.getValue() != null) {
            CompanyOrgUnitCollection coll = new CompanyOrgUnitCollection();
            Object mainBizOrgValue = this.prmtCompany.getValue();
            if (mainBizOrgValue instanceof Object[]) {
                Object[] arrays = (Object[])mainBizOrgValue;
                for (int i = 0; i < arrays.length; ++i) {
                    if (null == arrays[i] || !(arrays[i] instanceof CompanyOrgUnitInfo)) continue;
                    coll.add((CompanyOrgUnitInfo)arrays[i]);
                }
            } else if (mainBizOrgValue instanceof CompanyOrgUnitInfo) {
                coll.add((CompanyOrgUnitInfo)mainBizOrgValue);
            }
            for (int i = 0; i < coll.size(); ++i) {
                idSet.add(coll.get(i).getId().toString());
            }
        }
        return idSet;
    }

    protected Class getParamClass() {
        return PaymentBillLogFilterParam.class;
    }
}

