/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.data.datasource.DSParam;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.print.IPrintActionListener;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.DefaultNoteDataProvider;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataParameter;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSortItem;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSource;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PaymentBillNoteDataProvider
extends DefaultNoteDataProvider
implements IPrintActionListener {
    private static Logger logger = Logger.getLogger((String)PaymentBillNoteDataProvider.class.getName());
    private IMetaDataPK qpk = null;
    private IObjectPK currentPK = null;
    private Set ids = null;
    KDNoteHelper currentHelper = null;
    private R1PrintDataSortItem[] sortItems;
    private String templatePath = "/FI/CAS/PAYMENTBILL";

    public PaymentBillNoteDataProvider(KDNoteHelper helper, Set ids, IMetaDataPK singleQpk) {
        super(ids, singleQpk);
        this.currentHelper = helper;
        this.qpk = singleQpk;
        this.ids = ids;
    }

    public void beforePreview() {
    }

    public void beforePrint() {
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)this.qpk);
        exec.option().isAutoTranslateEnum = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isMultiLanguage = true;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.ids, CompareType.INCLUDE));
        ev.setFilter(filter);
        exec.setObjectView(ev);
        IRowSet iRowSet = null;
        try {
            iRowSet = exec.executeQuery();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        try {
            while (iRowSet.next()) {
                this.currentPK = new ObjectUuidPK(iRowSet.getString("id"));
                int prepareTimes = this.currentHelper.getCopies();
                HashMap<String, Integer> idMap = new HashMap<String, Integer>();
                idMap.put(this.currentPK.toString(), new Integer(prepareTimes));
                IPaymentBill ipaymentbill = PaymentBillFactory.getRemoteInstance();
                PaymentBillInfo info = ipaymentbill.getPaymentBillInfo(this.currentPK);
                if (this.currentHelper.isPrintTimesControllable2(this.templatePath)) {
                    Object[] objs;
                    String msgInfo;
                    String billNumber;
                    int maxNum = this.currentHelper.getMaxPrintTimes2(this.templatePath);
                    int curNum = this.currentHelper.getCopies();
                    int pnum = info.getPrintCount();
                    if (pnum >= maxNum) {
                        billNumber = info.getNumber();
                        msgInfo = EASResource.getString((String)"com.kingdee.eas.basedata.assistant.PrintIntegrationResource", (String)"pi.controlinfo1");
                        objs = new Object[]{billNumber, String.valueOf(curNum), String.valueOf(pnum), String.valueOf(maxNum)};
                        MsgBox.showWarning((String)MessageFormat.format(msgInfo, objs));
                        SysUtil.abort();
                    } else if (curNum + pnum > maxNum) {
                        billNumber = info.getNumber();
                        msgInfo = EASResource.getString((String)"com.kingdee.eas.basedata.assistant.PrintIntegrationResource", (String)"pi.controlinfo2");
                        objs = new Object[]{billNumber, String.valueOf(curNum), String.valueOf(pnum), String.valueOf(maxNum)};
                        MsgBox.showWarning((String)MessageFormat.format(msgInfo, objs));
                        SysUtil.abort();
                    }
                }
                this.updatePrintCount(idMap);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (KDRSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    private void updatePrintCount(Map paramMap) {
        if (paramMap != null && paramMap.size() > 0) {
            try {
                IPaymentBill ipb = PaymentBillFactory.getRemoteInstance();
                ipb.updatePrintCount(paramMap);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
        }
    }

    public void beforePrintOrPreview() {
    }

    public void closePreview() {
    }

    public IRowSet getData(R1PrintDataSource dataSource) throws Exception {
        IRowSet iSet = super.getData(dataSource);
        while (iSet.next()) {
            try {
                if (iSet.getString("payeeType.name") == null) {
                    iSet.updateString("payeeType.name", EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"374_PaymentBillDataProvider"));
                }
                if (iSet.getString("sourceBillId") == null) continue;
                iSet.updateString("sourceBillId", FMClientHelper.getBillNumber((String)iSet.getString("sourceBillId")));
            }
            catch (Exception e) {
                logger.error((Object)"R1Print getData from DataProvider error\uff1asourceBillId is null");
            }
        }
        return iSet;
    }

    public EntityViewInfo getEntityViewInfo(R1PrintDataSource dataSource, EntityViewInfo ev) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)"NONE"));
        String maskString = "#0";
        int index = 1;
        Iterator iter = this.ids.iterator();
        while (iter.hasNext()) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)((String)iter.next())));
            maskString = maskString + " OR #" + index;
            ++index;
        }
        filter.setMaskString(maskString);
        ArrayList param = this.getDataFilter(dataSource);
        FMClientHelper.addDataFilter((FilterInfo)filter, (ArrayList)param);
        this.sortItems = dataSource.getSortFields();
        if (this.sortItems != null && this.sortItems.length > 0) {
            for (int i = 0; i < this.sortItems.length; ++i) {
                String fieldName = this.sortItems[i].getSortField();
                if (EmptyUtil.isEmpty((String)fieldName)) continue;
                SorterItemInfo sort = new SorterItemInfo(fieldName);
                if (0 == this.sortItems[i].getSortType()) {
                    sort.setSortType(SortType.ASCEND);
                } else {
                    sort.setSortType(SortType.DESCEND);
                }
                ev.getSorter().add(sort);
            }
        } else {
            SorterItemInfo sort = new SorterItemInfo("number");
            sort.setSortType(SortType.ASCEND);
            ev.getSorter().add(sort);
        }
        ev.setFilter(filter);
        return ev;
    }

    public ArrayList getDataFilter(R1PrintDataSource dataSource) {
        ArrayList<DSParam> kdfDs = new ArrayList<DSParam>();
        R1PrintDataParameter[] r1Params = dataSource.getParams();
        for (int i = 0; i < r1Params.length; ++i) {
            R1PrintDataParameter r1Param = r1Params[i];
            DSParam kdfParam = new DSParam(r1Param.getId(), r1Param.getAssociateSource(), r1Param.getAssociateField());
            if (r1Param.getValue() != null) {
                kdfParam.setValue(new Variant(r1Param.getValue().getValue()));
                if (StringUtil.isEmptyString((String)r1Param.getAssociateSource())) {
                    kdfParam.setAssociateField(r1Param.getValue().toString());
                    log.info((Object)("KdfToR1\u8f6c\u53c2\u6570:" + kdfParam.getColName() + "" + kdfParam.getValue()));
                }
            } else {
                kdfParam.setValue(Variant.getNewEmptyVariant());
            }
            kdfDs.add(kdfParam);
        }
        return kdfDs;
    }
}

