/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.fi.arap.IArApBillFacade;
import com.kingdee.eas.fi.cas.CasForArApUtil;
import com.kingdee.eas.fi.cas.CurrentInfo;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.PaymentBillTypeInfo;
import com.kingdee.eas.fi.cas.RecPayBillTypeEnum;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.client.AbstractPaymentFilterUI;
import com.kingdee.eas.fi.cas.client.ArApRecPayHelper;
import com.kingdee.eas.fi.cas.client.ArApRecPayLogic;
import com.kingdee.eas.fi.cas.client.PaymentFilterParam;
import com.kingdee.eas.fi.cas.client.PaymentHandler;
import com.kingdee.eas.fi.cas.client.RecPayHandler;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class PaymentFilterUI
extends AbstractPaymentFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(PaymentFilterUI.class);
    private static String resourcePath = "com.kingdee.eas.fi.cas.RecPayResource";
    private RecPayHandler handler = new PaymentHandler();
    public CompanyOrgUnitInfo companyInfo = null;
    private boolean isInit;
    private boolean isStartAP = true;
    private SourceTypeEnum sourceType = null;
    private static final String PERMISSION = "cas_paymentbill_01view";
    private ArApRecPayHelper arapHelper = new ArApRecPayHelper();
    protected IArApBillFacade iBillFacade;
    protected ArApSysParamInfo cache = null;
    protected boolean isVerifi = false;
    protected String defaultCompanyId = null;
    private ArApRecPayLogic arapLogic = new ArApRecPayLogic();
    private boolean isDisplayEntries = false;

    public PaymentFilterUI() throws Exception {
        this.cache = new ArApSysParamInfo();
        this.iBillFacade = ArApBillFacadeFactory.getRemoteInstance();
    }

    public PaymentFilterUI(boolean isInit, SourceTypeEnum sourceType) throws Exception {
        this();
        this.isInit = isInit;
        this.sourceType = sourceType;
        if (isInit) {
            this.setUITitle(EASResource.getString((String)resourcePath, (String)"APInitBillQuery"));
        }
    }

    public PaymentFilterUI(boolean isInit, SourceTypeEnum sourceType, ArApSysParamInfo cache) throws Exception {
        this();
        this.isInit = isInit;
        this.sourceType = sourceType;
        this.cache = cache;
    }

    public PaymentFilterUI(boolean isInit, SourceTypeEnum sourceType, ArApSysParamInfo cache, boolean isVerifi) throws Exception {
        this();
        this.isInit = isInit;
        this.sourceType = sourceType;
        this.cache = cache;
        this.isVerifi = isVerifi;
    }

    public PaymentFilterUI(boolean isInit, SourceTypeEnum sourceType, String defaultCompanyId, boolean isVerifi) throws Exception {
        this();
        this.isInit = isInit;
        this.sourceType = sourceType;
        this.defaultCompanyId = defaultCompanyId;
        this.isVerifi = isVerifi;
    }

    @Override
    protected void init() throws Exception {
        super.init();
        if (SourceTypeEnum.AP.equals((Object)this.sourceType)) {
            if (this.cache.getCompany() == null) {
                if (this.defaultCompanyId != null) {
                    CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                    company.setId(BOSUuid.read((String)this.defaultCompanyId));
                    this.cache = this.iBillFacade.getSysParams(company, this.getUIParam());
                } else {
                    this.cache = this.iBillFacade.getSysParams(null, this.getUIParam());
                }
            }
            NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(OrgType.Company, PERMISSION);
            this.prmtCompany.setRequired(true);
            this.prmtCompany.setEditFormat("$number$");
            this.prmtCompany.setDisplayFormat("$name$");
            this.prmtCompany.setCommitFormat("$number$;$name$;$code$;$simpleName$");
            this.prmtCompany.setFilterInfoProducer((IFilterInfoProducer)iProducer);
            this.prmtCompany.setValue((Object)this.cache.getCompany());
            if (this.isInit && this.getBeforSysStartDate() != null) {
                this.arapHelper.setDefaultFitlerBillDate((Component)((Object)this), this.cache, this.isInit, this.sourceType, this.pkBillDateFrom, this.pkBillDateTo, this.cache.getCompany());
            }
            if (!this.isInit && (this.sourceType.equals((Object)SourceTypeEnum.AR) || this.sourceType.equals((Object)SourceTypeEnum.AP))) {
                this.pkBillDateTo.setValue((Object)SCMUtils.getSCMQueryTime(null, (String)"endDate"));
                this.pkBillDateFrom.setValue((Object)SCMUtils.getSCMQueryTime(null, (String)"startDate"));
            }
            this.prmtCompany.addDataChangeListener(new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        PaymentFilterUI.this.prmtCompany_dataChanged(e);
                    }
                    catch (Exception exc) {
                        PaymentFilterUI.this.handUIException(exc);
                    }
                }
            });
            this.pkBillDateFrom.setRequired(true);
            this.pkBillDateTo.setRequired(true);
            if (this.isVerifi) {
                this.prmtCompany.setEnabled(false);
                this.prmtCompany.setEditable(false);
            }
        } else {
            this.prmtCompany.setEnabled(false);
        }
        this.comboSourceType.removeItem((Object)SourceTypeEnum.AR);
        if (this.sourceType.equals((Object)SourceTypeEnum.AP)) {
            this.comboSourceType.setSelectedItem((Object)SourceTypeEnum.AP);
            this.comboSourceType.setEnabled(false);
        }
        this.comboPayeeType_actionPerformed(null);
        if (101 == this.sourceType.getValue()) {
            CasForArApUtil.makeAsstActType(this.comboPayeeType, this.cache, true);
        }
        if (this.isInit) {
            this.btnSubmitAll.setSelected(true);
            this.btnAuditAll.setSelected(true);
            this.btnPayAll.setSelected(true);
            this.btnVoucherAll.setSelected(true);
            this.panSubmit.setVisible(false);
            this.panAudit.setVisible(false);
            this.panPay.setVisible(false);
            this.panVoucher.setVisible(false);
            this.kDSeparator1.setVisible(false);
            this.setUITitle(EASResource.getString((String)resourcePath, (String)"APInitBillQuery"));
        }
    }

    protected HashMap getUIParam() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isSCM", Boolean.FALSE);
        map.put("sysEnum", SystemEnum.ACCOUNTSPAYABLE);
        map.put("permissionItem", PERMISSION);
        return map;
    }

    @Override
    public Object getParam() {
        PaymentFilterParam param = new PaymentFilterParam();
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtCompany);
        if (this.prmtCompany.getValue() != null && 101 == this.sourceType.getValue()) {
            Object obj = this.prmtCompany.getValue();
            if (obj instanceof CompanyOrgUnitInfo) {
                CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)obj;
                param.setCompanyId(company.getId().toString());
                param.setCompanyName(company.getName());
            } else {
                this.prmtCompany.setValue(null);
                ArApRecPayLogic.verify((CoreUIObject)this, this.prmtCompany);
            }
        }
        param.setBillDateFrom((Date)this.pkBillDateFrom.getValue());
        param.setBillDateTo((Date)this.pkBillDateTo.getValue());
        if (this.prmtBillNumberFrom.getData() != null) {
            param.setBillNumberFrom(((PaymentBillInfo)this.prmtBillNumberFrom.getData()).getNumber());
        }
        if (this.prmtBillNumberTo.getData() != null) {
            param.setBillNumberTo(((PaymentBillInfo)this.prmtBillNumberTo.getData()).getNumber());
        }
        if (this.comboSourceType.getSelectedItem().equals(FMSysDefinedEnum.ALL_ITEMS)) {
            param.setSourceType(999);
        } else {
            param.setSourceType(((SourceTypeEnum)this.comboSourceType.getSelectedItem()).getValue());
        }
        if (SourceTypeEnum.AP == this.sourceType) {
            if (this.prmtPayType.getValue() != null) {
                param.setPaymentTypeId(((PaymentBillTypeInfo)this.prmtPayType.getValue()).getId().toString());
                param.setPaymentTypeNumber(((PaymentBillTypeInfo)this.prmtPayType.getValue()).getNumber());
                param.setPaymentTypeName(((PaymentBillTypeInfo)this.prmtPayType.getValue()).getName());
            }
        } else if (this.comboBillType.getSelectedItem().equals(FMSysDefinedEnum.ALL_ITEMS)) {
            param.setBillType(999);
        } else {
            param.setBillType(((RecPayBillTypeEnum)((Object)this.comboBillType.getSelectedItem())).getValue());
        }
        if (this.prmtCurrency.getValue() == null) {
            param.setCurrencyId(null);
        } else if (this.prmtCurrency.getValue() instanceof CurrencyInfo) {
            param.setCurrencyId(((CurrencyInfo)this.prmtCurrency.getValue()).getId().toString());
        }
        if (this.comboPayeeType.getSelectedItem() == null || this.comboPayeeType.getSelectedItem().equals(FMSysDefinedEnum.ALL_ITEMS) || CasForArApUtil.ITEM_ALL.equals(String.valueOf(this.comboPayeeType.getSelectedItem()))) {
            param.setPayeeTypeId(null);
        } else if (this.comboPayeeType.getSelectedItem() instanceof DataBaseInfo) {
            param.setPayeeTypeId(((DataBaseInfo)this.comboPayeeType.getSelectedItem()).getId().toString());
        }
        if (this.prmtPayee.getValue() instanceof DataBaseInfo) {
            param.setPayeeId(((DataBaseInfo)this.prmtPayee.getValue()).getId().toString());
            param.setPayeeName(((DataBaseInfo)this.prmtPayee.getValue()).getName());
            param.setPayeeNumber(((DataBaseInfo)this.prmtPayee.getValue()).getNumber());
        }
        if (this.prmtPayeeTo.getValue() instanceof DataBaseInfo) {
            param.setPayeeToId(((DataBaseInfo)this.prmtPayeeTo.getValue()).getId().toString());
            param.setPayeeToName(((DataBaseInfo)this.prmtPayeeTo.getValue()).getName());
            param.setPayeeNumberTo(((DataBaseInfo)this.prmtPayeeTo.getValue()).getNumber());
        }
        if (this.radioHead.isSelected()) {
            param.setDisplayEntries(false);
        } else if (this.radioEntries.isSelected()) {
            param.setDisplayEntries(true);
        }
        if (!this.isInit) {
            if (this.btnSubmited.isSelected()) {
                param.setIsSubmited(1);
            } else if (this.btnSave.isSelected()) {
                param.setIsSubmited(0);
            } else if (this.btnSubmitAll.isSelected()) {
                param.setIsSubmited(999);
            }
            if (this.btnAudited.isSelected()) {
                param.setIsAudited(1);
            } else if (this.btnUnAudited.isSelected()) {
                param.setIsAudited(0);
            } else if (this.btnAuditAll.isSelected()) {
                param.setIsAudited(999);
            }
            if (this.btnPayed.isSelected()) {
                param.setIsPayed(1);
            } else if (this.btnUnPayed.isSelected()) {
                param.setIsPayed(0);
            } else if (this.btnPayAll.isSelected()) {
                param.setIsPayed(999);
            }
            if (this.btnVouchered.isSelected()) {
                param.setIsVouchered(1);
            } else if (this.btnUnVouchered.isSelected()) {
                param.setIsVouchered(0);
            } else if (this.btnVoucherAll.isSelected()) {
                param.setIsVouchered(999);
            }
        } else {
            param.setInit(true);
        }
        return param;
    }

    @Override
    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        if (!(param instanceof PaymentFilterParam)) {
            return;
        }
        PaymentFilterParam filterParam = (PaymentFilterParam)param;
        this.pkBillDateFrom.setValue((Object)filterParam.getBillDateFrom());
        this.pkBillDateTo.setValue((Object)filterParam.getBillDateTo());
        try {
            DataBaseInfo currentInfo;
            if (filterParam.getCompanyId() != null && 101 == this.sourceType.getValue()) {
                CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
                companyInfo.setId(BOSUuid.read((String)filterParam.getCompanyId()));
                if (!CasForArApUtil.idEquals((CoreBaseInfo)this.cache.getCompany(), (CoreBaseInfo)companyInfo)) {
                    this.cache = this.iBillFacade.getSysParams(companyInfo, this.getUIParam());
                }
                if (!CasForArApUtil.idEquals((CoreBaseInfo)((CompanyOrgUnitInfo)this.prmtCompany.getValue()), (CoreBaseInfo)this.cache.getCompany())) {
                    this.prmtCompany.setData((Object)this.cache.getCompany());
                }
            }
            if (filterParam.getBillNumberFrom() != null) {
                this.prmtBillNumberFrom.setData((Object)PaymentBillFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(filterParam.getBillNumberFrom())));
            }
            if (filterParam.getBillNumberTo() != null) {
                this.prmtBillNumberTo.setData((Object)PaymentBillFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(filterParam.getBillNumberTo())));
            }
            if (filterParam.getCurrencyId() != null) {
                this.prmtCurrency.setValue((Object)CurrencyFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(filterParam.getCurrencyId())));
            } else {
                this.prmtCurrency.setValue(null);
            }
            if (filterParam.getPayeeTypeId() == null) {
                this.comboPayeeType.setSelectedItem((Object)CasForArApUtil.ITEM_ALL);
            } else if (!CasForArApUtil.ITEM_ALL.equals(filterParam.getPayeeTypeId())) {
                int selectIndex = PaymentFilterUI.getSelectIndex(this.comboPayeeType, filterParam.getPayeeTypeId());
                this.comboPayeeType.setSelectedIndex(selectIndex);
            }
            if (filterParam.getPayeeId() != null) {
                currentInfo = new CurrentInfo();
                currentInfo.setId(BOSUuid.read((String)filterParam.getPayeeId()));
                currentInfo.setName(filterParam.getPayeeName());
                currentInfo.setNumber(filterParam.getPayeeNumber());
                this.prmtPayee.setData((Object)currentInfo);
            }
            if (filterParam.isDisplayEntries() || this.isDisplayEntries) {
                this.radioHead.setSelected(false);
                this.radioEntries.setSelected(true);
            } else {
                this.radioHead.setSelected(true);
                this.radioEntries.setSelected(false);
            }
            if (filterParam.getPayeeToId() != null) {
                currentInfo = new CurrentInfo();
                currentInfo.setId(BOSUuid.read((String)filterParam.getPayeeToId()));
                currentInfo.setNumber(filterParam.getPayeeNumberTo());
                currentInfo.setName(filterParam.getPayeeToName());
                this.prmtPayeeTo.setData((Object)currentInfo);
            }
            if (filterParam.getPaymentTypeId() != null) {
                currentInfo = new PaymentBillTypeInfo();
                currentInfo.setId(BOSUuid.read((String)filterParam.getPaymentTypeId()));
                currentInfo.setName(filterParam.getPaymentTypeName());
                currentInfo.setNumber(filterParam.getPaymentTypeNumber());
                this.prmtPayType.setData((Object)currentInfo);
            } else {
                this.prmtPayType.setValue(null);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (filterParam.getSourceType() == 999) {
            this.comboSourceType.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        } else {
            this.comboSourceType.setSelectedItem((Object)SourceTypeEnum.getEnum((int)filterParam.getSourceType()));
        }
        if (filterParam.getBillType() == 999) {
            this.comboBillType.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        } else {
            this.comboBillType.setSelectedItem((Object)RecPayBillTypeEnum.getEnum(filterParam.getBillType()));
        }
        if (!this.isInit) {
            if (filterParam.getIsSubmited() == 999) {
                this.btnSubmitAll.setSelected(true);
            } else if (filterParam.getIsSubmited() == 1) {
                this.btnSubmited.setSelected(true);
            } else {
                this.btnSave.setSelected(true);
            }
            if (filterParam.getIsAudited() == 999) {
                this.btnAuditAll.setSelected(true);
            } else if (filterParam.getIsAudited() == 1) {
                this.btnAudited.setSelected(true);
            } else {
                this.btnUnAudited.setSelected(true);
            }
            if (filterParam.getIsPayed() == 999) {
                this.btnPayAll.setSelected(true);
            } else if (filterParam.getIsPayed() == 1) {
                this.btnPayed.setSelected(true);
            } else {
                this.btnUnPayed.setSelected(true);
            }
            if (filterParam.getIsVouchered() == 999) {
                this.btnVoucherAll.setSelected(true);
            } else if (filterParam.getIsVouchered() == 1) {
                this.btnVouchered.setSelected(true);
            } else {
                this.btnUnVouchered.setSelected(true);
            }
        }
    }

    public static int getSelectIndex(KDComboBox comboBox, String id) {
        for (int i = 1; i < comboBox.getItemCount(); ++i) {
            CoreBaseInfo info;
            if (!(comboBox.getItemAt(i) instanceof CoreBaseInfo) || !id.equals((info = (CoreBaseInfo)comboBox.getItemAt(i)).getId().toString())) continue;
            return i;
        }
        return 0;
    }

    public void clear() {
        super.clear();
        try {
            if (this.defaultCompanyId != null) {
                CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                company.setId(BOSUuid.read((String)this.defaultCompanyId));
                this.cache = this.iBillFacade.getSysParams(company, this.getUIParam());
            } else {
                this.cache = this.iBillFacade.getSysParams(null, this.getUIParam());
            }
            this.prmtCompany.setValue((Object)this.cache.getCompany());
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
        this.comboSourceType.removeItem((Object)SourceTypeEnum.AR);
        this.comboSourceType.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        if (this.sourceType.equals((Object)SourceTypeEnum.AP)) {
            this.comboSourceType.setSelectedItem((Object)SourceTypeEnum.AP);
            this.comboSourceType.setEnabled(false);
        }
        try {
            if (101 == this.sourceType.getValue()) {
                if (this.isInit) {
                    this.arapHelper.setDefaultFitlerBillDate((Component)((Object)this), this.cache, this.isInit, this.sourceType, this.pkBillDateFrom, this.pkBillDateTo, this.cache.getCompany());
                } else {
                    this.pkBillDateTo.setValue((Object)SCMUtils.getSCMQueryTime(null, (String)"endDate"));
                    this.pkBillDateFrom.setValue((Object)SCMUtils.getSCMQueryTime(null, (String)"startDate"));
                }
            }
            this.comboPayeeType_actionPerformed(null);
            if (101 == this.sourceType.getValue()) {
                CasForArApUtil.makeAsstActType(this.comboPayeeType, this.cache, true);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.comboPayeeType.setSelectedItem((Object)CasForArApUtil.ITEM_ALL);
        this.btnSubmitAll.setSelected(true);
        this.btnAuditAll.setSelected(true);
        this.btnPayAll.setSelected(true);
        this.btnVoucherAll.setSelected(true);
        this.prmtPayType.setValue(null);
        this.prmtCurrency.setValue(null);
        this.prmtPayee.setValue(null);
        this.prmtPayeeTo.setValue(null);
        this.radioHead.setSelected(false);
        this.radioEntries.setSelected(true);
    }

    @Override
    protected void comboSourceType_actionPerformed(ActionEvent e) throws Exception {
        Object sourceTypeEnum = this.comboSourceType.getSelectedItem();
        if (sourceTypeEnum == null) {
            return;
        }
        if (sourceTypeEnum.equals(FMSysDefinedEnum.ALL_ITEMS)) {
            this.handler.initBillType(this.comboBillType, "");
            this.comboBillType.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
            this.comboBillType.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        } else if (sourceTypeEnum.equals(SourceTypeEnum.AP)) {
            this.handler.initBillType(this.comboBillType, "AP");
            this.comboBillType.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
            this.comboBillType.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
            this.arapHelper.initBillType(this.prmtPayType, SourceTypeEnum.AP, this.isInit, false);
        }
    }

    @Override
    protected void comboPayeeType_actionPerformed(ActionEvent e) throws Exception {
        this.prmtPayee.setValue(null);
        this.prmtPayeeTo.setValue(null);
        if (this.comboPayeeType.getSelectedItem() == null || !(this.comboPayeeType.getSelectedItem() instanceof AsstActTypeInfo)) {
            this.prmtPayee.setEnabled(false);
            this.prmtPayee.setData(null);
            this.prmtPayeeTo.setEnabled(false);
            this.prmtPayeeTo.setData(null);
            return;
        }
        if (this.prmtPayee.isEnabled() && this.prmtPayee.getData() != null) {
            return;
        }
        this.prmtPayee.setEnabled(true);
        this.prmtPayee.setData(null);
        this.prmtPayeeTo.setEnabled(true);
        this.prmtPayeeTo.setData(null);
        AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)this.comboPayeeType.getSelectedItem();
        if (101 == this.sourceType.getValue()) {
            this.arapHelper.assignSelector((CoreUIObject)this, this.prmtPayee, asstActTypeInfo, this.cache.getCompany(), true);
            this.arapHelper.assignSelector((CoreUIObject)this, this.prmtPayeeTo, asstActTypeInfo, this.cache.getCompany(), true);
        } else {
            RecPayHandler.assignSelector((CoreUIObject)this, this.prmtPayee, asstActTypeInfo);
        }
    }

    protected void prmtCompany_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtCompany.getValue() == null) {
            return;
        }
        if (this.isInit) {
            this.arapHelper.setDefaultFitlerBillDateNoCache((Component)((Object)this), this.isInit, this.sourceType, this.pkBillDateFrom, this.pkBillDateTo, (CompanyOrgUnitInfo)this.prmtCompany.getValue());
        }
        if (!CasForArApUtil.idEquals((CoreBaseInfo)this.cache.getCompany(), (CoreBaseInfo)((CompanyOrgUnitInfo)e.getNewValue()))) {
            this.cache = this.iBillFacade.getSysParams((CompanyOrgUnitInfo)e.getNewValue(), this.getUIParam());
        }
        this.prmtPayee.setValue(null);
        this.prmtPayeeTo.setValue(null);
        if (this.comboPayeeType.getSelectedItem() == null || !(this.comboPayeeType.getSelectedItem() instanceof AsstActTypeInfo)) {
            this.prmtPayee.setEnabled(false);
            this.prmtPayee.setData(null);
            this.prmtPayeeTo.setEnabled(false);
            this.prmtPayeeTo.setData(null);
            return;
        }
        AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)this.comboPayeeType.getSelectedItem();
        this.arapHelper.assignSelector((CoreUIObject)this, this.prmtPayee, asstActTypeInfo, this.cache.getCompany(), true);
        this.arapHelper.assignSelector((CoreUIObject)this, this.prmtPayeeTo, asstActTypeInfo, this.cache.getCompany(), true);
    }

    public boolean verify() {
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtCompany);
        return this.arapHelper.verifyFitlerBillDate((CoreUIObject)this, this.cache, this.isInit, this.sourceType, this.pkBillDateFrom, this.pkBillDateTo, this.cache.getCompany());
    }

    public void initF7BillNumber(KDBizPromptBox prmtBillNumber) {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.cache.getCompany().getId()));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        prmtBillNumber.setEntityViewInfo(evi);
    }

    private Date getBeforSysStartDate() throws EASBizException, BOSException {
        PeriodInfo startPeriod = this.cache.getStartPeriod(this.getSysEnum());
        if (startPeriod == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ArApBillResource", (String)"startPeriodIsNull"));
            SysUtil.abort();
        }
        Date beforeStartDate = null;
        Calendar cal = Calendar.getInstance();
        cal.setTime(startPeriod.getBeginDate());
        cal.add(5, -1);
        beforeStartDate = cal.getTime();
        return beforeStartDate;
    }

    protected SystemEnum getSysEnum() {
        return SystemEnum.ACCOUNTSPAYABLE;
    }

    public String getPermissionItem() {
        return PERMISSION;
    }

    public FilterInfo getFilterInfo() {
        PaymentFilterParam param = new PaymentFilterParam();
        param = (PaymentFilterParam)this.getParam();
        return param.getFilter();
    }

    protected Class getParamClass() {
        return PaymentFilterParam.class;
    }

    public void setCustomerParams(CustomerParams cp) {
        this.isDisplayEntries = cp.getCustomerParam("displayEntries") == null;
        super.setCustomerParams(cp);
    }

    public CompanyOrgUnitInfo getCompanyInfo() {
        CompanyOrgUnitInfo companyInfo = this.prmtCompany.getValue() == null ? null : (CompanyOrgUnitInfo)this.prmtCompany.getValue();
        return companyInfo;
    }
}

