/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.client.CashClientHelper;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public final class PeriodHelper {
    private static Map periodCache;
    private static Map startPeriodMap;

    public static void periodNumChange(KDSpinner spinner, CompanyOrgUnitInfo companyInfo, int year) throws Exception {
        int periodNum = Integer.parseInt(spinner.getValue().toString());
        int maxNum = PeriodUtils.getMaxPeriodNumber(null, (int)year, (String)companyInfo.getId().toString());
        int minNum = PeriodUtils.getMinPeriodNumber(null, (int)year, (String)companyInfo.getId().toString());
        if (periodNum > maxNum) {
            spinner.setValue((Object)new Integer(maxNum));
        }
        if (periodNum < minNum) {
            spinner.setValue((Object)new Integer(minNum));
        }
    }

    public static void initPeriodSpinner(KDSpinner beginYearSpinner, KDSpinner beginPeriodSpinner) throws NumberFormatException, EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        PeriodHelper.initPeriodSpinner(companyInfo, beginYearSpinner, beginPeriodSpinner);
    }

    public static void initPeriodSpinner(CompanyOrgUnitInfo companyInfo, KDSpinner beginYearSpinner, KDSpinner beginPeriodSpinner) throws EASBizException, BOSException {
        PeriodInfo currPeriod = ClientUtils.getCurrentPeriod(null, companyInfo);
        beginYearSpinner.setModel((SpinnerModel)PeriodHelper.getYearSnm(companyInfo));
        beginPeriodSpinner.setModel((SpinnerModel)PeriodHelper.getMonthSnm(companyInfo, (Integer)beginYearSpinner.getValue()));
        if (currPeriod != null) {
            beginYearSpinner.setValue((Object)new Integer(currPeriod.getPeriodYear()));
            beginPeriodSpinner.setValue((Object)new Integer(currPeriod.getPeriodNumber()));
        }
    }

    public static void initPeriodSpinner(CompanyOrgUnitInfo companyInfo, PeriodInfo currPeriod, PeriodInfo startPeriod, KDSpinner beginYearSpinner, KDSpinner beginPeriodSpinner) throws EASBizException, BOSException {
        beginYearSpinner.setModel((SpinnerModel)PeriodHelper.getYearSnm(companyInfo, startPeriod));
        beginPeriodSpinner.setModel((SpinnerModel)PeriodHelper.getMonthSnm(companyInfo, (Integer)beginYearSpinner.getValue()));
        if (currPeriod != null) {
            beginYearSpinner.setValue((Object)new Integer(currPeriod.getPeriodYear()));
            beginPeriodSpinner.setValue((Object)new Integer(currPeriod.getPeriodNumber()));
        }
    }

    public static SpinnerNumberModel getYearSnm(CompanyOrgUnitInfo companyInfo, PeriodInfo startPeriod) throws EASBizException, BOSException {
        ObjectUuidPK companyPK = new ObjectUuidPK(companyInfo.getId());
        if (periodCache == null || !periodCache.containsKey(companyPK)) {
            PeriodHelper.cachePeriod(companyInfo);
        }
        TreeMap yearMap = (TreeMap)periodCache.get(companyPK);
        int begin = (Integer)yearMap.firstKey();
        int end = (Integer)yearMap.lastKey();
        if (startPeriod != null) {
            begin = startPeriod.getPeriodYear();
        }
        SpinnerNumberModel result = null;
        if (begin > end) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"375_PeriodHelper"));
            SysUtil.abort();
        } else {
            result = new SpinnerNumberModel(begin, begin, end, 1);
        }
        return result;
    }

    public static void initPeriodSpinner(KDSpinner beginYearSpinner, KDSpinner beginPeriodSpinner, KDSpinner endYearSpinner, KDSpinner endPeriodSpinner) throws NumberFormatException, EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        PeriodHelper.initPeriodSpinner(companyInfo, beginYearSpinner, beginPeriodSpinner, endYearSpinner, endPeriodSpinner);
    }

    public static void initPeriodSpinner(CompanyOrgUnitInfo companyInfo, KDSpinner beginYearSpinner, KDSpinner beginPeriodSpinner, KDSpinner endYearSpinner, KDSpinner endPeriodSpinner) throws EASBizException, BOSException {
        PeriodInfo curPeriod = ClientUtils.getCurrentPeriod(null, companyInfo);
        if (curPeriod != null) {
            beginYearSpinner.setValue((Object)new Integer(curPeriod.getPeriodYear()));
            beginPeriodSpinner.setValue((Object)new Integer(curPeriod.getPeriodNumber()));
            endYearSpinner.setValue((Object)new Integer(curPeriod.getPeriodYear()));
            endPeriodSpinner.setValue((Object)new Integer(curPeriod.getPeriodNumber()));
        }
    }

    public static PeriodCollection getPeriodc(CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        if (companyInfo.getAccountPeriodType() == null || companyInfo.getAccountPeriodType().getId() == null) {
            ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
            companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        }
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        evi.getSorter().add(new SorterItemInfo("periodYear"));
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc == null || periodc.size() == 0) {
            return null;
        }
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)companyInfo)) {
            return periodc;
        }
        PeriodInfo startPeriod = ClientUtils.getStartPeriodInfo(null, companyInfo);
        PeriodCollection rsltCols = new PeriodCollection();
        int n = periodc.size();
        for (int i = 0; i < n; ++i) {
            PeriodInfo periodInfo = periodc.get(i);
            if (!PeriodHelper.isAfterStartPeriod(startPeriod, periodInfo)) continue;
            rsltCols.add(periodInfo);
        }
        return rsltCols;
    }

    public static boolean isAfterStartPeriod(PeriodInfo startPeriod, PeriodInfo periodInfo) {
        if (startPeriod == null || periodInfo == null) {
            return false;
        }
        if (startPeriod.getPeriodYear() < periodInfo.getPeriodYear()) {
            return true;
        }
        return startPeriod.getPeriodYear() == periodInfo.getPeriodYear() && startPeriod.getPeriodNumber() <= periodInfo.getPeriodNumber();
    }

    private static void cachePeriod(CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        if (periodCache == null) {
            periodCache = new HashMap();
        }
        TreeMap<Integer, PeriodCollection> result = new TreeMap<Integer, PeriodCollection>();
        PeriodCollection pc = PeriodHelper.getPeriodc(companyInfo);
        for (PeriodInfo pi : pc) {
            PeriodCollection tmpPc;
            Integer year = new Integer(pi.getPeriodYear());
            if (!result.containsKey(year)) {
                tmpPc = new PeriodCollection();
                tmpPc.add(pi);
                result.put(year, tmpPc);
                continue;
            }
            tmpPc = (PeriodCollection)result.get(year);
            tmpPc.add(pi);
        }
        periodCache.put(new ObjectUuidPK(companyInfo.getId()), result);
    }

    public static void removeCachePeriod(CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        if (periodCache == null) {
            return;
        }
        periodCache.put(new ObjectUuidPK(companyInfo.getId()), null);
    }

    public static SpinnerNumberModel getYearSnm(CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        ObjectUuidPK companyPK = new ObjectUuidPK(companyInfo.getId());
        if (periodCache == null || !periodCache.containsKey(companyPK)) {
            PeriodHelper.cachePeriod(companyInfo);
        }
        TreeMap yearMap = (TreeMap)periodCache.get(companyPK);
        int begin = (Integer)yearMap.firstKey();
        int end = (Integer)yearMap.lastKey();
        PeriodInfo startPeriod = CashClientHelper.getStartPeriod(companyInfo);
        begin = startPeriod.getPeriodYear();
        SpinnerNumberModel result = null;
        if (begin > end) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"375_PeriodHelper"));
            SysUtil.abort();
        } else {
            result = new SpinnerNumberModel(begin, begin, end, 1);
        }
        return result;
    }

    public static SpinnerNumberModel getMonthSnm(CompanyOrgUnitInfo companyInfo, Integer year) throws EASBizException, BOSException {
        ObjectUuidPK companyPK = new ObjectUuidPK(companyInfo.getId());
        if (periodCache == null || !periodCache.containsKey(companyPK)) {
            PeriodHelper.cachePeriod(companyInfo);
        }
        TreeMap yearMap = (TreeMap)periodCache.get(companyPK);
        PeriodCollection pc = (PeriodCollection)yearMap.get(year);
        int begin = 1;
        int end = 1;
        if (pc != null && pc.get(0) != null) {
            begin = pc.get(0).getPeriodNumber();
        }
        if (pc != null && pc.get(pc.size() - 1) != null) {
            end = pc.get(pc.size() - 1).getPeriodNumber();
        }
        SpinnerNumberModel result = new SpinnerNumberModel(begin, begin, end, 1);
        return result;
    }

    public static void setPeriodNum(CompanyOrgUnitInfo companyInfo, KDSpinner spMonth, Integer year) throws EASBizException, BOSException {
        ObjectUuidPK companyPK = new ObjectUuidPK(companyInfo.getId());
        if (periodCache == null || !periodCache.containsKey(companyPK)) {
            PeriodHelper.cachePeriod(companyInfo);
        }
        int curValue = Integer.parseInt(spMonth.getValue().toString());
        TreeMap yearMap = (TreeMap)periodCache.get(companyPK);
        PeriodCollection pc = (PeriodCollection)yearMap.get(year);
        if (pc == null || pc != null && pc.size() < 1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"CheckPeriodMsg"));
            SysUtil.abort();
        }
        int begin = pc.get(0).getPeriodNumber();
        int end = pc.get(pc.size() - 1).getPeriodNumber();
        SpinnerNumberModel model = null;
        model = curValue >= begin && curValue <= end ? new SpinnerNumberModel(curValue, begin, end, 1) : new SpinnerNumberModel(begin, begin, end, 1);
        spMonth.setModel((SpinnerModel)model);
    }

    public static void periodChange(KDSpinner spYearFrom, KDSpinner spNumberFrom, KDSpinner spYearTo, KDSpinner spNumberTo) {
        int yearFrom = Integer.parseInt(spYearFrom.getValue().toString());
        int yearTo = Integer.parseInt(spYearTo.getValue().toString());
        int numberFrom = Integer.parseInt(spNumberFrom.getValue().toString());
        int numberTo = Integer.parseInt(spNumberTo.getValue().toString());
        if (yearFrom > yearTo) {
            spYearTo.setValue((Object)new Integer(yearFrom), false);
            spNumberTo.setValue((Object)new Integer(numberFrom), false);
            return;
        }
        if (yearFrom == yearTo && numberFrom > numberTo) {
            spNumberTo.setValue((Object)new Integer(numberFrom), false);
            return;
        }
    }

    public static PeriodInfo getPeriodInfo(int year, int periodNumber, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        TreeMap yearMap;
        PeriodCollection pc;
        ObjectUuidPK companyPK = new ObjectUuidPK(companyInfo.getId());
        if (periodCache == null || !periodCache.containsKey(companyPK)) {
            PeriodHelper.cachePeriod(companyInfo);
        }
        if ((pc = (PeriodCollection)(yearMap = (TreeMap)periodCache.get(companyPK)).get(new Integer(year))) == null) {
            return PeriodUtils.getPeriodInfo((int)year, (int)periodNumber, (CompanyOrgUnitInfo)companyInfo);
        }
        if (pc.get(periodNumber - 1) != null && pc.get(periodNumber - 1).getPeriodNumber() == periodNumber) {
            return pc.get(periodNumber - 1);
        }
        PeriodInfo info = null;
        for (int i = 0; i < pc.size(); ++i) {
            info = pc.get(i);
            if (info.getPeriodNumber() != periodNumber) continue;
            return info;
        }
        return PeriodUtils.getPeriodInfo((int)year, (int)periodNumber, (CompanyOrgUnitInfo)companyInfo);
    }

    public static PeriodInfo getPeriodInfo(Date date, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        TreeMap yearMap;
        PeriodCollection pc;
        Calendar cal = Calendar.getInstance();
        Date sourceDate = DateTimeUtils.truncateDate((Date)date);
        cal.setTime(date);
        int year = cal.get(1);
        ObjectUuidPK companyPK = new ObjectUuidPK(companyInfo.getId());
        if (periodCache == null || !periodCache.containsKey(companyPK)) {
            PeriodHelper.cachePeriod(companyInfo);
        }
        if ((pc = (PeriodCollection)(yearMap = (TreeMap)periodCache.get(companyPK)).get(new Integer(year))) == null) {
            return null;
        }
        PeriodInfo periodInfo = null;
        for (int i = 0; i < pc.size(); ++i) {
            periodInfo = pc.get(i);
            Date beginDate = periodInfo.getBeginDate();
            Date endDate = DateTimeUtils.truncateDate((Date)periodInfo.getEndDate());
            if ((!beginDate.before(sourceDate) || !endDate.after(sourceDate)) && !beginDate.equals(sourceDate) && !endDate.equals(sourceDate)) continue;
            return periodInfo;
        }
        return null;
    }

    public static PeriodInfo getPrePeriodInfo(CompanyOrgUnitInfo companyInfo, PeriodInfo period) throws EASBizException, BOSException {
        ObjectUuidPK companyPK = new ObjectUuidPK(companyInfo.getId());
        if (periodCache == null || !periodCache.containsKey(companyPK)) {
            PeriodHelper.cachePeriod(companyInfo);
        }
        TreeMap yearMap = (TreeMap)periodCache.get(companyPK);
        PeriodCollection pc = null;
        if (period.getPeriodNumber() == 1) {
            pc = (PeriodCollection)yearMap.get(new Integer(period.getPeriodYear() - 1));
            if (pc != null && pc.size() > 0) {
                return pc.get(pc.size() - 1);
            }
        } else {
            pc = (PeriodCollection)yearMap.get(new Integer(period.getPeriodYear()));
        }
        if (pc == null) {
            return null;
        }
        PeriodInfo periodInfo = null;
        for (int i = 0; i < pc.size(); ++i) {
            periodInfo = pc.get(i);
            if (periodInfo.getPeriodYear() != period.getPeriodYear() || periodInfo.getPeriodNumber() != period.getPeriodNumber()) continue;
            if (i == 0) {
                return null;
            }
            return pc.get(i - 1);
        }
        return null;
    }

    public static PeriodInfo getNextPeriodInfo(CompanyOrgUnitInfo companyInfo, PeriodInfo period) throws EASBizException, BOSException {
        TreeMap yearMap;
        PeriodCollection pc;
        if (period == null) {
            return null;
        }
        ObjectUuidPK companyPK = new ObjectUuidPK(companyInfo.getId());
        if (periodCache == null || !periodCache.containsKey(companyPK)) {
            PeriodHelper.cachePeriod(companyInfo);
        }
        if ((pc = (PeriodCollection)(yearMap = (TreeMap)periodCache.get(companyPK)).get(new Integer(period.getPeriodYear()))) == null) {
            return null;
        }
        PeriodInfo periodInfo = null;
        for (int i = 0; i < pc.size(); ++i) {
            periodInfo = pc.get(i);
            if (periodInfo.getPeriodYear() != period.getPeriodYear() || periodInfo.getPeriodNumber() != period.getPeriodNumber()) continue;
            if (i == pc.size() - 1) {
                pc = (PeriodCollection)yearMap.get(new Integer(period.getPeriodYear() + 1));
                if (pc == null) {
                    return null;
                }
                return pc.get(0);
            }
            return pc.get(i + 1);
        }
        return null;
    }

    public static PeriodInfo getCashStartPeriod(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        String key = company.getId().toString();
        if (startPeriodMap == null) {
            startPeriodMap = new HashMap();
        }
        if (startPeriodMap.containsKey(key)) {
            return (PeriodInfo)startPeriodMap.get(key);
        }
        PeriodInfo info = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        startPeriodMap.put(key, info);
        return info;
    }

    public static PeriodInfo getLastPeriodInfo(CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        int end;
        TreeMap yearMap;
        PeriodCollection pc;
        ObjectUuidPK companyPK = new ObjectUuidPK(companyInfo.getId());
        if (periodCache == null || !periodCache.containsKey(companyPK)) {
            PeriodHelper.cachePeriod(companyInfo);
        }
        if ((pc = (PeriodCollection)(yearMap = (TreeMap)periodCache.get(companyPK)).get(new Integer(end = ((Integer)yearMap.lastKey()).intValue()))) == null) {
            return null;
        }
        return pc.get(pc.size() - 1);
    }

    public static String getPeriodCollSQL(String periodTypeId, int beginYear, int beginMonth, int endYear, int endMonth) {
        StringBuffer sb = new StringBuffer();
        sb.append("select fid from t_bd_period A ");
        sb.append(" where A.FPERIODYEAR*100 + A.FPERIODNUMBER >=");
        sb.append(beginYear * 100 + beginMonth);
        sb.append(" and A.FPERIODYEAR*100 + A.FPERIODNUMBER  <=");
        sb.append(endYear * 100 + endMonth);
        sb.append(" and A.FTypeID='");
        sb.append(periodTypeId);
        sb.append("'");
        return sb.toString();
    }

    public static PeriodCollection getPeriodColl(Context ctx, String periodtypeId, int beginYear, int beginMonth, int endYear, int endMonth) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StringBuffer sb = new StringBuffer();
        sb.append("select fid from t_bd_period A ");
        sb.append(" where A.FPERIODYEAR*100 + A.FPERIODNUMBER >=");
        sb.append(beginYear * 100 + beginMonth);
        sb.append(" and A.FPERIODYEAR*100 + A.FPERIODNUMBER  <=");
        sb.append(endYear * 100 + endMonth);
        sb.append(" and A.FTypeID='");
        sb.append(periodtypeId);
        sb.append("'");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sb.toString(), CompareType.INNER));
        ev.setFilter(filter);
        ev.getSorter().add(new SorterItemInfo("periodyear"));
        ev.getSorter().add(new SorterItemInfo("periodnumber"));
        IPeriod iPeriod = null;
        iPeriod = ctx == null ? PeriodFactory.getRemoteInstance() : PeriodFactory.getLocalInstance((Context)ctx);
        PeriodCollection periocColl = iPeriod.getPeriodCollection(ev);
        return periocColl;
    }

    public static void initPeriodSpinner(CompanyOrgUnitInfo companyInfo, PeriodInfo curPeriod, PeriodInfo startPeriod, KDSpinner beginYearSpinner, KDSpinner beginPeriodSpinner, KDSpinner endYearSpinner, KDSpinner endPeriodSpinner) throws EASBizException, BOSException {
        if (curPeriod != null) {
            beginYearSpinner.setValue((Object)new Integer(curPeriod.getPeriodYear()));
            beginPeriodSpinner.setValue((Object)new Integer(curPeriod.getPeriodNumber()));
            endYearSpinner.setValue((Object)new Integer(curPeriod.getPeriodYear()));
            endPeriodSpinner.setValue((Object)new Integer(curPeriod.getPeriodNumber()));
        }
    }
}

