/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.client.AbstractPeriodSelectUI;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;

public class PeriodSelectUI
extends AbstractPeriodSelectUI {
    private static final String recourcePath = "com.kingdee.eas.fi.cas.CasResources";
    private int closeWindowType = -1;
    private PeriodCollection periods = null;
    private static PeriodInfo selectedPeriod = null;
    private CompanyOrgUnitInfo _companyInfo = null;
    public static final String COMPANYID = "COMPANYID";
    public static final String START_PERIODID = "START_PERIODID";

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public String getUITitle() {
        return EASResource.getString((String)recourcePath, (String)"ImportGLUITitle");
    }

    public boolean isConfirm() throws Exception {
        return this.closeWindowType == 2;
    }

    private void initSpinner() throws Exception {
        if (this._companyInfo == null) {
            this.spYear.setModel((SpinnerModel)new SpinnerNumberModel(2000, 2000, 2038, 1));
            this.spNumber.setModel((SpinnerModel)new SpinnerNumberModel(1, 1, 12, 1));
            return;
        }
        ObjectUuidPK companyPK = new ObjectUuidPK(this._companyInfo.getId());
        if (this._companyInfo.getAccountPeriodType() == null) {
            ICompanyOrgUnit iCom = CompanyOrgUnitFactory.getRemoteInstance();
            this._companyInfo = iCom.getCompanyOrgUnitInfo((IObjectPK)companyPK);
        }
        PeriodInfo currPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (IObjectPK)companyPK);
        PeriodInfo glStartPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)companyPK);
        PeriodInfo glCurrentPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (IObjectPK)companyPK);
        IPeriod iPeriod = PeriodFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)this._companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        if (currPeriod != null) {
            filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)glStartPeriod.getBeginDate(), CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)glCurrentPeriod.getEndDate(), CompareType.LESS_EQUALS));
        }
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("periodYear"));
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        this.periods = iPeriod.getPeriodCollection(evi);
        if (this.periods == null || this.periods.size() == 0) {
            this.spYear.setModel((SpinnerModel)new SpinnerNumberModel(2004, 2004, 2038, 1));
            this.spNumber.setModel((SpinnerModel)new SpinnerNumberModel(1, 1, 12, 1));
            return;
        }
        PeriodInfo periodInfo = null;
        int firstYear = 2004;
        int endYear = 2004;
        int firstNum = 1;
        int endNum = 12;
        int n = this.periods.size();
        for (int i = 0; i < n; ++i) {
            periodInfo = this.periods.get(i);
            if (i == 0) {
                firstYear = periodInfo.getPeriodYear();
                firstNum = periodInfo.getPeriodNumber();
                endYear = periodInfo.getPeriodYear();
                endNum = periodInfo.getPeriodNumber();
                continue;
            }
            if (periodInfo.getPeriodYear() == firstYear) {
                endNum = periodInfo.getPeriodNumber();
                continue;
            }
            if (i != n - 1) continue;
            endYear = periodInfo.getPeriodYear();
        }
        if (firstYear < endYear) {
            this.spYear.setModel((SpinnerModel)new SpinnerNumberModel(firstYear, firstYear, endYear, 1));
        } else if (firstYear == endYear) {
            this.spYear.setEnabled(false);
            this.spYear.setValue((Object)new Integer(firstYear));
        }
        this.spNumber.setModel((SpinnerModel)new SpinnerNumberModel(firstNum, firstNum, endNum, 1));
        if (glCurrentPeriod != null) {
            this.spYear.setValue((Object)new Integer(glCurrentPeriod.getPeriodYear()));
            this.spNumber.setValue((Object)new Integer(glCurrentPeriod.getPeriodNumber()));
        }
    }

    @Override
    protected void spYear_stateChanged(ChangeEvent e) throws Exception {
        super.spYear_stateChanged(e);
        int year = Integer.parseInt(this.spYear.getValue().toString());
        if (this.periods != null) {
            PeriodInfo periodInfo = null;
            int firstNum = 1;
            int endNum = 1;
            boolean fYear = false;
            int n = this.periods.size();
            for (int i = 0; i < n; ++i) {
                periodInfo = this.periods.get(i);
                if (periodInfo.getPeriodYear() == year) {
                    if (!fYear) {
                        firstNum = periodInfo.getPeriodNumber();
                        endNum = periodInfo.getPeriodNumber();
                        fYear = true;
                        continue;
                    }
                    endNum = periodInfo.getPeriodNumber();
                    continue;
                }
                if (periodInfo.getPeriodYear() > year) break;
            }
            this.spNumber.setModel((SpinnerModel)new SpinnerNumberModel(firstNum, firstNum, endNum, 1));
        }
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.closeWindowType = 1;
        selectedPeriod = null;
        this.disposeUIWindow();
    }

    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.closeWindowType = 2;
        int year = Integer.parseInt(this.spYear.getValue().toString());
        int num = Integer.parseInt(this.spNumber.getValue().toString());
        if (this.periods != null) {
            int n = this.periods.size();
            for (int i = 0; i < n; ++i) {
                if (this.periods.get(i).getPeriodYear() != year || this.periods.get(i).getPeriodNumber() != num) continue;
                selectedPeriod = this.periods.get(i);
                break;
            }
        } else {
            selectedPeriod = new PeriodInfo();
            selectedPeriod.setPeriodYear(year);
            selectedPeriod.setPeriodNumber(num);
        }
        this.disposeUIWindow();
    }

    public PeriodInfo getPeriod() {
        return selectedPeriod;
    }

    public void onLoad() throws Exception {
        this._companyInfo = (CompanyOrgUnitInfo)this.getUIContext().get("company");
        this.initSpinner();
    }

    public static PeriodInfo showDialogWindow(IUIObject ui, CompanyOrgUnitInfo company) throws UIException {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"company", (Object)company);
        IUIWindow window = null;
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        window = uiFactory.create(PeriodSelectUI.class.getName(), (Map)uiContext, null, null);
        window.show();
        return selectedPeriod;
    }
}

