/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.cas.CashManagementFactory;
import com.kingdee.eas.fi.cas.client.AbstractQingCapitalSumFilterUI;
import com.kingdee.eas.fi.cas.client.CashClientHelper;
import com.kingdee.eas.fi.cas.client.JournalHandler;
import com.kingdee.eas.fi.cas.client.QingCapitalSumFilterParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.INewCompanyF7UsedAble;
import com.kingdee.eas.fm.common.client.NewCompanyF7Substitute;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.SpinnerUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.Set;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class QingCapitalSumFilterUI
extends AbstractQingCapitalSumFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(QingCapitalSumFilterUI.class);
    public static final String RESOURCEPATH = "com.kingdee.eas.fi.cas.client.CashMgtResource";
    public CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();

    public QingCapitalSumFilterUI() throws Exception {
        try {
            PeriodEntity pe = JournalHandler.requestPeriodEntity(this.currentCompany);
            SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.spiBeginYear, (KDSpinner)this.spiBeginMonth, (KDSpinner)this.spiEndYear, (KDSpinner)this.spiEndMonth, (boolean)false, (boolean)false);
        }
        catch (Exception e) {
            SpinnerUtil.manageAccountLevelRange((int)1970, (int)2990, (KDSpinner)this.spiBeginYear, (KDSpinner)this.spiEndYear);
            SpinnerUtil.manageAccountLevelRange((int)1, (int)12, (KDSpinner)this.spiBeginMonth, (KDSpinner)this.spiEndMonth);
        }
        SpinnerNumberModel spmodel = new SpinnerNumberModel(1, 1, 99, 1);
        this.txtSmallLimitAmt.setHorizontalAlignment(4);
        this.txtSmallLimitAmt.setPrecision(2);
        this.spiLevel.setModel((SpinnerModel)spmodel);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        FMClientHelper.initComboCurrency((KDComboBox)this.cboCurrency, (boolean)true);
        this.jtAmountUnit.setSelectedItem((Object)AmountUnitEnum.yuan);
        F7SelectorFactory.initBankTree((IUIObject)this, (KDBizPromptBox)this.jbpBank);
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            this.lblLevel.setVisible(false);
        }
        this.txtSmallLimitAmt.setHorizontalAlignment(4);
        this.txtSmallLimitAmt.setRemoveingZeroInDispaly(false);
        this.txtSmallLimitAmt.setImmediatelyValidate(true);
        this.txtSmallLimitAmt.setSupportedEmpty(true);
    }

    public Object getParam() {
        QingCapitalSumFilterParam param = new QingCapitalSumFilterParam();
        param.setCompanyIdSet(this.getCompanyIdSet());
        param.setBankIdSet(FMHelper.Array2Set((String[])AccessHelper.getF7Ids((KDBizPromptBox)this.jbpBank)));
        CurrencyInfo currency = (CurrencyInfo)this.cboCurrency.getSelectedItem();
        param.setCurrency(currency);
        if (this.btnByPeriod.isSelected()) {
            int startYear = Integer.parseInt(this.spiBeginYear.getValue().toString());
            int startMonth = Integer.parseInt(this.spiBeginMonth.getValue().toString());
            int endYear = Integer.parseInt(this.spiEndYear.getValue().toString());
            int endMonth = Integer.parseInt(this.spiEndMonth.getValue().toString());
            try {
                param.setBeginYear(startYear);
                param.setBeginMonth(startMonth);
                param.setEndYear(endYear);
                param.setEndMonth(endMonth);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            param.setStartDate(this.dtpFromDate.getSqlDate());
            param.setEndDate(this.dtpToDate.getSqlDate());
        }
        param.setLimitAmt(this.txtSmallLimitAmt.getBigDecimalValue());
        boolean isShowCancelUs = this.isShowCancelUser.isSelected();
        param.setShowCancelUs(isShowCancelUs);
        AmountUnitEnum amountUnit = (AmountUnitEnum)this.jtAmountUnit.getSelectedItem();
        param.setAmountUnit(amountUnit);
        boolean includeCash = this.chkIncudeCash.isSelected();
        param.setIncludeCash(includeCash);
        boolean isHideNoDataAcct = this.chkHideNoDataAccount.isSelected();
        param.setHideNoDataAcct(isHideNoDataAcct);
        int level = (Integer)this.spiLevel.getValue();
        param.setLevel(level);
        param.setByDate(!this.btnByPeriod.isSelected());
        return param;
    }

    public void setParam(Object param) {
    }

    public void onShow() throws Exception {
        super.onShow();
        this.spiBeginYear.requestFocus();
    }

    protected void init() throws Exception {
        super.init();
        PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.currentCompany);
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            PeriodEntity pe = new PeriodEntity(CashManagementFactory.getRemoteInstance().getPeriodRange(this.currentCompany, SystemEnum.CASHMANAGEMENT));
            SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.spiBeginYear, (KDSpinner)this.spiBeginMonth, (KDSpinner)this.spiEndYear, (KDSpinner)this.spiEndMonth, (boolean)false, (boolean)false);
        } else if (EmptyUtil.isEmpty((CoreBaseInfo)periodInfo)) {
            periodInfo = PeriodUtils.getPeriodInfo(null, (Date)new Date(), (CompanyOrgUnitInfo)this.currentCompany);
        }
        this.spiBeginYear.setValue((Object)new Integer(periodInfo.getPeriodYear()));
        this.spiBeginMonth.setValue((Object)new Integer(periodInfo.getPeriodNumber()));
        this.spiEndYear.setValue((Object)new Integer(periodInfo.getPeriodYear()));
        this.spiEndMonth.setValue((Object)new Integer(periodInfo.getPeriodNumber()));
    }

    public void clear() {
        super.clear();
        try {
            FMClientHelper.initComboCurrency((KDComboBox)this.cboCurrency, (boolean)true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SpinnerNumberModel spmodel = new SpinnerNumberModel(1, 1, 99, 1);
        this.txtSmallLimitAmt.setHorizontalAlignment(4);
        this.txtSmallLimitAmt.setPrecision(2);
        this.spiLevel.setModel((SpinnerModel)spmodel);
        this.jtAmountUnit.setSelectedItem((Object)AmountUnitEnum.yuan);
        this.chkIncudeCash.setSelected(false);
        this.prmtAccountProperty.setValue(null);
        this.jbpBank.setValue(null);
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            this.lblLevel.setVisible(false);
        }
        this.btnByPeriod.setSelected(true);
        this.txtSmallLimitAmt.setValue(null);
        this.dtpFromDate.setValue((Object)DateHelper.getDayBegin());
        this.dtpToDate.setValue((Object)DateHelper.getDayBegin());
        this.chkHideNoDataAccount.setSelected(false);
        this.isShowCancelUser.setSelected(false);
    }

    public boolean verify() {
        super.verify();
        if (this.btnByDate.isSelected()) {
            boolean rst = super.verify();
            CashClientHelper.verifyEmpty((CoreUIObject)this, RESOURCEPATH, this.dtpToDate, "cm63");
            CashClientHelper.verifyEmpty((CoreUIObject)this, RESOURCEPATH, this.dtpFromDate, "cm63");
            if (DateTimeUtils.truncateDate((Date)this.dtpToDate.getSqlDate()).before(DateTimeUtils.truncateDate((Date)this.dtpFromDate.getSqlDate()))) {
                this.dtpFromDate.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCEPATH, (String)"EndDateBeforeBeginDate"));
                SysUtil.abort();
            }
            try {
                PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.currentCompany);
                if (startPeriod != null && startPeriod.getBeginDate().compareTo(DateTimeUtils.truncateDate((Date)this.dtpFromDate.getSqlDate())) > 0) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCEPATH, (String)"EndDateBeforeStartDate"));
                    SysUtil.abort();
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            return rst;
        }
        boolean rst = super.verify();
        return rst;
    }

    public boolean verifyBeginPerid(Set companySet, int serial) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ss.fcompanyid ");
        sb.append(" FROM t_bd_systemstatusctrol ss, t_bd_period sp, t_bd_period cp");
        sb.append(" WHERE ss.fstartperiodid = sp.fid AND ss.fcurrentperiodid = cp.fid");
        sb.append(" and ss.FSYSTEMSTATUSID in (select fid from t_bd_systemstatus  where fname =7)");
        sb.append(" and ( sp.FPERIODYEAR*100 + sp.FPERIODNUMBER>" + serial);
        sb.append(" or  cp.FPERIODYEAR*100 + cp.FPERIODNUMBER <" + serial);
        sb.append(") and ss.fisstart=1");
        sb.append(" and ");
        sb.append(FMHelper.buildIn((String)"ss.fcompanyid", (Object[])companySet.toArray()));
        ISQLExecutor sql = SQLExecutorFactory.getRemoteInstance((String)sb.toString());
        try {
            IRowSet rs = sql.executeSQL();
            if (rs.next()) {
                CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(rs.getString(1)));
                MsgBox.showError((Component)((Object)this), (String)com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"384_RptCapitalSumFilterUI", (Object[])new Object[]{company.getName()}));
                SysUtil.abort();
                return true;
            }
        }
        catch (Exception e) {
            SysUtil.abort((Throwable)e);
        }
        return false;
    }

    protected void btnCompanySelect_actionPerformed(ActionEvent e) throws Exception {
        NewCompanyF7Substitute newCompanyF7 = new NewCompanyF7Substitute((INewCompanyF7UsedAble)this, this.getNewCompanyF7());
        newCompanyF7.showAndSaveSelected();
    }

    @Override
    protected void btnByPeriod_stateChanged(ChangeEvent e) throws Exception {
        this.pnlByDate.setVisible(false);
        this.pnlByPeriod.setVisible(false);
        this.pnlByPeriod.setVisible(true);
    }

    @Override
    protected void btnByDate_stateChanged(ChangeEvent e) throws Exception {
        this.pnlByDate.setVisible(false);
        this.pnlByPeriod.setVisible(false);
        this.pnlByDate.setVisible(true);
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
    }
}

