/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.PaymentBillTypeInfo;
import com.kingdee.eas.fi.cas.ReceivingBillEntryCollection;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillTypeInfo;
import com.kingdee.eas.fi.cas.client.CasPaymentBillUI;
import com.kingdee.eas.fi.cas.client.CasReceivingBillUI;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class RecPayRedTypeHelper {
    private static Logger logger = Logger.getLogger((String)RecPayRedTypeHelper.class.getName());
    private static RecPayRedTypeHelper instance = null;
    public static final String COL_AMT = "amount";
    public static final String COL_LOC_AMT = "localAmt";

    private RecPayRedTypeHelper() {
    }

    public static RecPayRedTypeHelper getInstance() {
        if (instance == null) {
            instance = new RecPayRedTypeHelper();
            return instance;
        }
        return instance;
    }

    public String[] getPaymentRedFontColumnNames() {
        String[] redFontColumns = new String[]{COL_AMT, COL_LOC_AMT};
        return redFontColumns;
    }

    private String[] getReceiveRedFontColumnNames() {
        String[] redFontColumns = new String[]{COL_AMT, COL_LOC_AMT};
        return redFontColumns;
    }

    public boolean isPaymentTypeRedType(PaymentBillTypeInfo paymentBillType) {
        HashSet<String> set = new HashSet<String>();
        set.add("203");
        set.add("204");
        set.add("206");
        return paymentBillType != null && set.contains(paymentBillType.getNumber());
    }

    public boolean isReceivingTypeRedType(ReceivingBillTypeInfo receivingBillType) {
        HashSet<String> set = new HashSet<String>();
        set.add("103");
        set.add("102");
        set.add("105");
        return receivingBillType != null && set.contains(receivingBillType.getNumber());
    }

    public void setPaymentRedBillCompsOpp(CasPaymentBillUI ui) {
        PaymentBillInfo editData = ui.editData;
        KDTable kdtEntries = ui.kdtEntries;
        ui.txtActPayAmt.setValue((Object)this.getOppsValue(editData.getActPayAmt()));
        ui.txtActPayLocAmt.setValue((Object)this.getOppsValue(editData.getActPayLocAmt()));
        for (int num = 0; num < kdtEntries.getRowCount(); ++num) {
            IRow row = kdtEntries.getRow2(num);
            PaymentBillEntryInfo bo = (PaymentBillEntryInfo)row.getUserObject();
            row.getCell(COL_AMT).setValue((Object)this.getOppsValue(bo.getActualAmt()));
            row.getCell(COL_LOC_AMT).setValue((Object)this.getOppsValue(bo.getActualLocAmt()));
        }
    }

    public void setReceivingRedBillCompsOpp(CasReceivingBillUI ui) {
        ReceivingBillInfo editData = ui.editData;
        KDTable kdtEntries = ui.kdtEntries;
        ui.txtActRecAmt.setValue((Object)this.getOppsValue(editData.getActRecAmt()));
        ui.txtActRecLocAmt.setValue((Object)this.getOppsValue(editData.getActRecLocAmt()));
        for (int num = 0; num < kdtEntries.getRowCount(); ++num) {
            IRow row = kdtEntries.getRow2(num);
            ReceivingBillEntryInfo bo = (ReceivingBillEntryInfo)row.getUserObject();
            row.getCell(COL_AMT).setValue((Object)this.getOppsValue(bo.getActualAmt()));
            row.getCell(COL_LOC_AMT).setValue((Object)this.getOppsValue(bo.getActualLocAmt()));
        }
    }

    public void storePaymentCompValues(CasPaymentBillUI ui) {
        PaymentBillInfo editData = ui.editData;
        editData.setActPayAmt(this.getOppsValue(ui.txtActPayAmt.getBigDecimalValue()));
        editData.setActPayLocAmt(this.getOppsValue(ui.txtActPayLocAmt.getBigDecimalValue()));
        editData.setLocalAmt(this.getOppsValue(ui.txtActPayAmt.getBigDecimalValue()));
        KDTable kdtEntries = ui.kdtEntries;
        PaymentBillEntryCollection entries = editData.getEntries();
        for (int i = 0; i < entries.size(); ++i) {
            BigDecimal amount;
            IRow row = kdtEntries.getRow2(i);
            Object idValue = row.getCell("id").getValue();
            PaymentBillEntryInfo bo = (PaymentBillEntryInfo)row.getUserObject();
            if (row.getCell(COL_AMT).getValue() != null) {
                amount = (BigDecimal)row.getCell(COL_AMT).getValue();
                bo.setActualAmt(this.getOppsValue(amount));
            }
            if (row.getCell(COL_LOC_AMT).getValue() == null) continue;
            amount = (BigDecimal)row.getCell(COL_LOC_AMT).getValue();
            bo.setLocalAmt(this.getOppsValue(amount));
            bo.setActualLocAmt(this.getOppsValue(amount));
        }
    }

    public void storeReceivingCompValues(CasReceivingBillUI ui) {
        ReceivingBillInfo editData = ui.editData;
        editData.setActRecAmt(this.getOppsValue(ui.txtActRecAmt.getBigDecimalValue()));
        editData.setActRecLocAmt(this.getOppsValue(ui.txtActRecLocAmt.getBigDecimalValue()));
        editData.setLocalAmt(this.getOppsValue(ui.txtActRecAmt.getBigDecimalValue()));
        KDTable kdtEntries = ui.kdtEntries;
        ReceivingBillEntryCollection entries = editData.getEntries();
        for (int i = 0; i < entries.size(); ++i) {
            BigDecimal amount;
            IRow row = kdtEntries.getRow2(i);
            Object idValue = row.getCell("id").getValue();
            ReceivingBillEntryInfo bo = (ReceivingBillEntryInfo)row.getUserObject();
            if (row.getCell(COL_AMT).getValue() != null) {
                amount = (BigDecimal)row.getCell(COL_AMT).getValue();
                bo.setActualAmt(this.getOppsValue(amount));
            }
            if (row.getCell(COL_LOC_AMT).getValue() == null) continue;
            amount = (BigDecimal)row.getCell(COL_LOC_AMT).getValue();
            bo.setLocalAmt(this.getOppsValue(amount));
            bo.setActualLocAmt(this.getOppsValue(amount));
        }
    }

    public BigDecimal getOppsValue(BigDecimal value) {
        if (value != null) {
            value = value.negate();
        }
        return value;
    }

    public void resetPaymentRedBillColumns(KDTable kdtEntries, boolean isRedBill) {
        if (isRedBill) {
            this.resetColumnFontColor(kdtEntries, Color.RED, this.getPaymentRedFontColumnNames(), isRedBill);
        } else {
            this.resetColumnFontColor(kdtEntries, Color.BLACK, this.getPaymentRedFontColumnNames(), isRedBill);
        }
    }

    public void resetReceivingRedBillColumns(KDTable kdtEntries, boolean isRedBill) {
        if (isRedBill) {
            this.resetColumnFontColor(kdtEntries, Color.RED, this.getPaymentRedFontColumnNames(), isRedBill);
        } else {
            this.resetColumnFontColor(kdtEntries, Color.BLACK, this.getPaymentRedFontColumnNames(), isRedBill);
        }
    }

    public void resetReceiveRedBillColumns(KDTable kdtEntries, boolean isRedBill) {
        if (isRedBill) {
            this.resetColumnFontColor(kdtEntries, Color.RED, this.getReceiveRedFontColumnNames(), isRedBill);
        } else {
            this.resetColumnFontColor(kdtEntries, Color.BLACK, this.getReceiveRedFontColumnNames(), isRedBill);
        }
    }

    public void resetColumnFontColor(KDTable kdtEntries, Color colorType, String[] redArray, boolean isRedBill) {
        int num = kdtEntries.getRowCount();
        for (int row = 0; row < num; ++row) {
            for (int i = 0; i < redArray.length; ++i) {
                try {
                    kdtEntries.getColumn(redArray[i]).getStyleAttributes().setFontColor(colorType);
                    continue;
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
        }
    }
}

