/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ReceiptFormDataProvider
implements BOSQueryDelegate {
    private static IMetaDataPK qpk = new MetaDataPK("com.kingdee.eas.fi.cas.ReceiptFormTDQuery");
    private Set ids = null;

    public ReceiptFormDataProvider(Set id) {
        this.ids = id;
    }

    public ReceiptFormDataProvider(List id) {
        this.ids = new HashSet(id);
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        IRowSet iRowSet = null;
        try {
            IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)qpk);
            exec.option().isAutoTranslateEnum = true;
            exec.option().isAutoTranslateBoolean = true;
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)this.ids, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("parent.billStatus", (Object)new Integer(1)));
            ev.setFilter(filter);
            exec.setObjectView(ev);
            iRowSet = exec.executeQuery();
            while (iRowSet.next()) {
                int precision = iRowSet.getInt("currency.precision");
                iRowSet.updateBigDecimal("parent.amtSum", iRowSet.getBigDecimal("parent.amtSum").setScale(precision, 4));
                iRowSet.updateBigDecimal("amount", iRowSet.getBigDecimal("amount").setScale(precision, 4));
                iRowSet.updateBigDecimal("price", iRowSet.getBigDecimal("price").setScale(precision, 4));
                iRowSet.updateBigDecimal("rebate", iRowSet.getBigDecimal("rebate").setScale(precision, 4));
                iRowSet.updateBigDecimal("quantity", iRowSet.getBigDecimal("quantity").setScale(0, 4));
                if (iRowSet.getString("bizDate") != null) {
                    iRowSet.updateString("bizDate", iRowSet.getString("bizDate").substring(0, 10));
                }
                if (iRowSet.getString("endDate") != null) {
                    iRowSet.updateString("endDate", iRowSet.getString("endDate").substring(0, 10));
                }
                iRowSet.updateString("srcBillID", FMClientHelper.getBillNumber((String)iRowSet.getString("srcBillID")));
                String typeId = iRowSet.getString("asstType.id");
                String acctId = iRowSet.getString("parent.asstActID");
                if (FMHelper.isEmpty((String)typeId) || FMHelper.isEmpty((String)acctId)) continue;
                ObjectUuidPK pk = new ObjectUuidPK(acctId);
                BOSUuid bosId = BOSUuid.read((String)acctId);
                IDynamicObject da = DynamicObjectFactory.getRemoteInstance();
                IObjectValue info = da.getValue(bosId.getType(), (IObjectPK)pk);
                iRowSet.updateString("address", info.getString("address"));
            }
            iRowSet.beforeFirst();
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Component)((CoreUI)null), (Throwable)e1);
        }
        return iRowSet;
    }

    public static void main(String[] args) throws BOSException {
        FMClientHelper.printTDMetaDataField((String)qpk.getFullName());
    }
}

