/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.CurrentInfo;
import com.kingdee.eas.fi.cas.IReceiptForm;
import com.kingdee.eas.fi.cas.ReceiptFormEntryInfo;
import com.kingdee.eas.fi.cas.ReceiptFormFactory;
import com.kingdee.eas.fi.cas.ReceiptFormInfo;
import com.kingdee.eas.fi.cas.ReceiptStatusEnum;
import com.kingdee.eas.fi.cas.client.AbstractReceiptFormEditUI;
import com.kingdee.eas.fi.cas.client.BookNotifyClientHelper;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fi.cas.client.RecPayHandler;
import com.kingdee.eas.fi.cas.client.ReceiptFormDataProvider;
import com.kingdee.eas.fi.cas.client.ReceiptFormHandler;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ReceiptFormEditUI
extends AbstractReceiptFormEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ReceiptFormEditUI.class);
    private BOSObjectType srcObjType = null;
    private CompanyOrgUnitInfo companyInfo = null;
    private UserInfo user = null;
    public static final String RECEIPTFORM_FILENAME = "/FI/CAS/RECEIPTFORM";

    public void onLoad() throws Exception {
        if (this.companyInfo == null) {
            this.companyInfo = ClientUtils.getCurrLoginCompany();
        }
        if (this.user == null) {
            this.user = ContextHelperFactory.getRemoteInstance().getCurrentUser();
        }
        if (!"FINDVIEW".equalsIgnoreCase(this.getOprtState())) {
            ClientUtils.checkCompany((Component)((Object)this), this.companyInfo);
        }
        this.kdtEntries.checkParsed();
        CashHelper.initCombCurrency(this.comboCurrency, false);
        BookNotifyClientHelper.initCurrentType(this.comboAsstActType, false, null);
        super.onLoad();
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        this.txtAmtSum.setHorizontalAlignment(4);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionCreateFromAsst.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_associatecreate"));
        this.actionCreateFromRec.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_associatecreate"));
        this.actionBlankOut.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_blankout"));
        this.comboCurrency.setEnabled(false);
        this.comboAsstActType.setEnabled(false);
        this.prmtAsstAct.setEnabled(false);
        this.txtAmtSum.setEnabled(false);
        this.kdtEntries.getStyleAttributes().setLocked(true);
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        if (OprtState.ADDNEW.equalsIgnoreCase(this.getOprtState())) {
            ((ReceiptFormInfo)dataObject).setCompany(this.companyInfo);
            ((ReceiptFormInfo)dataObject).setBizDate(DateHelper.getDayBegin());
            ((ReceiptFormInfo)dataObject).setCreator(this.user);
        }
        super.setDataObject(dataObject);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.actionAddNew.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionSave.setVisible(false);
        this.actionCopy.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionInsertLine.setVisible(false);
        this.actionAddLine.setVisible(false);
        this.actionCreateFrom.setVisible(false);
        this.actionCopyFrom.setVisible(false);
        this.actionTraceDown.setVisible(false);
        this.actionTraceUp.setVisible(false);
        this.actionMultiapprove.setVisible(false);
        this.actionNextPerson.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.actionRemove.setEnabled(false);
        ReceiptFormInfo info = (ReceiptFormInfo)this.getDataObject();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            FMClientHelper.initNumber((CoreBaseInfo)info, (KDTextField)this.txtNumber, (String)info.getCompany().getId().toString());
            this.actionBlankOut.setVisible(false);
        } else if (OprtState.VIEW.equals(this.getOprtState())) {
            this.actionCreateFromAsst.setVisible(false);
            this.actionCreateFromRec.setVisible(false);
            if (info.isHasEffected()) {
                this.actionSubmit.setVisible(false);
            } else {
                this.actionSubmit.setVisible(true);
                this.actionSubmit.setEnabled(true);
            }
            this.actionRemoveLine.setVisible(false);
            if (info.getBillStatus().equals((Object)ReceiptStatusEnum.BLANKOUT)) {
                this.actionBlankOut.setEnabled(false);
            } else {
                this.actionBlankOut.setEnabled(true);
            }
        }
        boolean isVerify = false;
        try {
            isVerify = GlUtils.getVerifyParam(null, (String)this.companyInfo.getId().toString());
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (isVerify) {
            this.actionCreateFromAsst.setEnabled(false);
        }
        BigDecimal amtSum = RecPayHandler.getEntryAmtSum(this.kdtEntries, "amount");
        this.txtAmtSum.setValue((Object)amtSum);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.editData.getCurrency());
        FMClientHelper.setSelectObject((KDComboBox)this.comboAsstActType, (Object)this.editData.getAsstActType());
        BOSUuid asstActID = this.editData.getAsstActID();
        String asstActName = this.editData.getAsstActName();
        ReceiptFormHandler.fillAsstAct(this.prmtAsstAct, asstActID, asstActName);
        BigDecimal amtSum = RecPayHandler.getEntryAmtSum(this.kdtEntries, "amount");
        this.txtAmtSum.setValue((Object)amtSum);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setBizDate(DateTimeUtils.truncateDate((Date)((Date)this.pkBizDate.getValue())));
        DataBaseInfo info = (DataBaseInfo)this.prmtAsstAct.getData();
        if (info != null) {
            this.editData.setAsstActID(info.getId());
            this.editData.setAsstActName(info.getName());
        }
    }

    @Override
    protected void comboCurrency_actionPerformed(ActionEvent e) throws Exception {
        CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        if (currencyInfo == null) {
            return;
        }
        String currencyId = currencyInfo.getId().toString();
        this.txtAmtSum.setPrecision(currencyInfo.getPrecision());
        this.txtAmtSum.setRemoveingZeroInDispaly(false);
        FMClientHelper.setNumberFormat((KDTable)this.kdtEntries, (String)"price", (String)currencyId);
        FMClientHelper.setNumberFormat((KDTable)this.kdtEntries, (String)"rebate", (String)currencyId);
        FMClientHelper.setNumberFormat((KDTable)this.kdtEntries, (String)"amount", (String)currencyId);
    }

    @Override
    protected void comboAsstActType_actionPerformed(ActionEvent e) throws Exception {
        super.comboAsstActType_actionPerformed(e);
    }

    @Override
    protected void prmtAsstAct_willShow(SelectorEvent e) throws Exception {
        super.prmtAsstAct_willShow(e);
        if (this.comboAsstActType.getSelectedItem() == null || !(this.comboAsstActType.getSelectedItem() instanceof AsstActTypeInfo)) {
            return;
        }
        AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)this.comboAsstActType.getSelectedItem();
        RecPayHandler.assignSelector((CoreUIObject)this, this.prmtAsstAct, asstActTypeInfo);
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
        BigDecimal amtSum = RecPayHandler.getEntryAmtSum(this.kdtEntries, "amount");
        this.txtAmtSum.setValue((Object)amtSum);
    }

    @Override
    public void actionCreateFromAsst_actionPerformed(ActionEvent e) throws Exception {
        this.srcObjType = ReceiptFormHandler.SRC_BILL_ASST;
        this.actionCreateFrom_actionPerformed(e);
    }

    @Override
    public void actionCreateFromRec_actionPerformed(ActionEvent e) throws Exception {
        this.srcObjType = ReceiptFormHandler.SRC_BILL_REC;
        this.actionCreateFrom_actionPerformed(e);
    }

    public void actionCreateFrom_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("TargetBillType", "ReceiptForm");
        this.getBillEdit().createFrom(null, map);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.editData.setHasEffected(true);
        super.actionSubmit_actionPerformed(e);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        CurrentInfo info;
        super.verifyInput(e);
        if (this.txtNumber.isEnabled()) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtCompany);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkBizDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDComboBox)this.comboCurrency);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDComboBox)this.comboAsstActType);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtAsstAct);
        if (this.prmtAsstAct.getData() != null && this.prmtAsstAct.getData() instanceof CurrentInfo && ((info = (CurrentInfo)((Object)this.prmtAsstAct.getData())).getId() == null || info.getName() == null)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"379_ReceiptFormEditUI"));
            SysUtil.abort();
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTable)this.kdtEntries);
    }

    @Override
    public void actionBlankOut_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            return;
        }
        String id = this.editData.getId().toString();
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(id);
        ((IReceiptForm)this.getBizInterface()).blankOut(idSet);
        Component component = (Component)e.getSource();
        FMClientHelper.showSuccessInfo((Component)((Object)this), (Component)component);
        this.actionBlankOut.setEnabled(false);
    }

    @Override
    protected String getEditUIName() {
        return ReceiptFormEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return ReceiptFormFactory.getRemoteInstance();
    }

    @Override
    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return new ReceiptFormEntryInfo();
    }

    @Override
    protected IObjectValue createNewData() {
        ReceiptFormInfo objectValue = new ReceiptFormInfo();
        objectValue.setCompany(this.companyInfo);
        objectValue.setCreator(this.user);
        return objectValue;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("asstActID"));
        sic.add(new SelectorItemInfo("asstActName"));
        sic.add(new SelectorItemInfo("asstActType.*"));
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    public int getBtpCreateFromType() {
        return 1;
    }

    public List getSrcBosTypeForBotp(List srcBosTypeList) {
        srcBosTypeList = new ArrayList<String>();
        srcBosTypeList.add(this.srcObjType.toString());
        return srcBosTypeList;
    }

    @Override
    protected void setAutoNumberByOrg(String orgType) {
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(this.editData.getId().toString());
        if (idList == null || idList.size() == 0) {
            return;
        }
        ReceiptFormDataProvider data = new ReceiptFormDataProvider(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print(RECEIPTFORM_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(this.editData.getId().toString());
        if (idList == null || idList.size() == 0) {
            return;
        }
        ReceiptFormDataProvider data = new ReceiptFormDataProvider(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview(RECEIPTFORM_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }
}

