/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CashManagementFactory;
import com.kingdee.eas.fi.cas.client.AbstractRptCapitalSumFilterUI;
import com.kingdee.eas.fi.cas.client.CashClientHelper;
import com.kingdee.eas.fi.cas.client.JournalHandler;
import com.kingdee.eas.fi.cas.client.PeriodHelper;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.INewCompanyF7UsedAble;
import com.kingdee.eas.fm.common.client.NewCompanyF7Substitute;
import com.kingdee.eas.fm.common.util.RptFmClientUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.RptConditionManager;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.SpinnerUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class RptCapitalSumFilterUI
extends AbstractRptCapitalSumFilterUI
implements RptFmClientUtil.SelectCompanyListener {
    private static final Logger logger = CoreUIObject.getLogger(RptCapitalSumFilterUI.class);
    public static final String RESOURCEPATH = "com.kingdee.eas.fi.cas.client.CashMgtResource";
    public CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private CurrencyInfo localCcurrency = ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(this.currentCompany);
    private Set bankIdSet = null;
    private Set accountPropertyIdSet = null;
    private String actualAcctTableId = null;
    private boolean isHideNoDataAcct = false;
    private boolean isShowCancelUs = true;
    private boolean flag = false;

    @Override
    protected void btnByPeriod_stateChanged(ChangeEvent e) throws Exception {
        this.pnlByDate.setVisible(false);
        this.pnlByPeriod.setVisible(false);
        if (this.btnByPeriod.isSelected()) {
            this.pnlByPeriod.setVisible(true);
        } else {
            this.pnlByDate.setVisible(true);
        }
    }

    public RptCapitalSumFilterUI() throws Exception {
        try {
            PeriodEntity pe = JournalHandler.requestPeriodEntity(this.currentCompany);
            SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.spiBeginYear, (KDSpinner)this.spiBeginMonth, (KDSpinner)this.spiEndYear, (KDSpinner)this.spiEndMonth, (boolean)false, (boolean)false);
        }
        catch (Exception e) {
            SpinnerUtil.manageAccountLevelRange((int)1970, (int)2990, (KDSpinner)this.spiBeginYear, (KDSpinner)this.spiEndYear);
            SpinnerUtil.manageAccountLevelRange((int)1, (int)12, (KDSpinner)this.spiBeginMonth, (KDSpinner)this.spiEndMonth);
        }
        SpinnerNumberModel spmodel = new SpinnerNumberModel(1, 1, 99, 1);
        this.txtSmallLimitAmt.setHorizontalAlignment(4);
        this.txtSmallLimitAmt.setPrecision(2);
        this.spiLevel.setModel((SpinnerModel)spmodel);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.spiBeginYear.requestFocus();
    }

    public void onInit(RptParams initParams) throws Exception {
        super.onInit(initParams);
        PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.currentCompany);
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            PeriodEntity pe = new PeriodEntity(CashManagementFactory.getRemoteInstance().getPeriodRange(this.currentCompany, SystemEnum.CASHMANAGEMENT));
            SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.spiBeginYear, (KDSpinner)this.spiBeginMonth, (KDSpinner)this.spiEndYear, (KDSpinner)this.spiEndMonth, (boolean)false, (boolean)false);
        } else if (EmptyUtil.isEmpty((CoreBaseInfo)periodInfo)) {
            periodInfo = PeriodUtils.getPeriodInfo(null, (Date)new Date(), (CompanyOrgUnitInfo)this.currentCompany);
        }
        this.spiBeginYear.setValue((Object)new Integer(periodInfo.getPeriodYear()));
        this.spiBeginMonth.setValue((Object)new Integer(periodInfo.getPeriodNumber()));
        this.spiEndYear.setValue((Object)new Integer(periodInfo.getPeriodYear()));
        this.spiEndMonth.setValue((Object)new Integer(periodInfo.getPeriodNumber()));
    }

    public void clear() {
        super.clear();
        SpinnerNumberModel spmodel = new SpinnerNumberModel(1, 1, 99, 1);
        this.txtSmallLimitAmt.setHorizontalAlignment(4);
        this.txtSmallLimitAmt.setPrecision(2);
        this.spiLevel.setModel((SpinnerModel)spmodel);
        this.jtAmountUnit.setSelectedItem((Object)AmountUnitEnum.yuan);
        this.chkIncudeCash.setSelected(false);
        this.jrbCompany.setSelected(true);
        this.jrbBank.setSelected(false);
        FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)this.localCcurrency);
        this.prmtAccountProperty.setValue(null);
        this.jbpBank.setValue(null);
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            this.lblLevel.setVisible(false);
        }
        this.btnByPeriod.setSelected(true);
        this.txtSmallLimitAmt.setValue(null);
        this.dtpFromDate.setValue((Object)DateHelper.getDayBegin());
        this.dtpToDate.setValue((Object)DateHelper.getDayBegin());
        this.chkHideNoDataAccount.setSelected(false);
        this.isShowCancelUser.setSelected(false);
    }

    public boolean verify() {
        this.flag = this.jrbAccount.isSelected() || this.jrbCompanyAcct.isSelected() || this.jrbComProAcct.isSelected() || this.jrbProAcct.isSelected() || this.jrbProComAcct.isSelected();
        if (this.btnByDate.isSelected()) {
            boolean rst = super.verify();
            CashClientHelper.verifyEmpty((CoreUIObject)this, RESOURCEPATH, this.dtpToDate, "cm63");
            CashClientHelper.verifyEmpty((CoreUIObject)this, RESOURCEPATH, this.dtpFromDate, "cm63");
            if (DateTimeUtils.truncateDate((Date)this.dtpToDate.getSqlDate()).before(DateTimeUtils.truncateDate((Date)this.dtpFromDate.getSqlDate()))) {
                this.dtpFromDate.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCEPATH, (String)"EndDateBeforeBeginDate"));
                SysUtil.abort();
            }
            Date beginDate = DateTimeUtils.truncateDate((Date)this.dtpFromDate.getSqlDate());
            Date endDate = DateTimeUtils.truncateDate((Date)this.dtpToDate.getSqlDate());
            this.actualAcctTableId = FMClientHelper.getActualAcctTable((Date)beginDate, (Date)endDate);
            try {
                PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.currentCompany);
                if (startPeriod != null && startPeriod.getBeginDate().compareTo(DateTimeUtils.truncateDate((Date)this.dtpFromDate.getSqlDate())) > 0) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCEPATH, (String)"EndDateBeforeStartDate"));
                    SysUtil.abort();
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            return rst;
        }
        boolean rst = super.verify();
        if (rst) {
            // empty if block
        }
        int beginYear = AccessHelper.getSpiValue((KDSpinner)this.spiBeginYear);
        int beginMonth = AccessHelper.getSpiValue((KDSpinner)this.spiBeginMonth);
        int endYear = AccessHelper.getSpiValue((KDSpinner)this.spiEndYear);
        int endMonth = AccessHelper.getSpiValue((KDSpinner)this.spiEndMonth);
        this.actualAcctTableId = FMClientHelper.getActualAcctTable((int)beginYear, (int)beginMonth, (int)endYear, (int)endMonth);
        return rst;
    }

    public boolean verifyBeginPerid(Set companySet, int serial) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ss.fcompanyid ");
        sb.append(" FROM t_bd_systemstatusctrol ss, t_bd_period sp, t_bd_period cp");
        sb.append(" WHERE ss.fstartperiodid = sp.fid AND ss.fcurrentperiodid = cp.fid");
        sb.append(" and ss.FSYSTEMSTATUSID in (select fid from t_bd_systemstatus  where fname =7)");
        sb.append(" and ( sp.FPERIODYEAR*100 + sp.FPERIODNUMBER>" + serial);
        sb.append(" or  cp.FPERIODYEAR*100 + cp.FPERIODNUMBER <" + serial);
        sb.append(") and ss.fisstart=1");
        sb.append(" and ");
        sb.append(FMHelper.buildIn((String)"ss.fcompanyid", (Object[])companySet.toArray()));
        ISQLExecutor sql = SQLExecutorFactory.getRemoteInstance((String)sb.toString());
        try {
            IRowSet rs = sql.executeSQL();
            if (rs.next()) {
                CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(rs.getString(1)));
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"384_RptCapitalSumFilterUI", (Object[])new Object[]{company.getName()}));
                SysUtil.abort();
                return true;
            }
        }
        catch (BOSException e) {
            SysUtil.abort((Throwable)e);
        }
        catch (SQLException e) {
            SysUtil.abort((Throwable)e);
        }
        catch (EASBizException e) {
            SysUtil.abort((Throwable)e);
        }
        return false;
    }

    public RptParams getCustomCondition() {
        RptConditionManager rm = new RptConditionManager();
        rm.recordAllStatus((Container)((Object)this));
        rm.setProperty("companyIdSet", (Object)this.companyIdSet);
        this.bankIdSet = AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.jbpBank));
        rm.setProperty("bankIdSet", (Object)this.bankIdSet);
        this.accountPropertyIdSet = AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtAccountProperty));
        rm.setProperty("accountPropertyIdSet", (Object)this.accountPropertyIdSet);
        rm.setProperty("txtSmallLimitAmt.numberValue", (Object)this.txtSmallLimitAmt.getNumberValue());
        rm.setProperty("actualAcctTableId", (Object)this.actualAcctTableId);
        rm.setProperty("dtpFromDate.value", this.dtpFromDate.getValue());
        rm.setProperty("dtpToDate.value", this.dtpToDate.getValue());
        rm.setProperty("isByDay", (Object)this.btnByDate.isSelected());
        rm.setProperty("jtAmountUnit.value", this.jtAmountUnit.getSelectedItem());
        this.isHideNoDataAcct = this.chkHideNoDataAccount.isSelected();
        rm.setProperty("isHideNoDataAcct", (Object)this.isHideNoDataAcct);
        this.isShowCancelUs = this.isShowCancelUser.isSelected();
        rm.setProperty("isShowCancelUs", (Object)this.isShowCancelUs);
        CompanyOrgUnitInfo curCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (this.btnByDate.isSelected()) {
            PeriodInfo beginPeriodInfo = null;
            try {
                beginPeriodInfo = PeriodHelper.getPeriodInfo((Date)this.dtpFromDate.getValue(), curCompany);
                rm.setProperty("beginPeriodInfo", (Object)beginPeriodInfo);
                HashSet<String> periodInfos = new HashSet<String>();
                if (this.companyIdSet != null && this.companyIdSet.size() > 0) {
                    for (String companyId : this.companyIdSet) {
                        PeriodInfo periodInfo;
                        ObjectUuidPK chCompanyPk = new ObjectUuidPK(companyId);
                        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)chCompanyPk);
                        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
                        if (startPeriod == null || (periodInfo = PeriodHelper.getPeriodInfo((Date)this.dtpFromDate.getValue(), company)) == null) continue;
                        periodInfos.add(periodInfo.getId().toString());
                    }
                    if (EmptyUtil.isEmpty(periodInfos)) {
                        MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"402_RptCapitalSumFilterUI"));
                        SysUtil.abort();
                    }
                } else {
                    periodInfos.add(beginPeriodInfo.getId().toString());
                }
                rm.setProperty("periodInfos", periodInfos);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        this.flag = true;
        boolean isBizUnit = curCompany.isIsBizUnit();
        if (!isBizUnit) {
            this.flag = this.jrbAccount.isSelected() || this.jrbCompanyAcct.isSelected() || this.jrbComProAcct.isSelected() || this.jrbProAcct.isSelected() || this.jrbProComAcct.isSelected();
        }
        rm.setProperty("isIncludeAccount", (Object)this.flag);
        return rm.toRptParams();
    }

    public void setCustomCondition(RptParams params) {
        RptConditionManager rm = new RptConditionManager(params);
        rm.restoreAllStatus((Container)((Object)this));
        this.companyIdSet = (Set)params.getObject("companyIdSet");
        this.spiBeginYear.setValue(params.getObjectElement("spiBeginYear.value"));
        this.spiBeginMonth.setValue(params.getObjectElement("spiBeginMonth.value"));
        this.spiEndYear.setValue(params.getObjectElement("spiEndYear.value"));
        this.spiEndMonth.setValue(params.getObjectElement("spiEndMonth.value"));
        this.dtpFromDate.setValue(params.getObjectElement("dtpFromDate.value"));
        this.dtpToDate.setValue(params.getObjectElement("dtpToDate.value"));
        this.btnByDate.setSelected(((Boolean)params.getObject("isByDay")).booleanValue());
        this.jtAmountUnit.setSelectedItem(params.getObject("jtAmountUnit.value"));
        if (params.getObject("isHideNoDataAcct") != null) {
            this.isHideNoDataAcct = (Boolean)params.getObject("isHideNoDataAcct");
        }
        if (params.getObject("isShowCancelUs") != null) {
            this.isShowCancelUs = (Boolean)params.getObject("isShowCancelUs");
        }
        this.isShowCancelUser.setSelected(this.isShowCancelUs);
        if (this.jtAmountUnit.getSelectedItem() == null) {
            this.jtAmountUnit.setSelectedItem((Object)AmountUnitEnum.yuan);
        }
        try {
            this.bankIdSet = (Set)params.getObject("bankIdSet");
            CoreBaseInfo[] c = RptFmClientUtil.getBaseInfoFromIdSet((Set)this.bankIdSet);
            this.jbpBank.setData((Object)c);
            this.accountPropertyIdSet = (Set)params.getObject("accountPropertyIdSet");
            CoreBaseInfo[] c2 = RptFmClientUtil.getBaseInfoFromIdSet((Set)this.accountPropertyIdSet);
            this.prmtAccountProperty.setData((Object)c2);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    protected void jrbBank_actionPerformed(ActionEvent e) throws Exception {
        super.jrbBank_actionPerformed(e);
        this.doGroupBy();
    }

    protected void btnCompanySelect_actionPerformed(ActionEvent e) throws Exception {
        NewCompanyF7Substitute newCompanyF7 = new NewCompanyF7Substitute((INewCompanyF7UsedAble)this, this.getNewCompanyF7());
        newCompanyF7.showAndSaveSelected();
        this.doGroupBy();
    }

    protected NewCompanyF7 getNewCompanyF7() {
        return this.getSubPermissionCompanyOrg();
    }

    private void doGroupBy() throws Exception {
        SpinnerNumberModel model = (SpinnerNumberModel)this.spiLevel.getModel();
        if (this.jrbBank.isSelected()) {
            this.lblLevel.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"385_RptCapitalSumFilterUI"));
            StringBuffer sb = new StringBuffer();
            sb.append("select max(flevel) flevel from t_org_company where 1=1 ");
            if (this.companyIdSet != null && this.companyIdSet.size() > 0) {
                sb.append(" and ");
                sb.append(FMHelper.buildIn((String)"fid", (Object[])this.companyIdSet.toArray()));
                IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sb.toString()).executeSQL();
                if (rs.next()) {
                    model.setMaximum(new Integer(rs.getInt(1)));
                }
            } else {
                model.setMaximum(new Integer(99));
            }
        } else if (this.jrbCompany.isSelected()) {
            this.lblLevel.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"386_RptCapitalSumFilterUI"));
            StringBuffer sb = new StringBuffer();
            sb.append("select max(flevel) flevel from t_bd_bank where 1=1 ");
            this.bankIdSet = AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.jbpBank));
            if (this.bankIdSet != null && this.bankIdSet.size() > 0) {
                sb.append(" and ");
                sb.append(FMHelper.buildIn((String)"fid", (Object[])this.bankIdSet.toArray()));
                IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sb.toString()).executeSQL();
                if (rs.next()) {
                    model.setMaximum(new Integer(rs.getInt(1)));
                }
            } else {
                model.setMaximum(new Integer(99));
            }
        } else if (this.jrbAccountProperty.isSelected()) {
            this.lblLevel.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"385_RptCapitalSumFilterUI"));
            StringBuffer sb = new StringBuffer();
            sb.append("select max(flevel) flevel from t_org_company where 1=1 ");
            if (this.companyIdSet != null && this.companyIdSet.size() > 0) {
                sb.append(" and ");
                sb.append(FMHelper.buildIn((String)"fid", (Object[])this.companyIdSet.toArray()));
                IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sb.toString()).executeSQL();
                if (rs.next()) {
                    model.setMaximum(new Integer(rs.getInt(1)));
                }
            } else {
                model.setMaximum(new Integer(99));
            }
        } else if (this.jrbCompanyAcct.isSelected()) {
            this.lblLevel.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"386_RptCapitalSumFilterUI"));
            StringBuffer sb = new StringBuffer();
            sb.append("select max(flevel) flevel from t_bd_bank where 1=1 ");
            this.bankIdSet = AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.jbpBank));
            if (this.bankIdSet != null && this.bankIdSet.size() > 0) {
                sb.append(" and ");
                sb.append(FMHelper.buildIn((String)"fid", (Object[])this.bankIdSet.toArray()));
                IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sb.toString()).executeSQL();
                if (rs.next()) {
                    model.setMaximum(new Integer(rs.getInt(1)));
                }
            } else {
                model.setMaximum(new Integer(99));
            }
        } else {
            this.lblLevel.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"386_RptCapitalSumFilterUI"));
            StringBuffer sb = new StringBuffer();
            sb.append("select max(flevel) flevel from t_bd_bank where 1=1 ");
            this.bankIdSet = AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.jbpBank));
            if (this.bankIdSet != null && this.bankIdSet.size() > 0) {
                sb.append(" and ");
                sb.append(FMHelper.buildIn((String)"fid", (Object[])this.bankIdSet.toArray()));
                IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sb.toString()).executeSQL();
                if (rs.next()) {
                    model.setMaximum(new Integer(rs.getInt(1)));
                }
            } else {
                model.setMaximum(new Integer(99));
            }
        }
        if (model.getMaximum().compareTo(model.getValue()) < 0) {
            model.setValue(model.getMaximum());
        }
    }

    @Override
    protected void jrbCompany_actionPerformed(ActionEvent e) throws Exception {
        super.jrbCompany_actionPerformed(e);
        this.doGroupBy();
    }

    @Override
    protected void jbpBank_dataChanged(DataChangeEvent e) throws Exception {
        super.jbpBank_dataChanged(e);
        this.doGroupBy();
    }

    @Override
    protected void txtSmallLimitAmt_dataChanged(DataChangeEvent e) throws Exception {
        super.txtSmallLimitAmt_dataChanged(e);
    }

    @Override
    protected void txtSmallLimitAmt_mouseClicked(MouseEvent e) throws Exception {
        super.txtSmallLimitAmt_mouseClicked(e);
    }

    @Override
    protected void txtSmallLimitAmt_mouseMoved(MouseEvent e) throws Exception {
        super.txtSmallLimitAmt_mouseMoved(e);
    }

    @Override
    protected void txtSmallLimitAmt_mousePressed(MouseEvent e) throws Exception {
        super.txtSmallLimitAmt_mousePressed(e);
    }

    @Override
    protected void txtSmallLimitAmt_focusLost(FocusEvent e) throws Exception {
        super.txtSmallLimitAmt_focusLost(e);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        FMClientHelper.initComboCurrency((KDComboBox)this.cboCurrency, (boolean)true);
        FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)this.localCcurrency);
        this.jtAmountUnit.setSelectedItem((Object)AmountUnitEnum.yuan);
        F7SelectorFactory.initBankTree((IUIObject)this, (KDBizPromptBox)this.jbpBank);
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            this.lblLevel.setVisible(false);
            this.jrbCompanyAcct.setVisible(false);
            this.jrbProComAcct.setVisible(false);
            this.jrbProAcct.setVisible(false);
            this.jrbComProAcct.setVisible(false);
        }
        this.txtSmallLimitAmt.setHorizontalAlignment(4);
        this.txtSmallLimitAmt.setRemoveingZeroInDispaly(false);
        this.txtSmallLimitAmt.setImmediatelyValidate(true);
        this.txtSmallLimitAmt.setSupportedEmpty(true);
    }

    @Override
    protected void jrbAccountProperty_actionPerformed(ActionEvent e) throws Exception {
        super.jrbAccountProperty_actionPerformed(e);
        this.doGroupBy();
    }

    @Override
    protected void jrbCompanyAcct_actionPerformed(ActionEvent e) throws Exception {
        super.jrbCompanyAcct_actionPerformed(e);
        this.doGroupBy();
    }

    @Override
    protected void jrbProAcct_actionPerformed(ActionEvent e) throws Exception {
        super.jrbProAcct_actionPerformed(e);
        this.doGroupBy();
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            this.kDPanel1.setBounds(new Rectangle(10, 205, 350, 40));
            this.chkIncudeCash.setBounds(new Rectangle(13, 250, 150, 19));
            this.chkHideNoDataAccount.setBounds(new Rectangle(170, 250, 150, 19));
            this.isShowCancelUser.setBounds(new Rectangle(346, 250, 140, 19));
        } else {
            this.kDPanel1.setBounds(new Rectangle(10, 205, 533, 92));
        }
    }
}

