/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.CapitalSumFacadeFactory;
import com.kingdee.eas.fi.cas.InnerCashFacadeFactory;
import com.kingdee.eas.fi.cas.RptCapitalSumFacadeFactory;
import com.kingdee.eas.fi.cas.client.AbstractRptCapitalSumMainUI;
import com.kingdee.eas.fi.cas.client.CapitalSubLegerFilterParam;
import com.kingdee.eas.fi.cas.client.CapitalSubLegerUI;
import com.kingdee.eas.fi.cas.client.RptCapitalSumFilterUI;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.FMLoginModel;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.bireport.IBireportBaseFacade;
import com.kingdee.eas.framework.bireport.client.BireportBaseFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class RptCapitalSumMainUI
extends AbstractRptCapitalSumMainUI {
    private static final Logger logger = CoreUIObject.getLogger(RptCapitalSumMainUI.class);
    public static final String resourcePath = "com.kingdee.eas.fi.cas.client.CapitalSubLedgerResource";

    public void checkPeriodNull() throws Exception {
        CompanyOrgUnitInfo curCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)curCompany);
        if (curCompany.isIsBizUnit() && startPeriod == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"StartPeriod_NullMsg"));
            SysUtil.abort();
        }
    }

    public void onLoad() throws Exception {
        boolean flag;
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)company) && !(flag = SystemStatusCtrolUtils.isStart(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company))) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"CasNoInit"));
            SysUtil.abort();
        }
        this.checkPeriodNull();
        this.actionJoinQuery.setVisible(true);
        this.actionJoinQuery.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        super.onLoad();
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
    }

    protected BireportBaseFilterUI getQueryDialogUserPanel() throws Exception {
        return new RptCapitalSumFilterUI();
    }

    protected IBireportBaseFacade getRemoteInstance() throws BOSException {
        return RptCapitalSumFacadeFactory.getRemoteInstance();
    }

    protected void onBeforeQuery() throws Exception {
        if (EmptyUtil.isEmpty((Object)this.params.getObject("actualAcctTableId"))) {
            // empty if block
        }
        boolean isByDay = (Boolean)this.params.getObject("isByDay");
        String txtPeriodRange = "";
        if (isByDay) {
            txtPeriodRange = Constants.FORMAT_DAY.format((Date)this.params.getObjectElement("dtpFromDate.value")) + " ~ " + Constants.FORMAT_DAY.format((Date)this.params.getObjectElement("dtpToDate.value"));
        } else {
            Object[] args = new String[]{String.valueOf(this.params.getObjectElement("spiBeginYear.value")), String.valueOf(this.params.getObjectElement("spiBeginMonth.value")), String.valueOf(this.params.getObjectElement("spiEndYear.value")), String.valueOf(this.params.getObjectElement("spiEndMonth.value"))};
            txtPeriodRange = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"LBL_PeriodRange"), args);
        }
        this.txtPeriodRange.setText(txtPeriodRange);
        this.txtCurrency.setText(this.params.getObjectElement("cboCurrency.value").toString());
        this.txtUnit.setText(this.params.getObjectElement("jtAmountUnit.value").toString());
        this.setMeasurePrecision(2);
    }

    protected void onAfterQuery() throws Exception {
        this.kDTable1.exchangeColumn(1, 4);
        this.kDTable1.repaint();
        boolean isIncludeAccount = (Boolean)this.params.getObject("isIncludeAccount");
        this.actionJoinQuery.setEnabled(isIncludeAccount);
        String jrbAccount = String.valueOf(this.params.getObjectElement("jrbAccount.value"));
        String jrbCompanyAcct = String.valueOf(this.params.getObjectElement("jrbCompanyAcct.value"));
        String jrbProAcct = String.valueOf(this.params.getObjectElement("jrbProAcct.value"));
        if ("true".equals(jrbAccount)) {
            this.kDTable1.getColumn(2).getStyleAttributes().setNumberFormat("@");
        } else if ("true".equals(jrbCompanyAcct) || "true".equals(jrbProAcct)) {
            this.kDTable1.getColumn(3).getStyleAttributes().setNumberFormat("@");
        } else {
            this.kDTable1.getColumn(3).getStyleAttributes().setNumberFormat("@");
            this.kDTable1.getColumn(4).getStyleAttributes().setNumberFormat("@");
        }
    }

    protected KDTable getTableForPrintSetting() {
        return this.kDTable1;
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer sb = new StringBuffer();
        sb.append(this.lblPeriodRange.getBoundLabelText()).append("&[PeriodRange]&|").append(this.lblCurrency.getBoundLabelText()).append("&[Currency]&| ").append(this.lblUnit.getBoundLabelText()).append("&[AmountUnit]");
        header.addRow(sb.toString(), sa);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Company", SysContext.getSysContext().getCurrentFIUnit().getName());
        map.put("AmountUnit", this.txtUnit.getText());
        map.put("PeriodRange", this.txtPeriodRange.getText());
        map.put("Currency", this.txtCurrency.getText());
        return map;
    }

    public static Object getKey(Member[] ms, String name) {
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        for (int i = 0; i < ms.length; ++i) {
            if (!ms[i].getDimension().getName().equalsIgnoreCase(name)) continue;
            return ms[i].getKey();
        }
        return null;
    }

    public void actionJoinQuery_actionPerformed(ActionEvent e) throws Exception {
        Date perDate;
        String dateString;
        boolean query4day = false;
        CapitalSubLegerFilterParam param = new CapitalSubLegerFilterParam();
        Member[] ms = this.getSelectedDataCellItemInfo();
        if (ms == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"InValiadLine"));
            return;
        }
        for (int i = 0; i < ms.length; ++i) {
            if (!EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"387_RptCapitalSumMainUI").equals(ms[i].getName()) && !EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"388_RptCapitalSumMainUI").equals(ms[i].getName())) continue;
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"InValiadLine"));
            return;
        }
        this.getUIContext().put("companyIds", this.params.getObject("companyIdSet"));
        Object com = RptCapitalSumMainUI.getKey(ms, "Company");
        Object per = RptCapitalSumMainUI.getKey(ms, "Period");
        if (per == null && this.txtPeriodRange.getText() != null && this.txtPeriodRange.getText().length() > 0) {
            query4day = true;
        }
        Object acctB = RptCapitalSumMainUI.getKey(ms, "Bank");
        Object acctV = RptCapitalSumMainUI.getKey(ms, "BankAccount");
        Map map = new HashMap<String, String>();
        com = com == null ? "" : com.toString();
        per = per == null ? "" : per.toString();
        acctB = acctB == null ? "" : acctB.toString();
        acctV = acctV == null ? "" : acctV;
        acctV = "0".equals(acctV) ? "0" : acctV.toString();
        Object acctProp = RptCapitalSumMainUI.getKey(ms, "AccountProperty");
        acctProp = acctProp == null ? "0" : acctProp.toString();
        map.put("Company", com.toString());
        map.put("Period", per.toString());
        map.put("Bank", acctB.toString());
        map.put("BankAccount", acctV.toString());
        map.put("AccountProperty", acctProp.toString());
        map = CapitalSumFacadeFactory.getRemoteInstance().fetchData(map);
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)map.get("Company");
        if (company == null) {
            company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        }
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)company)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"NotOnlyUnionMsg"));
            SysUtil.abort();
            return;
        }
        param.setCompanyIds(new String[]{company.getId().toString()});
        PeriodInfo period = null;
        if (per != null && per.toString().length() > 0) {
            period = map.get("Period") == null ? PeriodFactory.getRemoteInstance().getPeriodInfo((IObjectPK)new ObjectUuidPK(per.toString())) : (PeriodInfo)map.get("Period");
        } else {
            dateString = this.txtPeriodRange.getText().substring(0, this.txtPeriodRange.getText().indexOf(" ~"));
            perDate = Constants.FORMAT_MONTH.parse(dateString);
            period = PeriodUtils.getPeriodInfo((Date)perDate, (CompanyOrgUnitInfo)company);
        }
        if (period == null) {
            period = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        }
        param.setPeriodId(period.getId().toString());
        param.setBeginYear(period.getPeriodYear());
        param.setBeginMonth(period.getPeriodNumber());
        if (query4day) {
            dateString = this.txtPeriodRange.getText().substring(this.txtPeriodRange.getText().indexOf(" ~") + 2, this.txtPeriodRange.getText().length());
            perDate = Constants.FORMAT_MONTH.parse(dateString);
            period = PeriodUtils.getPeriodInfo((Date)perDate, (CompanyOrgUnitInfo)company);
            param.setEndYear(period.getPeriodYear());
            param.setEndMonth(period.getPeriodNumber());
        } else {
            param.setEndYear(period.getPeriodYear());
            param.setEndMonth(period.getPeriodNumber());
        }
        String acctTableID = InnerCashFacadeFactory.getRemoteInstance().getActualAcctTableID(company.getId().toString(), param.getBeginYear(), param.getBeginMonth(), param.getEndYear(), param.getEndMonth());
        param.setAcctTableId(acctTableID);
        param.setIncludeUnSettBill(true);
        param.setFromDate(period.getBeginDate());
        param.setToDate(period.getEndDate());
        Object currency = FMSysDefinedEnum.SELECT_ALL;
        currency = this.params.getObjectElement("cboCurrency.value");
        AccountBankInfo acctBank = null;
        if (map.get("acctBank") == null) {
            if (acctV != null && !acctV.toString().trim().equals("0") && !acctV.toString().trim().equals("")) {
                acctBank = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(acctV.toString()));
            }
        } else {
            acctBank = (AccountBankInfo)map.get("acctBank");
        }
        if ((acctB = acctBank != null && acctBank.getBank() != null ? acctBank.getBank().getId().toString() : null) == null) {
            acctB = "00";
        }
        AccountViewInfo acct = null;
        if (map.get("acctBank") == null) {
            AccountBankCollection acctC;
            EntityViewInfo view;
            FilterInfo filter;
            boolean bankHasAcctBank = false;
            if (acctBank == null && acctB != null && !acctB.toString().trim().equals("00") && !acctB.toString().trim().equals("0")) {
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("bank.id", acctB));
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
                view = new EntityViewInfo();
                view.setFilter(filter);
                acctC = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
                if (acctC != null && acctC.size() > 0) {
                    acctBank = acctC.get(0);
                    acct = acctBank.getAccount();
                    bankHasAcctBank = true;
                }
            }
            if (acctBank == null) {
                acct = null;
            }
            if (("0".equals(acctB.toString().trim()) || !bankHasAcctBank) && acctV == null) {
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
                view = new EntityViewInfo();
                view.setFilter(filter);
                acctC = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
                if (acctC != null && acctC.size() > 0) {
                    acctBank = acctC.get(0);
                }
            }
            if ("00".equals(acctB.toString().trim())) {
                acctBank = null;
            }
        } else {
            acct = (AccountViewInfo)map.get("acct");
        }
        CapitalSubLegerUI.showCapitalSubUI((IUIObject)this, param, currency, acctBank, acct);
    }

    public static void main(String[] args) {
        FMLoginModel.newInstance().login("user", "", "eas", "ykport0828");
        FMLoginModel.newInstance().loginMain(RptCapitalSumMainUI.class.getName());
    }

    protected boolean isAutoMergeRowHead() {
        return false;
    }

    protected boolean isAutoMergeColumnHead() {
        return false;
    }

    protected boolean enableTablePreferences() {
        return true;
    }
}

