/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.bc.IOperationTypeCompanyEntry;
import com.kingdee.eas.cp.bc.OperationTypeCompanyEntryFactory;
import com.kingdee.eas.cp.bc.client.ExpenseTypeF7UI;
import com.kingdee.eas.cp.bc.util.OperationTypeUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class SpecialExpenseTypeF7UI
extends ExpenseTypeF7UI {
    public FilterInfo getCommonFilter() {
        FilterInfo filter = super.getCommonFilter();
        try {
            filter.mergeFilter(this.entityViewInfo.getFilter(), "and");
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return filter;
    }

    protected void buildTreeFilter() {
        FilterInfo filterInfo = this.getDefaultFilterForQuery();
        this.mainQuery.setFilter(filterInfo);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = super.getDefaultFilterForQuery();
        try {
            String billType = (String)super.getUIContext().get("Type");
            if ("PaymentBill".equals(billType) || "ReceivingBill".equals(billType)) {
                if (this.entityViewInfo.getFilter().getFilterItems().size() == 7) {
                    this.entityViewInfo.getFilter().getFilterItems().add(new FilterItemInfo("cu.id", (Object)((String)super.getUIContext().get("parentId"))));
                    this.entityViewInfo.getFilter().setMaskString("#0 and #1 and #2 and (#3 or #4 or #5 or #6 or #7)");
                }
            } else if ("AgentPayBill".equals(billType) && this.entityViewInfo.getFilter().getFilterItems().size() == 5) {
                this.entityViewInfo.getFilter().getFilterItems().add(new FilterItemInfo("cu.id", (Object)((String)super.getUIContext().get("parentId"))));
                this.entityViewInfo.getFilter().setMaskString("#0 and (#1 or #2 or #3 or #4 or #5)");
            }
            filter.mergeFilter(this.entityViewInfo.getFilter(), "and");
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return filter;
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.mainQuery.setFilter(this.getCommonFilter());
        KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        FilterInfo filterInfo = new FilterInfo();
        if (treeNode == null) {
            return;
        }
        filterInfo = this.getCommonFilter();
        if (!treeNode.isRoot()) {
            FilterInfo tempFilter = new FilterInfo();
            tempFilter.getFilterItems().add(new FilterItemInfo("operationType.id", (Object)((CoreBaseInfo)treeNode.getUserObject()).getId().toString()));
            try {
                filterInfo.mergeFilter(tempFilter, "and");
            }
            catch (BOSException ex) {
                ex.printStackTrace();
            }
        }
        this.mainQuery.setFilter(filterInfo);
        this.execQuery();
    }

    public FilterInfo getTreeFilterForQuery() {
        String companyId = (String)super.getUIContext().get("companyId");
        String companyLongNumber = (String)super.getUIContext().get("companyLongNumber");
        if (companyId == null && SysContext.getSysContext().getCurrentFIUnit() != null) {
            companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
            companyLongNumber = SysContext.getSysContext().getCurrentFIUnit().getLongNumber();
        }
        FilterInfo filter = super.getTreeFilterForQuery();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter1 = new FilterInfo();
        String ln = companyLongNumber;
        String[] lnSecs = ln.split("!");
        Set operationIdSet = new HashSet();
        try {
            operationIdSet = OperationTypeUtil.getOperationTypeIdsByCompanyMapp((IOperationTypeCompanyEntry)OperationTypeCompanyEntryFactory.getRemoteInstance(), (String)companyId, Arrays.asList(lnSecs));
            if (operationIdSet != null && operationIdSet.size() > 0) {
                filter1.getFilterItems().add(new FilterItemInfo("id", operationIdSet, CompareType.NOTINCLUDE));
            }
            filter.mergeFilter(filter1, "and");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return filter;
    }
}

