/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fi.cas.client.BookNotifyClientHelper;
import com.kingdee.eas.fi.cas.client.VoucherBookNotifyUI;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class VoucherBookNotifyByEntryUI
extends VoucherBookNotifyUI {
    private static Logger logger = Logger.getLogger((String)VoucherBookNotifyByEntryUI.class.getName());
    VoucherEntryInfo entryInfo = null;
    private VoucherInfo voucherInfo = null;

    @Override
    protected void autoBalance(KDTable table) {
        Object val;
        int i;
        int colIndex = table.getSelectManager().getActiveColumnIndex();
        int rowIndex = table.getSelectManager().getActiveRowIndex();
        VoucherEntryInfo entryInfo = null;
        try {
            entryInfo = this.getEntryInfo();
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        if (entryInfo == null) {
            return;
        }
        BigDecimal tempDebitAmount = CasConstants.ZERO;
        BigDecimal tempCreditAmount = CasConstants.ZERO;
        if (entryInfo.getAccount().isIsBank() || entryInfo.getAccount().isIsCash()) {
            if (entryInfo.getEntryDC().equals((Object)EntryDC.DEBIT)) {
                tempDebitAmount = tempDebitAmount.add(entryInfo.getOriginalAmount());
            } else {
                tempCreditAmount = tempCreditAmount.add(entryInfo.getOriginalAmount());
            }
        }
        for (i = 0; i < this.tblMain.getRowCount(); ++i) {
            val = this.tblMain.getRow(i).getCell("debitAmount").getValue();
            if (val == null || i == rowIndex) continue;
            tempDebitAmount = tempDebitAmount.subtract((BigDecimal)val);
        }
        for (i = 0; i < this.tblMain.getRowCount(); ++i) {
            val = this.tblMain.getRow(i).getCell("creditAmount").getValue();
            if (val == null || i == rowIndex) continue;
            tempCreditAmount = tempCreditAmount.subtract((BigDecimal)val);
        }
        if (colIndex == table.getColumnIndex("creditAmount")) {
            table.getRow(rowIndex).getCell("creditAmount").setValue((Object)tempCreditAmount);
            table.getRow(rowIndex).getCell("debitAmount").setValue(null);
        } else if (colIndex == table.getColumnIndex("debitAmount")) {
            table.getRow(rowIndex).getCell("debitAmount").setValue((Object)tempDebitAmount);
            table.getRow(rowIndex).getCell("creditAmount").setValue(null);
        }
    }

    @Override
    protected void setTableCellEditor() throws Exception {
        BookNotifyClientHelper.setTableCellEditorByDate(this.tblMain, "bizDate");
        BookNotifyClientHelper.setTableCellEditorByEnum(this.tblMain, JournalTypeEnum.class.getName(), "journalType");
        VoucherEntryInfo entryinfo = this.getEntryInfo();
        String status = (String)this.getUIContext().get("status");
        if (!status.equals(OprtState.VIEW)) {
            BookNotifyClientHelper.setTableCellEditorByComboBox(this.tblMain, (IObjectCollection)BookNotifyClientHelper.getAccountBankCollectionByVoucherEntryId(this.getEntryInfo().getId().toString()), "bankAccount");
            CurrencyCollection curColl = new CurrencyCollection();
            curColl.add(entryinfo.getCurrency());
            BookNotifyClientHelper.setTableCellEditorByComboBox(this.tblMain, (IObjectCollection)curColl, "currency");
            BookNotifyClientHelper.setTableCellEditorByComboBox(this.tblMain, (IObjectCollection)BookNotifyClientHelper.getAccountCollectionByVoucherId(entryinfo.getBill().getId().toString()), "oppAccountView");
        }
        String settleTypeF7 = "com.kingdee.eas.basedata.assistant.app.SettlementTypeQuery";
        BookNotifyClientHelper.setTableCellEditorByF7(this.tblMain, settleTypeF7, "settlementType");
        BookNotifyClientHelper.setTableCellEditorByFormattedTextField(this.tblMain, "debitAmount");
        BookNotifyClientHelper.setTableCellEditorByFormattedTextField(this.tblMain, "creditAmount");
    }

    public static JournalCollection showDialogWindowsByEntry(IUIObject ui, String builderName, String id, String status) throws UIException {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"builderName", (Object)builderName);
        uiContext.put((Object)"billId", (Object)id);
        uiContext.put((Object)"status", (Object)status);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(VoucherBookNotifyByEntryUI.class.getName(), (Map)uiContext, null, status);
        uiWindow.show();
        VoucherBookNotifyByEntryUI voucherBookNotifyUI = (VoucherBookNotifyByEntryUI)uiWindow.getUIObject();
        JournalCollection coll = voucherBookNotifyUI.getJournalCollection();
        if (coll != null) {
            for (int i = 0; i < coll.size(); ++i) {
                coll.get(i).setBillType(BillTypeEnum.voucherEntry);
            }
        }
        return coll;
    }

    @Override
    public void checkCurrencyAndAmount() throws Exception {
        BigDecimal journalCashDebit = CasConstants.ZERO;
        BigDecimal journalCashCredit = CasConstants.ZERO;
        BigDecimal journalBankDebit = CasConstants.ZERO;
        BigDecimal journalBankCredit = CasConstants.ZERO;
        BigDecimal voucherCashDebit = CasConstants.ZERO;
        BigDecimal voucherCashCredit = CasConstants.ZERO;
        BigDecimal voucherBankDebit = CasConstants.ZERO;
        BigDecimal voucherBankCredit = CasConstants.ZERO;
        BigDecimal tempDebitAmount = CasConstants.ZERO;
        BigDecimal tempCreditAmount = CasConstants.ZERO;
        IRow row = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            JournalTypeEnum type = (JournalTypeEnum)row.getCell("journalType").getValue();
            if (type.equals((Object)JournalTypeEnum.CASH)) {
                tempDebitAmount = (BigDecimal)row.getCell("debitAmount").getValue();
                tempCreditAmount = (BigDecimal)row.getCell("creditAmount").getValue();
                if (tempDebitAmount == null) {
                    tempDebitAmount = CasConstants.ZERO;
                }
                if (tempCreditAmount == null) {
                    tempCreditAmount = CasConstants.ZERO;
                }
                journalCashDebit = journalCashDebit.add(tempDebitAmount);
                journalCashCredit = journalCashCredit.add(tempCreditAmount);
            }
            if (!type.equals((Object)JournalTypeEnum.BANK)) continue;
            tempDebitAmount = (BigDecimal)row.getCell("debitAmount").getValue();
            tempCreditAmount = (BigDecimal)row.getCell("creditAmount").getValue();
            if (tempDebitAmount == null) {
                tempDebitAmount = CasConstants.ZERO;
            }
            if (tempCreditAmount == null) {
                tempCreditAmount = CasConstants.ZERO;
            }
            journalBankDebit = journalBankDebit.add(tempDebitAmount);
            journalBankCredit = journalBankCredit.add(tempCreditAmount);
        }
        VoucherEntryInfo entryInfo = this.getEntryInfo();
        if (entryInfo.getAccount().isIsCash()) {
            tempDebitAmount = CasConstants.ZERO;
            tempCreditAmount = CasConstants.ZERO;
            if (entryInfo.getEntryDC().equals((Object)EntryDC.CREDIT)) {
                tempCreditAmount = entryInfo.getOriginalAmount();
            }
            if (entryInfo.getEntryDC().equals((Object)EntryDC.DEBIT)) {
                tempDebitAmount = entryInfo.getOriginalAmount();
            }
            voucherCashDebit = voucherCashDebit.add(tempDebitAmount);
            voucherCashCredit = voucherCashCredit.add(tempCreditAmount);
        }
        if (entryInfo.getAccount().isIsBank()) {
            tempDebitAmount = CasConstants.ZERO;
            tempCreditAmount = CasConstants.ZERO;
            if (entryInfo.getEntryDC().equals((Object)EntryDC.CREDIT)) {
                tempCreditAmount = entryInfo.getOriginalAmount();
            }
            if (entryInfo.getEntryDC().equals((Object)EntryDC.DEBIT)) {
                tempDebitAmount = entryInfo.getOriginalAmount();
            }
            voucherBankDebit = voucherBankDebit.add(tempDebitAmount);
            voucherBankCredit = voucherBankCredit.add(tempCreditAmount);
        }
        if (journalCashDebit.compareTo(voucherCashDebit) != 0) {
            MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)this.resourcePath, (String)"CashDebitNotEqual"), journalCashDebit, voucherCashDebit));
            SysUtil.abort();
        }
        if (journalCashCredit.compareTo(voucherCashCredit) != 0) {
            MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)this.resourcePath, (String)"CashCreditNotEqual"), journalCashCredit, voucherCashCredit));
            SysUtil.abort();
        }
        if (journalBankDebit.compareTo(voucherBankDebit) != 0) {
            MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)this.resourcePath, (String)"BankDebitNotEqual"), journalBankDebit, voucherBankDebit));
            SysUtil.abort();
        }
        if (journalBankCredit.compareTo(voucherBankCredit) != 0) {
            MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)this.resourcePath, (String)"BankCreditNotEqual"), journalBankCredit, voucherBankCredit));
            SysUtil.abort();
        }
        this.checkAssiantNew(entryInfo);
        AccountViewInfo account = entryInfo.getAccount();
        for (int k = 0; k < this.tblMain.getRowCount(); ++k) {
            row = this.tblMain.getRow(k);
            AccountViewInfo acct = (AccountViewInfo)row.getCell("accountView").getValue();
            if (acct == null || account.equalsPK((IObjectValue)acct)) continue;
            MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)this.resourcePath, (String)"AccountViewNotEqual"), acct.getName()));
            this.abort();
        }
    }

    private VoucherEntryInfo getEntryInfo() throws BOSException, EASBizException {
        String billId = (String)this.getUIContext().get("billId");
        if (this.entryInfo == null) {
            this.entryInfo = BookNotifyClientHelper.getEntryInfo(billId);
        }
        return this.entryInfo;
    }

    @Override
    public VoucherInfo getVoucherInfo() throws BOSException, EASBizException {
        if (this.voucherInfo == null) {
            IVoucher voucher = VoucherFactory.getRemoteInstance();
            this.voucherInfo = (VoucherInfo)voucher.getValue((IObjectPK)new ObjectUuidPK(this.getEntryInfo().getBill().getId()), BookNotifyClientHelper.getVoucherSelector());
        }
        return this.voucherInfo;
    }

    @Override
    public void setTableCellEditorAfterOperateLine(IRow row) throws Exception {
        KDComboBox comboType = new KDComboBox();
        comboType.removeAllItems();
        VoucherEntryInfo entryInfo = this.getEntryInfo();
        if (entryInfo.getAccount().isIsCash()) {
            row.getCell("journalType").setValue((Object)JournalTypeEnum.CASH);
            row.getCell("journalType").getStyleAttributes().setLocked(true);
            row.getCell("bankAccount").getStyleAttributes().setLocked(true);
            row.getCell("accountView").getStyleAttributes().setLocked(false);
        } else if (entryInfo.getAccount().isIsBank()) {
            row.getCell("journalType").setValue((Object)JournalTypeEnum.BANK);
            row.getCell("journalType").getStyleAttributes().setLocked(true);
            row.getCell("accountView").getStyleAttributes().setLocked(true);
            row.getCell("bankAccount").getStyleAttributes().setLocked(false);
        }
    }

    @Override
    public AccountBankCollection getAccountBankCollection() throws Exception {
        AccountBankCollection accountBankCollectionByVoucherId = BookNotifyClientHelper.getAccountBankCollectionByVoucherEntryId(this.getEntryInfo().getId().toString());
        return accountBankCollectionByVoucherId;
    }

    public void checkAssiantNew(VoucherEntryInfo voucherEntryInfo) throws EASBizException, BOSException {
        BigDecimal assistantAmount = CasConstants.ZERO;
        BigDecimal entryCreditAmount = CasConstants.ZERO;
        BigDecimal entryDebitAmount = CasConstants.ZERO;
        BigDecimal entryAmountTotal = CasConstants.ZERO;
        BigDecimal tmpAmount = CasConstants.ZERO;
        AccountBankInfo assiBankAcct = null;
        AccountBankInfo bankAcct = null;
        IRow row = null;
        String acctId = null;
        HashMap<String, BigDecimal> assistantMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> entryMap = new HashMap<String, BigDecimal>();
        String key2 = null;
        AccountViewInfo accountViewInfo = voucherEntryInfo.getAccount();
        if (accountViewInfo.isIsBank()) {
            VoucherAssistRecordCollection voucherAssistRecordColl = voucherEntryInfo.getAssistRecords();
            if (voucherAssistRecordColl == null || voucherAssistRecordColl.size() == 0) {
                return;
            }
            for (int j = 0; j < voucherAssistRecordColl.size(); ++j) {
                VoucherAssistRecordInfo assistRecordInfo = voucherAssistRecordColl.get(j);
                if (assistRecordInfo.getAssGrp() == null || (assiBankAcct = assistRecordInfo.getAssGrp().getBankAccount()) == null) continue;
                acctId = assiBankAcct.getId().toString();
                key2 = voucherEntryInfo.getEntryDC().equals((Object)EntryDC.DEBIT) ? "debit" + acctId : "credit" + acctId;
                assistantAmount = assistRecordInfo.getOriginalAmount();
                if (assistantMap.containsKey(key2)) {
                    tmpAmount = (BigDecimal)assistantMap.get(key2);
                    tmpAmount = tmpAmount.add(assistantAmount);
                    assistantMap.remove(key2);
                    assistantMap.put(key2, tmpAmount);
                    continue;
                }
                assistantMap.put(key2, assistantAmount);
            }
        }
        for (int k = 0; k < this.tblMain.getRowCount(); ++k) {
            row = this.tblMain.getRow(k);
            bankAcct = (AccountBankInfo)row.getCell("bankAccount").getValue();
            if (bankAcct == null) continue;
            acctId = bankAcct.getId().toString();
            entryCreditAmount = (BigDecimal)row.getCell("creditAmount").getValue();
            entryDebitAmount = (BigDecimal)row.getCell("debitAmount").getValue();
            if (entryCreditAmount != null && entryCreditAmount.compareTo(CasConstants.ZERO) != 0) {
                entryAmountTotal = entryCreditAmount;
                key2 = "credit" + acctId;
            }
            if (entryDebitAmount != null && entryDebitAmount.compareTo(CasConstants.ZERO) != 0) {
                entryAmountTotal = entryDebitAmount;
                key2 = "debit" + acctId;
            }
            if (entryMap.containsKey(key2)) {
                tmpAmount = (BigDecimal)entryMap.get(key2);
                tmpAmount = tmpAmount.add(entryAmountTotal);
                entryMap.remove(key2);
                entryMap.put(key2, tmpAmount);
                continue;
            }
            entryMap.put(key2, entryAmountTotal);
        }
        Set keySet = assistantMap.keySet();
        for (String key2 : keySet) {
            assistantAmount = assistantMap.containsKey(key2) ? (BigDecimal)assistantMap.get(key2) : CasConstants.ZERO;
            if (assistantAmount.compareTo(entryAmountTotal = entryMap.containsKey(key2) ? (BigDecimal)entryMap.get(key2) : CasConstants.ZERO) == 0) continue;
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"AmountNotEqual"));
            SysUtil.abort();
        }
    }

    @Override
    protected IObjectValue createNewData() {
        JournalInfo journal = new JournalInfo();
        journal.setVerifyStatus(VerifyScopeEnum.NOVA);
        journal.setSource(JournalSourceEnum.BYVOUCHER);
        journal.setCreditAmount(null);
        journal.setDebitAmount(null);
        journal.setBillType(BillTypeEnum.voucherEntry);
        journal.setCompany(ContextHelperFactory.getRemoteInstance().getCurrentCompany());
        return journal;
    }
}

