/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fi.cas.client.AbstractVoucherBookNotifyUI;
import com.kingdee.eas.fi.cas.client.BookNotifyClientHelper;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryFactory;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.UserOptionFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.UuidException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class VoucherBookNotifyUI
extends AbstractVoucherBookNotifyUI {
    private static Logger logger = Logger.getLogger((String)VoucherBookNotifyUI.class.getName());
    public String resourcePath = "com.kingdee.eas.fi.cas.BookNotifyResource";
    public String voucherId;
    private boolean isModify = false;
    protected KeyListener laSpaceKey = new KeyAdapter(){

        @Override
        public void keyTyped(KeyEvent e) {
            KDTEditManager em;
            if (e.getKeyChar() == '=' && (em = VoucherBookNotifyUI.this.tblMain.getEditManager()).isEditing()) {
                em.stopEditing();
                VoucherBookNotifyUI.this.autoBalance(VoucherBookNotifyUI.this.tblMain);
            }
        }
    };
    private VoucherInfo voucherInfo = null;

    @Override
    public void onLoad() throws Exception {
        Map uiContext = this.getUIContext();
        String builderName = (String)uiContext.get("builderName");
        this.voucherId = (String)uiContext.get("billId");
        String status = (String)uiContext.get("status");
        super.onLoad();
        this.loadData(builderName, this.voucherId, status);
        this.setTableColumnFormat();
        this.setEnumRender();
        this.setTableCellEditorByCondition();
        this.setUIStatus(status);
        this.tblMain.getColumn("billType").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("billNumber").getStyleAttributes().setHided(true);
    }

    protected void autoBalance(KDTable table) {
        Object val;
        int i;
        int colIndex = table.getSelectManager().getActiveColumnIndex();
        int rowIndex = table.getSelectManager().getActiveRowIndex();
        VoucherInfo voucherInfo = null;
        try {
            voucherInfo = this.getVoucherInfo();
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        if (voucherInfo == null) {
            return;
        }
        VoucherEntryCollection entryCollection = voucherInfo.getEntries();
        VoucherEntryInfo entryInfo = null;
        BigDecimal tempDebitAmount = CasConstants.ZERO;
        BigDecimal tempCreditAmount = CasConstants.ZERO;
        for (i = 0; i < entryCollection.size(); ++i) {
            entryInfo = entryCollection.get(i);
            if (!entryInfo.getAccount().isIsBank() && !entryInfo.getAccount().isIsCash()) continue;
            if (entryInfo.getEntryDC().equals((Object)EntryDC.DEBIT)) {
                tempDebitAmount = tempDebitAmount.add(entryInfo.getOriginalAmount());
                continue;
            }
            tempCreditAmount = tempCreditAmount.add(entryInfo.getOriginalAmount());
        }
        for (i = 0; i < this.tblMain.getRowCount(); ++i) {
            val = this.tblMain.getRow(i).getCell("debitAmount").getValue();
            if (val == null || i == rowIndex) continue;
            tempDebitAmount = tempDebitAmount.subtract((BigDecimal)val);
        }
        for (i = 0; i < this.tblMain.getRowCount(); ++i) {
            val = this.tblMain.getRow(i).getCell("creditAmount").getValue();
            if (val == null || i == rowIndex) continue;
            tempCreditAmount = tempCreditAmount.subtract((BigDecimal)val);
        }
        if (colIndex == table.getColumnIndex("creditAmount")) {
            table.getRow(rowIndex).getCell("creditAmount").setValue((Object)tempCreditAmount);
            table.getRow(rowIndex).getCell("debitAmount").setValue(null);
        } else if (colIndex == table.getColumnIndex("debitAmount")) {
            table.getRow(rowIndex).getCell("debitAmount").setValue((Object)tempDebitAmount);
            table.getRow(rowIndex).getCell("creditAmount").setValue(null);
        }
    }

    private void setTableCellEditorByCondition() throws Exception {
        String status = (String)this.getUIContext().get("status");
        if (status.equals(OprtState.VIEW)) {
            return;
        }
        IRow row = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            JournalTypeEnum journalTypeEnum = (JournalTypeEnum)row.getCell("journalType").getValue();
            if (journalTypeEnum.equals((Object)JournalTypeEnum.CASH)) {
                row.getCell("bankAccount").setValue(null);
                row.getCell("bankAccount").getStyleAttributes().setLocked(true);
                row.getCell("accountView").getStyleAttributes().setLocked(false);
                AccountViewCollection cashAccountCollection = this.getCashAccountCollection();
                BookNotifyClientHelper.setTableCellEditorByComboBox(this.tblMain, (IObjectCollection)cashAccountCollection, "accountView");
                continue;
            }
            if (!journalTypeEnum.equals((Object)JournalTypeEnum.BANK)) continue;
            row.getCell("accountView").getStyleAttributes().setLocked(true);
            row.getCell("bankAccount").getStyleAttributes().setLocked(false);
        }
    }

    @Override
    protected void setTableCellEditor() throws Exception {
        super.setTableCellEditor();
        String status = (String)this.getUIContext().get("status");
        if (!status.equals(OprtState.VIEW)) {
            AccountBankCollection accountBankCollectionByVoucherId = this.getAccountBankCollection();
            BookNotifyClientHelper.setTableCellEditorByComboBox(this.tblMain, (IObjectCollection)accountBankCollectionByVoucherId, "bankAccount");
            CurrencyCollection currencyCollectionByVoucherId = this.getCurrencyCollection();
            BookNotifyClientHelper.setTableCellEditorByComboBox(this.tblMain, (IObjectCollection)currencyCollectionByVoucherId, "currency");
            AccountViewCollection accountCollectionByVoucherId = this.getAccountCollection();
            BookNotifyClientHelper.setTableCellEditorByComboBox(this.tblMain, (IObjectCollection)accountCollectionByVoucherId, "oppAccountView");
        }
    }

    @Override
    protected IObjectValue createNewData() {
        JournalInfo journal = new JournalInfo();
        journal.setVerifyStatus(VerifyScopeEnum.NOVA);
        journal.setSource(JournalSourceEnum.BYVOUCHER);
        journal.setCreditAmount(null);
        journal.setDebitAmount(FMConstants.ZERO);
        journal.setCompany(ContextHelperFactory.getRemoteInstance().getCurrentCompany());
        return journal;
    }

    private void loadData(String builderName, String billId, String status) throws Exception {
        JournalCollection coll = this.getJournalCollection(builderName, billId, status);
        if (coll != null && coll.size() != 0) {
            this.tableHandler.bindDataToTable(this.tblMain, (IObjectCollection)coll);
            JournalInfo journalInfo = coll.get(0);
            java.util.Date bookDate = null;
            bookDate = journalInfo.getCreateDate().before(journalInfo.getBizDate()) ? journalInfo.getBizDate() : journalInfo.getCreateDate();
            this.txtBookDate.setText(bookDate.toString());
            this.txtVoucherType.setText(journalInfo.getVoucherType().toString());
            this.txtVoucherNumber.setText(journalInfo.getVoucherNumber());
            String[] args = new String[]{String.valueOf(journalInfo.getPeriod().getPeriodYear()), String.valueOf(journalInfo.getPeriod().getPeriodNumber())};
            MessageFormat mf = new MessageFormat(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"LBL_Period"));
            String result = mf.format(args);
            this.txtPeriod.setText(result);
            this.txtBookDate.setUserObject((Object)bookDate);
            this.txtVoucherType.setUserObject((Object)journalInfo.getVoucherType());
            this.txtPeriod.setUserObject((Object)journalInfo.getPeriod());
        }
    }

    @Override
    public void storeData() {
        this.tableHandler.bindTableToData(this.tblMain, (IObjectCollection)this.journalCollection, JournalInfo.class.getName());
        JournalInfo info = null;
        BOSUuid currencyId = null;
        int prec = 0;
        for (int i = 0; i < this.journalCollection.size(); ++i) {
            info = this.journalCollection.get(i);
            info.setCreateDate(info.getBizDate());
            info.setVoucherType((VoucherTypeInfo)this.txtVoucherType.getUserObject());
            info.setPeriod((PeriodInfo)this.txtPeriod.getUserObject());
            info.setVoucherNumber(this.txtVoucherNumber.getText());
            info.setBillNumber(this.txtVoucherNumber.getText());
            info.setVerifyStatus(VerifyScopeEnum.NOVA);
            info.setSource(JournalSourceEnum.BYVOUCHER);
            if (info.getBillId() == null) {
                info.setBillId(this.voucherId);
            }
            if (info.getBillType() == null) {
                info.setBillType(BillTypeEnum.voucherEntry);
            }
            if (info.getDebitAmount() == null) {
                info.setDebitAmount(FMConstants.ZERO);
                info.setIsDebit(true);
            }
            if (info.getCreditAmount() == null) {
                info.setCreditAmount(FMConstants.ZERO);
                info.setIsDebit(false);
            }
            if (info.getCompany() == null) {
                info.setCompany(ContextHelperFactory.getRemoteInstance().getCurrentCompany());
            }
            if (info.getCurrency() == null) continue;
            currencyId = info.getCurrency().getId();
            prec = FMClientHelper.getPrecOfCurrency((BOSUuid)currencyId);
            BigDecimal debit = info.getDebitAmount().setScale(prec, 4);
            info.setDebitAmount(debit);
            BigDecimal credit = info.getCreditAmount().setScale(prec, 4);
            info.setCreditAmount(credit);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        BOSUuid currencyId = null;
        int prec = 0;
        IRow row = null;
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = this.tblMain.getRow(i);
            if (row.getCell("currency").getValue() != null && row.getCell("currency").getValue() instanceof CurrencyInfo) {
                currencyId = ((CurrencyInfo)row.getCell("currency").getValue()).getId();
                prec = FMClientHelper.getPrecOfCurrency((BOSUuid)currencyId);
            }
            if (row.getCell("creditAmount").getValue() != null && row.getCell("creditAmount").getValue() instanceof BigDecimal) {
                BigDecimal creditAmt = (BigDecimal)row.getCell("creditAmount").getValue();
                creditAmt = creditAmt.setScale(prec, 4);
                row.getCell("creditAmount").setValue((Object)creditAmt);
            }
            if (row.getCell("debitAmount").getValue() == null || !(row.getCell("debitAmount").getValue() instanceof BigDecimal)) continue;
            BigDecimal debitAmt = (BigDecimal)row.getCell("debitAmount").getValue();
            debitAmt = debitAmt.setScale(prec, 4);
            row.getCell("debitAmount").setValue((Object)debitAmt);
        }
        this.storeData();
        super.storeFields();
    }

    public static JournalCollection showDialogWindows(IUIObject ui, String builderName, String id, String status) throws UIException {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"builderName", (Object)builderName);
        uiContext.put((Object)"billId", (Object)id);
        uiContext.put((Object)"status", (Object)status);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(VoucherBookNotifyUI.class.getName(), (Map)uiContext, null, status);
        uiWindow.show();
        VoucherBookNotifyUI voucherBookNotifyUI = (VoucherBookNotifyUI)uiWindow.getUIObject();
        return voucherBookNotifyUI.getJournalCollection();
    }

    @Override
    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        java.util.Date beginDate = DateTimeUtils.truncateDate((java.util.Date)BookNotifyClientHelper.getBeginDateOfCurrentPeriod());
        CompanyOrgUnitInfo company = this.getCompany(this.voucherId);
        IRow row = null;
        Date userDate = null;
        Map uiContext = this.getUIContext();
        String status = (String)uiContext.get("status");
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            userDate = TypeConversionUtils.objToDate((Object)this.txtBookDate.getUserObject());
            PeriodInfo period = PeriodUtils.getPeriodInfo(null, (java.util.Date)userDate, (CompanyOrgUnitInfo)company);
            if (period == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"PEROID_INVALAID"));
                SysUtil.abort();
            }
            if (!userDate.before(beginDate = period.getBeginDate())) continue;
            if (status.equals("EDIT")) {
                this.tblMain.getEditManager().editCellAt(row.getRowIndex(), this.tblMain.getColumnIndex("bizDate"));
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"APPOINT_DATE_ERROR"));
                SysUtil.abort();
                continue;
            }
            this.txtBookDate.setUserObject((Object)beginDate);
        }
        this.checkCurrencyAndAmount();
    }

    private CompanyOrgUnitInfo getCompany(String voucherId) throws EASBizException, BOSException, UuidException {
        FilterInfo filter = new FilterInfo();
        BOSUuid id = BOSUuid.read((String)voucherId);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        evi.getSelector().add("company.id");
        evi.getSelector().add("company.name");
        evi.getSelector().add("company.number");
        if ("2652E01E".equals(id.getType().toString())) {
            BillBaseInfo info = VoucherFactory.getRemoteInstance().getBillBaseInfo((IObjectPK)new ObjectUuidPK(voucherId));
            return info.getCompany();
        }
        VoucherInfo item = null;
        VoucherEntryInfo entry = (VoucherEntryInfo)VoucherEntryFactory.getRemoteInstance().getBillEntryBaseInfo((IObjectPK)new ObjectUuidPK(voucherId));
        item = entry.getBill();
        id = BOSUuid.read((String)item.getId().toString());
        BillBaseInfo info = VoucherFactory.getRemoteInstance().getBillBaseInfo((IObjectPK)new ObjectUuidPK(item.getId().toString()));
        return info.getCompany();
    }

    public void checkCurrencyAndAmount() throws Exception {
        BigDecimal journalCashDebit = CasConstants.ZERO;
        BigDecimal journalCashCredit = CasConstants.ZERO;
        BigDecimal journalBankDebit = CasConstants.ZERO;
        BigDecimal journalBankCredit = CasConstants.ZERO;
        BigDecimal voucherCashDebit = CasConstants.ZERO;
        BigDecimal voucherCashCredit = CasConstants.ZERO;
        BigDecimal voucherBankDebit = CasConstants.ZERO;
        BigDecimal voucherBankCredit = CasConstants.ZERO;
        BigDecimal tempDebitAmount = CasConstants.ZERO;
        BigDecimal tempCreditAmount = CasConstants.ZERO;
        IRow row = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            JournalTypeEnum type = (JournalTypeEnum)row.getCell("journalType").getValue();
            if (type.equals((Object)JournalTypeEnum.CASH)) {
                tempDebitAmount = (BigDecimal)row.getCell("debitAmount").getValue();
                tempCreditAmount = (BigDecimal)row.getCell("creditAmount").getValue();
                if (tempDebitAmount == null) {
                    tempDebitAmount = CasConstants.ZERO;
                }
                if (tempCreditAmount == null) {
                    tempCreditAmount = CasConstants.ZERO;
                }
                journalCashDebit = journalCashDebit.add(tempDebitAmount);
                journalCashCredit = journalCashCredit.add(tempCreditAmount);
            }
            if (!type.equals((Object)JournalTypeEnum.BANK)) continue;
            tempDebitAmount = (BigDecimal)row.getCell("debitAmount").getValue();
            tempCreditAmount = (BigDecimal)row.getCell("creditAmount").getValue();
            if (tempDebitAmount == null) {
                tempDebitAmount = CasConstants.ZERO;
            }
            if (tempCreditAmount == null) {
                tempCreditAmount = CasConstants.ZERO;
            }
            journalBankDebit = journalBankDebit.add(tempDebitAmount);
            journalBankCredit = journalBankCredit.add(tempCreditAmount);
        }
        VoucherInfo voucherInfo = this.getVoucherInfo();
        VoucherEntryCollection entryCollection = voucherInfo.getEntries();
        VoucherEntryInfo entryInfo = null;
        for (int i = 0; i < entryCollection.size(); ++i) {
            entryInfo = entryCollection.get(i);
            if (entryInfo.getAccount().isIsCash()) {
                tempDebitAmount = CasConstants.ZERO;
                tempCreditAmount = CasConstants.ZERO;
                if (entryInfo.getEntryDC().equals((Object)EntryDC.CREDIT)) {
                    tempCreditAmount = entryInfo.getOriginalAmount();
                }
                if (entryInfo.getEntryDC().equals((Object)EntryDC.DEBIT)) {
                    tempDebitAmount = entryInfo.getOriginalAmount();
                }
                voucherCashDebit = voucherCashDebit.add(tempDebitAmount);
                voucherCashCredit = voucherCashCredit.add(tempCreditAmount);
            }
            if (!entryInfo.getAccount().isIsBank()) continue;
            tempDebitAmount = CasConstants.ZERO;
            tempCreditAmount = CasConstants.ZERO;
            if (entryInfo.getEntryDC().equals((Object)EntryDC.CREDIT)) {
                tempCreditAmount = entryInfo.getOriginalAmount();
            }
            if (entryInfo.getEntryDC().equals((Object)EntryDC.DEBIT)) {
                tempDebitAmount = entryInfo.getOriginalAmount();
            }
            voucherBankDebit = voucherBankDebit.add(tempDebitAmount);
            voucherBankCredit = voucherBankCredit.add(tempCreditAmount);
        }
        boolean isByOppAccount = false;
        Map bookUserMap = UserOptionFactory.getRemoteInstance().getUserOptionMap("com.kingdee.eas.fi.cas.client.BookUserOptionUI");
        if (bookUserMap != null) {
            isByOppAccount = new Boolean((String)bookUserMap.get("kDRadioButtonAccount"));
            if (isByOppAccount) {
                this.checkOppAccountBalance(journalCashDebit, journalCashCredit, voucherCashDebit, voucherCashCredit, journalBankDebit, journalBankCredit, voucherBankDebit, voucherBankCredit);
            } else {
                this.checkAccountBalance(journalCashDebit, journalCashCredit, voucherCashDebit, voucherCashCredit, journalBankDebit, journalBankCredit, voucherBankDebit, voucherBankCredit);
            }
        }
        this.checkAssiantNew(voucherInfo, isByOppAccount);
        this.checkAccount(voucherInfo, isByOppAccount);
    }

    private void checkOppAccountBalance(BigDecimal journalCashDebit, BigDecimal journalCashCredit, BigDecimal voucherCashDebit, BigDecimal voucherCashCredit, BigDecimal journalBankDebit, BigDecimal journalBankCredit, BigDecimal voucherBankDebit, BigDecimal voucherBankCredit) {
        String cashResource = "CashCreditNotEqual";
        BigDecimal journalCashBalance = journalCashDebit.subtract(journalCashCredit);
        BigDecimal voucherCashBalance = voucherCashDebit.subtract(voucherCashCredit);
        if (journalCashBalance.compareTo(Constants.ZERO) > 0) {
            cashResource = "CashDebitNotEqual";
        }
        if (journalCashBalance.compareTo(voucherCashBalance) != 0) {
            MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)this.resourcePath, (String)cashResource), journalCashBalance, voucherCashBalance));
            this.journalCollection.clear();
            SysUtil.abort();
        }
        String bankResource = "BankCreditNotEqual";
        BigDecimal journalBankBalance = journalBankDebit.subtract(journalBankCredit);
        BigDecimal voucherBankBalance = voucherBankDebit.subtract(voucherBankCredit);
        if (journalBankBalance.compareTo(Constants.ZERO) > 0) {
            cashResource = "BankDebitNotEqual";
        }
        if (journalBankBalance.compareTo(voucherBankBalance) != 0) {
            MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)this.resourcePath, (String)bankResource), journalBankBalance, voucherBankBalance));
            this.journalCollection.clear();
            SysUtil.abort();
        }
    }

    private void checkAccountBalance(BigDecimal journalCashDebit, BigDecimal journalCashCredit, BigDecimal voucherCashDebit, BigDecimal voucherCashCredit, BigDecimal journalBankDebit, BigDecimal journalBankCredit, BigDecimal voucherBankDebit, BigDecimal voucherBankCredit) {
        if (journalCashDebit.compareTo(voucherCashDebit) != 0) {
            MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)this.resourcePath, (String)"CashDebitNotEqual"), journalCashDebit, voucherCashDebit));
            this.journalCollection.clear();
            SysUtil.abort();
        }
        if (journalCashCredit.compareTo(voucherCashCredit) != 0) {
            MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)this.resourcePath, (String)"CashCreditNotEqual"), journalCashCredit, voucherCashCredit));
            this.journalCollection.clear();
            SysUtil.abort();
        }
        if (journalBankDebit.compareTo(voucherBankDebit) != 0) {
            MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)this.resourcePath, (String)"BankDebitNotEqual"), journalBankDebit, voucherBankDebit));
            this.journalCollection.clear();
            SysUtil.abort();
        }
        if (journalBankCredit.compareTo(voucherBankCredit) != 0) {
            MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)this.resourcePath, (String)"BankCreditNotEqual"), journalBankCredit, voucherBankCredit));
            this.journalCollection.clear();
            SysUtil.abort();
        }
    }

    public void checkAccount(VoucherInfo voucherInfo, boolean isByOppAccount) throws EASBizException, BOSException {
        VoucherEntryCollection entryColl = voucherInfo.getEntries();
        BigDecimal assistantAmount = CasConstants.ZERO;
        BigDecimal entryCreditAmount = CasConstants.ZERO;
        BigDecimal entryDebitAmount = CasConstants.ZERO;
        BigDecimal entryAmountTotal = CasConstants.ZERO;
        BigDecimal tmpAmount = CasConstants.ZERO;
        IRow row = null;
        String acctId = null;
        HashMap<String, BigDecimal> assistantMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> entryMap = new HashMap<String, BigDecimal>();
        String key = null;
        for (int i = 0; i < entryColl.size(); ++i) {
            VoucherEntryInfo voucherEntryInfo = entryColl.get(i);
            AccountViewInfo accountViewInfo = voucherEntryInfo.getAccount();
            if (!accountViewInfo.isIsBank() && !accountViewInfo.isIsCash()) continue;
            acctId = accountViewInfo.getId().toString();
            key = voucherEntryInfo.getEntryDC().equals((Object)EntryDC.DEBIT) ? "debit" + acctId : "credit" + acctId;
            assistantAmount = voucherEntryInfo.getOriginalAmount();
            if (assistantMap.containsKey(key)) {
                tmpAmount = (BigDecimal)assistantMap.get(key);
                tmpAmount = tmpAmount.add(assistantAmount);
                assistantMap.remove(key);
                assistantMap.put(key, tmpAmount);
                continue;
            }
            assistantMap.put(key, assistantAmount);
        }
        for (int k = 0; k < this.tblMain.getRowCount(); ++k) {
            row = this.tblMain.getRow(k);
            AccountViewInfo bankAcct = (AccountViewInfo)row.getCell("accountView").getValue();
            if (bankAcct == null) continue;
            acctId = bankAcct.getId().toString();
            entryCreditAmount = (BigDecimal)row.getCell("creditAmount").getValue();
            entryDebitAmount = (BigDecimal)row.getCell("debitAmount").getValue();
            if (entryCreditAmount != null && entryCreditAmount.compareTo(CasConstants.ZERO) != 0) {
                entryAmountTotal = entryCreditAmount;
                key = "credit" + acctId;
            }
            if (entryDebitAmount != null && entryDebitAmount.compareTo(CasConstants.ZERO) != 0) {
                entryAmountTotal = entryDebitAmount;
                key = "debit" + acctId;
            }
            if (entryMap.containsKey(key)) {
                tmpAmount = (BigDecimal)entryMap.get(key);
                tmpAmount = tmpAmount.add(entryAmountTotal);
                entryMap.remove(key);
                entryMap.put(key, tmpAmount);
                continue;
            }
            entryMap.put(key, entryAmountTotal);
        }
        Iterator iterator = assistantMap.keySet().iterator();
        Iterator it = entryMap.keySet().iterator();
        if (isByOppAccount) {
            BigDecimal assisBalance = BigDecimal.ZERO;
            BigDecimal entryBalance = BigDecimal.ZERO;
            while (iterator.hasNext()) {
                key = (String)iterator.next();
                if (assistantMap.size() > 1) {
                    if (assisBalance == null) {
                        assisBalance = (BigDecimal)assistantMap.get(key);
                        continue;
                    }
                    assisBalance = assisBalance.subtract((BigDecimal)assistantMap.get(key));
                    continue;
                }
                assisBalance = (BigDecimal)assistantMap.get(key);
            }
            while (it.hasNext()) {
                key = (String)it.next();
                if (entryMap.size() > 1) {
                    if (entryBalance == null) {
                        entryBalance = (BigDecimal)entryMap.get(key);
                        continue;
                    }
                    entryBalance = entryBalance.subtract((BigDecimal)entryMap.get(key));
                    continue;
                }
                entryBalance = (BigDecimal)entryMap.get(key);
            }
            if (assisBalance.abs().compareTo(entryBalance.abs()) != 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"AmountNotEqual"));
                this.journalCollection.clear();
                SysUtil.abort();
            }
        } else {
            while (iterator.hasNext()) {
                key = (String)iterator.next();
                assistantAmount = assistantMap.containsKey(key) ? (BigDecimal)assistantMap.get(key) : CasConstants.ZERO;
                if (assistantAmount.compareTo(entryAmountTotal = entryMap.containsKey(key) ? (BigDecimal)entryMap.get(key) : CasConstants.ZERO) == 0) continue;
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"AmountNotEqual"));
                this.journalCollection.clear();
                SysUtil.abort();
            }
        }
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        IRow row = BookNotifyClientHelper.addLine(this.tblMain, this.createNewData());
        this.setTableCellEditorAfterOperateLine(row);
        this.isModify = true;
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() <= 0) {
            return;
        }
        IRow row = BookNotifyClientHelper.insertLine(this.tblMain, this.createNewData());
        this.setTableCellEditorAfterOperateLine(row);
        this.isModify = true;
    }

    @Override
    public void actionCopyLine_actionPerformed(ActionEvent e) throws Exception {
        IRow row = BookNotifyClientHelper.CopyLine(this.tblMain);
        if (row == null) {
            return;
        }
        this.setTableCellEditorAfterOperateLine(row);
        JournalTypeEnum journalTypeEnum = (JournalTypeEnum)row.getCell("journalType").getValue();
        if (journalTypeEnum == null) {
            return;
        }
        if (journalTypeEnum.equals((Object)JournalTypeEnum.CASH)) {
            row.getCell("bankAccount").setValue(null);
            row.getCell("bankAccount").getStyleAttributes().setLocked(true);
            row.getCell("accountView").getStyleAttributes().setLocked(false);
            AccountViewCollection cashAccountCollection = this.getCashAccountCollection();
            BookNotifyClientHelper.setTableCellEditorByComboBox(this.tblMain, (IObjectCollection)cashAccountCollection, "accountView");
        } else if (journalTypeEnum.equals((Object)JournalTypeEnum.BANK)) {
            row.getCell("accountView").getStyleAttributes().setLocked(true);
            row.getCell("bankAccount").getStyleAttributes().setLocked(false);
        }
        this.isModify = true;
    }

    @Override
    public AccountViewCollection getCashAccountCollection() throws Exception {
        AccountViewCollection cashAccountCollection = BookNotifyClientHelper.getCashAccountCollection(this.getVoucherInfo());
        return cashAccountCollection;
    }

    private AccountViewCollection getAccountCollection() throws Exception {
        AccountViewCollection accountCollectionByVoucherId = BookNotifyClientHelper.getAccountCollectionByVoucherId(this.getVoucherInfo());
        return accountCollectionByVoucherId;
    }

    private CurrencyCollection getCurrencyCollection() throws Exception {
        CurrencyCollection currencyCollectionByVoucherId = BookNotifyClientHelper.getCurrencyCollectionByVoucherId(this.getVoucherInfo());
        return currencyCollectionByVoucherId;
    }

    public AccountBankCollection getAccountBankCollection() throws Exception {
        AccountBankCollection accountBankCollectionByVoucherId = BookNotifyClientHelper.getAccountBankCollectionByVoucherId(this.getVoucherInfo());
        return accountBankCollectionByVoucherId;
    }

    public VoucherInfo getVoucherInfo() throws BOSException, EASBizException {
        if (this.voucherInfo == null) {
            IVoucher voucher = VoucherFactory.getRemoteInstance();
            this.voucherInfo = (VoucherInfo)voucher.getValue((IObjectPK)new ObjectUuidPK(this.voucherId), BookNotifyClientHelper.getVoucherSelector());
        }
        return this.voucherInfo;
    }

    public void setTableCellEditorAfterOperateLine(IRow row) throws Exception {
        KDComboBox comboType = new KDComboBox();
        comboType.removeAllItems();
        if (BookNotifyClientHelper.getAccountType(this.getVoucherInfo()) == 1) {
            row.getCell("journalType").setValue((Object)JournalTypeEnum.CASH);
            row.getCell("journalType").getStyleAttributes().setLocked(true);
            row.getCell("bankAccount").getStyleAttributes().setLocked(true);
            row.getCell("accountView").getStyleAttributes().setLocked(false);
        } else if (BookNotifyClientHelper.getAccountType(this.getVoucherInfo()) == 2) {
            row.getCell("journalType").setValue((Object)JournalTypeEnum.BANK);
            row.getCell("journalType").getStyleAttributes().setLocked(true);
            row.getCell("accountView").getStyleAttributes().setLocked(true);
            row.getCell("bankAccount").getStyleAttributes().setLocked(false);
        } else if (BookNotifyClientHelper.getAccountType(this.getVoucherInfo()) == 3) {
            // empty if block
        }
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        this.actionSubmit_actionPerformed(null);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        String status = (String)this.getUIContext().get("status");
        if (!status.equals(OprtState.VIEW)) {
            this.verify(e);
            this.storeData();
        }
        this.disposeUIWindow();
    }

    @Override
    protected void btnNotOK_actionPerformed(ActionEvent e) throws Exception {
        super.btnNotOK_actionPerformed(e);
        this.disposeUIWindow();
        SysUtil.abort();
    }

    @Override
    protected void tblMain_editStopping(KDTEditEvent e) throws Exception {
        String status = (String)this.getUIContext().get("status");
        if (status.equals(OprtState.VIEW)) {
            return;
        }
        super.tblMain_editStopping(e);
        Component comp1 = this.tblMain.getColumn("debitAmount").getEditor().getFocusComponent();
        comp1.addKeyListener(this.laSpaceKey);
        Component comp2 = this.tblMain.getColumn("creditAmount").getEditor().getFocusComponent();
        comp2.addKeyListener(this.laSpaceKey);
        this.isModify = true;
    }

    public void checkAssiantNew(VoucherInfo voucherInfo, boolean isByOppAccount) throws EASBizException, BOSException {
        VoucherEntryCollection entryColl = voucherInfo.getEntries();
        BigDecimal assistantAmount = CasConstants.ZERO;
        BigDecimal entryCreditAmount = CasConstants.ZERO;
        BigDecimal entryDebitAmount = CasConstants.ZERO;
        BigDecimal entryAmountTotal = CasConstants.ZERO;
        BigDecimal tmpAmount = CasConstants.ZERO;
        AccountBankInfo assiBankAcct = null;
        AccountBankInfo bankAcct = null;
        IRow row = null;
        String acctId = null;
        HashMap<String, BigDecimal> assistantMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> entryMap = new HashMap<String, BigDecimal>();
        String key = null;
        for (int i = 0; i < entryColl.size(); ++i) {
            VoucherAssistRecordCollection voucherAssistRecordColl;
            VoucherEntryInfo voucherEntryInfo = entryColl.get(i);
            AccountViewInfo accountViewInfo = voucherEntryInfo.getAccount();
            if (!accountViewInfo.isIsBank() || (voucherAssistRecordColl = voucherEntryInfo.getAssistRecords()) == null || voucherAssistRecordColl.size() == 0) continue;
            for (int j = 0; j < voucherAssistRecordColl.size(); ++j) {
                VoucherAssistRecordInfo assistRecordInfo = voucherAssistRecordColl.get(j);
                if (assistRecordInfo.getAssGrp() == null || (assiBankAcct = assistRecordInfo.getAssGrp().getBankAccount()) == null) continue;
                acctId = assiBankAcct.getId().toString();
                key = voucherEntryInfo.getEntryDC().equals((Object)EntryDC.DEBIT) ? "debit" + acctId : "credit" + acctId;
                assistantAmount = assistRecordInfo.getOriginalAmount();
                if (assistantMap.containsKey(key)) {
                    tmpAmount = (BigDecimal)assistantMap.get(key);
                    tmpAmount = tmpAmount.add(assistantAmount);
                    assistantMap.remove(key);
                    assistantMap.put(key, tmpAmount);
                    continue;
                }
                assistantMap.put(key, assistantAmount);
            }
        }
        for (int k = 0; k < this.tblMain.getRowCount(); ++k) {
            row = this.tblMain.getRow(k);
            bankAcct = (AccountBankInfo)row.getCell("bankAccount").getValue();
            if (bankAcct == null) continue;
            acctId = bankAcct.getId().toString();
            entryCreditAmount = (BigDecimal)row.getCell("creditAmount").getValue();
            entryDebitAmount = (BigDecimal)row.getCell("debitAmount").getValue();
            if (entryCreditAmount != null && entryCreditAmount.compareTo(CasConstants.ZERO) != 0) {
                entryAmountTotal = entryCreditAmount;
                key = "credit" + acctId;
            }
            if (entryDebitAmount != null && entryDebitAmount.compareTo(CasConstants.ZERO) != 0) {
                entryAmountTotal = entryDebitAmount;
                key = "debit" + acctId;
            }
            if (entryMap.containsKey(key)) {
                tmpAmount = (BigDecimal)entryMap.get(key);
                tmpAmount = tmpAmount.add(entryAmountTotal);
                entryMap.remove(key);
                entryMap.put(key, tmpAmount);
                continue;
            }
            entryMap.put(key, entryAmountTotal);
        }
        Iterator iterator = assistantMap.keySet().iterator();
        Iterator it = entryMap.keySet().iterator();
        if (isByOppAccount) {
            BigDecimal assisBalance = CasConstants.ZERO;
            BigDecimal entryBalance = CasConstants.ZERO;
            while (iterator.hasNext()) {
                key = (String)iterator.next();
                if (assistantMap.size() > 1) {
                    if (assisBalance == null) {
                        assisBalance = (BigDecimal)assistantMap.get(key);
                        continue;
                    }
                    assisBalance = assisBalance.subtract((BigDecimal)assistantMap.get(key));
                    continue;
                }
                assisBalance = (BigDecimal)assistantMap.get(key);
            }
            while (it.hasNext()) {
                key = (String)it.next();
                if (entryMap.size() > 1) {
                    if (entryBalance == null) {
                        entryBalance = (BigDecimal)entryMap.get(key);
                        continue;
                    }
                    entryBalance = entryBalance.subtract((BigDecimal)entryMap.get(key));
                    continue;
                }
                entryBalance = (BigDecimal)entryMap.get(key);
            }
            if (assisBalance.abs().compareTo(entryBalance.abs()) != 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"AmountNotEqual"));
                this.journalCollection.clear();
                SysUtil.abort();
            }
        } else {
            while (iterator.hasNext()) {
                key = (String)iterator.next();
                assistantAmount = assistantMap.containsKey(key) ? (BigDecimal)assistantMap.get(key) : CasConstants.ZERO;
                if (assistantAmount.compareTo(entryAmountTotal = entryMap.containsKey(key) ? (BigDecimal)entryMap.get(key) : CasConstants.ZERO) == 0) continue;
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"AmountNotEqual"));
                this.journalCollection.clear();
                SysUtil.abort();
            }
        }
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddLine.setVisible(false);
        this.btnAddNew.setVisible(false);
        this.btnAddNewLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnInertLine1.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnCopyLine1.setIcon(EASResource.getIcon((String)"imgTbtn_copyline"));
        this.btnRemoveLine1.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnLable.setIcon(EASResource.getIcon((String)"imgLableword_btn"));
        this.actionAttachment.setVisible(false);
        this.actionAttachment.setEnabled(false);
    }

    @Override
    protected void setUIStatus(String oprtState) {
        this.txtBookDate.setEnabled(false);
        this.txtPeriod.setEnabled(false);
        this.txtVoucherNumber.setEnabled(false);
        this.txtVoucherType.setEnabled(false);
        this.btnCopyLine.setVisible(false);
        this.btnInsertLine.setVisible(false);
        super.setUIStatus(oprtState);
        if (oprtState.equals(OprtState.VIEW)) {
            this.actionAddLine.setEnabled(false);
            this.actionCopyLine.setEnabled(false);
            this.actionRemoveLine.setEnabled(false);
            this.actionSubmit.setEnabled(false);
            this.actionInsertLine.setEnabled(false);
            this.actionAttachment.setEnabled(false);
        } else {
            Component comp1 = this.tblMain.getColumn("debitAmount").getEditor().getFocusComponent();
            comp1.addKeyListener(this.laSpaceKey);
            Component comp2 = this.tblMain.getColumn("creditAmount").getEditor().getFocusComponent();
            comp2.addKeyListener(this.laSpaceKey);
        }
    }

    public boolean checkBeforeWindowClosing() {
        if (this.isModify()) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit"));
            if (result == 0) {
                try {
                    this.actionSubmit_actionPerformed(null);
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
            if (result == 1) {
                this.journalCollection = null;
                return true;
            }
            return false;
        }
        this.journalCollection = null;
        return true;
    }

    public boolean isModify() {
        if (OprtState.VIEW.equals(this.getOprtState())) {
            return false;
        }
        return this.isModify;
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        if (dataObject == null) {
            dataObject = this.createNewData();
        }
        super.setDataObject(dataObject);
    }

    public IObjectValue getDataObject() {
        return this.createNewData();
    }
}

