/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.BookNotifyFacadeFactory;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.IBookNotifyFacade;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.VoucherCheckFilterParam;
import com.kingdee.eas.fi.cas.VoucherCheckUIFacadeFactory;
import com.kingdee.eas.fi.cas.client.AbstractVoucherCheckListUI;
import com.kingdee.eas.fi.cas.client.BookAppointDateUI;
import com.kingdee.eas.fi.cas.client.BookUserOptionUI;
import com.kingdee.eas.fi.cas.client.CashClientHelper;
import com.kingdee.eas.fi.cas.client.CheckQueryProcessor;
import com.kingdee.eas.fi.cas.client.VoucherBookNotifyUI;
import com.kingdee.eas.fi.cas.client.VoucherCheckByEntryListUI;
import com.kingdee.eas.fi.cas.client.VoucherCheckFilterUI;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.fi.gl.client.VoucherEditUI;
import com.kingdee.eas.fm.common.CheckUtils;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.DynamicUtils;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMLoginModel;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.IUserOption;
import com.kingdee.eas.fm.common.UserOptionFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class VoucherCheckListUI
extends AbstractVoucherCheckListUI {
    private static final Logger logger = CoreUIObject.getLogger(VoucherCheckListUI.class);
    public static final String RESOURCE_PATH = "com.kingdee.eas.fi.gl.client.VoucherEditResource";
    public static final String resourcePath = "com.kingdee.eas.fi.cas.CasResources";
    private VoucherCheckFilterUI filterUI;
    protected EntityViewInfo view;
    private CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private IUserOption iUserOption = UserOptionFactory.getRemoteInstance();
    private Map paramMap;
    FillListener fillListener = new FillListener();

    private void preProcess() throws Exception {
        this.paramMap = new HashMap();
        this.paramMap.put("currentCompany", null);
        this.paramMap.put("currentPeriod", null);
        this.paramMap.put("CS001", null);
        this.paramMap.put("association", null);
        this.paramMap.put("GL_047", null);
        this.paramMap.put("CS119", null);
        this.paramMap = VoucherCheckUIFacadeFactory.getRemoteInstance().fetchData(this.paramMap);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        boolean isAssociationGL = true;
        VoucherCheckFilterParam param = (VoucherCheckFilterParam)this.getFilterParam();
        this.companyInfo = !EmptyUtil.isEmpty((CoreBaseInfo)param.getCurrentCompany()) ? param.getCurrentCompany() : (this.paramMap.get("currentCompany") == null ? ContextHelperFactory.getRemoteInstance().getCurrentCompany() : (CompanyOrgUnitInfo)this.paramMap.get("currentCompany"));
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.companyInfo);
        if (currentPeriod == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"391_VoucherCheckListUI"));
            SysUtil.abort();
            isAssociationGL = false;
        } else {
            boolean isAGL = CashHelper.isAssociationGeneralLeger(this.companyInfo);
            if (!isAGL) {
                isAssociationGL = false;
            }
        }
        if (!isAssociationGL) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"NotAssociationGL"));
            SysUtil.abort();
        }
        this.btnAuditResult.setVisible(false);
        this.getMainStatusBar().setPerTitle(this.getSysStatusBarTitle());
        this.btnVoucher.setVisible(false);
        this.btnDelVoucher.setVisible(false);
        this.menuItemVoucher.setVisible(false);
        this.menuItemDelVoucher.setVisible(false);
    }

    public String getSysStatusBarTitle() throws Exception {
        PeriodInfo curP = null;
        if (this.paramMap.get("currentPeriod") == null) {
            CompanyOrgUnitInfo curC = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)curC)) {
                return null;
            }
            curP = CashClientHelper.getCurrentPeriod(curC);
            if (curP == null) {
                return null;
            }
        } else {
            curP = (PeriodInfo)this.paramMap.get("currentPeriod");
            if (curP == null) {
                return null;
            }
        }
        return EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"PeriodTitle") + curP.getPeriodYear() + EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"year") + curP.getPeriodNumber() + EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"period");
    }

    protected boolean isPerTitleAuto() {
        return false;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnAutoCheck.setIcon(EASResource.getIcon((String)"imgTbtn_autocollate"));
        this.btnHandCheck.setIcon(EASResource.getIcon((String)"imgTbtn_handworkcollate"));
        this.btnEditCheck.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.btnViewCheck.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this.btnCancelCheck.setIcon(EASResource.getIcon((String)"imgTbtn_fallotpopedomforbid"));
        this.actionBookOption.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_dengzsetting"));
        this.actionAutoCheck.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_autocollate"));
        this.actionHandCheck.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_handworkcollate"));
        this.actionCancelCheck.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fallotpopedomforbid"));
        this.actionViewCheck.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_view"));
        this.actionEditCheck.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_edit"));
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    protected void execQuery() {
        try {
            CompanyOrgUnitInfo companyInfo = ((VoucherCheckFilterParam)this.getFilterParam()).getCurrentCompany();
            this.paramMap = new HashMap();
            this.paramMap.put("currentCompany", companyInfo);
            this.paramMap.put("currentPeriod", companyInfo);
            this.paramMap.put("CS001", companyInfo);
            this.paramMap.put("association", companyInfo);
            this.paramMap.put("GL_047", companyInfo);
            this.paramMap.put("CS119", companyInfo);
            this.paramMap = VoucherCheckUIFacadeFactory.getRemoteInstance().fetchData(this.paramMap);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.mainQuery.getSorter().add(new SorterItemInfo("voucherType.name"));
        this.mainQuery.getSorter().add(new SorterItemInfo("number"));
        this.mainQuery.getSorter().add(new SorterItemInfo("bookedDate"));
        this.mainQuery.getSorter().add(new SorterItemInfo("entries.seq"));
        this.mainQuery.setSorter(this.mainQuery.getSorter());
        super.execQuery();
    }

    private void setCurrencyFormat(int first, int last) {
        String numberFtm = null;
        IRow row = null;
        String currencyId = null;
        for (int i = first; i <= last; ++i) {
            if (i >= this.tblMain.getRowCount3() || this.tblMain.getRow(i) == null) continue;
            row = this.tblMain.getRow(i);
            currencyId = (String)row.getCell("currency.id").getValue();
            if (null != currencyId) {
                numberFtm = FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)currencyId));
            }
            row.getCell("localAmountDebit").getStyleAttributes().setNumberFormat(numberFtm);
            row.getCell("localAmountCredit").getStyleAttributes().setNumberFormat(numberFtm);
            row.getCell("localAmountDebit").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            row.getCell("localAmountCredit").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    @Override
    public void actionBookOption_actionPerformed(ActionEvent e) throws Exception {
        VoucherCheckFilterParam param = (VoucherCheckFilterParam)this.getFilterParam();
        BookUserOptionUI.showDialogWindows((IUIObject)this, param.getCurrentCompany());
    }

    @Override
    public void actionAutoCheck_actionPerformed(ActionEvent e) throws Exception {
        boolean sucess;
        PermissionFactory.getRemoteInstance().checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (IObjectPK)new ObjectUuidPK(this.companyInfo.getId().toString()), "cas_voucher_02check");
        FMClientHelper.checkSelected((Component)((Object)this), (KDTable)this.tblMain);
        PeriodInfo currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.companyInfo);
        String voucherId = null;
        IVoucher voucher = VoucherFactory.getRemoteInstance();
        ArrayList idList = this.getSelectedIdValues();
        int size = idList.size();
        if (size <= 0) {
            return;
        }
        if (size == 1 && CashHelper.checkVoucherBookDate(voucherId = this.getSelectedKeyValue(), this.companyInfo, true) == 0 && (sucess = VoucherEditUI.voucherAutoCheck((CoreUIObject)this, (String)voucherId, (CompanyOrgUnitInfo)this.companyInfo))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"checkSuccess"));
            this.refreshList();
            this.tblMain.getGroupManager().group();
        }
        if (size > 1) {
            boolean b;
            Map map = UserOptionFactory.getRemoteInstance().getUserOptionMap(null, this.companyInfo.getId().toString(), BookUserOptionUI.class.getName(), null);
            boolean isByAppointTime = false;
            if (map != null) {
                isByAppointTime = new Boolean((String)map.get("kDRadioButtonAppointTime"));
            }
            if (isByAppointTime && (b = BookAppointDateUI.showDialogWindows((IUIObject)this))) {
                SysUtil.abort();
            }
            int successNum = 0;
            ArrayList<String> realIdList = new ArrayList<String>();
            ArrayList arrayList = this.tblMain.getSelectManager().getBlocks();
            IBlock selectBlock = null;
            IRow row = null;
            for (int i = 0; i < arrayList.size(); ++i) {
                String oldVoucherId = null;
                selectBlock = KDTSelectBlock.change((KDTable)this.tblMain, (IBlock)this.tblMain.getSelectManager().get(i));
                for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                    row = this.tblMain.getRow(j);
                    voucherId = (String)row.getCell("id").getValue();
                    if (voucherId.equals(oldVoucherId)) continue;
                    oldVoucherId = voucherId;
                    Boolean isCheck = (Boolean)row.getCell("isCheck").getValue();
                    if (isCheck.booleanValue()) continue;
                    realIdList.add(voucherId);
                }
            }
            ArrayList<String> finalIdList = new ArrayList<String>();
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(this.getFilterInfoByID(realIdList));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("bookedDate"));
            sic.add(new SelectorItemInfo("bizDate"));
            sic.add(new SelectorItemInfo("company.id"));
            sic.add(new SelectorItemInfo("company.name"));
            view.setSelector(sic);
            for (VoucherInfo voucherInfo : voucher.getVoucherCollection(view)) {
                Date voucherBookDate = this.getVoucherBookDate(voucherInfo, currPeriodInfo);
                int result = 0;
                if (currPeriodInfo != null && voucherBookDate != null && currPeriodInfo.getBeginDate().after(voucherBookDate)) {
                    result = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"393_VoucherCheckListUI", (Object[])new Object[]{voucherInfo.getNumber()}));
                }
                if (result != 0) continue;
                finalIdList.add(voucherInfo.getId().toString());
                ++successNum;
            }
            if (finalIdList.size() > 0) {
                voucher.checkVoucherCollection(finalIdList);
            }
            if (successNum > 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"checkSuccess"));
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"hasNotValidRecord"));
            }
            this.refreshList();
            this.tblMain.getGroupManager().group();
        }
    }

    public Date getVoucherBookDate(VoucherInfo voucherInfo, PeriodInfo currPeriod) throws EASBizException, BOSException {
        Map bookUserMap = this.iUserOption.getUserOptionMap("com.kingdee.eas.fi.cas.client.BookUserOptionUI");
        Map bookAppointMap = this.iUserOption.getUserOptionMap("com.kingdee.eas.fi.cas.client.BookAppointDateUI");
        boolean isBySystemTime = false;
        boolean isByBillTime = true;
        boolean isByBizTime = false;
        boolean isByAppointTime = false;
        if (bookUserMap != null) {
            isBySystemTime = new Boolean((String)bookUserMap.get("kDRadioButtonSystemTime"));
            isByBillTime = new Boolean((String)bookUserMap.get("kDRadioButtonBillTime"));
            isByBizTime = new Boolean((String)bookUserMap.get("kDRadioButtonBizTime"));
            isByAppointTime = new Boolean((String)bookUserMap.get("kDRadioButtonAppointTime"));
        }
        Date bookDate = null;
        if (isBySystemTime) {
            bookDate = DateHelper.getDayBegin();
        } else if (isByBillTime) {
            bookDate = voucherInfo.getBookedDate();
        } else if (isByAppointTime) {
            Map bookDateMap = bookAppointMap;
            bookDate = bookDateMap != null && bookDateMap.get("dpkBookDate") != null ? DateHelper.stringToDate((String)((String)bookDateMap.get("dpkBookDate"))) : voucherInfo.getBookedDate();
        } else if (isByBizTime && (bookDate = voucherInfo.getBizDate()).before(currPeriod.getBeginDate())) {
            String number;
            String company;
            String message = EASResource.getString((String)resourcePath, (String)"bookDateConfig");
            String detail = MessageFormat.format(message, company = voucherInfo.getCompany().getName(), number = voucherInfo.getNumber());
            if (MsgBox.showConfirm2((String)detail) == 2) {
                SysUtil.abort();
            }
            bookDate = currPeriod.getBeginDate();
        }
        return bookDate;
    }

    private FilterInfo getFilterInfoByID(List idList) throws BOSException {
        FilterInfo filter = new FilterInfo();
        StringBuffer strFilter = new StringBuffer("");
        for (int i = 0; i < idList.size(); ++i) {
            String strID = idList.get(i).toString();
            if (i > 0) {
                strFilter.append(",");
            }
            strFilter.append(strID);
        }
        FilterInfo filterID = new FilterInfo();
        filterID.getFilterItems().add(new FilterItemInfo("id", (Object)strFilter.toString(), CompareType.INCLUDE));
        filter.mergeFilter(filterID, "and");
        return filter;
    }

    @Override
    public void actionEditCheck_actionPerformed(ActionEvent e) throws Exception {
        FMClientHelper.checkSelected((Component)((Object)this), (KDTable)this.tblMain);
        IBookNotifyFacade bookNotifyFacade = BookNotifyFacadeFactory.getRemoteInstance();
        String voucherId = this.getSelectedKeyValue();
        bookNotifyFacade.checkStatus(voucherId);
        JournalCollection journalCollection = VoucherBookNotifyUI.showDialogWindows((IUIObject)this, "com.kingdee.eas.fi.gl.VoucherBookNotifyBuilder", voucherId, "EDIT");
        if (journalCollection == null || journalCollection.size() == 0) {
            SysUtil.abort();
        }
        bookNotifyFacade.bookModify(voucherId, journalCollection);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"VoucherCheckEditSucess"));
        this.refreshList();
        this.tblMain.getGroupManager().group();
    }

    @Override
    public void actionHandCheck_actionPerformed(ActionEvent e) throws Exception {
        PermissionFactory.getRemoteInstance().checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (IObjectPK)new ObjectUuidPK(this.companyInfo.getId().toString()), "cas_voucher_02check");
        super.actionHandCheck_actionPerformed(e);
        FMClientHelper.checkSelected((Component)((Object)this), (KDTable)this.tblMain);
        String voucherId = this.getSelectedKeyValue();
        if (CashHelper.checkVoucherBookDate(voucherId, this.companyInfo, false) == 0) {
            VoucherEditUI.voucherHandCheck((CoreUIObject)this, (String)voucherId);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"checkSuccess"));
        }
        this.refreshList();
        this.tblMain.getGroupManager().group();
    }

    @Override
    public void actionViewCheck_actionPerformed(ActionEvent e) throws Exception {
        FMClientHelper.checkSelected((Component)((Object)this), (KDTable)this.tblMain);
        VoucherEditUI.voucherViewCheck((CoreUIObject)this, (String)this.getSelectedKeyValue());
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        PermissionFactory.getRemoteInstance().checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (IObjectPK)new ObjectUuidPK(this.companyInfo.getId().toString()), "cas_voucher_04print");
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        PermissionFactory.getRemoteInstance().checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (IObjectPK)new ObjectUuidPK(this.companyInfo.getId().toString()), "cas_voucher_04print");
        super.actionPrintPreview_actionPerformed(e);
    }

    @Override
    public void actionCancelCheck_actionPerformed(ActionEvent e) throws Exception {
        PermissionFactory.getRemoteInstance().checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (IObjectPK)new ObjectUuidPK(this.companyInfo.getId().toString()), "cas_voucher_03cancelCheck");
        FMClientHelper.checkSelected((Component)((Object)this), (KDTable)this.tblMain);
        String voucherId = null;
        IVoucher voucher = VoucherFactory.getRemoteInstance();
        ArrayList idList = this.getSelectedIdValues();
        int size = idList.size();
        if (size <= 0) {
            return;
        }
        boolean checkMustCheck = ContextHelperFactory.getRemoteInstance().getBooleanParam("GL_0493", (IObjectPK)new ObjectUuidPK(this.companyInfo.getId()));
        UserInfo currentUser = ContextHelperFactory.getRemoteInstance().getCurrentUser();
        if (size == 1) {
            voucherId = this.getSelectedKeyValue();
            voucher.checkVoucherValidForChecking(voucherId, VoucherOperateStatusEnum.ANTICHECK);
            PeriodInfo currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.companyInfo);
            if (CheckUtils.exist((Object)currPeriodInfo) && currPeriodInfo.isIsAdjustPeriod()) {
                throw new FMException(FMException.CURRPERIODISADJUST);
            }
            int rowindex = this.tblMain.getSelectManager().getActiveRowIndex();
            String cashier = (String)this.tblMain.getRow(rowindex).getCell("cashier.id").getValue();
            if (checkMustCheck && !currentUser.getId().toString().equals(cashier)) {
                throw new VoucherException(VoucherException.CHECKMUSTCHECK);
            }
            voucher.antiCheckVoucher((IObjectPK)new ObjectUuidPK(voucherId));
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"antiCheckSuccess"));
            this.refreshList();
            this.tblMain.getGroupManager().group();
        } else if (size > 1) {
            int successNum = 0;
            ArrayList arrayList = this.tblMain.getSelectManager().getBlocks();
            String oldVoucherId = null;
            IBlock selectBlock = null;
            int size1 = arrayList.size();
            for (int i = 0; i < size1; ++i) {
                selectBlock = KDTSelectBlock.change((KDTable)this.tblMain, (IBlock)this.tblMain.getSelectManager().get(i));
                IRow row = null;
                for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                    row = this.tblMain.getRow(j);
                    voucherId = (String)row.getCell("id").getValue();
                    if (voucherId.equals(oldVoucherId)) continue;
                    oldVoucherId = voucherId;
                    Boolean isCheck = (Boolean)row.getCell("isCheck").getValue();
                    if (!isCheck.booleanValue()) continue;
                    String cashier = (String)row.getCell("cashier.id").getValue();
                    if (checkMustCheck && !currentUser.getId().toString().equals(cashier)) {
                        throw new VoucherException(VoucherException.CHECKMUSTCHECK);
                    }
                    VoucherInfo voucherInfo = (VoucherInfo)DynamicUtils.getInfo((Object[])new Object[]{ConvertUtils.PK((Object)voucherId), ConvertUtils.SIC((Object[])new Object[]{"period.*"})});
                    if (CheckUtils.exist((Object)voucherInfo.getPeriod()) && voucherInfo.getPeriod().isIsAdjustPeriod()) {
                        throw new FMException(FMException.CURRPERIODISADJUST);
                    }
                    voucher.antiCheckVoucher((IObjectPK)new ObjectUuidPK(voucherId));
                    ++successNum;
                }
            }
            if (successNum > 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"antiCheckSuccess"));
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"hasNotValidRecord"));
            }
            this.refreshList();
            this.tblMain.getGroupManager().group();
        }
    }

    protected String getEditUIName() {
        return VoucherEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return VoucherFactory.getRemoteInstance();
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        this.changeButtonStatus();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1) {
            CompanyOrgUnitInfo companyInfo = ((VoucherCheckFilterParam)this.getFilterParam()).getCurrentCompany();
            this.getUIContext().put("companyId", companyInfo.getId().toString());
            this.getUIContext().put("company", companyInfo);
            super.tblMain_tableClicked(e);
            this.getUIContext().remove("companyId");
            this.getUIContext().remove("company");
            return;
        }
        if (this.isOrderForClickTableHead() && e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
            if (e.getColIndex() == 3 || e.getColIndex() == 4) {
                this.getUIContext().put("companyId", this.companyInfo.getId().toString());
                this.getUIContext().put("company", this.companyInfo);
                super.tblMain_tableClicked(e);
                this.getUIContext().remove("companyId");
                this.getUIContext().remove("company");
            } else {
                return;
            }
        }
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"companyId", (Object)this.companyInfo.getId().toString());
        uiContext.put((Object)"company", (Object)this.companyInfo);
    }

    public void changeButtonStatus() {
        int rowNumber = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        if (rowNumber < 0) {
            return;
        }
        IRow row = this.tblMain.getRow(rowNumber);
        if (row.getCell("isCheck").getValue() == null) {
            return;
        }
        Boolean isCheck = (Boolean)row.getCell("isCheck").getValue();
        this.actionAutoCheck.setEnabled(isCheck == false);
        this.actionHandCheck.setEnabled(isCheck == false);
        this.actionEditCheck.setEnabled(isCheck);
        this.actionViewCheck.setEnabled(isCheck);
        this.actionCancelCheck.setEnabled(isCheck);
        Set idList = FMClientHelper.getSelectedRows((KDTable)this.tblMain);
        if (idList != null && idList.size() > 1) {
            this.actionAutoCheck.setEnabled(true);
            this.actionCancelCheck.setEnabled(true);
        }
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new VoucherCheckFilterUI(this.paramMap);
        }
        return this.filterUI;
    }

    public static void main(String[] args) throws BOSException, ParserException {
        FMLoginModel.newInstance().login("aaa", "", "eas", "Oracle0916");
        MetaDataPK pk = new MetaDataPK("com.kingdee.eas.fi.cas", "VoucherCheckQuery");
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)pk);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("entrieList.account.number", (Object)"ddd"));
        exec.setObjectView(ev);
    }

    public String[] getMergeColumnKeys() {
        String[] columnKeys = new String[]{"id", "bookedDate", "period", "voucherType.name", "number", "creator.name", "cashier.name", "auditor.name"};
        return columnKeys;
    }

    protected String[] getNotOrderColumns() {
        String[] columnKeys = new String[]{"entries.description", "voucherEntriesAccount.number", "voucherEntriesAccount.name", "vouocherEntriesCurrency.id", "vouocherEntriesCurrency.name", "localAmountDebit", "localAmountCredit"};
        return columnKeys;
    }

    public IUIObject getInstance(Map arg0) {
        try {
            this.preProcess();
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
        boolean CS119_Value = true;
        CS119_Value = this.paramMap.get("CS119") == null ? true : (Boolean)this.paramMap.get("CS119");
        if (!CS119_Value) {
            try {
                return new VoucherCheckByEntryListUI();
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return super.getInstance(arg0);
    }

    protected CommonQueryProcessor getQueryProcessor() {
        return new CheckQueryProcessor();
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exc = super.getQueryExecutor(queryPK, viewInfo);
        return exc;
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        FMFilterBaseUI filterUI = this.getFilterUI();
        FilterParam customFilterParam = null;
        if (filterUI != null) {
            customFilterParam = (FilterParam)filterUI.getParam();
        }
        this.executeQuery(customFilterParam);
    }

    public void executeQuery(FilterParam param) throws BOSException {
        Object sels = this.filterUI.getMainOrg().getValue();
        if (sels != null && sels instanceof CompanyOrgUnitInfo) {
            this.companyInfo = (CompanyOrgUnitInfo)sels;
        }
        super.executeQuery(param);
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            VoucherCheckListUI.this.setCurrencyFormat(e.getFirstRow(), e.getLastRow());
        }
    }
}

