/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.NewHROF7;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.CashManagementFactory;
import com.kingdee.eas.fi.cas.VoucherAccountTypeEnum;
import com.kingdee.eas.fi.cas.VoucherImport2JournalFilterParam;
import com.kingdee.eas.fi.cas.client.AbstractVoucherImport2JournalByEntryFilterUI;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fi.cas.client.PeriodHelper;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.framework.ContextTypeEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.SpinnerUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class VoucherImport2JournalByEntryFilterUI
extends AbstractVoucherImport2JournalByEntryFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(VoucherImport2JournalByEntryFilterUI.class);
    private IAccountView accountView = null;
    private CompanyOrgUnitInfo company = null;
    public static final String resource = "com.kingdee.eas.fi.cas.CasResources";

    protected KDDialog initDialog() throws Exception {
        return null;
    }

    protected void init() throws Exception {
        super.init();
        this.radByPeriod.setSelected(true);
        this.comboAccountType.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.comboAccountType.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
        CashHelper.initCombCurrency(this.comboCurrency, false);
        this.comboCurrency.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.comboCurrency.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.initAccountTypeListener();
        this.btnCompanySelect.setVisible(false);
        if (EmptyUtil.isEmpty((CoreBaseInfo)this.company)) {
            this.company = this.getCompanyOrgUnitInfoByUserPermisson();
        }
        this.prmtCompany.setValue((Object)this.company);
        if (EmptyUtil.isEmpty((Object)this.prmtCompany.getValue())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"456_OutStandingFilterUI"));
            SysUtil.abort();
        }
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
        PeriodHelper.initPeriodSpinner(companyInfo, this.spiBeginYear, this.spiBeginMonth, this.spiEndYear, this.spiEndMonth);
        PeriodEntity pe = new PeriodEntity(CashManagementFactory.getRemoteInstance().getPeriodRange(this.currentCompany, SystemEnum.CASHMANAGEMENT));
        SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.spiBeginYear, (KDSpinner)this.spiBeginMonth, (KDSpinner)this.spiEndYear, (KDSpinner)this.spiEndMonth, (boolean)false, (boolean)false);
    }

    private CompanyOrgUnitInfo getCompanyOrgUnitInfoByUserPermisson() throws EASBizException, BOSException, SQLException {
        if (this.checkCurrentCompany()) {
            return this.currentCompany;
        }
        HashSet<String> idSet = new HashSet<String>();
        try {
            String sql = "select FOrgUnitID from T_BAS_ParamItem where FKeyID in(select fid from T_BAS_Param where fnumber = 'CS001')  and (FValue_L2 = '0' or FValue_L2 = '2')";
            IRowSet rowSet = SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
            while (rowSet.next()) {
                String id = (String)rowSet.getObject("FOrgUnitID");
                if (EmptyUtil.isEmpty((String)id)) continue;
                idSet.add(id);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        Set<String> validCompanySet = this.getStartPeriodOrgRange(idSet);
        CompanyOrgUnitCollection companyColl = FMHelper.getUserOrgRangesWithRange(null, (String)this.getPermissionItem(), validCompanySet);
        for (int i = 0; i < companyColl.size(); ++i) {
            CompanyOrgUnitInfo info = companyColl.get(i);
            if (info.isIsBizUnit() && !info.isIsOUSealUp() && !info.isIsAssistantOrg()) continue;
            companyColl.remove(companyColl.get(i));
        }
        if (companyColl.size() > 0) {
            if (companyColl.contains((Object)BOSUuid.read((String)this.currentCompany.getId().toString()))) {
                return this.currentCompany;
            }
            return companyColl.get(0);
        }
        return null;
    }

    private Set<String> getStartPeriodOrgRange(Set<String> companySet) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select FCompanyID from T_BD_SystemStatusCtrol sysStaCtr,T_BD_SystemStatus sysSta ");
        sql.append(" where sysStaCtr.FSystemStatusID=sysSta.FID ");
        sql.append(" and FStartPeriodID is not null and sysStaCtr.FCompanyID in ");
        sql.append(FMHelper.setTran2String(companySet));
        sql.append(" and sysSta.FName= ");
        sql.append(7);
        IRowSet rowSet = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
        HashSet<String> idSet = new HashSet<String>();
        while (rowSet.next()) {
            idSet.add(rowSet.getString("FCompanyID"));
        }
        return idSet;
    }

    private boolean checkCurrentCompany() throws EASBizException, BOSException, SQLException {
        if (this.currentCompany.isIsBizUnit() && !this.currentCompany.isIsOUSealUp() && !this.currentCompany.isIsAssistantOrg()) {
            PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.currentCompany);
            if (null == startPeriod) {
                return false;
            }
        } else {
            return false;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("SystemStatus.name", (Object)String.valueOf(7)));
        filter.getFilterItems().add(new FilterItemInfo("isRelatedAccount", (Object)Boolean.TRUE));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString()));
        boolean isAssociation = SystemStatusCtrolFactory.getRemoteInstance().exists(filter);
        if (!isAssociation) {
            return false;
        }
        String sql = "select FOrgUnitID from T_BAS_ParamItem where FKeyID in (select fid from T_BAS_Param where fnumber = 'CS001') and FValue_L2 ='1' and FOrgUnitID = '" + this.currentCompany.getId().toString() + "'";
        IRowSet rowSet = SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
        if (!rowSet.next()) {
            return false;
        }
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        IPermission permission = PermissionFactory.getRemoteInstance();
        boolean hasPermission = permission.hasFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId()), (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()), "cas_voucherimport_01view");
        return hasPermission;
    }

    private void initAccountTypeListener() {
        this.prmtBank.setEnabled(false);
        this.prmtBank.setData(null);
        this.comboAccountType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getItem().equals((Object)VoucherAccountTypeEnum.CASH)) {
                    VoucherImport2JournalByEntryFilterUI.this.prmtBank.setEnabled(false);
                    VoucherImport2JournalByEntryFilterUI.this.prmtBank.setData(null);
                } else if (e.getItem().equals((Object)VoucherAccountTypeEnum.BANK)) {
                    VoucherImport2JournalByEntryFilterUI.this.prmtBank.setEnabled(true);
                    VoucherImport2JournalByEntryFilterUI.this.prmtBank.setEditFormat("$number$");
                    VoucherImport2JournalByEntryFilterUI.this.prmtBank.setDisplayFormat("$number$");
                    VoucherImport2JournalByEntryFilterUI.this.prmtBank.setCommitFormat("$number$");
                    VoucherImport2JournalByEntryFilterUI.this.prmtBank.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)VoucherImport2JournalByEntryFilterUI.this.currentCompany.getId().toString()));
                    filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Boolean(false)));
                    EntityViewInfo evi = new EntityViewInfo();
                    evi.setFilter(filter);
                    VoucherImport2JournalByEntryFilterUI.this.prmtBank.setEntityViewInfo(evi);
                } else {
                    VoucherImport2JournalByEntryFilterUI.this.prmtBank.setEnabled(false);
                    VoucherImport2JournalByEntryFilterUI.this.prmtBank.setData(null);
                }
            }
        });
    }

    @Override
    protected void radByPeriodOrDate_stateChanged(ChangeEvent e) throws Exception {
        if (!this.radByPeriod.isSelected()) {
            this.pnlByPeriod.setVisible(false);
            this.pnlByDate.setVisible(true);
        } else {
            this.pnlByPeriod.setVisible(true);
            this.pnlByDate.setVisible(false);
        }
    }

    @Override
    protected void spiBeginMonth_stateChanged(ChangeEvent e) throws Exception {
        PeriodHelper.periodChange(this.spiBeginYear, this.spiBeginMonth, this.spiEndYear, this.spiEndMonth);
    }

    @Override
    protected void spiBeginYear_stateChanged(ChangeEvent e) throws Exception {
        PeriodHelper.periodChange(this.spiBeginYear, this.spiBeginMonth, this.spiEndYear, this.spiEndMonth);
        try {
            CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            PeriodHelper.setPeriodNum(companyInfo, this.spiBeginMonth, (Integer)this.spiBeginYear.getValue());
        }
        catch (Exception ex) {
            SysUtil.abort((Throwable)ex);
        }
    }

    @Override
    protected void spiEndMonth_stateChanged(ChangeEvent e) throws Exception {
        PeriodHelper.periodChange(this.spiBeginYear, this.spiBeginMonth, this.spiEndYear, this.spiEndMonth);
    }

    @Override
    protected void spiEndYear_stateChanged(ChangeEvent e) throws Exception {
        PeriodHelper.periodChange(this.spiBeginYear, this.spiBeginMonth, this.spiEndYear, this.spiEndMonth);
        try {
            CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            PeriodHelper.setPeriodNum(companyInfo, this.spiEndMonth, (Integer)this.spiEndYear.getValue());
        }
        catch (Exception ex) {
            SysUtil.abort((Throwable)ex);
        }
    }

    private EntityViewInfo setFilterForAccount() {
        FilterInfo aFilter = new FilterInfo();
        if (this.comboAccountType.getSelectedItem().equals((Object)VoucherAccountTypeEnum.CASH)) {
            aFilter.getFilterItems().add(new FilterItemInfo("isCash", (Object)new Integer(1)));
        } else if (this.comboAccountType.getSelectedItem().equals((Object)VoucherAccountTypeEnum.BANK)) {
            aFilter.getFilterItems().add(new FilterItemInfo("isBank", (Object)new Integer(1)));
        } else {
            aFilter.getFilterItems().add(new FilterItemInfo("isCash", (Object)new Integer(1)));
            aFilter.getFilterItems().add(new FilterItemInfo("isBank", (Object)new Integer(1)));
            aFilter.setMaskString("#0 or #1");
        }
        AccountPromptBox acctPromptBox = new AccountPromptBox((IUIObject)this, this.currentCompany, aFilter, false, true);
        this.prmtAccountFrom.setSelector((KDPromptSelector)acctPromptBox);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)this.currentCompany.getAccountTable().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)this.currentCompany.getId().toString()));
        if (this.comboAccountType.getSelectedItem().equals((Object)VoucherAccountTypeEnum.CASH)) {
            filter.getFilterItems().add(new FilterItemInfo("isCash", (Object)new Integer(1)));
            filter.setMaskString("#0 and #1 and #2");
        } else if (this.comboAccountType.getSelectedItem().equals((Object)VoucherAccountTypeEnum.BANK)) {
            filter.getFilterItems().add(new FilterItemInfo("isBank", (Object)new Integer(1)));
            filter.setMaskString("#0 and #1 and #2");
        } else {
            filter.getFilterItems().add(new FilterItemInfo("isCash", (Object)new Integer(1)));
            filter.getFilterItems().add(new FilterItemInfo("isBank", (Object)new Integer(1)));
            filter.setMaskString("#0 and #1 and (#2 or #3)");
        }
        evi.setFilter(filter);
        return evi;
    }

    @Override
    protected void prmtAccountFrom_willCommit(CommitEvent e) throws Exception {
        super.prmtAccountFrom_willCommit(e);
        this.prmtAccountFrom.setEntityViewInfo(this.setFilterForAccount());
        this.prmtAccountFrom.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void prmtAccountTo_willCommit(CommitEvent e) throws Exception {
        super.prmtAccountTo_willCommit(e);
        this.prmtAccountTo.setEntityViewInfo(this.setFilterForAccount());
        this.prmtAccountTo.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void comboAccountType_actionPerformed(ActionEvent e) throws Exception {
        super.comboAccountType_actionPerformed(e);
        this.resetAccount();
    }

    private void resetAccount() {
        FilterInfo accountFilter = new FilterInfo();
        if (this.comboAccountType.getSelectedItem().equals((Object)VoucherAccountTypeEnum.CASH)) {
            accountFilter.getFilterItems().add(new FilterItemInfo("isCash", (Object)new Integer(1)));
        } else if (this.comboAccountType.getSelectedItem().equals((Object)VoucherAccountTypeEnum.BANK)) {
            accountFilter.getFilterItems().add(new FilterItemInfo("isBank", (Object)new Integer(1)));
        } else {
            accountFilter.getFilterItems().add(new FilterItemInfo("isCash", (Object)new Integer(1)));
            accountFilter.getFilterItems().add(new FilterItemInfo("isBank", (Object)new Integer(1)));
            accountFilter.setMaskString("#0 or #1");
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)this.currentCompany.getAccountTable().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)this.currentCompany.getId().toString()));
        filter.setMaskString("#0 and #1");
        try {
            accountFilter.mergeFilter(filter, "and");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        AccountPromptBox acctPromptBox = new AccountPromptBox((IUIObject)this, this.currentCompany, accountFilter, false, true);
        this.prmtAccountFrom.setSelector((KDPromptSelector)acctPromptBox);
        this.prmtAccountTo.setSelector((KDPromptSelector)acctPromptBox);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)this.currentCompany.getAccountTable().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)this.currentCompany.getId().toString()));
        evi.setFilter(filterInfo);
        this.prmtAccountFrom.setEntityViewInfo(evi);
        this.prmtAccountTo.setEntityViewInfo(evi);
    }

    public Object getParam() {
        CurrencyInfo currencyInfo;
        AccountViewInfo accountInfo;
        VoucherImport2JournalFilterParam param = new VoucherImport2JournalFilterParam();
        param.setByDate(this.radByDate.isSelected());
        param.setSpiBeginYear(AccessHelper.getSpiValue((KDSpinner)this.spiBeginYear));
        param.setSpiEndYear(AccessHelper.getSpiValue((KDSpinner)this.spiEndYear));
        param.setSpiBeginMonth(AccessHelper.getSpiValue((KDSpinner)this.spiBeginMonth));
        param.setSpiEndMonth(AccessHelper.getSpiValue((KDSpinner)this.spiEndMonth));
        param.setDptFromDate((Date)this.dptFromDate.getValue());
        param.setDptToDate((Date)this.dptToDate.getValue());
        if (this.comboAccountType.getSelectedItem().equals(FMSysDefinedEnum.SELECT_ALL)) {
            param.setAccountType(999);
        } else {
            VoucherAccountTypeEnum accountTypeEnum = (VoucherAccountTypeEnum)((Object)this.comboAccountType.getSelectedItem());
            param.setAccountType(accountTypeEnum.getValue());
        }
        if (this.prmtAccountFrom.getData() != null) {
            accountInfo = (AccountViewInfo)this.prmtAccountFrom.getData();
            param.setAccountNumberFrom(accountInfo.getNumber());
        }
        if (this.prmtAccountTo.getData() != null) {
            accountInfo = (AccountViewInfo)this.prmtAccountTo.getData();
            param.setAccountNumberTo(accountInfo.getNumber());
        }
        if (this.comboCurrency.getSelectedItem() != null && !this.comboCurrency.getSelectedItem().equals(FMSysDefinedEnum.SELECT_ALL) && (currencyInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem()) != null) {
            param.setCurrencyId(currencyInfo.getId().toString());
        }
        if (this.btnChecked.isSelected()) {
            param.setIsChecked(1);
        } else if (this.btnUnChecked.isSelected()) {
            param.setIsChecked(0);
        } else if (this.btnAll.isSelected()) {
            param.setIsChecked(999);
        }
        if (this.comboAccountType.getSelectedItem().equals((Object)VoucherAccountTypeEnum.BANK) && this.prmtBank.getData() != null) {
            AccountBankInfo bankInfo = null;
            HashSet<String> bankSet = new HashSet<String>();
            Object[] obj = (Object[])this.prmtBank.getData();
            for (int i = 0; i < obj.length; ++i) {
                bankInfo = (AccountBankInfo)obj[i];
                bankSet.add(bankInfo.getNumber());
            }
            param.setBank(bankSet);
        }
        param.setCompany((CompanyOrgUnitInfo)this.prmtCompany.getValue());
        return param;
    }

    public void setParam(Object param) {
        AccountViewCollection accountCollection;
        FilterInfo fi;
        EntityViewInfo evi;
        if (param == null) {
            return;
        }
        if (!(param instanceof VoucherImport2JournalFilterParam)) {
            return;
        }
        VoucherImport2JournalFilterParam checkParam = (VoucherImport2JournalFilterParam)param;
        if (EmptyUtil.isEmpty((CoreBaseInfo)checkParam.getCompany())) {
            try {
                this.prmtCompany.setValue((Object)this.getCompanyOrgUnitInfoByUserPermisson());
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        } else {
            this.prmtCompany.setValue((Object)checkParam.getCompany());
        }
        if (checkParam.isByDate()) {
            this.radByDate.setSelected(true);
            this.dptFromDate.setValue((Object)checkParam.getDptFromDate());
            this.dptToDate.setValue((Object)checkParam.getDptToDate());
        } else {
            this.radByPeriod.setSelected(true);
            this.spiBeginYear.setValue((Object)new Integer(checkParam.getSpiBeginYear()));
            this.spiEndYear.setValue((Object)new Integer(checkParam.getSpiEndYear()));
            this.spiBeginMonth.setValue((Object)new Integer(checkParam.getSpiBeginMonth()));
            this.spiEndMonth.setValue((Object)new Integer(checkParam.getSpiEndMonth()));
        }
        if (checkParam.getAccountType() == 999) {
            this.comboAccountType.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
        } else {
            this.comboAccountType.setSelectedItem((Object)VoucherAccountTypeEnum.getEnum(checkParam.getAccountType()));
        }
        if (checkParam.getAccountNumberFrom() != null) {
            evi = new EntityViewInfo();
            fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("number", (Object)checkParam.getAccountNumberFrom()));
            evi.setFilter(fi);
            accountCollection = null;
            try {
                accountCollection = this.getAccountView().getAccountViewCollection(evi);
            }
            catch (BOSException e) {
                SysUtil.abort((Throwable)e);
            }
            if (accountCollection.size() != 0) {
                this.prmtAccountFrom.setData((Object)accountCollection.get(0));
            }
        } else {
            this.prmtAccountFrom.setData(null);
        }
        if (checkParam.getAccountNumberTo() != null) {
            evi = new EntityViewInfo();
            fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("number", (Object)checkParam.getAccountNumberTo()));
            evi.setFilter(fi);
            accountCollection = null;
            try {
                accountCollection = this.getAccountView().getAccountViewCollection(evi);
            }
            catch (BOSException e) {
                SysUtil.abort((Throwable)e);
            }
            if (accountCollection.size() != 0) {
                this.prmtAccountTo.setData((Object)accountCollection.get(0));
            }
        } else {
            this.prmtAccountTo.setData(null);
        }
        if (checkParam.getCurrencyId() != null) {
            CurrencyInfo currencyInfo = null;
            try {
                currencyInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(checkParam.getCurrencyId()));
            }
            catch (Exception e) {
                SysUtil.abort((Throwable)e);
            }
            if (currencyInfo != null) {
                this.comboCurrency.setSelectedItem((Object)currencyInfo);
            }
        } else {
            this.comboCurrency.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
        }
        if (checkParam.getIsChecked() == 1) {
            this.btnChecked.setSelected(true);
        } else if (checkParam.getIsChecked() == 0) {
            this.btnUnChecked.setSelected(true);
        } else if (checkParam.getIsChecked() == 999) {
            this.btnAll.setSelected(true);
        }
        if (checkParam.getAccountType() == 2 && checkParam.getBank() != null) {
            evi = new EntityViewInfo();
            fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("number", (Object)checkParam.getBank(), CompareType.INCLUDE));
            evi.setFilter(fi);
            AccountBankCollection bankCollection = null;
            try {
                bankCollection = AccountBankFactory.getRemoteInstance().getAccountBankCollection(evi);
            }
            catch (BOSException e) {
                SysUtil.abort((Throwable)e);
            }
            if (bankCollection.size() != 0) {
                Object[] obj = new Object[bankCollection.size()];
                for (int i = 0; i < bankCollection.size(); ++i) {
                    obj[i] = bankCollection.get(i);
                }
                this.prmtBank.setData((Object)obj);
            }
        } else {
            this.prmtBank.setData(null);
        }
    }

    public void clear() {
        super.clear();
        try {
            this.comboAccountType.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
            if (EmptyUtil.isEmpty((CoreBaseInfo)this.company)) {
                this.company = this.getCompanyOrgUnitInfoByUserPermisson();
            }
            this.prmtCompany.setValue((Object)this.company);
            PeriodHelper.initPeriodSpinner(this.company, this.spiBeginYear, this.spiBeginMonth, this.spiEndYear, this.spiEndMonth);
            this.comboCurrency.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
            this.radByPeriod.setSelected(true);
            this.btnUnChecked.setSelected(true);
            this.btnUnChecked.setSelected(false);
            this.chkIA.setSelected(false);
            this.btnChecked.setSelected(false);
            this.btnAll.setSelected(false);
            this.prmtAccountFrom.setData(null);
            this.prmtAccountTo.setData(null);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private IAccountView getAccountView() {
        if (this.accountView == null) {
            try {
                this.accountView = AccountViewFactory.getRemoteInstance();
            }
            catch (BOSException e) {
                SysUtil.abort((Throwable)e);
            }
        }
        return this.accountView;
    }

    protected void initMainOrgF7() {
        if (this.getMainOrg() == null) {
            return;
        }
        KDBizPromptBox bizOrgUnitBox = this.getMainOrg();
        this.getMainOrg().setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
        if (bizOrgUnitBox != null) {
            NewOrgUnitFilterInfoProducer iProducer = null;
            String permissionItem = this.getPermissionItem();
            if (ContextTypeEnum.INQUERYING.equals((Object)this.getUIContext())) {
                NewHROF7 model = null;
                if (this.getMainOrgType().equals((Object)OrgType.HRO)) {
                    model = new NewHROF7();
                }
                iProducer = this.isSupportVirturalOrgs() ? new NewOrgUnitFilterInfoProducer(this.getMainOrgType()) : (model != null ? new NewOrgUnitFilterInfoProducer((NewOrgViewF7PromptDialog)model) : new NewOrgUnitFilterInfoProducer(this.getMainOrgType()));
            } else {
                iProducer = new NewOrgUnitFilterInfoProducer(this.getMainOrgType());
            }
            FilterInfo outerFilterInfo = iProducer.getModel().getOuterFilterInfo();
            HashSet<String> idSet = new HashSet<String>();
            try {
                String sql = "select FOrgUnitID from T_BAS_ParamItem where FKeyID in(select fid from T_BAS_Param where fnumber = 'CS001') and (FValue_L2 = '0' or FValue_L2 = '2')";
                IRowSet rowSet = SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
                while (rowSet.next()) {
                    String id = (String)rowSet.getObject("FOrgUnitID");
                    if (EmptyUtil.isEmpty((String)id)) continue;
                    idSet.add(id);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            outerFilterInfo.getFilterItems().add(new FilterItemInfo("unit.id", idSet, CompareType.INCLUDE));
            iProducer.getModel().setOuterFilterInfo(outerFilterInfo);
            if (iProducer != null) {
                if (permissionItem != null) {
                    iProducer.getModel().setPermissionItem(permissionItem);
                }
                bizOrgUnitBox.setFilterInfoProducer((IFilterInfoProducer)iProducer);
                if (iProducer.getModel() != null) {
                    bizOrgUnitBox.setSelector((KDPromptSelector)iProducer.getModel());
                    iProducer.getModel().setMultiSelect(this.isSupportMultiOrgs());
                }
            }
            bizOrgUnitBox.setCommitFormat("$number$;$code$");
            bizOrgUnitBox.setEditFormat("$number$");
            bizOrgUnitBox.setDisplayFormat("$name$");
            bizOrgUnitBox.setEnabledMultiSelection(this.isSupportMultiOrgs());
        }
    }

    public boolean verify() {
        if (EmptyUtil.isEmpty((Object)this.prmtCompany.getValue())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"458_VoucherCheckFilterUI"));
            SysUtil.abort();
        }
        if (this.dptFromDate.getValue() == null || this.dptToDate.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"394_VoucherImport2JournalByEntryFilterUI"));
            SysUtil.abort();
        }
        Date dateFrom = DateTimeUtils.truncateDate((Date)((Date)this.dptFromDate.getValue()));
        Date dateTo = DateTimeUtils.truncateDate((Date)((Date)this.dptToDate.getValue()));
        FMClientVerifyHelper.verifyBeginEndDateRel((CoreUIObject)this, (Date)dateTo, (Date)dateFrom);
        return true;
    }

    protected Class getParamClass() {
        return VoucherImport2JournalFilterParam.class;
    }

    @Override
    protected void prmtCompany_dataChanged(DataChangeEvent e) throws Exception {
        int bookType;
        if (e.getNewValue() == null) {
            e.setNewValue(e.getOldValue());
            return;
        }
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
        ClientUtils.checkCompany((Component)((Object)this), companyInfo);
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        if (currentPeriod == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"395_VoucherImport2JournalByEntryUI"));
            SysUtil.abort();
        }
        if ((bookType = CashHelper.getBookType(companyInfo.getId().toString())) == 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"396_VoucherImport2JournalByEntryUI"));
            SysUtil.abort();
        }
        this.currentCompany = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId().toString()));
        PeriodEntity pe = new PeriodEntity(CashManagementFactory.getRemoteInstance().getPeriodRange(companyInfo, SystemEnum.CASHMANAGEMENT));
        SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.spiBeginYear, (KDSpinner)this.spiBeginMonth, (KDSpinner)this.spiEndYear, (KDSpinner)this.spiEndMonth, (boolean)false, (boolean)false);
        PeriodHelper.initPeriodSpinner(companyInfo, this.spiBeginYear, this.spiBeginMonth, this.spiEndYear, this.spiEndMonth);
        this.resetAccount();
        F7SelectorFactory.initAccountBank((IUIObject)this, (KDBizPromptBox)this.prmtBank, (CompanyOrgUnitInfo)companyInfo);
    }

    public String getPermissionItem() {
        return "cas_voucherimport_01view";
    }

    public KDBizPromptBox getMainOrg() {
        return this.prmtCompany;
    }

    public boolean isSupportMultiOrgs() {
        return false;
    }
}

