/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client.export;

import com.kingdee.bos.ctrl.kdf.excel.ui.ExportEvent;
import com.kingdee.bos.ctrl.kdf.excel.ui.ExportListener;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.cas.client.export.CASExportExcelHelper;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.exportexcel.ExportExcelConfigManager;
import com.kingdee.eas.framework.client.exportexcel.ExportExcelConfigParam;
import com.kingdee.eas.framework.client.exportexcel.ExportExcelConfigUI;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class CASExportExcelConfigUI
extends ExportExcelConfigUI {
    private static final long serialVersionUID = 756492281516388473L;
    private static final Logger logger = CoreUIObject.getLogger(CASExportExcelConfigUI.class);
    private static final int BTNSTATUS_DEFAULT = 0;
    private static final int BTNSTATUS_EXPORTING = 1;
    private static final int BTNSTATUS_EXPORT_COMPLETE = 2;
    private int currentExportStatus = 0;
    private int currentRowIndex = 0;
    private int selectedRowCount = 0;
    private int tableRowCount = 0;
    private CoreUI parentUI = null;
    private KDTable table = null;
    private CASExportExcelHelper helper = null;
    private File excelFile = null;
    protected ExportExcelConfigParam configParam = null;

    public CASExportExcelConfigUI() throws Exception {
        if (this.radioVer2003.isSelected()) {
            this.exportProgress.setStringPainted(false);
        } else {
            this.exportProgress.setStringPainted(true);
        }
        this.exportProgress.repaint();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Map context = super.getUIContext();
        Object parent = context.get("Owner");
        if (parent instanceof CoreUI) {
            this.parentUI = (CoreUI)parent;
        }
        ExcelVersionChangeListener changeListener_version = new ExcelVersionChangeListener();
        ExportSelectChangeListener changeListener_select = new ExportSelectChangeListener();
        this.radioVer2003.setSelected(true);
        this.radioVer2007.setSelected(false);
        this.radioVer2007.addActionListener((ActionListener)changeListener_version);
        this.radioVer2003.addActionListener((ActionListener)changeListener_version);
        this.radioSelect.addActionListener((ActionListener)changeListener_select);
        this.radioFull.addActionListener((ActionListener)changeListener_select);
    }

    private String getDefaultFilePath() {
        String suffix = this.getConfigParamFromUI().isExportExcel2007() ? ".xlsx" : ".xls";
        return this.getSystemTempFile(suffix).getPath();
    }

    protected void initConfigParam(ExportExcelConfigParam configParam) {
        this.configParam = configParam;
        this.radioVer2007.setSelected(configParam.isExportExcel2007());
        this.radioVer2003.setSelected(configParam.isExportExcel2003());
        this.cBoxOpenFile.setSelected(configParam.isOpenFile());
        this.cBoxExportMergeBlocks.setSelected(configParam.isExportMergeBlocks());
        if (configParam.isExportSelect()) {
            this.radioSelect.setSelected(true);
        } else {
            this.radioFull.setSelected(true);
        }
        this.checkExportRowCount();
        this.textPath.setText(new File(configParam.getSavePath(), this.bulidFileName(true)).getAbsolutePath());
        this.updateUIStatus(this.configParam.getExcelVersion(), 0);
    }

    public void onShow() {
    }

    private void updateUIStatus(int version, int status) {
        this.currentExportStatus = status;
        switch (status) {
            case 0: {
                if (!this.btnChoosePath.isEnabled()) {
                    this.btnChoosePath.setEnabled(true);
                }
                if (!this.btnStartExport.isEnabled()) {
                    this.btnStartExport.setEnabled(true);
                }
                if (!this.btnCancel.isEnabled()) {
                    this.btnCancel.setEnabled(true);
                }
                if (1 == version && this.exportProgress.isVisible()) {
                    this.exportProgress.setVisible(true);
                }
                if (0 != version || this.exportProgress.isVisible()) break;
                this.exportProgress.setVisible(true);
                break;
            }
            case 1: {
                logger.info((Object)("export " + this.bulidFileName(false) + " startTime:" + new Date()));
                if (this.btnChoosePath.isEnabled()) {
                    this.btnChoosePath.setEnabled(false);
                }
                if (this.btnStartExport.isEnabled()) {
                    this.btnStartExport.setEnabled(false);
                }
                if (this.btnCancel.isEnabled()) {
                    this.btnCancel.setEnabled(false);
                }
                if (0 == version && !this.exportProgress.isVisible()) {
                    this.exportProgress.setVisible(true);
                    this.exportProgress.setStringPainted(true);
                    this.exportProgress.setIndeterminate(false);
                }
                if (1 != version || this.labExporting_2003.isVisible()) break;
                this.exportProgress.setVisible(true);
                this.exportProgress.setStringPainted(false);
                this.exportProgress.setIndeterminate(true);
                break;
            }
            case 2: {
                logger.info((Object)("export " + this.bulidFileName(false) + " endTime:" + new Date()));
                if (this.btnChoosePath.isEnabled()) {
                    this.btnChoosePath.setEnabled(false);
                }
                if (this.btnStartExport.isVisible()) {
                    this.btnStartExport.setVisible(false);
                }
                if (!this.btnCancel.isEnabled()) {
                    this.btnCancel.setEnabled(true);
                }
                if (this.exportProgress.isVisible()) {
                    this.exportProgress.setVisible(false);
                }
                if (1 != version || this.labExporting_2003.isVisible()) {
                    // empty if block
                }
                if (this.labExportSuccess.isVisible()) break;
                this.labExportSuccess.setForeground(Color.RED);
                this.labExportSuccess.setVisible(true);
                break;
            }
            default: {
                logger.error((Object)("status error:" + status));
            }
        }
        String savepath = this.textPath.getText();
        if (version == 0 && savepath.endsWith(".xls")) {
            savepath = savepath.replaceAll(".xls", ".xlsx");
        }
        if (version == 1 && savepath.endsWith(".xlsx")) {
            savepath = savepath.replaceAll(".xlsx", ".xls");
        }
        this.textPath.setText(savepath);
    }

    private boolean isTableRangeNull(KDTable table, boolean isExportSelect) {
        KDTRange range = null;
        if (isExportSelect && (range = table.getSelectManager().toRange()).isEmpty()) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"55_ExportExcelConfigUI"));
            return true;
        }
        return false;
    }

    private ExportExcelConfigParam getConfigParamFromUI() {
        ExportExcelConfigParam uiParam = new ExportExcelConfigParam();
        uiParam.setExcelVersion(this.radioVer2007.isSelected() ? 0 : 1);
        uiParam.setExportMergeBlocks(this.cBoxExportMergeBlocks.isSelected());
        uiParam.setExportSelect(this.radioSelect.isSelected());
        uiParam.setOpenFile(this.cBoxOpenFile.isSelected());
        File file = new File(this.textPath.getText());
        uiParam.setSavePath(file.getParent());
        uiParam.setFileName(file.getName());
        return uiParam;
    }

    public void setCursorOfDefault() {
        Window window = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (window == null) {
            window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        }
        if (window == null) {
            return;
        }
        window.setCursor(Cursor.getDefaultCursor());
    }

    public void handUIException(Throwable throwable) {
        this.setCursorOfDefault();
        if (throwable instanceof AbortException) {
            return;
        }
        super.handUIException(throwable);
    }

    public int getRowCount() {
        return this.tableRowCount;
    }

    public void setRowCount(int rowCount) {
        this.tableRowCount = rowCount;
    }

    public void setTable(KDTable table) {
        this.table = table;
    }

    public void setHelper(CASExportExcelHelper exportExcelHelper) {
        this.helper = exportExcelHelper;
    }

    public void actionChoose_actionPerformed(ActionEvent e) throws Exception {
        this.initSaveDialog();
    }

    public void actionStartExport_actionPerformed(ActionEvent e) throws Exception {
        this.saveConfigParam();
        if (this.isTableRangeNull(this.table, this.getConfigParamFromUI().isExportSelect())) {
            return;
        }
        ExportListener[] listeners = this.getDefaultExportListeners();
        ExportRunnable exportRunnable = new ExportRunnable(this.getConfigParamFromUI(), listeners);
        Thread exportThread = new Thread(exportRunnable);
        exportThread.setDaemon(true);
        exportThread.start();
    }

    private ExportListener[] getDefaultExportListeners() {
        ExportListener[] listenerArr = new ExportListener[1];
        ExportExcelConfigParam param = this.getConfigParamFromUI();
        if (param.isExportExcel2007()) {
            ExportListener2007 listener = new ExportListener2007(param);
            listenerArr[0] = listener;
        } else {
            ExportListener2003 listener = new ExportListener2003(param);
            listenerArr[0] = listener;
        }
        return listenerArr;
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        if (this.currentExportStatus == 1) {
            this.currentExportStatus = 0;
        }
        this.disposeUIWindow();
    }

    private void saveConfigParam() {
        ExportExcelConfigParam newParam = this.getConfigParamFromUI();
        if (!this.configParam.equals((Object)newParam)) {
            ExportExcelConfigManager.saveExportExcelConfig((ExportExcelConfigParam)newParam);
            this.configParam = newParam;
        }
    }

    private void initSaveDialog() throws Exception {
        KDFileChooser fileChooser = this.initKDFileChooser();
        this.excelFile = this.getConfigParamFromUI().isExportExcel2007() ? this.initFile(fileChooser, ".xlsx") : this.initFile(fileChooser, ".xls");
    }

    private KDFileChooser initKDFileChooser() throws Exception {
        String title = !this.getConfigParamFromUI().isExportSelect() ? EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_ExportToExcel") : EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_ExportSelected");
        String FileName = this.bulidFileName(true);
        if (this.getConfigParamFromUI() != null) {
            String suffix = this.getConfigParamFromUI().isExportExcel2007() ? ".xlsx" : ".xls";
            KDFileChooser fileChooser = this.getKDFileChooser(title, this.configParam.getSavePath(), FileName, suffix);
            return fileChooser;
        }
        return null;
    }

    private String bulidFileName(boolean isShowTime) {
        String dateTime = "";
        if (isShowTime) {
            SimpleDateFormat tempDate = new SimpleDateFormat("yyyyMMddHHmmss");
            dateTime = tempDate.format(new Date());
        }
        StringBuffer name = new StringBuffer();
        if (this.parentUI != null) {
            String fileName = FrameWorkUtils.getTrimFileName((String)this.parentUI.getUITitle());
            name.append(fileName).append(dateTime);
        } else {
            name.append(dateTime);
        }
        if (this.getConfigParamFromUI().isExportExcel2007()) {
            name.append(".xlsx");
        } else {
            name.append(".xls");
        }
        return name.toString();
    }

    private File initFile(KDFileChooser fileChooser, String suffix) throws Exception {
        if (fileChooser != null) {
            int result = fileChooser.showSaveDialog(null);
            File file = fileChooser.getSelectedFile();
            if (result != 0) {
                return null;
            }
            if (!file.getAbsolutePath().endsWith(suffix)) {
                file = new File(file.getAbsolutePath() + suffix);
            }
            if (file.exists()) {
                int select = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"56_ExportExcelConfigUI"));
                if (select == 2) {
                    return null;
                }
                if (select == 0 && !file.renameTo(file)) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"57_ExportExcelConfigUI"));
                    return null;
                }
            }
            this.textPath.setText(file.getAbsolutePath());
            return file;
        }
        return null;
    }

    private KDFileChooser getKDFileChooser(String title, String path, String fileName, String suffix) throws Exception {
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setDialogTitle(title);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setSelectedFile(new File(path, fileName));
        fileChooser.setFileFilter(this.bulidFilter(suffix));
        return fileChooser;
    }

    private void openExcelFile(String fileName) throws IOException {
        if (fileName != null) {
            try {
                KDTMenuManager.openFileInExcel((String)fileName);
            }
            catch (IOException e) {
                throw new IOException("openfile error:" + fileName);
            }
        } else {
            throw new IOException("file not exist:" + fileName);
        }
    }

    private FileFilter bulidFilter(final String suffix) throws Exception {
        FileFilter fileFilter = new FileFilter(){
            private static final String suffix_2003 = "xls";
            private static final String suffix_2007 = "xlsx";

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String extension = this.getExtension(f);
                if (extension != null) {
                    return extension.equalsIgnoreCase(this.getFilterSuffix());
                }
                return false;
            }

            private String getExtension(File f) {
                String ext = null;
                String fileName = f.getName();
                int i = fileName.lastIndexOf(".");
                if (i > 0 && i < fileName.length() - 1) {
                    ext = fileName.substring(i + 1).toLowerCase();
                }
                return ext;
            }

            @Override
            public String getDescription() {
                return suffix + "(*." + this.getFilterSuffix() + ")";
            }

            private String getFilterSuffix() {
                if (".xlsx".equals(suffix)) {
                    return suffix_2007;
                }
                return suffix_2003;
            }
        };
        return fileFilter;
    }

    public File getSystemTempFile(String suffix) {
        File tempFile = null;
        try {
            tempFile = File.createTempFile("eastemp", suffix);
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        return tempFile;
    }

    public void disposeUIWindow() {
        if (this.currentExportStatus != 1) {
            super.disposeUIWindow();
        }
    }

    protected void checkExportRowCount() {
        int rowCount;
        int n = rowCount = this.radioSelect.isSelected() ? this.selectedRowCount : this.tableRowCount;
        if (rowCount > ExportExcelConfigParam.EXCEL2003_MAXROWS_VALUE || this.table.getColumnCount() > 255) {
            this.updateUIStatus(0, this.currentExportStatus);
            this.radioVer2007.setSelected(true);
            this.radioVer2003.setEnabled(false);
            String message = this.labMessage.getText();
            message = MessageFormat.format(message, String.valueOf(ExportExcelConfigParam.EXCEL2003_MAXROWS_VALUE));
            this.labMessage.setText(message);
            this.labMessage.setVisible(true);
        } else {
            this.radioVer2003.setEnabled(true);
            this.labMessage.setVisible(false);
        }
    }

    public void setSelectedRowCount(int rowCount) {
        this.selectedRowCount = rowCount;
    }

    class ExportListener2007
    implements ExportListener {
        private ExportExcelConfigParam param = null;
        private int rowCount = 0;

        public ExportListener2007(ExportExcelConfigParam param) {
            this.param = param;
            this.rowCount = this.param.isExportSelect() ? CASExportExcelConfigUI.this.selectedRowCount : CASExportExcelConfigUI.this.tableRowCount;
            CASExportExcelConfigUI.this.exportProgress.setMinimum(0);
            CASExportExcelConfigUI.this.exportProgress.setMaximum(this.rowCount);
        }

        public void complete(ExportEvent arg0) {
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    CASExportExcelConfigUI.this.updateUIStatus(0, 2);
                }
            };
            try {
                SwingUtilities.invokeAndWait(runner);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            catch (InvocationTargetException e1) {
                e1.printStackTrace();
            }
            if (this.param.isOpenFile()) {
                try {
                    CASExportExcelConfigUI.this.openExcelFile(CASExportExcelConfigUI.this.excelFile.getAbsolutePath());
                }
                catch (IOException e) {
                    logger.error((Object)e);
                }
            }
        }

        public void delEvent(ExportEvent arg0) {
            CASExportExcelConfigUI.this.currentRowIndex++;
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    CASExportExcelConfigUI.this.exportProgress.setValue(CASExportExcelConfigUI.this.currentRowIndex / 3);
                }
            };
            SwingUtilities.invokeLater(runner);
        }
    }

    class ExportListener2003
    implements ExportListener {
        private ExportExcelConfigParam param = null;
        private int rowCount = 0;

        public ExportListener2003(ExportExcelConfigParam param) {
        }

        public void complete(ExportEvent arg0) {
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    CASExportExcelConfigUI.this.updateUIStatus(1, 2);
                }
            };
            try {
                SwingUtilities.invokeAndWait(runner);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            catch (InvocationTargetException e1) {
                e1.printStackTrace();
            }
            if (this.param.isOpenFile()) {
                try {
                    CASExportExcelConfigUI.this.openExcelFile(CASExportExcelConfigUI.this.excelFile.getAbsolutePath());
                }
                catch (IOException e) {
                    logger.error((Object)e);
                }
            }
        }

        public void delEvent(ExportEvent arg0) {
            CASExportExcelConfigUI.this.currentRowIndex++;
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                }
            };
            SwingUtilities.invokeLater(runner);
        }
    }

    class ExportSelectChangeListener
    implements ActionListener {
        ExportSelectChangeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KDRadioButton source = (KDRadioButton)e.getSource();
            if (source.isSelected() && CASExportExcelConfigUI.this.currentExportStatus == 0) {
                CASExportExcelConfigUI.this.checkExportRowCount();
            }
        }
    }

    class ExcelVersionChangeListener
    implements ActionListener {
        ExcelVersionChangeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final KDRadioButton source = (KDRadioButton)e.getSource();
            if (!source.isSelected()) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (source.equals(CASExportExcelConfigUI.this.radioVer2003) && CASExportExcelConfigUI.this.currentExportStatus == 0) {
                        CASExportExcelConfigUI.this.updateUIStatus(1, CASExportExcelConfigUI.this.currentExportStatus);
                    } else if (source.equals(CASExportExcelConfigUI.this.radioVer2007) && CASExportExcelConfigUI.this.currentExportStatus == 0) {
                        CASExportExcelConfigUI.this.updateUIStatus(0, CASExportExcelConfigUI.this.currentExportStatus);
                    }
                }
            });
        }
    }

    class ExportRunnable
    implements Runnable {
        ExportExcelConfigParam param = null;
        ExportListener[] listeners = null;

        public ExportRunnable(ExportExcelConfigParam param, ExportListener[] listeners) {
            this.param = param;
            this.listeners = listeners;
        }

        @Override
        public void run() {
            try {
                logger.info((Object)("export " + CASExportExcelConfigUI.this.bulidFileName(false) + " param:" + this.param));
                CASExportExcelConfigUI.this.updateUIStatus(this.param.getExcelVersion(), 1);
                CASExportExcelConfigUI.this.excelFile = CASExportExcelConfigUI.this.helper.export2Excel(this.param, this.listeners);
                if (this.param.isExportExcel2003()) {
                    CASExportExcelConfigUI.this.updateUIStatus(1, 2);
                }
                if (this.param.isExportExcel2007()) {
                    CASExportExcelConfigUI.this.updateUIStatus(0, 2);
                }
                if (this.param.isOpenFile()) {
                    try {
                        CASExportExcelConfigUI.this.openExcelFile(CASExportExcelConfigUI.this.excelFile.getAbsolutePath());
                    }
                    catch (IOException e) {
                        logger.error((Object)e);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
                CASExportExcelConfigUI.this.updateUIStatus(this.param.isExportExcel2007() ? 0 : 1, 0);
            }
        }
    }
}

