/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client.export;

import com.kingdee.bos.ctrl.kdf.excel.ui.ExportListener;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.client.export.CASExcel2003Exporter;
import com.kingdee.eas.fi.cas.client.export.CASExcel2007Exporter;
import com.kingdee.eas.fi.cas.client.export.CASExportExcelConfigUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.exportexcel.ExportExcelConfigManager;
import com.kingdee.eas.framework.client.exportexcel.ExportExcelConfigParam;
import com.kingdee.eas.framework.client.exportexcel.ExportExcelConfigUI;
import com.kingdee.eas.framework.client.exportexcel.ExportExcelHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.swing.JDialog;
import org.apache.log4j.Logger;

public class CASExportExcelHelper
extends ExportExcelHelper {
    private static final Logger logger = Logger.getLogger(CASExportExcelHelper.class);
    private CoreUI UI = null;
    private KDTable table = null;

    public CASExportExcelHelper(CoreUI uI, KDTable table) {
        super(uI, table);
        this.UI = uI;
        this.table = table;
    }

    private IUIWindow createExportExcelConfigDialog(UIContext uiContext) {
        long onLoadStart = System.currentTimeMillis();
        IUIWindow window = null;
        try {
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            window = uiFactory.create(CASExportExcelConfigUI.class.getName(), (Map)uiContext, null, null);
        }
        catch (UIException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        final IUIWindow window1 = window;
        if (window1 instanceof JDialog) {
            WindowListener[] Listeners = ((JDialog)window1).getWindowListeners();
            ((JDialog)window1).removeWindowListener(Listeners[0]);
            ((JDialog)window1).addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    if (window1.getUIObject() instanceof ExportExcelConfigUI) {
                        ((ExportExcelConfigUI)window1.getUIObject()).disposeUIWindow();
                    }
                }
            });
        }
        long onLoadCost = System.currentTimeMillis() - onLoadStart;
        logger.debug((Object)("Create ExportExcelConfigDialog spent " + onLoadCost + " ms."));
        return window;
    }

    public void createExportConfigUI() throws IOException {
        UIContext uiContext = new UIContext((Object)this.UI);
        IUIWindow window = this.createExportExcelConfigDialog(uiContext);
        CASExportExcelConfigUI exportExcelConfigUI = (CASExportExcelConfigUI)window.getUIObject();
        ExportExcelConfigParam param = ExportExcelConfigManager.loadExportExcelConfig();
        int selectedRowCount = 0;
        if (this.UI instanceof ListUI) {
            ListUI listUI = (ListUI)this.UI;
            try {
                selectedRowCount = listUI.getSelectedRowCount(this.table);
                if (listUI.getMaxReturnRowCount() > 0 && selectedRowCount > listUI.getMaxReturnRowCount()) {
                    selectedRowCount = listUI.getMaxReturnRowCount();
                }
            }
            catch (Throwable e2) {
                selectedRowCount = KDTableUtil.getSelectedRows((KDTable)this.table).length;
            }
        } else {
            selectedRowCount = KDTableUtil.getSelectedRows((KDTable)this.table).length;
        }
        int rowCount = this.table.getRowCount();
        exportExcelConfigUI.setHelper(this);
        exportExcelConfigUI.setRowCount(rowCount);
        exportExcelConfigUI.setSelectedRowCount(selectedRowCount);
        exportExcelConfigUI.setTable(this.table);
        exportExcelConfigUI.initConfigParam(param);
        window.show();
    }

    public File export2Excel(ExportExcelConfigParam param, ExportListener[] listeners) throws Exception {
        if (param == null) {
            throw new IllegalArgumentException("ArgumentERROR:param=" + param);
        }
        Object exporter = null;
        switch (param.getExcelVersion()) {
            case 1: {
                exporter = new CASExcel2003Exporter();
                break;
            }
            case 0: {
                exporter = new CASExcel2007Exporter();
                break;
            }
            default: {
                exporter = new CASExcel2003Exporter();
            }
        }
        File file = exporter.startExport(this.table, param, listeners);
        return file;
    }
}

