/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.wssc.BillImageFacadeFactory;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankInfo;
import com.kingdee.eas.basedata.person.PersonAccountFactory;
import com.kingdee.eas.basedata.person.PersonAccountInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.ArApRecPayException;
import com.kingdee.eas.fi.cas.RecPayBillFacadeFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class BillUIUtil {
    public static final String ACCOUNT_BANK_NO = "accountBankNo";
    public static final String ACCOUNT_BANK_NAME = "accountBankName";
    public static final String ACCOUNT_BANK_INFO = "accountBankInfo";
    public static final String PAYEE_NAME = "beneficiary";
    public static final String PERSON = "person";
    public static final String REC_PAY_RES = "com.kingdee.eas.fi.cas.RecPayResource.";

    public static Map<String, Object> getAccountBankInfo(Object asstActAccountBankNo) throws EASBizException, BOSException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String accountBankNo = null;
        String accountBankName = null;
        String beneficiary = null;
        PersonInfo person = null;
        AccountBankInfo accountBankInfo = null;
        if (asstActAccountBankNo instanceof CustomerCompanyBankInfo || asstActAccountBankNo instanceof SupplierCompanyBankInfo) {
            CoreBaseInfo bankInfo = (CoreBaseInfo)asstActAccountBankNo;
            accountBankNo = bankInfo.getString("bankAccount");
            accountBankName = bankInfo.getString("bank");
            beneficiary = bankInfo.getString(PAYEE_NAME);
        } else if (asstActAccountBankNo instanceof AccountBankInfo) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("*");
            selector.add("company.*");
            selector.add("bank.*");
            ObjectUuidPK id = new ObjectUuidPK(((AccountBankInfo)asstActAccountBankNo).getId());
            accountBankInfo = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)id, selector);
            if (null != accountBankInfo) {
                accountBankNo = accountBankInfo.getBankAccountNumber();
                accountBankName = accountBankInfo.getBank().getName();
            }
        } else if (asstActAccountBankNo instanceof String) {
            accountBankNo = (String)asstActAccountBankNo;
        } else if (asstActAccountBankNo instanceof PersonAccountInfo) {
            String bank;
            CoreBaseInfo objInfo = (CoreBaseInfo)asstActAccountBankNo;
            String personAccountId = objInfo.get("id").toString();
            accountBankName = bank = objInfo.get("bank").toString();
            if (!EmptyUtil.isEmpty((String)personAccountId)) {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("*");
                selector.add("person.*");
                PersonAccountInfo personAccountInfo = PersonAccountFactory.getRemoteInstance().getPersonAccountInfo((IObjectPK)new ObjectUuidPK(personAccountId), selector);
                if (personAccountInfo != null) {
                    person = personAccountInfo.getPerson();
                    accountBankNo = personAccountInfo.getBankAccount();
                    accountBankName = personAccountInfo.getBank();
                }
            }
        }
        resultMap.put(ACCOUNT_BANK_NO, accountBankNo);
        resultMap.put(ACCOUNT_BANK_NAME, accountBankName);
        resultMap.put(ACCOUNT_BANK_INFO, accountBankInfo);
        resultMap.put(PAYEE_NAME, beneficiary);
        resultMap.put(PERSON, person);
        return resultMap;
    }

    public static String ids2SqlString(Collection billIDs) {
        StringBuilder ids = new StringBuilder(300);
        Iterator iter = billIDs.iterator();
        while (iter.hasNext()) {
            ids.append("'");
            ids.append((String)iter.next());
            ids.append("',");
        }
        if (ids.length() > 0) {
            ids.deleteCharAt(ids.length() - 1);
        }
        return ids.toString();
    }

    public static String getSourceBillImageUrl(Context ctx, Set<String> idSet, String userName) throws Exception {
        String url = null;
        if (null == idSet || idSet.isEmpty()) {
            throw new ArApRecPayException(ArApRecPayException.BILL_ID_NOT_EXIST);
        }
        HashSet<String> sourceIdSet = new HashSet<String>(20);
        String sql = " SELECT FSRCOBJECTID FROM T_BOT_RELATION WHERE FDESTOBJECTID IN (" + BillUIUtil.ids2SqlString(idSet) + ")";
        IRowSet rs = RecPayBillFacadeFactory.getRemoteInstance().executeQuery(sql);
        while (rs.next()) {
            sourceIdSet.add(rs.getString("FSRCOBJECTID"));
        }
        if (sourceIdSet.isEmpty()) {
            throw new ArApRecPayException(ArApRecPayException.SOURCE_BILL_NOT_EXIST);
        }
        url = BillImageFacadeFactory.getRemoteInstance().createImagePathsByBillID(sourceIdSet, "1", userName, userName);
        if (StringUtils.isEmpty((String)url)) {
            throw new ArApRecPayException(ArApRecPayException.SOURCE_BILL_NOT_EXIST_IMAGE);
        }
        return url;
    }

    public static boolean checkExpectDealTime(CoreUI ui, KDDatePicker pkexpectDealTime) throws Exception {
        String comfimMsg;
        Timestamp serverDate;
        Date expectDealTime;
        Object obj;
        return null == pkexpectDealTime || null == (obj = pkexpectDealTime.getValue()) || !(obj instanceof Date) || (expectDealTime = (Date)obj).compareTo(serverDate = RecPayBillFacadeFactory.getRemoteInstance().getServerDate()) > 0 || MsgBox.isYes((int)MsgBox.showConfirm2((Component)ui, (String)(comfimMsg = EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource.229_expectDealTime_GT_Currenttime"))));
    }
}

