/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.IMethodBatchQuery;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.app.CashCaculaterExtStrategy;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.ICalculator;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CashExtBatchCaculator
implements ICalculator,
IMethodBatchQuery {
    private static Logger logger = Logger.getLogger((String)CashExtBatchCaculator.class.getName());
    private ICalculateContextProvider context;
    private Context serverCtx = null;
    private String reportCompanyNumber = null;
    private String reportCurrencyNumber = null;
    private Date reportBeginDate = null;
    private Date reportEndDate = null;

    public BigDecimal cashExt(String companyNum, String bankNum, String bankAcctNum, String currencyNum, String sBeginDate, String sEndDate, String sDataType) throws BOSException, EASBizException {
        return null;
    }

    public void initCalculateContext(ICalculateContextProvider context) {
        this.context = context;
        this.serverCtx = this.context.getServerContext();
    }

    public boolean batchQuery(Map methods) {
        String reportCompanyId = (String)this.context.getReportAdapter().getReportProperty("Company.ID");
        try {
            this.reportCompanyNumber = CompanyOrgUnitFactory.getLocalInstance((Context)this.serverCtx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(reportCompanyId)).getNumber();
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        this.reportCurrencyNumber = (String)this.context.getReportAdapter().getReportProperty("Currency.Number");
        this.reportBeginDate = (Date)this.context.getReportAdapter().getReportProperty("Report_StartDate");
        this.reportEndDate = (Date)this.context.getReportAdapter().getReportProperty("Report_EndDate");
        for (Map.Entry e : methods.entrySet()) {
            String method = (String)e.getKey();
            SortedParameterArray param = (SortedParameterArray)e.getValue();
            this.execute(param);
        }
        return true;
    }

    public void execute(SortedParameterArray params) {
        Map hm = this.groupByDataType(params);
        Set entrySet = hm.entrySet();
        for (Map.Entry entry : entrySet) {
            CashCaculaterExtStrategy.getInstance((Context)this.serverCtx, (String)entry.getKey().toString()).doCash((List)entry.getValue(), this.context);
        }
    }

    private Map groupByDataType(SortedParameterArray params) {
        HashMap hmReturn = new HashMap();
        String dataType = "";
        Parameter param = null;
        Object[] args = null;
        HashSet<String> allType = new HashSet<String>();
        ArrayList<Parameter> singleType = null;
        for (int i = 0; i < params.size(); ++i) {
            param = params.getParameter(i);
            args = this.getParams(param);
            dataType = args[6].toString();
            if (!allType.contains(dataType)) {
                allType.add(dataType);
                singleType = new ArrayList<Parameter>();
                singleType.add(param);
                hmReturn.put(dataType, singleType);
                continue;
            }
            ((List)hmReturn.get(dataType)).add(param);
        }
        return hmReturn;
    }

    private Object[] getParams(Parameter param) {
        String endDate;
        String beginDate;
        String currencyNumber;
        Object[] args = param.getArgs();
        String companyNumber = args[0].toString();
        if (FMHelper.isEmpty((String)companyNumber)) {
            companyNumber = this.reportCompanyNumber;
            args[0] = companyNumber;
        }
        if (FMHelper.isEmpty((String)(currencyNumber = args[3].toString()))) {
            currencyNumber = this.reportCurrencyNumber;
            args[3] = currencyNumber;
        }
        if (FMHelper.isEmpty((String)(beginDate = args[4].toString()))) {
            beginDate = FMConstants.FORMAT_DAY.format(this.reportBeginDate);
            args[4] = beginDate;
        }
        if (FMHelper.isEmpty((String)(endDate = args[5].toString()))) {
            endDate = FMConstants.FORMAT_DAY.format(this.reportEndDate);
            args[5] = endDate;
        }
        return args;
    }
}

