/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.model;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.util.CellRangeAddress;

public class ExcelTool {
    private HSSFWorkbook workbook = null;
    private HSSFSheet currentSheet = null;
    private static Map<Integer, HorizontalAlignment> alignmentMap = new HashMap<Integer, HorizontalAlignment>();
    private Map<String, HSSFCellStyle> styleMap = new HashMap<String, HSSFCellStyle>();

    public ExcelTool(String sheetName) {
        this.workbook = new HSSFWorkbook();
        this.currentSheet = this.workbook.createSheet(sheetName);
    }

    public HSSFSheet createSheet(String sheetName) {
        this.currentSheet = this.workbook.createSheet(sheetName);
        return this.currentSheet;
    }

    public HSSFSheet switch2Sheet(String sheetName) {
        this.currentSheet = this.workbook.getSheet(sheetName);
        return this.currentSheet;
    }

    public void setColumnWidth(int columnIndex, int width) {
        this.currentSheet.setColumnWidth(columnIndex, 335 * width);
    }

    public HSSFCell getCell(int rowIndex, int colIndex, HSSFCellStyle style) {
        HSSFCell cell;
        HSSFRow row = this.currentSheet.getRow(rowIndex);
        if (row == null) {
            row = this.currentSheet.createRow(rowIndex);
        }
        if ((cell = row.getCell(colIndex)) == null) {
            cell = row.createCell(colIndex);
        }
        if (style != null) {
            cell.setCellStyle(style);
        }
        return cell;
    }

    public byte[] getBytes() {
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            this.workbook.write((OutputStream)bOut);
            return bOut.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public HSSFCellStyle getNormalStyle(int alignment) {
        String NORMAL = "NORMAL_" + alignment;
        HSSFCellStyle normalStyle = this.styleMap.get(NORMAL);
        if (alignmentMap.isEmpty()) {
            this.putAlignment();
        }
        if (normalStyle == null) {
            HSSFFont font = this.workbook.createFont();
            font.setFontName("Calibri");
            font.setFontHeightInPoints((short)12);
            normalStyle = this.workbook.createCellStyle();
            normalStyle.setFont(font);
            normalStyle.setAlignment(alignmentMap.get(alignment));
            normalStyle.setBorderTop(BorderStyle.NONE);
            normalStyle.setBorderBottom(BorderStyle.DOTTED);
            normalStyle.setBorderLeft(BorderStyle.DOTTED);
            normalStyle.setBorderTop(BorderStyle.DOTTED);
            normalStyle.setBorderRight(BorderStyle.DOTTED);
            this.styleMap.put(NORMAL, normalStyle);
        }
        return normalStyle;
    }

    public HSSFCellStyle getSubtotalStyle(int alignment) {
        String SUBTOTAL = "SUBTOTAL_" + alignment;
        HSSFCellStyle style = this.styleMap.get(SUBTOTAL);
        if (alignmentMap.isEmpty()) {
            this.putAlignment();
        }
        if (style == null) {
            HSSFFont font = this.workbook.createFont();
            font.setFontName("Calibri");
            font.setFontHeightInPoints((short)12);
            style = this.workbook.createCellStyle();
            style.setFont(font);
            style.setAlignment(alignmentMap.get(alignment));
            style.setBorderTop(BorderStyle.NONE);
            style.setBorderBottom(BorderStyle.DOTTED);
            style.setBorderLeft(BorderStyle.DOTTED);
            style.setBorderTop(BorderStyle.DOTTED);
            style.setBorderRight(BorderStyle.DOTTED);
            style.setFillForegroundColor(IndexedColors.BLUE.index);
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.styleMap.put(SUBTOTAL, style);
        }
        return style;
    }

    public HSSFCellStyle getTotalStyle() {
        HSSFCellStyle style = this.styleMap.get("TOTAL");
        if (style == null) {
            HSSFFont font = this.workbook.createFont();
            font.setFontName("Calibri");
            font.setFontHeightInPoints((short)12);
            font.setBold(true);
            style = this.workbook.createCellStyle();
            style.setFont(font);
            style.setAlignment(HorizontalAlignment.CENTER);
            style.setBorderTop(BorderStyle.NONE);
            style.setBorderBottom(BorderStyle.DOTTED);
            style.setBorderLeft(BorderStyle.DOTTED);
            style.setBorderTop(BorderStyle.DOTTED);
            style.setBorderRight(BorderStyle.DOTTED);
            style.setFillForegroundColor(IndexedColors.LIGHT_ORANGE.index);
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.styleMap.put("TOTAL", style);
        }
        return style;
    }

    public HSSFCellStyle getTitleStyle() {
        HSSFCellStyle style = this.styleMap.get("TITLE");
        if (style == null) {
            HSSFFont font = this.workbook.createFont();
            font.setFontName("Calibri");
            font.setFontHeightInPoints((short)12);
            style = this.workbook.createCellStyle();
            style.setFont(font);
            style.setAlignment(HorizontalAlignment.CENTER);
            style.setBorderTop(BorderStyle.NONE);
            style.setBorderBottom(BorderStyle.DOTTED);
            style.setBorderLeft(BorderStyle.DOTTED);
            style.setBorderTop(BorderStyle.DOTTED);
            style.setBorderRight(BorderStyle.DOTTED);
            style.setFillForegroundColor(IndexedColors.LIGHT_YELLOW.index);
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.styleMap.put("TITLE", style);
        }
        return style;
    }

    public HSSFCellStyle getTemplateStyle() {
        HSSFCellStyle style = this.styleMap.get("TITLE");
        if (style == null) {
            HSSFFont font = this.workbook.createFont();
            font.setFontName("Calibri");
            font.setFontHeightInPoints((short)12);
            style = this.workbook.createCellStyle();
            style.setFont(font);
            style.setAlignment(HorizontalAlignment.CENTER);
            style.setBorderTop(BorderStyle.NONE);
            style.setBorderBottom(BorderStyle.DOTTED);
            style.setBorderLeft(BorderStyle.DOTTED);
            style.setBorderTop(BorderStyle.DOTTED);
            style.setBorderRight(BorderStyle.DOTTED);
            style.setFillForegroundColor(IndexedColors.LIGHT_CORNFLOWER_BLUE.index);
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.styleMap.put("TITLE", style);
        }
        return style;
    }

    public HSSFCellStyle getQueryTitleStyle() {
        HSSFCellStyle style = this.styleMap.get("getQueryTitleStyle");
        if (style == null) {
            HSSFFont font = this.workbook.createFont();
            font.setFontName("Calibri");
            font.setFontHeightInPoints((short)12);
            font.setColor(IndexedColors.GREEN.index);
            style = this.workbook.createCellStyle();
            style.setFont(font);
            style.setAlignment(HorizontalAlignment.CENTER);
            style.setBorderTop(BorderStyle.NONE);
            style.setBorderBottom(BorderStyle.DOTTED);
            style.setBorderLeft(BorderStyle.DOTTED);
            style.setBorderTop(BorderStyle.DOTTED);
            style.setBorderRight(BorderStyle.DOTTED);
            style.setFillForegroundColor(IndexedColors.LIGHT_YELLOW.index);
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.styleMap.put("getQueryTitleStyle", style);
        }
        return style;
    }

    public HSSFCellStyle getQueryTitleStyle(int alignment) {
        String GROUP = "getQueryTitleStyle_" + alignment;
        HSSFCellStyle style = this.styleMap.get(GROUP);
        if (alignmentMap.isEmpty()) {
            this.putAlignment();
        }
        if (style == null) {
            HSSFFont font = this.workbook.createFont();
            font.setFontName("Calibri");
            font.setFontHeightInPoints((short)12);
            font.setColor(IndexedColors.GREEN.index);
            style = this.workbook.createCellStyle();
            style.setFont(font);
            style.setAlignment(alignmentMap.get(alignment));
            style.setBorderTop(BorderStyle.NONE);
            style.setBorderBottom(BorderStyle.DOTTED);
            style.setBorderLeft(BorderStyle.DOTTED);
            style.setBorderTop(BorderStyle.DOTTED);
            style.setBorderRight(BorderStyle.DOTTED);
            style.setFillForegroundColor(IndexedColors.LIGHT_YELLOW.index);
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.styleMap.put(GROUP, style);
        }
        return style;
    }

    public HSSFCellStyle getGroupStyle(int alignment) {
        String GROUP = "GROUP_" + alignment;
        HSSFCellStyle style = this.styleMap.get(GROUP);
        if (alignmentMap.isEmpty()) {
            this.putAlignment();
        }
        if (style == null) {
            HSSFFont font = this.workbook.createFont();
            font.setFontName("Calibri");
            font.setFontHeightInPoints((short)12);
            style = this.workbook.createCellStyle();
            style.setFont(font);
            style.setAlignment(alignmentMap.get(alignment));
            style.setBorderBottom(BorderStyle.DOTTED);
            style.setBorderLeft(BorderStyle.DOTTED);
            style.setBorderTop(BorderStyle.DOTTED);
            style.setBorderRight(BorderStyle.DOTTED);
            style.setFillForegroundColor(IndexedColors.LIGHT_TURQUOISE.index);
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.styleMap.put(GROUP, style);
        }
        return style;
    }

    public HSSFCellStyle getHeadStyle() {
        HSSFCellStyle style = this.styleMap.get("HEAD");
        if (style == null) {
            HSSFFont font = this.workbook.createFont();
            font.setFontName("Calibri");
            font.setFontHeightInPoints((short)18);
            font.setColor(IndexedColors.GREEN.index);
            style = this.workbook.createCellStyle();
            style.setFont(font);
            style.setAlignment(HorizontalAlignment.CENTER);
            style.setBorderBottom(BorderStyle.DOTTED);
            style.setBorderLeft(BorderStyle.DOTTED);
            style.setBorderTop(BorderStyle.DOTTED);
            style.setBorderRight(BorderStyle.DOTTED);
            style.setFillForegroundColor(IndexedColors.LIGHT_YELLOW.index);
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.styleMap.put("HEAD", style);
        }
        return style;
    }

    public HSSFWorkbook getWorkbook() {
        return this.workbook;
    }

    public HSSFSheet getSheet() {
        return this.currentSheet;
    }

    public void setCellStyle(int firstRow, int lastRow, int firstCol, int lastCol, HSSFCell cell, ExcelTool excelTool) {
        HSSFCellStyle styleCenter = excelTool.getNormalStyle(1);
        for (int i = firstRow; i <= lastRow; ++i) {
            for (int j = firstCol; j <= lastCol; ++j) {
                cell = excelTool.getCell(i, j, styleCenter);
            }
        }
    }

    public CellRangeAddress getCellRangeAddress(int firstRow, int lastRow, int firstCol, int lastCol) {
        return new CellRangeAddress(firstRow, lastRow, firstCol, lastCol);
    }

    public void createTableHeader(String[] tableHeader, int row) {
        for (int i = 0; i < tableHeader.length; ++i) {
            if (tableHeader[i] == null) continue;
            HSSFCell cell = this.getCell(row, i, this.getTitleStyle());
            cell.setCellValue(tableHeader[i]);
        }
    }

    public void createTemplateTableHeader(String[] tableHeader, int row) {
        for (int i = 0; i < tableHeader.length; ++i) {
            if (tableHeader[i] == null) continue;
            HSSFCell cell = this.getCell(row, i, this.getTemplateStyle());
            cell.setCellValue(tableHeader[i]);
        }
    }

    public void putAlignment() {
        alignmentMap.put(0, HorizontalAlignment.LEFT);
        alignmentMap.put(1, HorizontalAlignment.CENTER);
        alignmentMap.put(2, HorizontalAlignment.RIGHT);
    }
}

