/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.subacct.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.cas.AccountTypeEnum;
import com.kingdee.eas.fi.cas.subacct.ISubAcctMgtInitFacade;
import com.kingdee.eas.fi.cas.subacct.SubAccountBalanceCollection;
import com.kingdee.eas.fi.cas.subacct.SubAccountBalanceInfo;
import com.kingdee.eas.fi.cas.subacct.SubAcctMgtInitFacadeFactory;
import com.kingdee.eas.fi.cas.subacct.client.SubAcctInitHandler;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.HashMap;

public abstract class AbstractSubAcctMgtInitHandler {
    private ICellEditor numberEditor;
    private CurrencyInfo currency;
    private CompanyOrgUnitInfo companyInfo;
    private PeriodInfo periodInfo;
    private boolean isDisplayImport;
    private SubAccountBalanceCollection journalBalCollection;
    private boolean isImportChanged;
    public static final int scPrecision = 2;
    public static final int fcPrecision = 2;
    public static final Color KDTABLE_NOEDIT_BG_COLOR = new Color(0xF6F6B6);
    public static final BigDecimal ZERO = new BigDecimal("0.00");
    public static final String resPath = "com.kingdee.eas.fi.cas.CasResource";
    public static final String SAVESUCCESS = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"saveSuccess");
    public static final String YEARDEBITAMOUNT = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"yearDebitAmount");
    public static final String YEARCREDITAMOUNT = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"yearCreditAmount");
    public static final String BEGINBALANCE = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"beginBalance");
    public static final String JOURNALBALANCE = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"journalBalance");
    public static final String SUBACCT_NUMBER = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"subAcctNumber");
    public static final String SUBACCT_ACCOUNTNUMBER = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"subAcctAccountNumber");
    public static final String SUBACCT_NAME = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"subAcctName");
    public static final String SUBACCT_RELATEUNIT = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"subAcctRelateUnit");
    public final String SUBACCT_NUMBER_COL = "subAcctNumber";
    public final String SUBACCT_ACCOUNTNUMBER_COL = "subAcctAccountNumber";
    public final String SUBACCT_NAME_COL = "subAcctName";
    public final String SUBACCT_RELATEUNIT_COL = "subAcctReateUnit";
    public static final String DEB_COL = "yearDebitAmount";
    public static final String CRE_COL = "yearCreditAmount";
    public static final String BAL_COL = "beginBalance";

    public static AbstractSubAcctMgtInitHandler getInstance(AccountTypeEnum accType) {
        return new SubAcctInitHandler();
    }

    public void setColumnColor(IColumn column) {
        column.getStyleAttributes().setLocked(true);
        column.getStyleAttributes().setBackground(KDTABLE_NOEDIT_BG_COLOR);
    }

    public BigDecimal getBigDecimal(BigDecimal big) {
        return big == null ? ZERO : big;
    }

    public BigDecimal getBigDecimal(Object obj) {
        BigDecimal value = null;
        if (obj == null || obj.toString().length() == 0) {
            value = ZERO;
        } else if (obj instanceof BigDecimal) {
            value = (BigDecimal)obj;
        } else if (FMClientHelper.verifyIsNumber((String)obj.toString())) {
            value = new BigDecimal(obj.toString());
        } else {
            throw new IllegalArgumentException("object is not BigDecimal type!");
        }
        return value;
    }

    public BigDecimal getBigDecimalByScale(BigDecimal big, int scale) {
        BigDecimal newBig = this.getBigDecimal(big);
        newBig = newBig.setScale(scale, 4);
        return newBig;
    }

    public static boolean isZERO(BigDecimal o) {
        return o == null || o.compareTo(FMConstants.ZERO) == 0;
    }

    public static boolean isNull(Object obj) {
        return obj == null;
    }

    public boolean isRowNotValid(IRow row) {
        Object debitObj = row.getCell(DEB_COL).getValue();
        Object creditObj = row.getCell(CRE_COL).getValue();
        Object balanceObj = row.getCell(BAL_COL).getValue();
        boolean isDebitNotValid = AbstractSubAcctMgtInitHandler.isNull(debitObj);
        boolean isCreditNotValid = AbstractSubAcctMgtInitHandler.isNull(creditObj);
        boolean isBalanceNotValid = AbstractSubAcctMgtInitHandler.isNull(balanceObj);
        boolean isRowNotValid = isDebitNotValid && isCreditNotValid && isBalanceNotValid;
        return isRowNotValid;
    }

    public void initTable(KDTable table) {
    }

    public boolean isImportChanged() {
        return this.isImportChanged;
    }

    public void setIsImportChanged(boolean isImportChanged) {
        this.isImportChanged = isImportChanged;
    }

    public CurrencyInfo getCurrency() {
        return this.currency;
    }

    public void setCurrency(CurrencyInfo currency) {
        this.currency = currency;
    }

    public CompanyOrgUnitInfo getCompanyInfo() {
        return this.companyInfo;
    }

    public void setCompanyInfo(CompanyOrgUnitInfo companyInfo) {
        this.companyInfo = companyInfo;
    }

    public PeriodInfo getPeriodInfo() {
        return this.periodInfo;
    }

    public void setPeriodInfo(PeriodInfo periodInfo) {
        this.periodInfo = periodInfo;
    }

    public ICellEditor getNumberEditor() {
        return this.numberEditor;
    }

    public void setNumberEditor(ICellEditor numberEditor) {
        this.numberEditor = numberEditor;
    }

    public boolean isDisplayImport() {
        return this.isDisplayImport;
    }

    public void setIsDisplayImport(boolean isDisplayImport) {
        this.isDisplayImport = isDisplayImport;
    }

    public void initTable(KDTable table, boolean isFirstPeriod) {
        String strCurrencyId = this.getCurrency().getId().toString();
        FMClientHelper.setNumberFormat((KDTable)table, (String)DEB_COL, (String)strCurrencyId);
        FMClientHelper.setNumberFormat((KDTable)table, (String)CRE_COL, (String)strCurrencyId);
        FMClientHelper.setNumberFormat((KDTable)table, (String)BAL_COL, (String)strCurrencyId);
        table.getColumn(DEB_COL).setWidth(110);
        table.getColumn(CRE_COL).setWidth(110);
        table.getColumn(BAL_COL).setWidth(110);
        table.getColumn("subAcctName").setWidth(200);
        table.getColumn("subAcctReateUnit").setWidth(200);
        if (table.getColumn(DEB_COL).getEditor() == null) {
            table.getColumn(DEB_COL).setEditor(this.getNumberEditor());
        }
        if (table.getColumn(CRE_COL).getEditor() == null) {
            table.getColumn(CRE_COL).setEditor(this.getNumberEditor());
        }
        if (table.getColumn(BAL_COL).getEditor() == null) {
            table.getColumn(BAL_COL).setEditor(this.getNumberEditor());
        }
        if (isFirstPeriod) {
            table.getColumn(DEB_COL).getStyleAttributes().setHided(true);
            table.getColumn(CRE_COL).getStyleAttributes().setHided(true);
        }
        this.initKDTableFormatter(table);
    }

    public abstract void initKDTableFormatter(KDTable var1);

    public void loadField(KDTable table) throws Exception {
        SubAccountBalanceCollection coll;
        CompanyOrgUnitInfo companyInfo = this.getCompanyInfo();
        String strCompanyId = companyInfo.getId().toString();
        CurrencyInfo currencyInfo = this.getCurrency();
        String strCurrencyId = currencyInfo.getId().toString();
        PeriodInfo periodInfo = this.getPeriodInfo();
        String strPeriodId = periodInfo.getId().toString();
        ISubAcctMgtInitFacade iSubAcctMgtInitFacade = SubAcctMgtInitFacadeFactory.getRemoteInstance();
        this.journalBalCollection = coll = iSubAcctMgtInitFacade.getInitCollection(strCompanyId, strCurrencyId, strPeriodId);
        this.loadCollectionToTable(coll, table);
    }

    public void loadCollectionToTable(SubAccountBalanceCollection coll, KDTable table) throws Exception {
        int size = 0;
        this.setIsDisplayImport(false);
        if (coll != null && (size = coll.size()) > 0) {
            this.setIsDisplayImport(true);
        }
        for (int i = 0; i < size; ++i) {
            SubAccountBalanceInfo journalInitInfo = coll.get(i);
            IRow row = table.addRow();
            row.setUserObject((Object)journalInitInfo);
            this.loadLineFields(row, journalInitInfo);
        }
    }

    protected abstract void loadLineFields(IRow var1, SubAccountBalanceInfo var2);

    public void storeField(KDTable table) throws Exception {
    }

    public void storeData(SubAccountBalanceCollection journalBalCol, SubAccountBalanceInfo paramInfo) throws Exception {
        if (paramInfo == null) {
            return;
        }
        ISubAcctMgtInitFacade iSubAcctMgtInitFacade = SubAcctMgtInitFacadeFactory.getRemoteInstance();
        iSubAcctMgtInitFacade.save(journalBalCol, paramInfo);
    }

    private boolean compareTwoInfoValue(SubAccountBalanceInfo firstInfo, SubAccountBalanceInfo secondInfo) {
        return firstInfo.getPeriodEndBalance() != secondInfo.getPeriodEndBalance() || firstInfo.getDebitStartAmt() != secondInfo.getDebitStartAmt() || firstInfo.getCreditStartAmt() != secondInfo.getCreditStartAmt();
    }

    public void importFromJournalToInit(KDTable table, String strPeriodId) throws Exception {
        table.removeRows();
        CompanyOrgUnitInfo companyInfo = this.getCompanyInfo();
        String strCompanyId = companyInfo.getId().toString();
        CurrencyInfo currencyInfo = this.getCurrency();
        String strCurrencyId = currencyInfo.getId().toString();
        ISubAcctMgtInitFacade iSubAcctMgtInitFacade = SubAcctMgtInitFacadeFactory.getRemoteInstance();
        SubAccountBalanceCollection coll = (SubAccountBalanceCollection)iSubAcctMgtInitFacade.getInitCollectionFrom(strCompanyId, strCurrencyId, strPeriodId);
        if (coll == null && this.journalBalCollection == null) {
            this.isImportChanged = false;
        } else if (coll == null && this.journalBalCollection != null && this.journalBalCollection.size() != 0 || coll != null && this.journalBalCollection == null && coll.size() != 0) {
            this.isImportChanged = true;
        } else if (coll != null && this.journalBalCollection != null && coll.size() != this.journalBalCollection.size()) {
            this.isImportChanged = false;
        } else {
            String key;
            SubAccountBalanceInfo subAcctBalInfo;
            HashMap<String, SubAccountBalanceInfo> indexMap = new HashMap<String, SubAccountBalanceInfo>();
            for (int i = 0; i < this.journalBalCollection.size(); ++i) {
                subAcctBalInfo = this.journalBalCollection.get(i);
                key = null;
                key = subAcctBalInfo.getSubacct().getId().toString();
                indexMap.put(key, subAcctBalInfo);
            }
            if (coll != null) {
                for (int j = 0; j < coll.size(); ++j) {
                    subAcctBalInfo = coll.get(j);
                    key = null;
                    key = subAcctBalInfo.getSubacct().getId().toString();
                    if (indexMap.containsKey(key)) {
                        this.isImportChanged = this.compareTwoInfoValue(subAcctBalInfo, (SubAccountBalanceInfo)indexMap.get(key));
                    }
                    if (this.isImportChanged) break;
                }
            }
        }
        this.loadCollectionToTable(coll, table);
    }
}

