/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.subacct.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgSelect;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.OrgUnitTreePromptBox;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fi.cas.CashDataTypeEnum;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.DirectionEnum;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fi.cas.client.PeriodHelper;
import com.kingdee.eas.fi.cas.subacct.ISubAcctManagementFacade;
import com.kingdee.eas.fi.cas.subacct.SubAcctManagementFacadeFactory;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class SubAcctHandler {
    private static final String resourcePath = "com.kingdee.eas.fi.cas.JournalResource";
    protected static final String DAY_TOTAL = EASResource.getString((String)"com.kingdee.eas.fi.cas.JournalResource", (String)"DayTotal");
    protected static final String YEAR_TOTAL = EASResource.getString((String)"com.kingdee.eas.fi.cas.JournalResource", (String)"YearTotal");
    protected static final String PERIOD_TOTAL = EASResource.getString((String)"com.kingdee.eas.fi.cas.JournalResource", (String)"MonthTotal");
    protected static final String DAY_BALANCE = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"BankStmt_DayStart");
    protected static final String resourcePath1 = "com.kingdee.eas.fi.cas.client.CashMgtResource";
    protected static final String YEAR_BALANCE = EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"YearBalance");
    protected static final String BEGIN_BALANCE = EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"BeginBalance");
    protected static final String COL_DC = "dc";
    protected static final String COL_PERIOD = "period";
    protected static final String COL_YEAR = "year";
    protected static final String COL_SOURCE = "source";
    protected static final String COL_BALANCE = "balance";
    protected static final String COL_CREDIT = "credit";
    protected static final String COL_DEBIT = "debit";
    protected static final String COL_DESCRIPTION = "description";
    protected static final String COL_CASHIER = "cashier";
    protected static final String COL_BILLNUMBER = "billNumber";
    protected static final String COL_BILLTYPE = "billType";
    protected static final String COL_OPPACCOUNTNUMBER = "oppAccountNumber";
    protected static final String COL_VOUCHERNUMBER = "voucherNumber";
    protected static final String COL_VOUCHERTYPE = "voucherType";
    protected static final String COL_BIZDATE = "bizDate";
    protected static final String COL_ID = "id";
    protected static final String CREDIT_AMOUNT = "creditAmount";
    protected static final String DEBIT_AMOUNT = "debitAmount";
    protected static final String PERIOD_NUMBER = "periodnumber";
    protected static final String PERIOD_YEAR = "periodyear";
    protected static final String COL_CREATE_DATE = "bookDate";
    protected static final String COL_LOCAL_BALANCE = "localBalance";
    protected static final String COL_LOCAL_CREDIT = "localCredit";
    protected static final String COL_LOCAL_DEBIT = "localDebit";
    protected static final String COL_EXCHANGE = "exchange";

    public void showErrer(CoreUIObject ui, String errerMsg) {
        MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)errerMsg));
        SysUtil.abort();
    }

    public static void setF7Company(IUIObject owner, KDBizPromptBox f7company) {
        OrgType[] CompanyType = new OrgType[]{OrgType.Company};
        f7company.setEditFormat("$number$");
        f7company.setDisplayFormat("$name$");
        OrgUnitTreePromptBox boxCompany = new OrgUnitTreePromptBox(owner, CompanyType, null, OrgSelect.OnlySelectCompanyEntity, false, false, false);
        f7company.setSelector((KDPromptSelector)boxCompany);
    }

    protected void fillLocalCurrencyDataForTotal(IRow row, BigDecimal exchange, BigDecimal debitAmt, BigDecimal creditAmt, BigDecimal balance, boolean isCurEqualsBasecur, ConvertModeEnum convertMode) {
        BigDecimal localBalance;
        BigDecimal localCreditAmt;
        BigDecimal localDebitAmt;
        if (isCurEqualsBasecur) {
            localDebitAmt = debitAmt;
            localCreditAmt = creditAmt;
            localBalance = balance;
        } else if (convertMode.equals((Object)ConvertModeEnum.DIRECTEXCHANGERATE)) {
            localDebitAmt = debitAmt.multiply(exchange);
            localCreditAmt = creditAmt.multiply(exchange);
            localBalance = balance.multiply(exchange);
        } else {
            localDebitAmt = debitAmt.divide(exchange, 4);
            localCreditAmt = creditAmt.divide(exchange, 4);
            localBalance = balance.divide(exchange, 4);
        }
        DirectionEnum direction = balance.compareTo(CasConstants.ZERO) == 0 ? DirectionEnum.Balance : (balance.compareTo(CasConstants.ZERO) > 0 ? DirectionEnum.Debit : DirectionEnum.Credit);
        row.getCell(COL_DC).setValue((Object)direction);
        row.getCell(COL_LOCAL_DEBIT).setValue((Object)localDebitAmt);
        row.getCell(COL_LOCAL_CREDIT).setValue((Object)localCreditAmt);
        row.getCell(COL_LOCAL_BALANCE).setValue((Object)localBalance.abs());
    }

    protected void fillLocalCurrencyData(IRow row, BigDecimal exchange, BigDecimal debitAmt, BigDecimal creditAmt, BigDecimal balance, boolean isCurEqualsBasecur, ConvertModeEnum convertMode) {
        BigDecimal localBalance;
        BigDecimal localCreditAmt;
        BigDecimal localDebitAmt;
        if (isCurEqualsBasecur) {
            localDebitAmt = debitAmt;
            localCreditAmt = creditAmt;
            localBalance = balance;
        } else if (convertMode.equals((Object)ConvertModeEnum.DIRECTEXCHANGERATE)) {
            localDebitAmt = debitAmt.multiply(exchange);
            localCreditAmt = creditAmt.multiply(exchange);
            localBalance = balance.multiply(exchange);
        } else {
            localDebitAmt = debitAmt.divide(exchange, 4);
            localCreditAmt = creditAmt.divide(exchange, 4);
            localBalance = balance.divide(exchange, 4);
        }
        DirectionEnum direction = balance.compareTo(CasConstants.ZERO) == 0 ? DirectionEnum.Balance : (balance.compareTo(CasConstants.ZERO) > 0 ? DirectionEnum.Debit : DirectionEnum.Credit);
        row.getCell(COL_DC).setValue((Object)direction);
        if (localDebitAmt.compareTo(CasConstants.ZERO) != 0) {
            row.getCell(COL_LOCAL_DEBIT).setValue((Object)localDebitAmt);
        }
        if (localCreditAmt.compareTo(CasConstants.ZERO) != 0) {
            row.getCell(COL_LOCAL_CREDIT).setValue((Object)localCreditAmt);
        }
        row.getCell(COL_LOCAL_BALANCE).setValue((Object)localBalance.abs());
    }

    public void setColumnFormat(KDTable tblMain, BOSUuid currencyId) {
        String numberFtm = FMClientHelper.getNumberFtm((BOSUuid)currencyId);
        tblMain.getColumn(COL_DEBIT).getStyleAttributes().setNumberFormat(numberFtm);
        tblMain.getColumn(COL_CREDIT).getStyleAttributes().setNumberFormat(numberFtm);
        tblMain.getColumn(COL_BALANCE).getStyleAttributes().setNumberFormat(numberFtm);
        tblMain.getColumn(COL_LOCAL_BALANCE).getStyleAttributes().setNumberFormat(numberFtm);
        tblMain.getColumn(COL_LOCAL_CREDIT).getStyleAttributes().setNumberFormat(numberFtm);
        tblMain.getColumn(COL_LOCAL_DEBIT).getStyleAttributes().setNumberFormat(numberFtm);
        tblMain.getColumn(COL_DEBIT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tblMain.getColumn(COL_CREDIT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tblMain.getColumn(COL_BALANCE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tblMain.getColumn(COL_LOCAL_BALANCE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tblMain.getColumn(COL_LOCAL_CREDIT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tblMain.getColumn(COL_LOCAL_DEBIT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    public void setNumberFormat(IRow row, BOSUuid currencyId, boolean isShowDate) {
        String numberFtm = FMClientHelper.getNumberFtm((BOSUuid)currencyId);
        row.getCell(COL_DEBIT).getStyleAttributes().setNumberFormat(numberFtm);
        row.getCell(COL_CREDIT).getStyleAttributes().setNumberFormat(numberFtm);
        row.getCell(COL_BALANCE).getStyleAttributes().setNumberFormat(numberFtm);
        row.getCell(COL_LOCAL_DEBIT).getStyleAttributes().setNumberFormat(numberFtm);
        row.getCell(COL_LOCAL_CREDIT).getStyleAttributes().setNumberFormat(numberFtm);
        row.getCell(COL_LOCAL_BALANCE).getStyleAttributes().setNumberFormat(numberFtm);
        row.getCell(COL_DEBIT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell(COL_CREDIT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell(COL_BALANCE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell(COL_LOCAL_DEBIT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell(COL_LOCAL_CREDIT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell(COL_LOCAL_BALANCE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    protected void fillBalance(CompanyOrgUnitInfo companyInfo, int year, int periodNumber, IRow row, BigDecimal exchange, BigDecimal balance, boolean isCurEqualsBasecur, String description, ConvertModeEnum convertMode) throws EASBizException, BOSException {
        PeriodInfo period = PeriodHelper.getPeriodInfo(year, periodNumber, companyInfo);
        Date beginDate = period.getBeginDate();
        this.fillBalance(row, exchange, balance, isCurEqualsBasecur, description, beginDate, convertMode);
    }

    protected void fillBalance(IRow row, BigDecimal exchange, BigDecimal balance, boolean isCurEqualsBasecur, String description, Date beginDate, ConvertModeEnum convertMode) {
        BigDecimal localBalance = isCurEqualsBasecur ? balance : (convertMode.equals((Object)ConvertModeEnum.DIRECTEXCHANGERATE) ? balance.multiply(exchange) : balance.divide(exchange, 4));
        DirectionEnum direction = balance.compareTo(CasConstants.ZERO) == 0 ? DirectionEnum.Balance : (balance.compareTo(CasConstants.ZERO) > 0 ? DirectionEnum.Debit : DirectionEnum.Credit);
        row.getStyleAttributes().setBackground(CasConstants.PERIOD_TOTAL_COLOR);
        row.getCell(COL_DC).setValue((Object)direction);
        row.getCell(COL_DESCRIPTION).setValue((Object)description);
        row.getCell(COL_BALANCE).setValue((Object)balance.abs());
        row.getCell(COL_LOCAL_BALANCE).setValue((Object)localBalance.abs());
        row.getCell(COL_CREATE_DATE).setValue((Object)ClientUtils.formatDate(beginDate));
    }

    protected void fillTotal(CompanyOrgUnitInfo companyInfo, int year, int periodNumber, Date date, IRow row, BigDecimal exchange, BigDecimal debitAmt, BigDecimal creditAmt, BigDecimal balance, boolean isCurEqualsBasecur, String description, ConvertModeEnum convertMode) throws EASBizException, BOSException {
        row.getStyleAttributes().setBackground(CasConstants.PERIOD_TOTAL_COLOR);
        row.getCell(COL_DESCRIPTION).setValue((Object)description);
        row.getCell(COL_DEBIT).setValue((Object)debitAmt);
        row.getCell(COL_CREDIT).setValue((Object)creditAmt);
        row.getCell(COL_BALANCE).setValue((Object)balance.abs());
        if (date == null) {
            PeriodInfo endPeriod = PeriodHelper.getPeriodInfo(year, periodNumber, companyInfo);
            row.getCell(COL_CREATE_DATE).setValue((Object)FMConstants.FORMAT_DAY.format(endPeriod.getEndDate()));
        } else {
            row.getCell(COL_CREATE_DATE).setValue((Object)FMConstants.FORMAT_DAY.format(date));
        }
        this.fillLocalCurrencyDataForTotal(row, exchange, debitAmt, creditAmt, balance, isCurEqualsBasecur, convertMode);
    }

    protected BigDecimal getBeginBalance(CompanyOrgUnitInfo companyInfo, String currencyNumber, String accountBankNumber, Date beginDate) throws EASBizException, BOSException {
        ISubAcctManagementFacade cashInacct = SubAcctManagementFacadeFactory.getRemoteInstance();
        BigDecimal balance = null;
        balance = cashInacct.cash(companyInfo.getNumber(), accountBankNumber, currencyNumber, beginDate, beginDate, CashDataTypeEnum.C, false);
        return balance;
    }

    protected BigDecimal getYearTotal(CompanyOrgUnitInfo companyInfo, String currencyNumber, String accountBankNumber, int year, int periodNumber, CashDataTypeEnum type) throws EASBizException, BOSException {
        ISubAcctManagementFacade cashInacct = SubAcctManagementFacadeFactory.getRemoteInstance();
        BigDecimal result = null;
        GregorianCalendar begincal = new GregorianCalendar(year, 0, 1);
        PeriodInfo endPeriod = PeriodHelper.getPeriodInfo(year, periodNumber, companyInfo);
        if ((endPeriod = PeriodHelper.getPrePeriodInfo(companyInfo, endPeriod)) == null || endPeriod.getPeriodYear() != year) {
            return CasConstants.ZERO;
        }
        result = cashInacct.cash(companyInfo.getNumber(), accountBankNumber, currencyNumber, begincal.getTime(), endPeriod.getEndDate(), type, false);
        return result;
    }

    protected void fillAdjustRow_New(BigDecimal monthDebitAmt, BigDecimal monthCreditAmt, BigDecimal yearDebitAmt, BigDecimal yearCreditAmt, KDTable tblMain, boolean isShowBeginBalance, boolean isShowPeriodTotal, boolean isShowYearTotal, CompanyOrgUnitInfo companyInfo, BigDecimal exchange, boolean isCurEqualsBasecur, BigDecimal balance, PeriodInfo beginPeriodInfo, PeriodInfo endPeriodInfo, ConvertModeEnum convertMode) throws BOSException, EASBizException {
        PeriodInfo temPeriodInfo = beginPeriodInfo;
        if (beginPeriodInfo == null || endPeriodInfo == null) {
            return;
        }
        while (temPeriodInfo.getPeriodYear() < endPeriodInfo.getPeriodYear() || temPeriodInfo.getPeriodYear() == endPeriodInfo.getPeriodYear() && endPeriodInfo.getPeriodNumber() >= temPeriodInfo.getPeriodNumber()) {
            PeriodInfo temNextPeriodInfo;
            IRow row;
            if (isShowBeginBalance) {
                row = tblMain.addRow();
                this.fillBalance(companyInfo, temPeriodInfo.getPeriodYear(), temPeriodInfo.getPeriodNumber(), row, exchange, balance, isCurEqualsBasecur, BEGIN_BALANCE, convertMode);
            }
            if (isShowPeriodTotal) {
                row = tblMain.addRow();
                this.fillTotal(companyInfo, temPeriodInfo.getPeriodYear(), temPeriodInfo.getPeriodNumber(), temPeriodInfo.getEndDate(), row, exchange, monthDebitAmt, monthCreditAmt, balance, isCurEqualsBasecur, PERIOD_TOTAL, convertMode);
                monthDebitAmt = FMConstants.ZERO;
                monthCreditAmt = FMConstants.ZERO;
            }
            if (isShowYearTotal) {
                row = tblMain.addRow();
                this.fillTotal(companyInfo, temPeriodInfo.getPeriodYear(), temPeriodInfo.getPeriodNumber(), temPeriodInfo.getEndDate(), row, exchange, yearDebitAmt, yearCreditAmt, balance, isCurEqualsBasecur, YEAR_TOTAL, convertMode);
            }
            if ((temNextPeriodInfo = PeriodHelper.getNextPeriodInfo(companyInfo, temPeriodInfo)) == null) {
                return;
            }
            if ((temNextPeriodInfo.getPeriodYear() < endPeriodInfo.getPeriodYear() || temNextPeriodInfo.getPeriodYear() == endPeriodInfo.getPeriodYear() && endPeriodInfo.getPeriodNumber() >= temNextPeriodInfo.getPeriodNumber()) && temPeriodInfo.getPeriodYear() < temNextPeriodInfo.getPeriodYear()) {
                row = tblMain.addRow();
                this.fillBalance(companyInfo, temNextPeriodInfo.getPeriodYear(), temNextPeriodInfo.getPeriodNumber(), row, exchange, balance, isCurEqualsBasecur, YEAR_BALANCE, convertMode);
                yearDebitAmt = CasConstants.ZERO;
                yearCreditAmt = CasConstants.ZERO;
            }
            temPeriodInfo = temNextPeriodInfo;
        }
    }

    protected void setBeginBalanceRowDisc(KDTable tblMain, Date beginDate, boolean isByDay, BigDecimal exchange, boolean isCurEqualsBasecur, BigDecimal dayBalance, ConvertModeEnum convertMode) {
        if (isByDay) {
            String desc = null;
            int size = tblMain.getRowCount() >= 2 ? 2 : tblMain.getRowCount();
            for (int i = 0; i < size; ++i) {
                IRow row = tblMain.getRow(i);
                desc = (String)row.getCell(COL_DESCRIPTION).getValue();
                if (desc == null || !desc.equals(BEGIN_BALANCE)) continue;
                desc = DAY_BALANCE;
                this.fillBalance(row, exchange, dayBalance, isCurEqualsBasecur, desc, beginDate, convertMode);
                break;
            }
        }
    }

    protected void setLocalColumnHided(KDTable tblMain, boolean isHide) {
        if (isHide) {
            tblMain.getHeadRow(1).getStyleAttributes().setHided(true);
            tblMain.getColumn(COL_EXCHANGE).getStyleAttributes().setHided(true);
            tblMain.getColumn(COL_LOCAL_DEBIT).getStyleAttributes().setHided(true);
            tblMain.getColumn(COL_LOCAL_CREDIT).getStyleAttributes().setHided(true);
            tblMain.getColumn(COL_LOCAL_BALANCE).getStyleAttributes().setHided(true);
        } else {
            tblMain.getHeadRow(1).getStyleAttributes().setHided(false);
            tblMain.getColumn(COL_EXCHANGE).getStyleAttributes().setHided(false);
            tblMain.getColumn(COL_LOCAL_DEBIT).getStyleAttributes().setHided(false);
            tblMain.getColumn(COL_LOCAL_CREDIT).getStyleAttributes().setHided(false);
            tblMain.getColumn(COL_LOCAL_BALANCE).getStyleAttributes().setHided(false);
        }
    }

    protected ConvertModeEnum getExchangeConvertMode(CompanyOrgUnitInfo company, CurrencyInfo sourceCurrency, CurrencyInfo desCurrency) throws EASBizException, BOSException {
        IExchangeRate iexchangRate = null;
        ObjectUuidPK excTablepk = null;
        ObjectUuidPK sourceCurrpk = null;
        ObjectUuidPK destCurrpk = null;
        if (company == null) {
            company = SysContext.getSysContext().getCurrentFIUnit();
        } else if (company.getBaseExchangeTable() == null || company.getBaseCurrency() == null) {
            company = CashHelper.getCompanyInfo(company.getId());
        }
        if (sourceCurrency == null) {
            return ConvertModeEnum.DIRECTEXCHANGERATE;
        }
        if (desCurrency == null) {
            desCurrency = company.getBaseCurrency();
        }
        if (company.getBaseExchangeTable() == null) {
            return ConvertModeEnum.DIRECTEXCHANGERATE;
        }
        excTablepk = new ObjectUuidPK(company.getBaseExchangeTable().getId());
        if (desCurrency == null) {
            return ConvertModeEnum.DIRECTEXCHANGERATE;
        }
        if (desCurrency.getId().equals((Object)sourceCurrency.getId())) {
            return ConvertModeEnum.DIRECTEXCHANGERATE;
        }
        destCurrpk = new ObjectUuidPK(desCurrency.getId());
        iexchangRate = ExchangeRateFactory.getRemoteInstance();
        ExchangeRateInfo erInfo = iexchangRate.getExchangeRateConvertInfo((IObjectPK)excTablepk, (IObjectPK)(sourceCurrpk = new ObjectUuidPK(sourceCurrency.getId())), (IObjectPK)destCurrpk, Calendar.getInstance().getTime());
        if (erInfo == null) {
            return ConvertModeEnum.DIRECTEXCHANGERATE;
        }
        return erInfo.getConvertMode();
    }
}

