/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.subacct.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fi.cas.subacct.SubAccountBalanceCollection;
import com.kingdee.eas.fi.cas.subacct.SubAccountBalanceInfo;
import com.kingdee.eas.fi.cas.subacct.SubAccountInfo;
import com.kingdee.eas.fi.cas.subacct.client.AbstractSubAcctMgtInitHandler;
import java.math.BigDecimal;

public class SubAcctInitHandler
extends AbstractSubAcctMgtInitHandler {
    public final String[] noEditColumns = new String[]{"subAcctNumber", "subAcctAccountNumber", "subAcctName", "subAcctReateUnit"};

    @Override
    public void initTable(KDTable table, boolean isFirstPeriod) {
        String[] columnKeys = new String[]{"subAcctNumber", "subAcctAccountNumber", "subAcctName", "subAcctReateUnit", "yearDebitAmount", "yearCreditAmount", "beginBalance"};
        String[] columnNames = new String[]{SUBACCT_NUMBER, SUBACCT_ACCOUNTNUMBER, SUBACCT_NAME, SUBACCT_RELATEUNIT, YEARDEBITAMOUNT, YEARCREDITAMOUNT, BEGINBALANCE};
        table.addColumns(columnKeys.length);
        IRow hRow = table.addHeadRow();
        for (int i = 0; i < columnKeys.length; ++i) {
            table.getColumn(i).setKey(columnKeys[i]);
            hRow.getCell(i).setValue((Object)columnNames[i]);
        }
        super.initTable(table, isFirstPeriod);
    }

    @Override
    public void initKDTableFormatter(KDTable table) {
        for (int i = 0; i < this.noEditColumns.length; ++i) {
            IColumn column = table.getColumn(this.noEditColumns[i]);
            this.setColumnColor(column);
        }
    }

    @Override
    public void loadField(KDTable table) throws Exception {
        super.loadField(table);
    }

    @Override
    public void loadLineFields(IRow row, SubAccountBalanceInfo obj) {
        BigDecimal debitStartAmt;
        CurrencyInfo currencyInfo = super.getCurrency();
        int scale = currencyInfo.getPrecision();
        SubAccountBalanceInfo initInfo = obj;
        SubAccountInfo subAccount = initInfo.getSubacct();
        row.getCell("subAcctNumber").setValue((Object)subAccount.getNumber());
        row.getCell("subAcctNumber").setUserObject((Object)subAccount);
        row.getCell("subAcctAccountNumber").setValue((Object)subAccount.getAccountNumber());
        row.getCell("subAcctAccountNumber").setUserObject((Object)subAccount);
        row.getCell("subAcctName").setValue((Object)subAccount.getName());
        row.getCell("subAcctName").setUserObject((Object)subAccount);
        if (subAccount.getRelationalUnit() != null) {
            row.getCell("subAcctReateUnit").setValue((Object)subAccount.getRelationalUnit().getName());
            row.getCell("subAcctReateUnit").setUserObject((Object)subAccount.getRelationalUnit());
        }
        if ((debitStartAmt = initInfo.getDebitStartAmt()) == null) {
            debitStartAmt = CasConstants.ZERO;
        }
        if (debitStartAmt != null) {
            debitStartAmt = this.getBigDecimalByScale(debitStartAmt, scale);
        }
        row.getCell("yearDebitAmount").setValue((Object)debitStartAmt);
        BigDecimal creditStartAmt = initInfo.getCreditStartAmt();
        if (creditStartAmt == null) {
            creditStartAmt = CasConstants.ZERO;
        }
        if (creditStartAmt != null) {
            creditStartAmt = this.getBigDecimalByScale(creditStartAmt, scale);
        }
        row.getCell("yearCreditAmount").setValue((Object)creditStartAmt);
        BigDecimal monthStartAmt = initInfo.getPeriodStartBalance();
        if (monthStartAmt == null) {
            monthStartAmt = CasConstants.ZERO;
        }
        if (monthStartAmt != null) {
            monthStartAmt = this.getBigDecimalByScale(monthStartAmt, scale);
        }
        row.getCell("beginBalance").setValue((Object)monthStartAmt);
    }

    @Override
    public void storeField(KDTable table) throws Exception {
        table.getEditManager().stopEditing();
        int rowCount = table.getRowCount();
        SubAccountBalanceCollection journalBalCol = null;
        SubAccountBalanceInfo tmpJournalBalInfo = null;
        if (rowCount > 0) {
            journalBalCol = new SubAccountBalanceCollection();
            for (int i = 0; i < rowCount; ++i) {
                IRow row = table.getRow(i);
                if (i == 0) {
                    tmpJournalBalInfo = (SubAccountBalanceInfo)row.getUserObject();
                    tmpJournalBalInfo.setCompany(this.getCompanyInfo());
                    tmpJournalBalInfo.setCurrency(this.getCurrency());
                    tmpJournalBalInfo.setPeriod(this.getPeriodInfo());
                }
                if (this.isRowNotValid(row)) continue;
                SubAccountBalanceInfo journalBalInfo = (SubAccountBalanceInfo)row.getUserObject();
                journalBalInfo.setIsInit(true);
                journalBalInfo.setCompany(this.getCompanyInfo());
                journalBalInfo.setCurrency(this.getCurrency());
                journalBalInfo.setPeriod(this.getPeriodInfo());
                journalBalInfo.setSubacct((SubAccountInfo)row.getCell("subAcctName").getUserObject());
                journalBalInfo.setDebitStartAmt(this.getBigDecimal(row.getCell("yearDebitAmount").getValue()));
                journalBalInfo.setCreditStartAmt(this.getBigDecimal(row.getCell("yearCreditAmount").getValue()));
                journalBalInfo.setPeriodStartBalance(this.getBigDecimal(row.getCell("beginBalance").getValue()));
                journalBalInfo.setYearStartBalance(this.getBigDecimal(row.getCell("beginBalance").getValue()));
                journalBalCol.add(journalBalInfo);
            }
        }
        super.storeData(journalBalCol, tmpJournalBalInfo);
    }
}

