/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.subacct.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.InnerCashFacadeFactory;
import com.kingdee.eas.fi.cas.client.CashClientHelper;
import com.kingdee.eas.fi.cas.client.PeriodHelper;
import com.kingdee.eas.fi.cas.subacct.client.AbstractSubAcctJournalFilterUI;
import com.kingdee.eas.fi.cas.subacct.client.SubAcctJournalFilterParam;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.sql.Date;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class SubAcctJournalFilterUI
extends AbstractSubAcctJournalFilterUI {
    private static Logger logger = Logger.getLogger((String)SubAcctJournalFilterUI.class.getName());
    public static final String RESOURCEPATH = "com.kingdee.eas.fi.cas.client.CashMgtResource";
    String actualAcctTableId = null;

    @Override
    protected void btnByPeriod_stateChanged(ChangeEvent e) throws Exception {
        this.pnlByDate.setVisible(false);
        this.pnlByPeriod.setVisible(false);
        if (this.btnByPeriod.isSelected()) {
            this.pnlByPeriod.setVisible(true);
        } else {
            this.pnlByDate.setVisible(true);
        }
    }

    @Override
    public Object getParam() {
        SubAcctJournalFilterParam para = new SubAcctJournalFilterParam();
        para.setToDate(this.dtpToDate.getSqlDate());
        para.setFromDate(this.dtpFromDate.getSqlDate());
        para.setShowCancelAccount(this.chkIsShowCancleAccount.isSelected());
        para.setShowBeginBalance(this.chkIsShowBeginBalance.isSelected());
        para.setShowDayTotal(this.chkIsShowDayTotal.isSelected());
        para.setShowMonthTotal(this.chkIsShowMonthTotal.isSelected());
        para.setShowYearTotal(this.chkIsShowYearTotal.isSelected());
        para.setByDay(this.btnByDate.isSelected());
        para.setBeginMonth(AccessHelper.getSpiValue((KDSpinner)this.spiBeginMonth));
        para.setBeginYear(AccessHelper.getSpiValue((KDSpinner)this.spiBeginYear));
        para.setEndMonth(AccessHelper.getSpiValue((KDSpinner)this.spiEndMonth));
        para.setEndYear(AccessHelper.getSpiValue((KDSpinner)this.spiEndYear));
        para.setAcctTableId(this.actualAcctTableId);
        return para;
    }

    protected void init() throws Exception {
        PeriodHelper.initPeriodSpinner(this.spiBeginYear, this.spiBeginMonth, this.spiEndYear, this.spiEndMonth);
    }

    public void clear() {
        super.clear();
        try {
            PeriodHelper.initPeriodSpinner(this.spiBeginYear, this.spiBeginMonth, this.spiEndYear, this.spiEndMonth);
            this.dtpToDate.setValue((Object)DateHelper.getDayBegin());
            this.dtpFromDate.setValue((Object)DateHelper.getDayBegin());
            this.btnByDate.setSelected(true);
            this.btnByPeriod.setSelected(true);
            this.chkIsShowForbiddenAccount.setSelected(false);
            this.chkIsShowBeginBalance.setSelected(true);
            this.chkIsShowDayTotal.setSelected(true);
            this.chkIsShowMonthTotal.setSelected(true);
            this.chkIsShowYearTotal.setSelected(true);
        }
        catch (NumberFormatException e) {
            logger.error((Object)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    @Override
    protected void spiBeginMonth_stateChanged(ChangeEvent e) throws Exception {
        PeriodHelper.periodChange(this.spiBeginYear, this.spiBeginMonth, this.spiEndYear, this.spiEndMonth);
    }

    @Override
    protected void spiBeginYear_stateChanged(ChangeEvent e) throws Exception {
        PeriodHelper.periodChange(this.spiBeginYear, this.spiBeginMonth, this.spiEndYear, this.spiEndMonth);
        try {
            CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            PeriodHelper.setPeriodNum(companyInfo, this.spiBeginMonth, (Integer)this.spiBeginYear.getValue());
        }
        catch (Exception ex) {
            SysUtil.abort((Throwable)ex);
        }
    }

    @Override
    protected void spiEndMonth_stateChanged(ChangeEvent e) throws Exception {
        PeriodHelper.periodChange(this.spiBeginYear, this.spiBeginMonth, this.spiEndYear, this.spiEndMonth);
    }

    @Override
    protected void spiEndYear_stateChanged(ChangeEvent e) throws Exception {
        PeriodHelper.periodChange(this.spiBeginYear, this.spiBeginMonth, this.spiEndYear, this.spiEndMonth);
        try {
            CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            PeriodHelper.setPeriodNum(companyInfo, this.spiEndMonth, (Integer)this.spiEndYear.getValue());
        }
        catch (Exception ex) {
            SysUtil.abort((Throwable)ex);
        }
    }

    @Override
    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        SubAcctJournalFilterParam filterParam = (SubAcctJournalFilterParam)param;
        this.dtpToDate.setValue((Object)filterParam.getToDate());
        this.dtpFromDate.setValue((Object)filterParam.getFromDate());
        this.btnByDate.setSelected(filterParam.isByDay());
        this.spiBeginYear.setValue((Object)new Integer(filterParam.getBeginYear()));
        this.spiBeginMonth.setValue((Object)new Integer(filterParam.getBeginMonth()));
        this.spiEndYear.setValue((Object)new Integer(filterParam.getEndYear()));
        this.spiEndMonth.setValue((Object)new Integer(filterParam.getEndMonth()));
        this.chkIsShowCancleAccount.setSelected(filterParam.isShowCancelAccount());
        this.chkIsShowBeginBalance.setSelected(filterParam.isShowBeginBalance());
        this.chkIsShowDayTotal.setSelected(filterParam.isShowDayTotal());
        this.chkIsShowMonthTotal.setSelected(filterParam.isShowMonthTotal());
        this.chkIsShowYearTotal.setSelected(filterParam.isShowYearTotal());
    }

    public boolean verify() {
        CashClientHelper.verifyEmpty((CoreUIObject)this, RESOURCEPATH, this.dtpToDate, "cm63");
        CashClientHelper.verifyEmpty((CoreUIObject)this, RESOURCEPATH, this.dtpFromDate, "cm63");
        if (this.btnByPeriod.isSelected()) {
            if (AccessHelper.getSpiValue((KDSpinner)this.spiBeginYear) * 100 + AccessHelper.getSpiValue((KDSpinner)this.spiBeginMonth) > AccessHelper.getSpiValue((KDSpinner)this.spiEndYear) * 100 + AccessHelper.getSpiValue((KDSpinner)this.spiEndMonth)) {
                this.spiBeginYear.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCEPATH, (String)"EndPeriodBeforeBeginPeriod"));
                SysUtil.abort();
            }
        } else {
            if (DateTimeUtils.truncateDate((java.util.Date)this.dtpToDate.getSqlDate()).before(DateTimeUtils.truncateDate((java.util.Date)this.dtpFromDate.getSqlDate()))) {
                this.dtpFromDate.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCEPATH, (String)"EndDateBeforeBeginDate"));
                SysUtil.abort();
            }
            CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            try {
                PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
                if (DateTimeUtils.truncateDate((java.util.Date)this.dtpToDate.getSqlDate()).before(startPeriod.getBeginDate())) {
                    this.dtpToDate.requestFocus(true);
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCEPATH, (String)"EndDateBeforeStartPeriod"));
                    SysUtil.abort();
                }
                java.util.Date startDate = this.dtpFromDate.getSqlDate();
                Date endDate = this.dtpToDate.getSqlDate();
                if (DateTimeUtils.dayBefore((java.util.Date)startDate, (java.util.Date)startPeriod.getBeginDate())) {
                    startDate = new java.util.Date(startPeriod.getBeginDate().getTime());
                    this.dtpFromDate.setValue((Object)startDate);
                }
                if (DateTimeUtils.dayBefore((java.util.Date)endDate, (java.util.Date)startDate)) {
                    this.dtpToDate.setValue((Object)startDate);
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                SysUtil.abort();
            }
            catch (BOSException e) {
                logger.error((Object)e);
                SysUtil.abort();
            }
        }
        int beginYear = 0;
        int beginMonth = 0;
        int endYear = 0;
        int endMonth = 0;
        if (this.btnByPeriod.isSelected()) {
            beginYear = AccessHelper.getSpiValue((KDSpinner)this.spiBeginYear);
            beginMonth = AccessHelper.getSpiValue((KDSpinner)this.spiBeginMonth);
            endYear = AccessHelper.getSpiValue((KDSpinner)this.spiEndYear);
            endMonth = AccessHelper.getSpiValue((KDSpinner)this.spiEndMonth);
            try {
                this.actualAcctTableId = InnerCashFacadeFactory.getRemoteInstance().getActualAcctTableID(null, beginYear, beginMonth, endYear, endMonth);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        if (this.btnByDate.isSelected()) {
            try {
                this.actualAcctTableId = InnerCashFacadeFactory.getRemoteInstance().getActualAcctTableID(null, beginYear, beginMonth, endYear, endMonth);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        return true;
    }

    protected Class getParamClass() {
        return SubAcctJournalFilterParam.class;
    }
}

