/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.subacct.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fi.cas.CashDataTypeEnum;
import com.kingdee.eas.fi.cas.client.PeriodHelper;
import com.kingdee.eas.fi.cas.subacct.ISubAcctManagementFacade;
import com.kingdee.eas.fi.cas.subacct.SubAccountCollection;
import com.kingdee.eas.fi.cas.subacct.SubAcctHelper;
import com.kingdee.eas.fi.cas.subacct.SubAcctManagementFacadeFactory;
import com.kingdee.eas.fi.cas.subacct.client.SubAcctHandler;
import com.kingdee.eas.fi.cas.subacct.client.SubAcctJournalFilterParam;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;

public class SubAcctJournalHandler
extends SubAcctHandler {
    private static final String COL_TICKETNUMBER = "ticketNumber";
    private static final String COL_TICKETTYPE = "ticketType";
    private static final String COL_SETTNUMBER = "settNumber";
    private static final String COL_SETTTYPE = "settType";
    public static final String resourcePath = "com.kingdee.eas.fi.cas.client.CashMgtResource";
    private static final String BEGIN_BALANCE = EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"BeginBalance");

    public void initCombAccountBank(KDComboBox cboBankAcct, String companyId, boolean isIncludeClosed) throws BOSException {
        ActionListener[] actionListener = cboBankAcct.getActionListeners();
        for (int i = 0; i < actionListener.length; ++i) {
            cboBankAcct.removeActionListener(actionListener[i]);
        }
        cboBankAcct.removeAllItems();
        SubAccountCollection acctBankCol = SubAcctHelper.getSubAccountCollection(companyId, isIncludeClosed);
        cboBankAcct.addItems(acctBankCol.toArray());
        for (int i = 0; i < actionListener.length; ++i) {
            cboBankAcct.addActionListener(actionListener[i]);
        }
    }

    public IRowSet getRowset(IMetaDataPK mainQueryPK, EntityViewInfo mainQuery, BOSUuid currencyId, BOSUuid accountBankId, SubAcctJournalFilterParam p) throws BOSException {
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)mainQueryPK);
        EntityViewInfo ev = (EntityViewInfo)mainQuery.clone();
        FilterInfo filter = ev.getFilter();
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId.toString()));
        filter.getFilterItems().add(new FilterItemInfo("subacct.id", (Object)accountBankId.toString()));
        ev.getSorter().add(new SorterItemInfo("bookDate"));
        ev.getSorter().add(new SorterItemInfo("createTime"));
        exec.setObjectView(ev);
        IRowSet rs = exec.executeQuery();
        return rs;
    }

    protected void fillOneJournalRow(KDTable tblMain, IRowSet rs, BigDecimal exchange, boolean isCurEqualsBasecur, BigDecimal debitAmt, BigDecimal creditAmt, BigDecimal balance, ConvertModeEnum convertMode) throws SQLException {
        IRow row = tblMain.addRow();
        row.getCell("id").setValue((Object)rs.getString("ID"));
        row.getCell("bizDate").setValue((Object)rs.getString("bizDate"));
        row.getCell("bookDate").setValue((Object)rs.getDate("bookDate"));
        row.getCell("billType").setValue((Object)BillTypeEnum.getEnum(rs.getInt("billType")));
        row.getCell("billNumber").setValue((Object)rs.getString("billNumber"));
        row.getCell("description").setValue((Object)rs.getString("description"));
        if (debitAmt.compareTo(CasConstants.ZERO) != 0) {
            row.getCell("debit").setValue((Object)debitAmt);
        }
        if (creditAmt.compareTo(CasConstants.ZERO) != 0) {
            row.getCell("credit").setValue((Object)creditAmt);
        }
        row.getCell("balance").setValue((Object)balance.abs());
        row.getCell("exchange").setValue((Object)exchange);
        row.getCell("periodYear").setValue(rs.getObject("periodYear"));
        row.getCell("periodNumber").setValue(rs.getObject("periodNumber"));
        row.getCell("cash").setValue((Object)rs.getString("cashier"));
        this.fillLocalCurrencyData(row, exchange, debitAmt, creditAmt, balance, isCurEqualsBasecur, convertMode);
    }

    public void fillData_New(KDTable tblMain, IRowSet rs, CurrencyInfo sourceCurrency, String accountNumber, String accountId, SubAcctJournalFilterParam para) throws SQLException, EASBizException, BOSException {
        BigDecimal beginBalance;
        int endPeriod;
        int endYear;
        int beginPeriod;
        int beginYear;
        java.util.Date beginDate;
        boolean isShowBeginBalance = para.isShowBeginBalance();
        boolean isShowDayTotal = para.isShowDayTotal();
        boolean isShowPeriodTotal = para.isShowMonthTotal();
        boolean isShowYearTotal = para.isShowYearTotal();
        PeriodInfo beginPeriodInfo = null;
        PeriodInfo endPeriodInfo = null;
        String currencyNumber = sourceCurrency.getNumber();
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        boolean isStart = SystemStatusCtrolUtils.isStart(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        PeriodInfo startPeriod = PeriodHelper.getCashStartPeriod(companyInfo);
        if (startPeriod == null) {
            return;
        }
        int startPeriodYear = startPeriod.getPeriodYear();
        boolean isByDay = para.isByDay();
        if (isByDay) {
            if (para.getFromDate().before(startPeriod.getBeginDate())) {
                beginPeriodInfo = startPeriod;
                beginDate = beginPeriodInfo.getBeginDate();
            } else {
                beginPeriodInfo = PeriodHelper.getPeriodInfo(para.getFromDate(), companyInfo);
                beginDate = para.getFromDate();
            }
            if (para.getToDate().before(startPeriod.getBeginDate())) {
                return;
            }
            endPeriodInfo = PeriodHelper.getPeriodInfo(para.getToDate(), companyInfo);
            if (endPeriodInfo == null) {
                endPeriodInfo = PeriodHelper.getLastPeriodInfo(companyInfo);
            }
            beginYear = beginPeriodInfo.getPeriodYear();
            beginPeriod = beginPeriodInfo.getPeriodNumber();
            endYear = endPeriodInfo.getPeriodYear();
            endPeriod = endPeriodInfo.getPeriodNumber();
        } else {
            beginYear = para.getBeginYear();
            beginPeriod = para.getBeginMonth();
            endYear = para.getEndYear();
            endPeriod = para.getEndMonth();
            beginPeriodInfo = PeriodHelper.getPeriodInfo(beginYear, beginPeriod, companyInfo);
            endPeriodInfo = PeriodHelper.getPeriodInfo(endYear, endPeriod, companyInfo);
            beginDate = beginPeriodInfo.getBeginDate();
        }
        BigDecimal exchange = SubAcctHelper.getExchange(companyInfo, sourceCurrency, null);
        ConvertModeEnum convertMode = this.getExchangeConvertMode(companyInfo, sourceCurrency, null);
        boolean isCurEqualsBasecur = sourceCurrency.getId().equals((Object)companyInfo.getBaseCurrency().getId());
        boolean isShowLocalCurrency = SubAcctHelper.isShowLocalCurrency(companyInfo.getId().toString());
        boolean isHide = true;
        isHide = isCurEqualsBasecur || !isShowLocalCurrency || !isCurEqualsBasecur && exchange.compareTo(FMConstants.ONE) == 0;
        this.setLocalColumnHided(tblMain, isHide);
        IRow row = null;
        BigDecimal debitAmt = null;
        BigDecimal creditAmt = null;
        BigDecimal balance = null;
        BigDecimal tmpDayDebitTotal = CasConstants.ZERO;
        BigDecimal tmpDayCreditTotal = CasConstants.ZERO;
        BigDecimal tmpMonthDebitTotal = CasConstants.ZERO;
        BigDecimal tmpMonthCreditTotal = CasConstants.ZERO;
        BigDecimal tmpYearDebitTotal = CasConstants.ZERO;
        BigDecimal tmpYearCreditTotal = CasConstants.ZERO;
        BigDecimal yearDebitAmt = CasConstants.ZERO;
        BigDecimal yearCreditAmt = CasConstants.ZERO;
        if (isStart && beginYear == startPeriodYear) {
            yearDebitAmt = SubAcctHelper.getYearStartAmount(companyInfo.getId().toString(), null, accountId, sourceCurrency.getId().toString(), CashDataTypeEnum.JF);
            yearCreditAmt = SubAcctHelper.getYearStartAmount(companyInfo.getId().toString(), null, accountId, sourceCurrency.getId().toString(), CashDataTypeEnum.DF);
        }
        balance = beginBalance = this.getBeginBalance(companyInfo, currencyNumber, accountNumber, beginPeriodInfo.getBeginDate());
        BigDecimal beginYearDebitTotal = this.getYearTotal(companyInfo, currencyNumber, accountNumber, beginYear, beginPeriod, CashDataTypeEnum.JF);
        BigDecimal beginYearCreditTotal = this.getYearTotal(companyInfo, currencyNumber, accountNumber, beginYear, beginPeriod, CashDataTypeEnum.DF);
        ISubAcctManagementFacade cashInacct = SubAcctManagementFacadeFactory.getRemoteInstance();
        BigDecimal adebitTotal = FMConstants.ZERO;
        BigDecimal acreditTotal = FMConstants.ZERO;
        if (isByDay && para.getFromDate().compareTo(beginPeriodInfo.getBeginDate()) > 0) {
            adebitTotal = cashInacct.cash(companyInfo.getNumber(), accountNumber, currencyNumber, beginPeriodInfo.getBeginDate(), DateHelper.getBeforeDay((java.util.Date)para.getFromDate()), CashDataTypeEnum.JF, false);
            acreditTotal = cashInacct.cash(companyInfo.getNumber(), accountNumber, currencyNumber, beginPeriodInfo.getBeginDate(), DateHelper.getBeforeDay((java.util.Date)para.getFromDate()), CashDataTypeEnum.DF, false);
            tmpMonthDebitTotal = adebitTotal;
            tmpMonthCreditTotal = acreditTotal;
        }
        if (beginYear == startPeriod.getPeriodYear() && beginPeriod == startPeriod.getPeriodNumber()) {
            row = tblMain.addRow();
            BigDecimal yearBeginBalance = CasConstants.ZERO;
            if (isStart) {
                yearBeginBalance = balance.add(yearCreditAmt).subtract(yearDebitAmt);
            }
            this.fillBalance(companyInfo, beginYear, beginPeriod, row, exchange, yearBeginBalance, isCurEqualsBasecur, YEAR_BALANCE, convertMode);
        }
        if (rs == null || rs.size() == 0) {
            if (beginYear == startPeriodYear) {
                tmpYearDebitTotal = beginYearDebitTotal.add(yearDebitAmt);
                tmpYearCreditTotal = beginYearCreditTotal.add(yearCreditAmt);
            } else {
                tmpYearDebitTotal = beginYearDebitTotal;
                tmpYearCreditTotal = beginYearCreditTotal;
            }
            if (isByDay && para.getFromDate().compareTo(beginPeriodInfo.getBeginDate()) > 0) {
                tmpYearDebitTotal = tmpYearDebitTotal.add(adebitTotal);
                tmpYearCreditTotal = tmpYearCreditTotal.add(acreditTotal);
            }
            this.fillAdjustRow_New(adebitTotal, acreditTotal, tmpYearDebitTotal, tmpYearCreditTotal, tblMain, isShowBeginBalance, isShowPeriodTotal, isShowYearTotal, companyInfo, exchange, isCurEqualsBasecur, balance, beginPeriodInfo, endPeriodInfo, convertMode);
            return;
        }
        Date date = null;
        int year = beginYear;
        int periodNumber = beginPeriod;
        int tmpYear = beginYear;
        int tmpPeriodNumber = beginPeriod;
        Date tmpdate = null;
        if (rs.next()) {
            date = rs.getDate("bookDate");
            year = rs.getInt("periodyear");
            periodNumber = rs.getInt("periodnumber");
            tmpYear = rs.getInt("periodyear");
            tmpPeriodNumber = rs.getInt("periodnumber");
            tmpdate = rs.getDate("bookDate");
            rs.beforeFirst();
        }
        if (beginYear < year || beginYear == year && beginPeriod < periodNumber) {
            endPeriodInfo = PeriodHelper.getPeriodInfo(year, periodNumber, companyInfo);
            endPeriodInfo = PeriodHelper.getPrePeriodInfo(companyInfo, endPeriodInfo);
            if (beginYear == startPeriodYear) {
                tmpYearDebitTotal = beginYearDebitTotal.add(yearDebitAmt);
                tmpYearCreditTotal = beginYearCreditTotal.add(yearCreditAmt);
            } else {
                tmpYearDebitTotal = beginYearDebitTotal;
                tmpYearCreditTotal = beginYearCreditTotal;
            }
            this.fillAdjustRow_New(CasConstants.ZERO, CasConstants.ZERO, tmpYearDebitTotal, tmpYearCreditTotal, tblMain, isShowBeginBalance, isShowPeriodTotal, isShowYearTotal, companyInfo, exchange, isCurEqualsBasecur, balance, beginPeriodInfo, endPeriodInfo, convertMode);
        }
        if (isShowBeginBalance) {
            row = tblMain.addRow();
            this.fillBalance(companyInfo, year, periodNumber, row, exchange, balance, isCurEqualsBasecur, BEGIN_BALANCE, convertMode);
        }
        BigDecimal dayBalance = balance;
        if (isByDay && rs != null && rs.size() != 0) {
            dayBalance = balance = this.getBeginBalance(companyInfo, currencyNumber, accountNumber, beginDate);
        }
        if (year == startPeriodYear) {
            tmpYearDebitTotal = beginYearDebitTotal.add(yearDebitAmt);
            tmpYearCreditTotal = beginYearCreditTotal.add(yearCreditAmt);
        } else {
            tmpYearDebitTotal = beginYearDebitTotal;
            tmpYearCreditTotal = beginYearCreditTotal;
        }
        while (rs.next()) {
            year = rs.getInt("periodyear");
            periodNumber = rs.getInt("periodnumber");
            date = rs.getDate("bookDate");
            debitAmt = rs.getBigDecimal("debitAmount");
            creditAmt = rs.getBigDecimal("creditAmount");
            if (debitAmt == null) {
                debitAmt = CasConstants.ZERO;
            }
            if (creditAmt == null) {
                creditAmt = CasConstants.ZERO;
            }
            if (date.compareTo(tmpdate) == 0) {
                tmpDayDebitTotal = tmpDayDebitTotal.add(debitAmt);
                tmpDayCreditTotal = tmpDayCreditTotal.add(creditAmt);
            }
            if (date.compareTo(tmpdate) != 0) {
                if (isShowDayTotal) {
                    row = tblMain.addRow();
                    this.fillTotal(companyInfo, tmpYear, tmpPeriodNumber, tmpdate, row, exchange, tmpDayDebitTotal, tmpDayCreditTotal, balance, isCurEqualsBasecur, DAY_TOTAL, convertMode);
                }
                tmpMonthDebitTotal = tmpMonthDebitTotal.add(tmpDayDebitTotal);
                tmpMonthCreditTotal = tmpMonthCreditTotal.add(tmpDayCreditTotal);
                tmpDayDebitTotal = debitAmt;
                tmpDayCreditTotal = creditAmt;
            }
            if (tmpPeriodNumber != periodNumber) {
                if (isShowPeriodTotal) {
                    row = tblMain.addRow();
                    this.fillTotal(companyInfo, tmpYear, tmpPeriodNumber, null, row, exchange, tmpMonthDebitTotal, tmpMonthCreditTotal, balance, isCurEqualsBasecur, PERIOD_TOTAL, convertMode);
                }
                tmpYearDebitTotal = tmpYearDebitTotal.add(tmpMonthDebitTotal);
                tmpYearCreditTotal = tmpYearCreditTotal.add(tmpMonthCreditTotal);
                if (isShowYearTotal) {
                    row = tblMain.addRow();
                    this.fillTotal(companyInfo, tmpYear, tmpPeriodNumber, null, row, exchange, tmpYearDebitTotal, tmpYearCreditTotal, balance, isCurEqualsBasecur, YEAR_TOTAL, convertMode);
                }
                beginPeriodInfo = PeriodHelper.getPeriodInfo(tmpYear, tmpPeriodNumber, companyInfo);
                beginPeriodInfo = PeriodHelper.getNextPeriodInfo(companyInfo, beginPeriodInfo);
                endPeriodInfo = PeriodHelper.getPeriodInfo(year, periodNumber, companyInfo);
                endPeriodInfo = PeriodHelper.getPrePeriodInfo(companyInfo, endPeriodInfo);
                this.fillAdjustRow_New(CasConstants.ZERO, CasConstants.ZERO, tmpYearDebitTotal, tmpYearCreditTotal, tblMain, isShowBeginBalance, isShowPeriodTotal, isShowYearTotal, companyInfo, exchange, isCurEqualsBasecur, balance, beginPeriodInfo, endPeriodInfo, convertMode);
                tmpMonthDebitTotal = CasConstants.ZERO;
                tmpMonthCreditTotal = CasConstants.ZERO;
            }
            if (tmpYear != year) {
                tmpYearDebitTotal = CasConstants.ZERO;
                tmpYearCreditTotal = CasConstants.ZERO;
            }
            if (tmpYear != year) {
                row = tblMain.addRow();
                this.fillBalance(companyInfo, year, periodNumber, row, exchange, balance, isCurEqualsBasecur, YEAR_BALANCE, convertMode);
            }
            if (tmpPeriodNumber != periodNumber && isShowBeginBalance) {
                row = tblMain.addRow();
                this.fillBalance(companyInfo, year, periodNumber, row, exchange, balance, isCurEqualsBasecur, BEGIN_BALANCE, convertMode);
            }
            balance = balance.add(debitAmt).subtract(creditAmt);
            this.fillOneJournalRow(tblMain, rs, exchange, isCurEqualsBasecur, debitAmt, creditAmt, balance, convertMode);
            tmpdate = date;
            tmpYear = year;
            tmpPeriodNumber = periodNumber;
        }
        if (isShowDayTotal) {
            row = tblMain.addRow();
            this.fillTotal(companyInfo, tmpYear, tmpPeriodNumber, date, row, exchange, tmpDayDebitTotal, tmpDayCreditTotal, balance, isCurEqualsBasecur, DAY_TOTAL, convertMode);
        }
        if (isByDay) {
            PeriodInfo period = PeriodHelper.getPeriodInfo(year, periodNumber, companyInfo);
            java.util.Date endDate = new java.util.Date(period.getEndDate().getTime());
            if (endDate.after(para.getToDate())) {
                endDate = para.getToDate();
            }
            balance = cashInacct.cash(companyInfo.getNumber(), accountNumber, currencyNumber, period.getBeginDate(), endDate, CashDataTypeEnum.Y, false);
            tmpMonthDebitTotal = cashInacct.cash(companyInfo.getNumber(), accountNumber, currencyNumber, period.getBeginDate(), endDate, CashDataTypeEnum.JF, false);
            tmpMonthCreditTotal = cashInacct.cash(companyInfo.getNumber(), accountNumber, currencyNumber, period.getBeginDate(), endDate, CashDataTypeEnum.DF, false);
        } else {
            tmpMonthDebitTotal = tmpMonthDebitTotal.add(tmpDayDebitTotal);
            tmpMonthCreditTotal = tmpMonthCreditTotal.add(tmpDayCreditTotal);
        }
        tmpYearDebitTotal = tmpYearDebitTotal.add(tmpMonthDebitTotal);
        tmpYearCreditTotal = tmpYearCreditTotal.add(tmpMonthCreditTotal);
        if (isShowPeriodTotal) {
            row = tblMain.addRow();
            this.fillTotal(companyInfo, tmpYear, tmpPeriodNumber, null, row, exchange, tmpMonthDebitTotal, tmpMonthCreditTotal, balance, isCurEqualsBasecur, PERIOD_TOTAL, convertMode);
        }
        if (isShowYearTotal) {
            row = tblMain.addRow();
            this.fillTotal(companyInfo, tmpYear, tmpPeriodNumber, null, row, exchange, tmpYearDebitTotal, tmpYearCreditTotal, balance, isCurEqualsBasecur, YEAR_TOTAL, convertMode);
        }
        if (year < endYear || year == endYear && periodNumber < endPeriod) {
            beginPeriodInfo = PeriodHelper.getPeriodInfo(year, periodNumber, companyInfo);
            beginPeriodInfo = PeriodHelper.getNextPeriodInfo(companyInfo, beginPeriodInfo);
            endPeriodInfo = PeriodHelper.getPeriodInfo(endYear, endPeriod, companyInfo);
            if (isByDay && !para.getToDate().equals(endPeriodInfo.getEndDate())) {
                endPeriodInfo = PeriodHelper.getPrePeriodInfo(companyInfo, endPeriodInfo);
            }
            this.fillAdjustRow_New(CasConstants.ZERO, CasConstants.ZERO, tmpYearDebitTotal, tmpYearCreditTotal, tblMain, isShowBeginBalance, isShowPeriodTotal, isShowYearTotal, companyInfo, exchange, isCurEqualsBasecur, balance, beginPeriodInfo, endPeriodInfo, convertMode);
        }
        this.setBeginBalanceRowDisc(tblMain, beginDate, isByDay, exchange, isCurEqualsBasecur, dayBalance, convertMode);
    }
}

