/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.subacct.client;

import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.calc.CalculatorDialog;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.client.BankJournalUI;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fi.cas.subacct.SubAccountInfo;
import com.kingdee.eas.fi.cas.subacct.SubAcctJournalFactory;
import com.kingdee.eas.fi.cas.subacct.SubAcctJournalInfo;
import com.kingdee.eas.fi.cas.subacct.client.AbstractSubAcctJournalListUI;
import com.kingdee.eas.fi.cas.subacct.client.SubAcctJournalFilterParam;
import com.kingdee.eas.fi.cas.subacct.client.SubAcctJournalFilterUI;
import com.kingdee.eas.fi.cas.subacct.client.SubAcctJournalHandler;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.AbstractHidedMenuItem;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.util.UserDefineColumnCollection;
import com.kingdee.eas.fm.common.util.UserDefineColumnInfo;
import com.kingdee.eas.fm.fs.TransUpDownBillHelper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class SubAcctJournalListUI
extends AbstractSubAcctJournalListUI {
    private static Logger logger = Logger.getLogger((String)SubAcctJournalListUI.class.getName());
    private SubAcctJournalFilterUI filterUI;
    private SubAcctJournalHandler handler = new SubAcctJournalHandler();
    public static final String resourcePath = "com.kingdee.eas.fi.cas.client.CashMgtResource";
    public static final String subResourcePath = "com.kingdee.eas.fi.cas.subacct.SubAccountResource";

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.fillData();
    }

    public void onLoad() throws Exception {
        int i;
        ClientUtils.checkCompanyAndPeriod((Component)((Object)this));
        ActionListener[] actionListener = this.cboCurrency.getActionListeners();
        for (i = 0; i < actionListener.length; ++i) {
            this.cboCurrency.removeActionListener(actionListener[i]);
        }
        CashHelper.initCombCurrency(this.cboCurrency, false);
        for (i = 0; i < actionListener.length; ++i) {
            this.cboCurrency.addActionListener(actionListener[i]);
        }
        this.tblMain.getViewManager().setFreezeView(0, 2);
        this.menuEdit.add((JMenuItem)new AbstractHidedMenuItem("shift ctrl alt F8"){

            public void action_actionPerformed() {
                try {
                    SubAcctJournalListUI.this.fillData();
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    SysUtil.abort((Throwable)e);
                }
            }
        });
        FMClientHelper.addSqlMenu((CoreUIObject)this, (KDMenu)this.menuEdit);
        super.onLoad();
        this.actionTDPreView.setVisible(false);
        this.actionTDPrint.setVisible(false);
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        CommonQueryDialog dialog = this.getQueryDlg();
        if (!dialog.show()) {
            this.abort();
        }
        this.doQuery(dialog);
        FilterParam param = (FilterParam)this.getFilterUI().getParam();
        this.executeQuery(param);
    }

    @Override
    public void actionViewDetail_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock == null) {
            return;
        }
        int rowIndex = selectBlock.getTop();
        String id = (String)this.tblMain.getRow(rowIndex).getCell("id").getValue();
        if (id == null) {
            MsgBox.showInfo((String)EASResource.getString((String)resourcePath, (String)"SelectValidRecord"));
            return;
        }
        SubAcctJournalInfo journalInfo = SubAcctJournalFactory.getRemoteInstance().getSubAcctJournalInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        String billId = journalInfo.getBillId();
        billId = TransUpDownBillHelper.changeTransBillId((String)billId);
        FMClientHelper.viewDetailBill((CoreUIObject)this, (String)billId, (CompanyOrgUnitInfo)ContextHelperFactory.getRemoteInstance().getCurrentCompany());
    }

    @Override
    protected void cboBankAccount_actionPerformed(ActionEvent e) throws Exception {
        this.fillData();
    }

    @Override
    protected void cboCurrency_actionPerformed(ActionEvent e) throws Exception {
        this.fillData();
    }

    protected void execQuery() {
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        SubAcctJournalFilterParam para = null;
        try {
            para = (SubAcctJournalFilterParam)this.getFilterParam();
            String companyId = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
            this.handler.initCombAccountBank(this.cboBankAccount, companyId, para.isShowCancelAccount());
        }
        catch (Exception e1) {
            logger.error((Object)e1);
            SysUtil.abort((Throwable)e1);
        }
        String datePeriod = "";
        datePeriod = para.isByDay() ? FMConstants.FORMAT_DAY.format(para.getFromDate()) + " - " + FMConstants.FORMAT_DAY.format(para.getToDate()) : para.getBeginYear() + "-" + para.getBeginMonth() + " - " + para.getEndYear() + "-" + para.getEndMonth();
        this.txtPeriod.setText(datePeriod);
        this.txtPeriod.setEditable(false);
        this.tblMain.checkParsed();
        try {
            this.fillData();
        }
        catch (Exception e1) {
            logger.error((Object)e1);
            SysUtil.abort((Throwable)e1);
        }
    }

    protected CommonQueryDialog getQueryDlg() throws Exception {
        CommonQueryDialog dialog = super.getQueryDlg();
        dialog.setShowFilter(false);
        dialog.setShowSorter(false);
        dialog.getCommonQueryParam().setUiObject(null);
        return dialog;
    }

    public void fillData() throws Exception {
        this.tblMain.getHeadMergeManager().mergeBlock(0, 25, 1, 25);
        CurrencyInfo currency = (CurrencyInfo)this.cboCurrency.getSelectedItem();
        SubAccountInfo accountBank = (SubAccountInfo)this.cboBankAccount.getSelectedItem();
        if (currency == null || accountBank == null) {
            this.tblMain.removeRows();
            return;
        }
        SubAcctJournalFilterParam para = (SubAcctJournalFilterParam)this.getFilterParam();
        IRowSet rs = this.handler.getRowset(this.mainQueryPK, this.mainQuery, currency.getId(), accountBank.getId(), para);
        this.tblMain.removeRows();
        this.handler.setColumnFormat(this.tblMain, currency.getId());
        String numberFtm = "%r-[ ]0." + CashHelper.getExchangePre(ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString(), currency.getId().toString(), null) + "n";
        this.tblMain.getColumn("exchange").getStyleAttributes().setNumberFormat(numberFtm);
        this.handler.fillData_New(this.tblMain, rs, currency, accountBank.getNumber(), accountBank.getId().toString(), para);
        this.tblMain.reLayoutAndPaint();
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return JournalFactory.getRemoteInstance();
    }

    @Override
    protected String getEditUIName() {
        return BankJournalUI.class.getName();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnInputOne.setIcon(EASResource.getIcon((String)"imgTbtn_addsinglefile"));
        this.btnInputMany.setIcon(EASResource.getIcon((String)"imgTbtn_copyline"));
        this.btnTDPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnCalculator.setIcon(EASResource.getIcon((String)"imgTbtn_counter"));
        this.btnTDPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnViewDetail.setIcon(EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        this.btnRegisterVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_addcredence"));
        this.btnExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.actionImportData.setVisible(false);
        this.actionRegisterVoucher.setVisible(false);
        this.actionExport.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_output"));
        this.actionExitCurrent.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_quit"));
        this.actionViewDetail.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        this.actionRegisterVoucher.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_addcredence"));
        this.actionCalculator.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_counter"));
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new SubAcctJournalFilterUI();
        }
        return this.filterUI;
    }

    protected boolean initDefaultFilter() {
        return false;
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    private UserDefineColumnCollection getUserDefineColumnCollection() {
        UserDefineColumnCollection udcc = new UserDefineColumnCollection();
        UserDefineColumnInfo info = null;
        info = new UserDefineColumnInfo();
        info.setName("bankAccount");
        info.setDescription(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"432_SubAcctJournalListUI"));
        info.setAlias(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"432_SubAcctJournalListUI"));
        info.setColumnValue(this.cboBankAccount.getSelectedItem().toString());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("currency");
        info.setDescription(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"27_AgentPayBillImportVerify"));
        info.setAlias(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"27_AgentPayBillImportVerify"));
        info.setColumnValue(this.cboCurrency.getSelectedItem().toString());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("intTerm");
        info.setDescription(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"433_SubAcctJournalListUI"));
        info.setAlias(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"433_SubAcctJournalListUI"));
        info.setColumnValue(this.txtPeriod.getText());
        udcc.add((Object)info);
        return udcc;
    }

    @Override
    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        CalculatorDialog calc = new CalculatorDialog((Container)this.getUIContext().get("Owner"));
        calc.setInitValue(null);
        calc.showDialog(2, true);
    }

    protected void preparePrintPageHeader(HeadFootModel headerModel) {
        String companyString = EASResource.getString((String)resourcePath, (String)"TblCol_Company") + "\uff1a&[Company]";
        String accountString = EASResource.getString((String)subResourcePath, (String)"subAccount") + "\uff1a&[SubAccount]";
        String currencyString = EASResource.getString((String)resourcePath, (String)"Currency") + "\uff1a&[Currency]";
        String headString = companyString + "&|&[PeriodRange]";
        StyleAttributes sb = Styles.getDefaultSA();
        headerModel.addRow(headString, sb);
        headString = accountString + "&|" + currencyString;
        headerModel.addRow(headString, sb);
        super.preparePrintPageHeader(headerModel);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Company", SysContext.getSysContext().getCurrentFIUnit().getName());
        SubAccountInfo accountBank = (SubAccountInfo)this.cboBankAccount.getSelectedItem();
        map.put("SubAccount", accountBank + "");
        CurrencyInfo currency = (CurrencyInfo)this.cboCurrency.getSelectedItem();
        map.put("Currency", currency + "");
        String periodString = null;
        periodString = EASResource.getString((String)resourcePath, (String)"cm25") + "\uff1a" + this.txtPeriod.getText();
        map.put("PeriodRange", periodString);
        return map;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void applyPreference() {
    }
}

