/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ArApDBUtil
extends DbUtil {
    public static Map<String, String> tabMap = new HashMap<String, String>();

    public static String getTableNameById(Context ctx, String pk) {
        if (StringUtils.isEmpty((String)pk)) {
            return null;
        }
        BOSObjectType bosType = BOSUuid.getBOSObjectType((String)pk, (boolean)true);
        String type = bosType.toString();
        String tableName = tabMap.get(type);
        if (StringUtils.isEmpty((String)tableName)) {
            IMetaDataLoader loader = null;
            loader = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            EntityObjectInfo entity = loader.getEntity(bosType);
            tableName = entity.getTable().getName();
            tabMap.put(type, tableName);
        }
        return tableName;
    }

    public static String convertToIDStr(IObjectPK[] pks) {
        if (null == pks) {
            return null;
        }
        StringBuilder lockIDs = new StringBuilder(pks.length * 44);
        IObjectPK pk2 = null;
        for (IObjectPK pk2 : pks) {
            if (null == pk2) continue;
            if (lockIDs.length() > 0) {
                lockIDs.append(",");
            }
            lockIDs.append("'").append(pk2.toString()).append("'");
        }
        return lockIDs.toString();
    }

    public static void addSQLLock(Context ctx, IObjectPK[] pks) throws BOSException {
        if (null == pks) {
            return;
        }
        IObjectPK pk = pks[0];
        String lockIDs = ArApDBUtil.convertToIDStr(pks);
        if (null == pk || StringUtils.isEmpty((String)lockIDs)) {
            return;
        }
        String tableName = ArApDBUtil.getTableNameById(ctx, pk.toString());
        String lock = " UPDATE " + tableName + " SET FID = FID WHERE FID in (" + lockIDs + ")";
        ArApDBUtil.execute((Context)ctx, (String)lock);
    }

    public static void addSQLLock(Context ctx, Set idSet) throws BOSException {
        if (null == idSet || idSet.size() == 0) {
            return;
        }
        ArrayList<ObjectUuidPK> pks = new ArrayList<ObjectUuidPK>(idSet.size());
        Iterator it = idSet.iterator();
        while (it.hasNext()) {
            pks.add(new ObjectUuidPK((String)it.next()));
        }
        ArApDBUtil.addSQLLock(ctx, pks.toArray(new IObjectPK[1]));
    }
}

