/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.utils;

import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.cas.BankBalanceAdjustFactory;
import com.kingdee.eas.fi.cas.BankStatementCollection;
import com.kingdee.eas.fi.cas.BankStatementInfo;
import com.kingdee.eas.fi.cas.BankStmtBookReportInfo;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.model.ExcelTool;
import com.kingdee.eas.fi.cas.model.ExcelTool2007;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFSheet;

public class CASReportExcelExportUtils {
    public ExcelTool exportBalanceAdjustExcelDetail(Context ctx, String modelID) throws Exception {
        Set exportData = BankBalanceAdjustFactory.getRemoteInstance().getBalanceAdjustPageInitData(modelID);
        Iterator it = exportData.iterator();
        int index = 0;
        ExcelTool excelTool = null;
        while (it.hasNext()) {
            Map result = (Map)it.next();
            StringBuffer queryString = new StringBuffer("");
            queryString.append(CASWebUtil.getResource(ctx, "357_OUTSTANDINGUNREACH_EXCEL_COMPANYNAME") + ":");
            CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)result.get("companyOrg");
            queryString.append(companyOrgUnitInfo.getName());
            queryString.append("," + CASWebUtil.getResource(ctx, "387_CASHCONTRASTGLE_ACCOUNTBANKNO") + ":");
            AccountBankInfo accountBankInfo = (AccountBankInfo)result.get("accountBank");
            queryString.append(accountBankInfo.getBankAccountNumber() + " " + accountBankInfo.getName());
            queryString.append("," + CASWebUtil.getResource(ctx, "389_CASHCONTRASTGLE_CURRENCY") + ":");
            CurrencyInfo currencyInfo = (CurrencyInfo)result.get("currencyInfo");
            queryString.append(currencyInfo.getName());
            PeriodInfo periodInfo = (PeriodInfo)result.get("periodInfo");
            if (periodInfo == null) {
                Date BizDate = (Date)result.get("bizDate");
                queryString.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"407_CASReportExcelExportUtils") + BizDate.toString());
            } else {
                queryString.append("," + CASWebUtil.getResource(ctx, "399_OUTBALANCEADJUST_PERIOD") + ":");
                queryString.append(periodInfo);
            }
            int seq = index + 1;
            if (excelTool != null && index > 0) {
                excelTool.createSheet(seq + "-" + accountBankInfo.getBankAccountNumber() + "-" + currencyInfo.getName());
            } else {
                excelTool = new ExcelTool(seq + "-" + accountBankInfo.getBankAccountNumber() + "-" + currencyInfo.getName());
            }
            int precision = Integer.valueOf(result.get("precision").toString());
            BankStmtBookReportInfo bankStmtBookReportInfo = (BankStmtBookReportInfo)result.get("rptInfo");
            BigDecimal labelEntAdjuest = (BigDecimal)result.get("entBalance");
            labelEntAdjuest = labelEntAdjuest.setScale(precision, 4);
            this.balanceAdjustEntData(excelTool, bankStmtBookReportInfo, ctx, labelEntAdjuest.toString(), precision, queryString);
            BigDecimal labelBankAdjuest = (BigDecimal)result.get("bankBalance");
            labelBankAdjuest = labelBankAdjuest.setScale(precision, 4);
            this.balanceAdjustBankData(excelTool, bankStmtBookReportInfo, ctx, labelBankAdjuest.toString(), precision);
            BankStatementCollection entCollection = (BankStatementCollection)((Object)result.get("entprUnreachedColl"));
            int entCount = entCollection.size();
            this.entprUnreachedColl(excelTool, entCollection, ctx, precision);
            JournalCollection bankCollection = (JournalCollection)result.get("bankUnreachedColl");
            this.bankUnreachedColl(excelTool, bankCollection, ctx, entCount, precision);
            ++index;
        }
        return excelTool;
    }

    public ExcelTool2007 exportBalanceAdjustExcel2007Detail(Context ctx, String modelID) throws Exception {
        Set exportData = BankBalanceAdjustFactory.getRemoteInstance().getBalanceAdjustPageInitData(modelID);
        Iterator it = exportData.iterator();
        int index = 0;
        ExcelTool2007 excelTool = null;
        while (it.hasNext()) {
            Map result = (Map)it.next();
            StringBuffer queryString = new StringBuffer("");
            queryString.append(CASWebUtil.getResource(ctx, "357_OUTSTANDINGUNREACH_EXCEL_COMPANYNAME") + ":");
            CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)result.get("companyOrg");
            queryString.append(companyOrgUnitInfo.getName());
            queryString.append("," + CASWebUtil.getResource(ctx, "387_CASHCONTRASTGLE_ACCOUNTBANKNO") + ":");
            AccountBankInfo accountBankInfo = (AccountBankInfo)result.get("accountBank");
            if (accountBankInfo != null) {
                queryString.append(accountBankInfo.getBankAccountNumber() + " " + accountBankInfo.getName());
            }
            queryString.append("," + CASWebUtil.getResource(ctx, "389_CASHCONTRASTGLE_CURRENCY") + ":");
            CurrencyInfo currencyInfo = (CurrencyInfo)result.get("currencyInfo");
            queryString.append(currencyInfo.getName());
            queryString.append("," + CASWebUtil.getResource(ctx, "399_OUTBALANCEADJUST_PERIOD") + ":");
            PeriodInfo periodInfo = (PeriodInfo)result.get("periodInfo");
            queryString.append(periodInfo);
            if (excelTool != null && index > 0) {
                excelTool.createSheet(accountBankInfo.getBankAccountNumber() + "-" + currencyInfo.getName());
            } else {
                excelTool = new ExcelTool2007(accountBankInfo.getBankAccountNumber() + "-" + currencyInfo.getName());
            }
            int precision = Integer.valueOf(result.get("precision").toString());
            BankStmtBookReportInfo bankStmtBookReportInfo = (BankStmtBookReportInfo)result.get("rptInfo");
            BigDecimal labelEntAdjuest = (BigDecimal)result.get("entBalance");
            labelEntAdjuest = labelEntAdjuest.setScale(precision, 4);
            this.balanceAdjustEntData2007(excelTool, bankStmtBookReportInfo, ctx, labelEntAdjuest.toString(), precision, queryString);
            BigDecimal labelBankAdjuest = (BigDecimal)result.get("bankBalance");
            labelBankAdjuest = labelBankAdjuest.setScale(precision, 4);
            this.balanceAdjustBankData2007(excelTool, bankStmtBookReportInfo, ctx, labelBankAdjuest.toString(), precision);
            BankStatementCollection entCollection = (BankStatementCollection)((Object)result.get("entprUnreachedColl"));
            int entCount = entCollection.size();
            this.entprUnreachedColl2007(excelTool, entCollection, ctx, precision);
            JournalCollection bankCollection = (JournalCollection)result.get("bankUnreachedColl");
            this.bankUnreachedColl2007(excelTool, bankCollection, ctx, entCount, precision);
            ++index;
        }
        return excelTool;
    }

    private String balanceAdjustEntData(ExcelTool excelTool, BankStmtBookReportInfo bankStmtBookReportInfo, Context ctx, String adjuest, int precision, StringBuffer queryString) throws Exception {
        HSSFCell cell = excelTool.getCell(0, 0, excelTool.getQueryTitleStyle());
        cell.setCellValue(queryString.toString());
        HSSFCellStyle style = excelTool.getNormalStyle(2);
        HSSFCellStyle styleLeft = excelTool.getNormalStyle(0);
        HSSFDataFormat format = excelTool.getWorkbook().createDataFormat();
        String value = StringUtils.leftPad((String)"0", (int)precision, (String)"0");
        style.setDataFormat(format.getFormat("#,##0." + value));
        cell = excelTool.getCell(1, 0, excelTool.getHeadStyle());
        cell.setCellValue(CASWebUtil.getResource(ctx, "395_OUTBALANCEADJUST_JOURNAL"));
        HSSFSheet sheet = excelTool.getSheet();
        sheet.setDefaultColumnWidth(20);
        sheet.addMergedRegion(excelTool.getCellRangeAddress(1, 1, 0, 3));
        cell = excelTool.getCell(2, 0, styleLeft);
        cell.setCellValue(CASWebUtil.getResource(ctx, "396_OUTBALANCEADJUST_ENDINGBALANCE"));
        cell = excelTool.getCell(2, 3, style);
        BigDecimal bankBookAmt = bankStmtBookReportInfo.getBankBookAmt();
        bankBookAmt = bankBookAmt.setScale(precision, 4);
        cell.setCellValue(Double.valueOf(bankBookAmt.toString()).doubleValue());
        cell = excelTool.getCell(3, 1, styleLeft);
        cell.setCellValue(CASWebUtil.getResource(ctx, "397_PLUS") + CASWebUtil.getResource(ctx, "398_OUTBALANCEADJUST_BANK_RECEIVED"));
        cell = excelTool.getCell(3, 3, style);
        BigDecimal bankGotAmt = bankStmtBookReportInfo.getBankGotAmt();
        bankBookAmt = bankBookAmt.setScale(precision, 4);
        cell.setCellValue(Double.valueOf(bankGotAmt.toString()).doubleValue());
        sheet.addMergedRegion(excelTool.getCellRangeAddress(2, 2, 1, 2));
        sheet.addMergedRegion(excelTool.getCellRangeAddress(0, 0, 0, 8));
        cell = excelTool.getCell(4, 1, styleLeft);
        cell.setCellValue(CASWebUtil.getResource(ctx, "370_LESS") + CASWebUtil.getResource(ctx, "371_OUTBALANCEADJUST_BANK_PAID"));
        cell = excelTool.getCell(4, 3, style);
        BigDecimal bankPayedAmt = bankStmtBookReportInfo.getBankPayedAmt();
        bankPayedAmt = bankPayedAmt.setScale(precision, 4);
        cell.setCellValue(Double.valueOf(bankPayedAmt.toString()).doubleValue());
        sheet.addMergedRegion(excelTool.getCellRangeAddress(3, 3, 1, 2));
        cell = excelTool.getCell(5, 0, styleLeft);
        cell.setCellValue(CASWebUtil.getResource(ctx, "372_OUTBALANCEADJUST_ENDINGBALANCE_UPDATE"));
        cell = excelTool.getCell(5, 3, style);
        cell.setCellValue(Double.valueOf(adjuest).doubleValue());
        return null;
    }

    private String balanceAdjustEntData2007(ExcelTool2007 excelTool, BankStmtBookReportInfo bankStmtBookReportInfo, Context ctx, String adjuest, int precision, StringBuffer queryString) throws Exception {
        XSSFCell cell = excelTool.getCell(0, 0, excelTool.getQueryTitleStyle());
        cell.setCellValue(queryString.toString());
        XSSFCellStyle style = excelTool.getNormalStyle(2);
        XSSFCellStyle styleLeft = excelTool.getNormalStyle(0);
        XSSFDataFormat format = excelTool.getWorkbook().createDataFormat();
        String value = StringUtils.leftPad((String)"0", (int)precision, (String)"0");
        style.setDataFormat(format.getFormat("#,##0." + value));
        cell = excelTool.getCell(1, 0, excelTool.getHeadStyle());
        cell.setCellValue(CASWebUtil.getResource(ctx, "395_OUTBALANCEADJUST_JOURNAL"));
        XSSFSheet sheet = excelTool.getSheet();
        sheet.setDefaultColumnWidth(20);
        sheet.addMergedRegion(excelTool.getCellRangeAddress(1, 1, 0, 3));
        cell = excelTool.getCell(2, 0, styleLeft);
        cell.setCellValue(CASWebUtil.getResource(ctx, "396_OUTBALANCEADJUST_ENDINGBALANCE"));
        cell = excelTool.getCell(2, 3, style);
        BigDecimal bankBookAmt = bankStmtBookReportInfo.getBankBookAmt();
        bankBookAmt = bankBookAmt.setScale(precision, 4);
        cell.setCellValue(Double.valueOf(bankBookAmt.toString()).doubleValue());
        cell = excelTool.getCell(3, 1, styleLeft);
        cell.setCellValue(CASWebUtil.getResource(ctx, "397_PLUS") + CASWebUtil.getResource(ctx, "398_OUTBALANCEADJUST_BANK_RECEIVED"));
        cell = excelTool.getCell(3, 3, style);
        BigDecimal bankGotAmt = bankStmtBookReportInfo.getBankGotAmt();
        bankBookAmt = bankBookAmt.setScale(precision, 4);
        cell.setCellValue(Double.valueOf(bankGotAmt.toString()).doubleValue());
        sheet.addMergedRegion(excelTool.getCellRangeAddress(2, 2, 1, 2));
        sheet.addMergedRegion(excelTool.getCellRangeAddress(0, 0, 0, 8));
        cell = excelTool.getCell(4, 1, styleLeft);
        cell.setCellValue(CASWebUtil.getResource(ctx, "370_LESS") + CASWebUtil.getResource(ctx, "371_OUTBALANCEADJUST_BANK_PAID"));
        cell = excelTool.getCell(4, 3, style);
        BigDecimal bankPayedAmt = bankStmtBookReportInfo.getBankPayedAmt();
        bankPayedAmt = bankPayedAmt.setScale(precision, 4);
        cell.setCellValue(Double.valueOf(bankPayedAmt.toString()).doubleValue());
        sheet.addMergedRegion(excelTool.getCellRangeAddress(3, 3, 1, 2));
        cell = excelTool.getCell(5, 0, styleLeft);
        cell.setCellValue(CASWebUtil.getResource(ctx, "372_OUTBALANCEADJUST_ENDINGBALANCE_UPDATE"));
        cell = excelTool.getCell(5, 3, style);
        cell.setCellValue(Double.valueOf(adjuest).doubleValue());
        return null;
    }

    private String balanceAdjustBankData(ExcelTool excelTool, BankStmtBookReportInfo bankStmtBookReportInfo, Context ctx, String adjuest, int precision) throws Exception {
        HSSFCellStyle style = excelTool.getNormalStyle(2);
        HSSFCellStyle styleLeft = excelTool.getNormalStyle(0);
        HSSFDataFormat format = excelTool.getWorkbook().createDataFormat();
        String value = StringUtils.leftPad((String)"0", (int)precision, (String)"0");
        style.setDataFormat(format.getFormat("#,##0." + value));
        HSSFCell cell = excelTool.getCell(1, 5, excelTool.getHeadStyle());
        cell.setCellValue(CASWebUtil.getResource(ctx, "373_OUTBALANCEADJUST_BANK_STATEMENTS"));
        HSSFSheet sheet = excelTool.getSheet();
        sheet.addMergedRegion(excelTool.getCellRangeAddress(1, 1, 5, 8));
        cell = excelTool.getCell(2, 5, styleLeft);
        cell.setCellValue(CASWebUtil.getResource(ctx, "396_OUTBALANCEADJUST_ENDINGBALANCE"));
        cell = excelTool.getCell(2, 8, style);
        BigDecimal bankStmtAmt = bankStmtBookReportInfo.getBankStmtAmt();
        bankStmtAmt = bankStmtAmt.setScale(precision, 4);
        cell.setCellValue(Double.valueOf(bankStmtAmt.toString()).doubleValue());
        cell = excelTool.getCell(3, 6, styleLeft);
        cell.setCellValue(CASWebUtil.getResource(ctx, "397_PLUS") + CASWebUtil.getResource(ctx, "374_OUTBALANCEADJUST_COMPANY_RECEIVED"));
        sheet.addMergedRegion(excelTool.getCellRangeAddress(2, 2, 6, 7));
        cell = excelTool.getCell(3, 8, style);
        BigDecimal entprGotAmt = bankStmtBookReportInfo.getEntprGotAmt();
        entprGotAmt = entprGotAmt.setScale(precision, 4);
        cell.setCellValue(Double.valueOf(entprGotAmt.toString()).doubleValue());
        cell = excelTool.getCell(4, 6, styleLeft);
        cell.setCellValue(CASWebUtil.getResource(ctx, "370_LESS") + CASWebUtil.getResource(ctx, "375_OUTBALANCEADJUST_COMPANY_PAID"));
        sheet.addMergedRegion(excelTool.getCellRangeAddress(3, 3, 6, 7));
        cell = excelTool.getCell(4, 8, style);
        BigDecimal entprPayedAmt = bankStmtBookReportInfo.getEntprPayedAmt();
        entprPayedAmt = entprPayedAmt.setScale(precision, 4);
        cell.setCellValue(Double.valueOf(entprPayedAmt.toString()).doubleValue());
        cell = excelTool.getCell(5, 5, styleLeft);
        cell.setCellValue(CASWebUtil.getResource(ctx, "372_OUTBALANCEADJUST_ENDINGBALANCE_UPDATE"));
        cell = excelTool.getCell(5, 8, style);
        cell.setCellValue(Double.valueOf(adjuest).doubleValue());
        return null;
    }

    private String balanceAdjustBankData2007(ExcelTool2007 excelTool, BankStmtBookReportInfo bankStmtBookReportInfo, Context ctx, String adjuest, int precision) throws Exception {
        XSSFCellStyle style = excelTool.getNormalStyle(2);
        XSSFCellStyle styleLeft = excelTool.getNormalStyle(0);
        XSSFDataFormat format = excelTool.getWorkbook().createDataFormat();
        String value = StringUtils.leftPad((String)"0", (int)precision, (String)"0");
        style.setDataFormat(format.getFormat("#,##0." + value));
        XSSFCell cell = excelTool.getCell(1, 5, excelTool.getHeadStyle());
        cell.setCellValue(CASWebUtil.getResource(ctx, "373_OUTBALANCEADJUST_BANK_STATEMENTS"));
        XSSFSheet sheet = excelTool.getSheet();
        sheet.addMergedRegion(excelTool.getCellRangeAddress(1, 1, 5, 8));
        cell = excelTool.getCell(2, 5, styleLeft);
        cell.setCellValue(CASWebUtil.getResource(ctx, "396_OUTBALANCEADJUST_ENDINGBALANCE"));
        cell = excelTool.getCell(2, 8, style);
        BigDecimal bankStmtAmt = bankStmtBookReportInfo.getBankStmtAmt();
        bankStmtAmt = bankStmtAmt.setScale(precision, 4);
        cell.setCellValue(Double.valueOf(bankStmtAmt.toString()).doubleValue());
        cell = excelTool.getCell(3, 6, styleLeft);
        cell.setCellValue(CASWebUtil.getResource(ctx, "397_PLUS") + CASWebUtil.getResource(ctx, "374_OUTBALANCEADJUST_COMPANY_RECEIVED"));
        sheet.addMergedRegion(excelTool.getCellRangeAddress(2, 2, 6, 7));
        cell = excelTool.getCell(3, 8, style);
        BigDecimal entprGotAmt = bankStmtBookReportInfo.getEntprGotAmt();
        entprGotAmt = entprGotAmt.setScale(precision, 4);
        cell.setCellValue(Double.valueOf(entprGotAmt.toString()).doubleValue());
        cell = excelTool.getCell(4, 6, styleLeft);
        cell.setCellValue(CASWebUtil.getResource(ctx, "370_LESS") + CASWebUtil.getResource(ctx, "375_OUTBALANCEADJUST_COMPANY_PAID"));
        sheet.addMergedRegion(excelTool.getCellRangeAddress(3, 3, 6, 7));
        cell = excelTool.getCell(4, 8, style);
        BigDecimal entprPayedAmt = bankStmtBookReportInfo.getEntprPayedAmt();
        entprPayedAmt = entprPayedAmt.setScale(precision, 4);
        cell.setCellValue(Double.valueOf(entprPayedAmt.toString()).doubleValue());
        cell = excelTool.getCell(5, 5, styleLeft);
        cell.setCellValue(CASWebUtil.getResource(ctx, "372_OUTBALANCEADJUST_ENDINGBALANCE_UPDATE"));
        cell = excelTool.getCell(5, 8, style);
        cell.setCellValue(Double.valueOf(adjuest).doubleValue());
        return null;
    }

    private String entprUnreachedColl(ExcelTool excelTool, BankStatementCollection entCollection, Context ctx, int precision) throws Exception {
        String[] tableHeader = new String[10];
        tableHeader[0] = CASWebUtil.getResource(ctx, "358_OUTSTANDINGUNREACH_EXCEL_DATE");
        tableHeader[1] = CASWebUtil.getResource(ctx, "352_OUTSTANDINGUNREACH_EXCEL_DESCRIPTION");
        tableHeader[2] = CASWebUtil.getResource(ctx, "353_OUTSTANDINGUNREACH_EXCEL_SETTLETYPE");
        tableHeader[3] = CASWebUtil.getResource(ctx, "354_OUTSTANDINGUNREACH_EXCEL_SETTLENUMBER");
        tableHeader[4] = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"408_CASReportExcelExportUtils");
        tableHeader[5] = CASWebUtil.getResource(ctx, "371_OUTBALANCEADJUST_BANK_PAID");
        tableHeader[6] = CASWebUtil.getResource(ctx, "398_OUTBALANCEADJUST_BANK_RECEIVED");
        excelTool.createTableHeader(tableHeader, 10);
        HSSFCell cell = excelTool.getCell(8, 0, excelTool.getHeadStyle());
        cell.setCellValue(CASWebUtil.getResource(ctx, "376_OUTBALANCEADJUST_TITLE1"));
        HSSFSheet sheet = excelTool.getSheet();
        sheet.addMergedRegion(excelTool.getCellRangeAddress(8, 9, 0, 5));
        HSSFCellStyle styleCenter = excelTool.getNormalStyle(1);
        HSSFCellStyle styleLeft = excelTool.getNormalStyle(0);
        HSSFCellStyle styleRight = excelTool.getNormalStyle(2);
        HSSFDataFormat format = excelTool.getWorkbook().createDataFormat();
        String value = StringUtils.leftPad((String)"0", (int)precision, (String)"0");
        styleRight.setDataFormat(format.getFormat("#,##0." + value));
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        int listRowNum = 11;
        for (int i = 0; entCollection != null && i < entCollection.size(); ++i) {
            BankStatementInfo bankStatementInfo = entCollection.get(i);
            cell = excelTool.getCell(i + listRowNum, 0, styleCenter);
            cell.setCellValue(df.format(bankStatementInfo.getCreateDate()));
            cell = excelTool.getCell(i + listRowNum, 1, styleLeft);
            cell.setCellValue(bankStatementInfo.getDescription() == null ? "" : bankStatementInfo.getDescription());
            cell = excelTool.getCell(i + listRowNum, 2, styleLeft);
            cell.setCellValue(bankStatementInfo.getSettleType() == null ? "" : bankStatementInfo.getSettleType().getName());
            cell = excelTool.getCell(i + listRowNum, 3, styleLeft);
            cell.setCellValue(bankStatementInfo.getSettleNumber() == null ? "" : bankStatementInfo.getSettleNumber());
            cell = excelTool.getCell(i + listRowNum, 4, styleLeft);
            cell.setCellValue(bankStatementInfo.getOppUnit() == null ? "" : bankStatementInfo.getOppUnit());
            cell = excelTool.getCell(i + listRowNum, 5, styleRight);
            BigDecimal debitAmount = bankStatementInfo.getDebitAmount();
            debitAmount = debitAmount.setScale(precision, 4);
            cell.setCellValue(Double.valueOf(debitAmount.toString()).doubleValue());
            cell = excelTool.getCell(i + listRowNum, 6, styleRight);
            BigDecimal creditAmount = bankStatementInfo.getCreditAmount();
            creditAmount = creditAmount.setScale(precision, 4);
            cell.setCellValue(Double.valueOf(creditAmount.toString()).doubleValue());
        }
        return null;
    }

    private String entprUnreachedColl2007(ExcelTool2007 excelTool, BankStatementCollection entCollection, Context ctx, int precision) throws Exception {
        String[] tableHeader = new String[10];
        tableHeader[0] = CASWebUtil.getResource(ctx, "358_OUTSTANDINGUNREACH_EXCEL_DATE");
        tableHeader[1] = CASWebUtil.getResource(ctx, "352_OUTSTANDINGUNREACH_EXCEL_DESCRIPTION");
        tableHeader[2] = CASWebUtil.getResource(ctx, "353_OUTSTANDINGUNREACH_EXCEL_SETTLETYPE");
        tableHeader[3] = CASWebUtil.getResource(ctx, "354_OUTSTANDINGUNREACH_EXCEL_SETTLENUMBER");
        tableHeader[4] = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"408_CASReportExcelExportUtils");
        tableHeader[5] = CASWebUtil.getResource(ctx, "371_OUTBALANCEADJUST_BANK_PAID");
        tableHeader[6] = CASWebUtil.getResource(ctx, "398_OUTBALANCEADJUST_BANK_RECEIVED");
        excelTool.createTableHeader(tableHeader, 10);
        XSSFCell cell = excelTool.getCell(8, 0, excelTool.getHeadStyle());
        cell.setCellValue(CASWebUtil.getResource(ctx, "376_OUTBALANCEADJUST_TITLE1"));
        XSSFSheet sheet = excelTool.getSheet();
        sheet.addMergedRegion(excelTool.getCellRangeAddress(8, 9, 0, 5));
        XSSFCellStyle styleCenter = excelTool.getNormalStyle(1);
        XSSFCellStyle styleLeft = excelTool.getNormalStyle(0);
        XSSFCellStyle styleRight = excelTool.getNormalStyle(2);
        XSSFDataFormat format = excelTool.getWorkbook().createDataFormat();
        String value = StringUtils.leftPad((String)"0", (int)precision, (String)"0");
        styleRight.setDataFormat(format.getFormat("#,##0." + value));
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        int listRowNum = 11;
        for (int i = 0; entCollection != null && i < entCollection.size(); ++i) {
            BankStatementInfo bankStatementInfo = entCollection.get(i);
            cell = excelTool.getCell(i + listRowNum, 0, styleCenter);
            cell.setCellValue(df.format(bankStatementInfo.getCreateDate()));
            cell = excelTool.getCell(i + listRowNum, 1, styleLeft);
            cell.setCellValue(bankStatementInfo.getDescription() == null ? "" : bankStatementInfo.getDescription());
            cell = excelTool.getCell(i + listRowNum, 2, styleLeft);
            cell.setCellValue(bankStatementInfo.getSettleType() == null ? "" : bankStatementInfo.getSettleType().getName());
            cell = excelTool.getCell(i + listRowNum, 3, styleLeft);
            cell.setCellValue(bankStatementInfo.getSettleNumber() == null ? "" : bankStatementInfo.getSettleNumber());
            cell = excelTool.getCell(i + listRowNum, 4, styleLeft);
            cell.setCellValue(bankStatementInfo.getOppUnit() == null ? "" : bankStatementInfo.getOppUnit());
            cell = excelTool.getCell(i + listRowNum, 5, styleRight);
            BigDecimal debitAmount = bankStatementInfo.getDebitAmount();
            debitAmount = debitAmount.setScale(precision, 4);
            cell.setCellValue(Double.valueOf(debitAmount.toString()).doubleValue());
            cell = excelTool.getCell(i + listRowNum, 6, styleRight);
            BigDecimal creditAmount = bankStatementInfo.getCreditAmount();
            creditAmount = creditAmount.setScale(precision, 4);
            cell.setCellValue(Double.valueOf(creditAmount.toString()).doubleValue());
        }
        return null;
    }

    private String bankUnreachedColl(ExcelTool excelTool, JournalCollection bankCollection, Context ctx, int entCount, int precision) throws Exception {
        int startNum = 11 + entCount;
        String[] tableHeader = new String[10];
        tableHeader[0] = CASWebUtil.getResource(ctx, "357_OUTSTANDINGUNREACH_EXCEL_COMPANYNAME");
        tableHeader[1] = CASWebUtil.getResource(ctx, "358_OUTSTANDINGUNREACH_EXCEL_DATE");
        tableHeader[2] = CASWebUtil.getResource(ctx, "351_OUTSTANDINGUNREACH_EXCEL_CREATEDATE");
        tableHeader[3] = CASWebUtil.getResource(ctx, "360_OUTSTANDINGUNREACH_EXCEL_BVOUCHER");
        tableHeader[4] = CASWebUtil.getResource(ctx, "352_OUTSTANDINGUNREACH_EXCEL_DESCRIPTION");
        tableHeader[5] = CASWebUtil.getResource(ctx, "363_OUTSTANDINGUNREACH_EXCEL_SETTLEMENTNUMBER");
        tableHeader[6] = CASWebUtil.getResource(ctx, "374_OUTBALANCEADJUST_COMPANY_RECEIVED");
        tableHeader[7] = CASWebUtil.getResource(ctx, "375_OUTBALANCEADJUST_COMPANY_PAID");
        excelTool.createTableHeader(tableHeader, startNum + 2);
        HSSFCell cell = excelTool.getCell(startNum, 0, excelTool.getHeadStyle());
        cell.setCellValue(CASWebUtil.getResource(ctx, "377_OUTBALANCEADJUST_TITLE2"));
        HSSFSheet sheet = excelTool.getSheet();
        sheet.addMergedRegion(excelTool.getCellRangeAddress(startNum, startNum + 1, 0, 7));
        HSSFCellStyle styleCenter = excelTool.getNormalStyle(1);
        HSSFCellStyle styleLeft = excelTool.getNormalStyle(0);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        int listRowNum = startNum + 3;
        HSSFCellStyle style = excelTool.getNormalStyle(2);
        HSSFDataFormat format = excelTool.getWorkbook().createDataFormat();
        String value = StringUtils.leftPad((String)"0", (int)precision, (String)"0");
        style.setDataFormat(format.getFormat("#,##0." + value));
        for (int i = 0; bankCollection != null && i < bankCollection.size(); ++i) {
            JournalInfo bankStatementInfo = bankCollection.get(i);
            cell = excelTool.getCell(i + listRowNum, 0, styleLeft);
            cell.setCellValue(bankStatementInfo.getCompany() == null ? "" : bankStatementInfo.getCompany().getName());
            cell = excelTool.getCell(i + listRowNum, 1, styleCenter);
            cell.setCellValue(df.format(bankStatementInfo.getCreateDate()));
            cell = excelTool.getCell(i + listRowNum, 2, styleCenter);
            cell.setCellValue(df.format(bankStatementInfo.getBizDate()));
            cell = excelTool.getCell(i + listRowNum, 3, styleLeft);
            String voucherTypeName = bankStatementInfo.getVoucherType() == null ? "" : bankStatementInfo.getVoucherType().getName();
            String voucherNumber = bankStatementInfo.getVoucherNumber() == null ? "" : bankStatementInfo.getVoucherNumber();
            cell.setCellValue(voucherTypeName + " " + voucherNumber);
            cell = excelTool.getCell(i + listRowNum, 4, styleLeft);
            cell.setCellValue(bankStatementInfo.getDescription() == null ? "" : bankStatementInfo.getDescription());
            cell = excelTool.getCell(i + listRowNum, 5, styleLeft);
            String settlementTypeName = bankStatementInfo.getSettlementType() == null ? "" : bankStatementInfo.getSettlementType().getName();
            String settlementNumber = bankStatementInfo.getSettlementNumber() == null ? "" : bankStatementInfo.getSettlementNumber();
            cell.setCellValue(settlementTypeName + settlementNumber);
            cell = excelTool.getCell(i + listRowNum, 6, style);
            BigDecimal debitAmount = bankStatementInfo.getDebitAmount();
            debitAmount = debitAmount.setScale(precision, 4);
            cell.setCellValue(Double.valueOf(debitAmount.toString()).doubleValue());
            cell = excelTool.getCell(i + listRowNum, 7, style);
            BigDecimal creditAmount = bankStatementInfo.getCreditAmount();
            creditAmount = creditAmount.setScale(precision, 4);
            cell.setCellValue(Double.valueOf(creditAmount.toString()).doubleValue());
        }
        return null;
    }

    private String bankUnreachedColl2007(ExcelTool2007 excelTool, JournalCollection bankCollection, Context ctx, int entCount, int precision) throws Exception {
        int startNum = 11 + entCount;
        String[] tableHeader = new String[10];
        tableHeader[0] = CASWebUtil.getResource(ctx, "357_OUTSTANDINGUNREACH_EXCEL_COMPANYNAME");
        tableHeader[1] = CASWebUtil.getResource(ctx, "358_OUTSTANDINGUNREACH_EXCEL_DATE");
        tableHeader[2] = CASWebUtil.getResource(ctx, "351_OUTSTANDINGUNREACH_EXCEL_CREATEDATE");
        tableHeader[3] = CASWebUtil.getResource(ctx, "360_OUTSTANDINGUNREACH_EXCEL_BVOUCHER");
        tableHeader[4] = CASWebUtil.getResource(ctx, "352_OUTSTANDINGUNREACH_EXCEL_DESCRIPTION");
        tableHeader[5] = CASWebUtil.getResource(ctx, "363_OUTSTANDINGUNREACH_EXCEL_SETTLEMENTNUMBER");
        tableHeader[6] = CASWebUtil.getResource(ctx, "374_OUTBALANCEADJUST_COMPANY_RECEIVED");
        tableHeader[7] = CASWebUtil.getResource(ctx, "375_OUTBALANCEADJUST_COMPANY_PAID");
        excelTool.createTableHeader(tableHeader, startNum + 2);
        XSSFCell cell = excelTool.getCell(startNum, 0, excelTool.getHeadStyle());
        cell.setCellValue(CASWebUtil.getResource(ctx, "377_OUTBALANCEADJUST_TITLE2"));
        XSSFSheet sheet = excelTool.getSheet();
        sheet.addMergedRegion(excelTool.getCellRangeAddress(startNum, startNum + 1, 0, 7));
        XSSFCellStyle styleCenter = excelTool.getNormalStyle(1);
        XSSFCellStyle styleLeft = excelTool.getNormalStyle(0);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        int listRowNum = startNum + 3;
        XSSFCellStyle style = excelTool.getNormalStyle(2);
        XSSFDataFormat format = excelTool.getWorkbook().createDataFormat();
        String value = StringUtils.leftPad((String)"0", (int)precision, (String)"0");
        style.setDataFormat(format.getFormat("#,##0." + value));
        for (int i = 0; bankCollection != null && i < bankCollection.size(); ++i) {
            JournalInfo bankStatementInfo = bankCollection.get(i);
            cell = excelTool.getCell(i + listRowNum, 0, styleLeft);
            cell.setCellValue(bankStatementInfo.getCompany() == null ? "" : bankStatementInfo.getCompany().getName());
            cell = excelTool.getCell(i + listRowNum, 1, styleCenter);
            cell.setCellValue(df.format(bankStatementInfo.getCreateDate()));
            cell = excelTool.getCell(i + listRowNum, 2, styleCenter);
            cell.setCellValue(df.format(bankStatementInfo.getBizDate()));
            cell = excelTool.getCell(i + listRowNum, 3, styleLeft);
            String voucherTypeName = bankStatementInfo.getVoucherType() == null ? "" : bankStatementInfo.getVoucherType().getName();
            String voucherNumber = bankStatementInfo.getVoucherNumber() == null ? "" : bankStatementInfo.getVoucherNumber();
            cell.setCellValue(voucherTypeName + " " + voucherNumber);
            cell = excelTool.getCell(i + listRowNum, 4, styleLeft);
            cell.setCellValue(bankStatementInfo.getDescription() == null ? "" : bankStatementInfo.getDescription());
            cell = excelTool.getCell(i + listRowNum, 5, styleLeft);
            String settlementTypeName = bankStatementInfo.getSettlementType() == null ? "" : bankStatementInfo.getSettlementType().getName();
            String settlementNumber = bankStatementInfo.getSettlementNumber() == null ? "" : bankStatementInfo.getSettlementNumber();
            cell.setCellValue(settlementTypeName + settlementNumber);
            cell = excelTool.getCell(i + listRowNum, 6, style);
            BigDecimal debitAmount = bankStatementInfo.getDebitAmount();
            debitAmount = debitAmount.setScale(precision, 4);
            cell.setCellValue(Double.valueOf(debitAmount.toString()).doubleValue());
            cell = excelTool.getCell(i + listRowNum, 7, style);
            BigDecimal creditAmount = bankStatementInfo.getCreditAmount();
            creditAmount = creditAmount.setScale(precision, 4);
            cell.setCellValue(Double.valueOf(creditAmount.toString()).doubleValue());
        }
        return null;
    }
}

