/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.utils;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CasWorkPlatfromHelper;
import com.kingdee.eas.fi.cas.vo.WelcomePageBankVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class CasWorkPlatfromBankJournalTimerTask
extends TimerTask {
    private Context context = null;
    private Logger logger = Logger.getLogger(CasWorkPlatfromBankJournalTimerTask.class);
    private static final int TaskPeriod = 3;
    private static final int TaskPeriod_Minutes = 30;
    private String companyID_Prior = null;

    public void setCompanyID_Prior(String companyID) {
        this.companyID_Prior = companyID;
    }

    public void setContext(Context ctx) {
        this.context = ctx;
    }

    public CasWorkPlatfromBankJournalTimerTask(Context ctx) {
        this.context = ctx;
    }

    @Override
    public void run() {
        if (this.context == null) {
            return;
        }
        try {
            CasWorkPlatfromHelper casWorkPlatfromHelper = CasWorkPlatfromHelper.getInstance(this.context);
            ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)this.context);
            Set<String> authorOrgSets = CASWebHelper.getAuthorizedOrg(this.context, null, false);
            ArrayList<String> companyOrgIDLists = new ArrayList<String>();
            if (!StringUtil.isEmptyString((String)this.companyID_Prior)) {
                companyOrgIDLists.add(this.companyID_Prior);
            }
            companyOrgIDLists.addAll(authorOrgSets);
            for (String curCompanyID : companyOrgIDLists) {
                int diffMinutes = casWorkPlatfromHelper.getBankJournalFinishMinute(curCompanyID);
                if (diffMinutes > 0 && diffMinutes < 30) continue;
                try {
                    ObjectUuidPK curCompanyPK = new ObjectUuidPK(curCompanyID);
                    if (!iCompanyOrgUnit.exists((IObjectPK)curCompanyPK)) continue;
                    CompanyOrgUnitInfo company = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)curCompanyPK);
                    List<WelcomePageBankVO> bankJournalList = casWorkPlatfromHelper.welcomePage_BankJouranlData(company);
                    casWorkPlatfromHelper.setBankJournalDataList(curCompanyID, bankJournalList);
                    casWorkPlatfromHelper.setBankJournalFinishDateMap(curCompanyID, new Date());
                }
                catch (Exception e1) {
                    this.logger.debug((Object)e1.getMessage());
                }
            }
            this.logger.debug((Object)("CasWorkPlatfromBankJournalTimerTask Run complete ... " + new Date().toString()));
        }
        catch (Exception e) {
            this.logger.debug((Object)e.getMessage());
        }
    }
}

